/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ApplicationKt;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.ide.model.popups.RdEditorOffsetPopupWindowContext;
import com.jetbrains.ide.model.popups.RdPopupWindowContextBase;
import com.jetbrains.ide.model.tooltips.RdTooltipDescriptor;
import com.jetbrains.ide.model.tooltips.RdTooltipType;
import com.jetbrains.ide.model.tooltips.TooltipsModel;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.services.uiContext.UiContextManager;
import java.awt.Component;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/services/TooltipsHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getHint", "Lcom/intellij/ui/LightweightHint;", "tooltip", "Lcom/jetbrains/ide/model/tooltips/RdTooltipDescriptor;", "showTooltip", "", "Companion", "Listener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTooltipsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipsHost.kt\ncom/jetbrains/rider/services/TooltipsHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,77:1\n13#2:78\n*S KotlinDebug\n*F\n+ 1 TooltipsHost.kt\ncom/jetbrains/rider/services/TooltipsHost\n*L\n28#1:78\n*E\n"})
final class TooltipsHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public TooltipsHost(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    private final void showTooltip(RdTooltipDescriptor tooltip2) {
        ApplicationKt.getApplication().invokeLater(() -> TooltipsHost.showTooltip$lambda$0(this, tooltip2));
    }

    private final LightweightHint getHint(RdTooltipDescriptor tooltip2) {
        String escapedText = XmlStringUtil.escapeString((String)tooltip2.getUnescapedText());
        return switch (WhenMappings.$EnumSwitchMapping$0[tooltip2.getType().ordinal()]) {
            case 1 -> new LightweightHint(HintUtil.createErrorLabel((String)escapedText, null, null));
            case 2 -> new LightweightHint(HintUtil.createInformationLabel((String)escapedText, null, null, null));
            default -> {
                logger.error("Unexpected tooltip type.");
                yield null;
            }
        };
    }

    private static final void showTooltip$lambda$0(TooltipsHost this$0, RdTooltipDescriptor $tooltip) {
        LightweightHint hint;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$tooltip, (String)"$tooltip");
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this$0.project).getSelectedEditor();
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        if (textEditor == null) {
            return;
        }
        TextEditor textEditor2 = textEditor;
        Editor editor2 = textEditor2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        if (UiContextManager.Companion.getInstance(this$0.project).isActualValues($tooltip.getTimestamps()) && (hint = this$0.getHint($tooltip)) != null) {
            HintManagerImpl manager = HintManagerImpl.getInstanceImpl();
            RdPopupWindowContextBase context2 = $tooltip.getContext();
            Point point = context2 instanceof RdEditorOffsetPopupWindowContext ? new RelativePoint((Component)editor3.getContentComponent(), editor3.offsetToXY(((RdEditorOffsetPopupWindowContext)context2).getEditorOffset())).getPoint() : manager.getHintPosition(hint, editor3, (short)1);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor3, point, 42, 0, false);
        }
    }

    public static final /* synthetic */ void access$showTooltip(TooltipsHost $this, RdTooltipDescriptor tooltip2) {
        $this.showTooltip(tooltip2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TooltipsHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TooltipsHost.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/services/TooltipsHost$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/services/TooltipsHost$Listener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/ide/model/tooltips/TooltipsModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.rdclient.dotnet"})
    public static final class Listener
    implements SolutionExtListener<TooltipsModel> {
        public void extensionCreated(@NotNull Lifetime lifetime2, @NotNull ClientProjectSession session2, @NotNull TooltipsModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            model.getMessage().advise(lifetime2, (Function1)new Function1<RdTooltipDescriptor, Unit>(session2){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                public final void invoke(@NotNull RdTooltipDescriptor tooltip2) {
                    Intrinsics.checkNotNullParameter((Object)tooltip2, (String)"tooltip");
                    ComponentManager $this$service$iv = (ComponentManager)this.$session.getProject();
                    boolean $i$f$service = false;
                    Class<TooltipsHost> serviceClass$iv = TooltipsHost.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    TooltipsHost.access$showTooltip((TooltipsHost)object, tooltip2);
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdTooltipType.values().length];
            try {
                nArray[RdTooltipType.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTooltipType.INFO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

