/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol.components;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdSolutionCloseOptions;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.SolutionModel;
import com.jetbrains.rd.ide.model.SolutionModel_GeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.ProtocolComponent;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/protocol/components/SolutionHost;", "Lcom/jetbrains/rider/protocol/ProtocolComponent;", "protocolHost", "Lcom/jetbrains/rider/protocol/IProtocolHost;", "(Lcom/jetbrains/rider/protocol/IProtocolHost;)V", "model", "Lcom/jetbrains/rd/ide/model/SolutionModel;", "getModel", "()Lcom/jetbrains/rd/ide/model/SolutionModel;", "assertReadyForSolution", "", "remove", "solution", "Lcom/jetbrains/rd/ide/model/Solution;", "set", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nSolutionHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionHost.kt\ncom/jetbrains/rider/protocol/components/SolutionHost\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,52:1\n13#2:53\n13#3:54\n*S KotlinDebug\n*F\n+ 1 SolutionHost.kt\ncom/jetbrains/rider/protocol/components/SolutionHost\n*L\n21#1:53\n21#1:54\n*E\n"})
public final class SolutionHost
extends ProtocolComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SolutionModel model;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final AtomicInteger idFactory;

    public SolutionHost(@NotNull IProtocolHost protocolHost) {
        Intrinsics.checkNotNullParameter((Object)protocolHost, (String)"protocolHost");
        super(protocolHost);
        this.model = SolutionModel_GeneratedKt.getSolutionModel((IProtocol)this.getProtocol());
    }

    @NotNull
    public final SolutionModel getModel() {
        return this.model;
    }

    public final void set(@NotNull Solution solution) {
        Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
        int id = idFactory.incrementAndGet();
        logger.info("Putting protocol solution...");
        Integer n = id;
        ((Map)this.model.getSolutions()).put(n, solution);
    }

    public final void remove(@NotNull Solution solution) {
        Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
        logger.info("Sending 'close' signal...");
        RdSolutionCloseOptions options = new RdSolutionCloseOptions(false);
        solution.getClose().fire((Object)options);
        DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel((IProtocol)this.getProtocol()).getDocuments().clear();
        logger.info("Clearing protocol solution...");
        this.model.getSolutions().clear();
    }

    public final void assertReadyForSolution() {
        Collection solutions = this.model.getSolutions().values();
        if (!solutions.isEmpty()) {
            Object object = (Solution)CollectionsKt.firstOrNull((Iterable)solutions);
            if (object == null || (object = SolutionHostExtensionsKt.getPath(object)) == null) {
                object = "EMPTY PATH";
            }
            Object existingSolution = object;
            throw new UnsupportedOperationException("Opening new solution before closing an old one. Current solution: " + (String)existingSolution);
        }
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SolutionHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SolutionHost.logger = logger;
        idFactory = new AtomicInteger(0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/protocol/components/SolutionHost$Companion;", "", "()V", "idFactory", "Ljava/util/concurrent/atomic/AtomicInteger;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

