/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.jetbrains.rd.framework.IIdentities;
import com.jetbrains.rd.framework.ISerializers;
import com.jetbrains.rd.framework.IWire;
import com.jetbrains.rd.framework.IdKind;
import com.jetbrains.rd.framework.Identities;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.framework.RdContext;
import com.jetbrains.rd.framework.Serializers;
import com.jetbrains.rd.framework.SocketWire;
import com.jetbrains.rd.framework.SocketWireKt;
import com.jetbrains.rd.platform.RdConstants;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.util.collections.SynchronizedSet;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.ViewableSet;
import com.jetbrains.rdclient.protocol.RdDispatcher;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.EarlyBackendStarter;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolComponent;
import com.jetbrains.rider.protocol.ProtocolHost;
import com.jetbrains.rider.protocol.ProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolManager;
import com.jetbrains.rider.protocol.ReSharperProcess;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.protocol.components.ShellHost;
import com.jetbrains.rider.util.StartUpUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 32\u00020\u0001:\u00013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eJ&\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0018\u00010 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0002J\u001e\u0010&\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0018\u00010 2\u0006\u0010%\u001a\u00020\u0005H\u0002J\b\u0010'\u001a\u0004\u0018\u00010(J\u0016\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010+\u001a\u00020\u001bJ\u000e\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u0015J\u000e\u0010.\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u0015J\b\u0010/\u001a\u00020\u0019H\u0002J\b\u00100\u001a\u00020\u0019H\u0002J\u0018\u00101\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u00152\u0006\u00102\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00064"}, d2={"Lcom/jetbrains/rider/protocol/ProtocolManager;", "", "application", "Lcom/intellij/openapi/application/Application;", "componentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/intellij/openapi/application/Application;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "initialized", "", "isReady", "Lcom/jetbrains/rd/util/reactive/Property;", "()Lcom/jetbrains/rd/util/reactive/Property;", "killedEbs", "", "Ljava/lang/Long;", "locker", "Ljava/lang/Object;", "nextId", "", "protocolHosts", "Lcom/jetbrains/rd/util/reactive/ViewableSet;", "Lcom/jetbrains/rider/protocol/IProtocolHostWithBackend;", "getProtocolHosts", "()Lcom/jetbrains/rd/util/reactive/ViewableSet;", "create", "Lcom/jetbrains/rider/protocol/ProtocolHost;", "forceShutdown", "", "getOrCreate", "project", "Lcom/intellij/openapi/project/Project;", "getPair", "Lkotlin/Pair;", "Lcom/jetbrains/rd/framework/Protocol;", "Lcom/jetbrains/rider/protocol/ReSharperProcessBase;", "ebsTask", "Lcom/jetbrains/rider/protocol/EarlyBackendStarter$EbsPreparedThings;", "lifetime", "getProcessFromEBS", "getUnattached", "Lcom/jetbrains/rider/protocol/IProtocolHost;", "increaseMaxMessageLengthTo", "newValue", "init", "release", "protocolHost", "requestShutdown", "runReSharperProcess", "runReSharperProcessWithLog", "shutdown", "async", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nProtocolManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolManager.kt\ncom/jetbrains/rider/protocol/ProtocolManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 IProtocolHost.kt\ncom/jetbrains/rider/protocol/IProtocolHostKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,471:1\n86#2,3:472\n13#2:505\n24#3:475\n800#4,11:476\n288#4,2:488\n288#4,2:490\n800#4,11:492\n1855#4,2:503\n1#5:487\n*S KotlinDebug\n*F\n+ 1 ProtocolManager.kt\ncom/jetbrains/rider/protocol/ProtocolManager\n*L\n222#1:472,3\n131#1:505\n324#1:475\n324#1:476,11\n348#1:488,2\n363#1:490,2\n385#1:492,11\n385#1:503,2\n*E\n"})
public final class ProtocolManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Application application;
    @NotNull
    private final Lifetime componentLifetime;
    private boolean initialized;
    private int nextId;
    @NotNull
    private final Object locker;
    @Nullable
    private Long killedEbs;
    @NotNull
    private final Property<Boolean> isReady;
    @NotNull
    private final ViewableSet<IProtocolHostWithBackend> protocolHosts;
    @NotNull
    private static final Logger logger;
    private static boolean onlyOneProcess;
    @NotNull
    public static final String getProcessFromEBSTimeKey = "getProcessFromEBSTime";
    @NotNull
    public static final String runReSharperProcessTimeKey = "runReSharperProcessTime";
    @NotNull
    private static final AtomicInteger protocolNameCounter;
    @NotNull
    private static final String DISABLE_RESHARPER_BACKEND = "rider.disable.resharper.backend";

    public ProtocolManager(@NotNull Application application, @NotNull Lifetime componentLifetime) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)componentLifetime, (String)"componentLifetime");
        this.application = application;
        this.componentLifetime = componentLifetime;
        this.locker = new Object();
        this.isReady = new Property((Object)false);
        this.protocolHosts = new ViewableSet((Set)new SynchronizedSet());
        this.runReSharperProcessWithLog();
    }

    @NotNull
    public final Property<Boolean> isReady() {
        return this.isReady;
    }

    @NotNull
    public final ViewableSet<IProtocolHostWithBackend> getProtocolHosts() {
        return this.protocolHosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProtocolHost runReSharperProcessWithLog() {
        try {
            ProtocolHost protocolHost = this.runReSharperProcess();
            return protocolHost;
        }
        finally {
            StartUpUtilKt.logMeasuredStartupTime(logger, runReSharperProcessTimeKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Protocol, ReSharperProcessBase> getProcessFromEBS(Lifetime lifetime2) {
        Pair<Protocol, ReSharperProcessBase> pair2;
        EarlyBackendStarter.EbsPreparedThings ebsPreparedThings = EarlyBackendStarter.Companion.getPreparedThings();
        if (ebsPreparedThings != null) {
            EarlyBackendStarter.EbsPreparedThings it = ebsPreparedThings;
            boolean bl = false;
            EarlyBackendStarter.Companion.setPreparedThings(null);
            try {
                Pair<Protocol, ReSharperProcessBase> pair3 = this.getPair(it, lifetime2);
                pair2 = pair3;
            }
            finally {
                StartUpUtilKt.logMeasuredStartupTime(logger, getProcessFromEBSTimeKey);
            }
        } else {
            pair2 = null;
        }
        return pair2;
    }

    private final Pair<Protocol, ReSharperProcessBase> getPair(EarlyBackendStarter.EbsPreparedThings ebsTask, Lifetime lifetime2) {
        Object $this$runAndLogException_u24lambda_u240$iv;
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            $this$runAndLogException_u24lambda_u240$iv = Result.constructor-impl((Object)ebsTask.getValue());
        }
        catch (Throwable bl) {
            $this$runAndLogException_u24lambda_u240$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        EarlyBackendStarter ebs = (EarlyBackendStarter)LoggerKt.getOrLogException((Object)$this$runAndLogException_u24lambda_u240$iv, (Logger)$this$runAndLogException$iv);
        if (ebs == null) {
            ProtocolManager.logger.warn("EarlyBackendStarter is null ");
            return null;
        }
        String targetDirs = ReSharperProcess.Companion.getAllDotNetBinDirectoriesAsSortedString(ReSharperProcess.Companion.getAdditionalInfo());
        String targetXml = ReSharperProcess.Companion.getDotNetPluginsXmlDescriptor(ReSharperProcess.Companion.getAdditionalInfo());
        List<String> extraFlags = ReSharperProcess.Companion.getAdditionalInfo().getExtraFlags();
        Map<String, String> extraEnvVars = ReSharperProcess.Companion.getAdditionalInfo().getExtraEnvVars();
        ReSharperProcessBase process2 = ebs.getPreparedProcess();
        String prevDirs = process2.getDotNetPluginsExtraDirs();
        String prevXml = process2.getDotNetPluginsXmlDescriptor();
        List<String> prevExtraFlags = process2.getExtraFlags();
        Map<String, String> prevExtraEnvVars = process2.getExtraEnvVars();
        if (!(Intrinsics.areEqual((Object)targetDirs, (Object)prevDirs) && Intrinsics.areEqual((Object)targetXml, (Object)prevXml) && Intrinsics.areEqual(extraFlags, prevExtraFlags) && Intrinsics.areEqual(extraEnvVars, prevExtraEnvVars))) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)ebs.getLifetimeDef(), (boolean)false, (int)1, null);
            ProtocolManager.logger.info("Early backend process uses wrong plugin set, command line arguments or env vars; throwing it out and restarting");
            ProtocolManager.getPair$reportDiff("DotNetPluginsExtraDirs", targetDirs, prevDirs);
            ProtocolManager.getPair$reportDiff("DotNetPluginsXmlDescriptor", targetXml, prevXml);
            ProtocolManager.getPair$reportDiff("ExtraFlags", CollectionsKt.joinToString$default((Iterable)extraFlags, (CharSequence)";", null, null, (int)0, null, null, (int)62, null), CollectionsKt.joinToString$default((Iterable)prevExtraFlags, (CharSequence)";", null, null, (int)0, null, null, (int)62, null));
            ProtocolManager.getPair$reportDiff("ExtraEnvVars", CollectionsKt.joinToString$default((Iterable)extraEnvVars.entrySet(), (CharSequence)";", null, null, (int)0, null, (Function1)getPair.1.INSTANCE, (int)30, null), CollectionsKt.joinToString$default((Iterable)prevExtraEnvVars.entrySet(), (CharSequence)";", null, null, (int)0, null, (Function1)getPair.2.INSTANCE, (int)30, null));
            this.killedEbs = process2.getResharperProcessHandler().getProcess().pid();
            process2.requestShutdown();
            process2.getResharperProcessHandler().destroyProcess();
            return null;
        }
        Protocol protocol = ProtocolManager.Companion.createProtocolFromEBS(this.application, lifetime2, ebs);
        return TuplesKt.to((Object)protocol, (Object)process2);
    }

    private final ProtocolHost runReSharperProcess() {
        LifetimeDefinition lifetimeDefinition = this.componentLifetime.createNested();
        Lifetime lifetime2 = lifetimeDefinition.getLifetime();
        Protocol protocol = null;
        ReSharperProcessBase process2 = null;
        Pair<Protocol, ReSharperProcessBase> ebsResult = this.getProcessFromEBS(lifetime2);
        if (ebsResult != null) {
            logger.info("Using early-started protocol and process");
            protocol = (Protocol)ebsResult.getFirst();
            process2 = (ReSharperProcessBase)ebsResult.getSecond();
        } else {
            logger.info("Create protocol...");
            protocol = Companion.createProtocol(this.application, lifetime2);
            logger.info("Run ReSharper process...");
            process2 = !Companion.isResharperBackendDisabled() ? (ReSharperProcessBase)new ReSharperProcess(this.application, lifetime2, SocketWireKt.getServerPort((IWire)protocol.getWire()), this.killedEbs) : null;
        }
        protocol.getOutOfSyncModels().view(lifetime2, (Function2)runReSharperProcess.1.INSTANCE);
        logger.info("Create protocol host...");
        int n = this.nextId;
        this.nextId = n + 1;
        String id = "ReSharper Process " + n;
        ProtocolHostWithBackend host = new ProtocolHostWithBackend(id, lifetimeDefinition, protocol, this.application, process2);
        if (this.initialized) {
            host.init();
        }
        this.protocolHosts.add((Object)host);
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release(@NotNull IProtocolHostWithBackend protocolHost) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)protocolHost, (String)"protocolHost");
        logger.info("Release protocolHost...");
        Object object = this.locker;
        synchronized (object) {
            boolean bl2;
            boolean bl3 = false;
            ((ProtocolHost)((Object)protocolHost)).release();
            if (((Collection)this.protocolHosts).size() > 1) {
                this.protocolHosts.remove((Object)protocolHost);
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        boolean shouldShutDown = bl;
        if (shouldShutDown) {
            logger.info("Kill protocolHost...");
            this.requestShutdown(protocolHost);
            this.shutdown(protocolHost, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void requestShutdown(@NotNull IProtocolHostWithBackend protocolHost) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)protocolHost, (String)"protocolHost");
        ReSharperProcessBase reSharperProcessBase = protocolHost.getResharperProcess();
        if (reSharperProcessBase != null) {
            reSharperProcessBase.requestShutdown();
        }
        IProtocolHost $this$getComponent$iv = protocolHost;
        boolean $i$f$getComponent = false;
        Iterable $this$filterIsInstance$iv$iv = $this$getComponent$iv.getComponents();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof ShellHost)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        ((ShellHost)((ProtocolComponent)CollectionsKt.single((List)((List)destination$iv$iv$iv)))).requestShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forceShutdown() {
        List list;
        Object object = this.locker;
        synchronized (object) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)((Iterable)this.protocolHosts));
        }
        List hosts = list;
        for (IProtocolHostWithBackend host : hosts) {
            this.shutdown(host, false);
        }
    }

    private final void shutdown(IProtocolHostWithBackend protocolHost, boolean async) {
        Intrinsics.checkNotNull((Object)protocolHost, (String)"null cannot be cast to non-null type com.jetbrains.rider.protocol.ProtocolHostWithBackend");
        ReSharperProcessBase resharperProcess = ((ProtocolHostWithBackend)protocolHost).getResharperProcess();
        if (resharperProcess == null) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)((ProtocolHostWithBackend)protocolHost).getLifetimeDefinition(), (boolean)false, (int)1, null);
            return;
        }
        resharperProcess.waitFor(async, (Function0<Unit>)((Function0)new Function0<Unit>(protocolHost){
            final /* synthetic */ IProtocolHostWithBackend $protocolHost;
            {
                this.$protocolHost = $protocolHost;
                super(0);
            }

            public final void invoke() {
                LifetimeDefinition.terminate$default((LifetimeDefinition)((ProtocolHostWithBackend)this.$protocolHost).getLifetimeDefinition(), (boolean)false, (int)1, null);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IProtocolHost getUnattached() {
        Object object = this.locker;
        synchronized (object) {
            Object v0;
            block4: {
                boolean bl = false;
                Iterable $this$firstOrNull$iv = (Iterable)this.protocolHosts;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IProtocolHostWithBackend it = (IProtocolHostWithBackend)element$iv;
                    boolean bl2 = false;
                    if (!(!it.isProjectAttached())) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            IProtocolHost iProtocolHost = v0;
            return iProtocolHost;
        }
    }

    public final void increaseMaxMessageLengthTo(int newValue, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        IWire iWire = ApplicationProtocolKt.getProtocol(project2).getWire();
        Intrinsics.checkNotNull((Object)iWire, (String)"null cannot be cast to non-null type com.jetbrains.rd.framework.SocketWire.Server");
        SocketWire.Server socketWire = (SocketWire.Server)iWire;
        if (newValue > socketWire.getMaxMessageLength()) {
            socketWire.setMaxMessageLength(newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IProtocolHostWithBackend getOrCreate(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        logger.info("GetOrCreate protocolHost...");
        Object object = this.locker;
        synchronized (object) {
            ProtocolHostWithBackend protocolHostWithBackend;
            IProtocolHostWithBackend freeProtocolHost;
            Object v0;
            block4: {
                boolean bl = false;
                Iterable $this$firstOrNull$iv = (Iterable)this.protocolHosts;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IProtocolHostWithBackend it = (IProtocolHostWithBackend)element$iv;
                    boolean bl2 = false;
                    if (!(!it.isProjectAttached())) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            IProtocolHostWithBackend iProtocolHostWithBackend = freeProtocolHost = (IProtocolHostWithBackend)v0;
            IProtocolHost protocolHost = iProtocolHostWithBackend != null ? (IProtocolHost)iProtocolHostWithBackend : (IProtocolHost)this.create();
            Intrinsics.checkNotNull((Object)protocolHost, (String)"null cannot be cast to non-null type com.jetbrains.rider.protocol.ProtocolHostWithBackend");
            ProtocolHostWithBackend $this$getOrCreate_u24lambda_u248_u24lambda_u247 = protocolHostWithBackend = (ProtocolHostWithBackend)protocolHost;
            boolean bl = false;
            $this$getOrCreate_u24lambda_u248_u24lambda_u247.attach(project2);
            IProtocolHostWithBackend iProtocolHostWithBackend2 = protocolHostWithBackend;
            return iProtocolHostWithBackend2;
        }
    }

    private final ProtocolHost create() {
        if (onlyOneProcess) {
            ProjectImpl project2;
            Object object = ((IProtocolHostWithBackend)CollectionsKt.single((Iterable)((Iterable)this.protocolHosts))).getProject().getValue();
            ProjectImpl projectImpl = project2 = object instanceof ProjectImpl ? (ProjectImpl)object : null;
            throw new IllegalStateException(("Several ReSharper processes execution is prohibited. Existing protocol's project: " + (projectImpl != null ? projectImpl.getCreationTrace() : null)).toString());
        }
        return this.runReSharperProcessWithLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void init() {
        logger.info("Initialize protocol manager");
        Object object = this.locker;
        synchronized (object) {
            void $this$filterIsInstanceTo$iv$iv;
            boolean bl = false;
            this.initialized = true;
            logger.info("Initialize " + this.protocolHosts.size() + " hosts");
            Iterable $this$filterIsInstance$iv = (Iterable)this.protocolHosts;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ProtocolHost)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProtocolHost it = (ProtocolHost)element$iv;
                boolean bl2 = false;
                it.init();
            }
            this.isReady.setValue((Object)true);
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void getPair$reportDiff(String label, String current, String prev) {
        logger.info(label + " current: \"" + current + "\", previous: \"" + prev + "\"");
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProtocolManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProtocolManager.logger = logger;
        protocolNameCounter = new AtomicInteger();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ(\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020\u0004H\u0002J\u0006\u0010*\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/protocol/ProtocolManager$Companion;", "", "()V", "DISABLE_RESHARPER_BACKEND", "", "getProcessFromEBSTimeKey", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "onlyOneProcess", "", "getOnlyOneProcess", "()Z", "setOnlyOneProcess", "(Z)V", "protocolNameCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "Lcom/jetbrains/rd/util/AtomicInteger;", "runReSharperProcessTimeKey", "allowBackgroundThreadAndSuppressPumping", "Lcom/jetbrains/rd/framework/Protocol;", "dispatcher", "Lcom/jetbrains/rdclient/protocol/RdDispatcher;", "create", "Lkotlin/Function0;", "createProtocol", "application", "Lcom/intellij/openapi/application/Application;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "serializers", "Lcom/jetbrains/rd/framework/Serializers;", "wire", "Lcom/jetbrains/rd/framework/IWire;", "createProtocolFromEBS", "ebs", "Lcom/jetbrains/rider/protocol/EarlyBackendStarter;", "getInstance", "Lcom/jetbrains/rider/protocol/ProtocolManager;", "getProtocolName", "isResharperBackendDisabled", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nProtocolManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolManager.kt\ncom/jetbrains/rider/protocol/ProtocolManager$Companion\n+ 2 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n*L\n1#1,471:1\n39#2,5:472\n*S KotlinDebug\n*F\n+ 1 ProtocolManager.kt\ncom/jetbrains/rider/protocol/ProtocolManager$Companion\n*L\n165#1:472,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public final boolean getOnlyOneProcess() {
            return onlyOneProcess;
        }

        public final void setOnlyOneProcess(boolean bl) {
            onlyOneProcess = bl;
        }

        private final String getProtocolName() {
            return "RiderBackend " + protocolNameCounter.getAndIncrement();
        }

        @NotNull
        public final ProtocolManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            return ApplicationProtocolKt.getProtocolManager(application);
        }

        @NotNull
        public final Protocol createProtocol(@NotNull Application application, @NotNull Lifetime lifetime2) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            RdDispatcher dispatcher = new RdDispatcher(application, lifetime2);
            Serializers serializers = new Serializers();
            SocketWire.Server wire = new SocketWire.Server(lifetime2, (IScheduler)dispatcher, null, "FrontendToBackend", false, 16, null);
            return this.allowBackgroundThreadAndSuppressPumping(dispatcher, (Function0<Protocol>)((Function0)new Function0<Protocol>(lifetime2, dispatcher, serializers, wire){
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ RdDispatcher $dispatcher;
                final /* synthetic */ Serializers $serializers;
                final /* synthetic */ SocketWire.Server $wire;
                {
                    this.$lifetime = $lifetime;
                    this.$dispatcher = $dispatcher;
                    this.$serializers = $serializers;
                    this.$wire = $wire;
                    super(0);
                }

                @NotNull
                public final Protocol invoke() {
                    return com.jetbrains.rider.protocol.ProtocolManager$Companion.access$createProtocol(ProtocolManager.Companion, this.$lifetime, this.$dispatcher, this.$serializers, (IWire)this.$wire);
                }
            }));
        }

        private final Protocol createProtocolFromEBS(Application application, Lifetime lifetime2, EarlyBackendStarter ebs) {
            lifetime2.onTermination((Function0)new Function0<Unit>(ebs){
                final /* synthetic */ EarlyBackendStarter $ebs;
                {
                    this.$ebs = $ebs;
                    super(0);
                }

                public final void invoke() {
                    LifetimeDefinition.terminate$default((LifetimeDefinition)this.$ebs.getLifetimeDef(), (boolean)false, (int)1, null);
                }
            });
            RdDispatcher dispatcher = new RdDispatcher(application, lifetime2);
            return (Protocol)ebs.setActualSchedulerWithProtocolInitBlock(dispatcher, (Function0)new Function0<Protocol>(dispatcher, lifetime2, ebs){
                final /* synthetic */ RdDispatcher $dispatcher;
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ EarlyBackendStarter $ebs;
                {
                    this.$dispatcher = $dispatcher;
                    this.$lifetime = $lifetime;
                    this.$ebs = $ebs;
                    super(0);
                }

                @NotNull
                public final Protocol invoke() {
                    return com.jetbrains.rider.protocol.ProtocolManager$Companion.access$allowBackgroundThreadAndSuppressPumping(ProtocolManager.Companion, this.$dispatcher, (Function0)new Function0<Protocol>(this.$lifetime, this.$ebs){
                        final /* synthetic */ Lifetime $lifetime;
                        final /* synthetic */ EarlyBackendStarter $ebs;
                        {
                            this.$lifetime = $lifetime;
                            this.$ebs = $ebs;
                            super(0);
                        }

                        @NotNull
                        public final Protocol invoke() {
                            return com.jetbrains.rider.protocol.ProtocolManager$Companion.access$createProtocol(ProtocolManager.Companion, this.$lifetime, (IRdDispatcher)this.$ebs.getSwitchingScheduler(), this.$ebs.getSerializers(), (IWire)this.$ebs.getPreparedWire());
                        }
                    });
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Protocol allowBackgroundThreadAndSuppressPumping(RdDispatcher dispatcher, Function0<Protocol> create2) {
            Lifetime.Companion this_$iv = Lifetime.Companion;
            boolean $i$f$using = false;
            LifetimeDefinition def$iv = new LifetimeDefinition();
            try {
                Lifetime protocolCreationLifetime = def$iv.getLifetime();
                boolean bl = false;
                dispatcher.allowBackgroundThreadAndSuppressPumping(protocolCreationLifetime);
                Protocol protocol = (Protocol)create2.invoke();
                return protocol;
            }
            finally {
                LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
            }
        }

        private final Protocol createProtocol(Lifetime lifetime2, IRdDispatcher dispatcher, Serializers serializers, IWire wire) {
            Protocol protocol;
            Identities identity = new Identities(IdKind.Client);
            Protocol protocol2 = new Protocol[]{RdConstants.INSTANCE.getClientIdContext()};
            Protocol $this$createProtocol_u24lambda_u241 = protocol2 = (protocol = new Protocol(this.getProtocolName(), (ISerializers)serializers, (IIdentities)identity, (IScheduler)dispatcher, wire, lifetime2, (RdContext[])protocol2));
            boolean bl = false;
            $this$createProtocol_u24lambda_u241.getContexts().getValueSet(RdConstants.INSTANCE.getClientIdContext()).add((Object)ClientId.Companion.getLocalId().getValue());
            return protocol2;
        }

        public final boolean isResharperBackendDisabled() {
            return System.getProperty(ProtocolManager.DISABLE_RESHARPER_BACKEND) != null || EarlyBackendStarter.Companion.isDisabled();
        }

        public static final /* synthetic */ Protocol access$createProtocol(Companion $this, Lifetime lifetime2, IRdDispatcher dispatcher, Serializers serializers, IWire wire) {
            return $this.createProtocol(lifetime2, dispatcher, serializers, wire);
        }

        public static final /* synthetic */ Protocol access$allowBackgroundThreadAndSuppressPumping(Companion $this, RdDispatcher dispatcher, Function0 create2) {
            return $this.allowBackgroundThreadAndSuppressPumping(dispatcher, (Function0<Protocol>)create2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

