/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.jetbrains.rider.protocol.BackendCrashAnalyzer;
import com.jetbrains.rider.protocol.NetFrameworkVersionNotSupportedKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/protocol/NetFrameworkVersionNotSupported;", "Lcom/jetbrains/rider/protocol/BackendCrashAnalyzer;", "()V", "guessNetFxVersion", "Lcom/intellij/openapi/util/Version;", "tryGetFailReason", "", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nNetFrameworkVersionNotSupported.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetFrameworkVersionNotSupported.kt\ncom/jetbrains/rider/protocol/NetFrameworkVersionNotSupported\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,54:1\n1#2:55\n23#3:56\n*S KotlinDebug\n*F\n+ 1 NetFrameworkVersionNotSupported.kt\ncom/jetbrains/rider/protocol/NetFrameworkVersionNotSupported\n*L\n46#1:56\n*E\n"})
public final class NetFrameworkVersionNotSupported
implements BackendCrashAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NET_FRAMEWORK_KEY_PATH = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v4\\Full";
    @NotNull
    public static final String NET_FRAMEWORK_KEY_NAME = "Release";

    /*
     * Unable to fully structure code
     */
    private final Version guessNetFxVersion() {
        var2_1 = WindowsRegistryUtil.readRegistryValue((String)"HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v4\\Full", (String)"Release");
        if (var2_1 == null) ** GOTO lbl-1000
        it = var2_1;
        $i$a$-let-NetFrameworkVersionNotSupported$guessNetFxVersion$value$1 = false;
        var3_4 = it.subSequence(2, it.length());
        if (var3_4 != null && (var4_5 = var3_4.toString()) != null) {
            v0 = var4_5;
        } else lbl-1000:
        // 2 sources

        {
            v0 = "0";
        }
        value = Integer.parseInt(v0, 16);
        if (value >= 528040) {
            return new Version(4, 8, 0);
        }
        if (value >= 461808) {
            return new Version(4, 7, 2);
        }
        if (value >= 461308) {
            return new Version(4, 7, 1);
        }
        if (value >= 460798) {
            return new Version(4, 7, 0);
        }
        if (value >= 394802) {
            return new Version(4, 6, 2);
        }
        if (value >= 394254) {
            return new Version(4, 6, 1);
        }
        if (value >= 393295) {
            return new Version(4, 6, 0);
        }
        if (value >= 379893) {
            return new Version(4, 5, 2);
        }
        if (value >= 378675) {
            return new Version(4, 5, 1);
        }
        if (value >= 378389) {
            return new Version(4, 0, 0);
        }
        return NetFrameworkVersionNotSupportedKt.access$getUNKNOWN_VERSION$p();
    }

    @Override
    @Nullable
    public String tryGetFailReason() {
        if (!SystemInfo.isWindows) {
            return null;
        }
        Version netFxVersion = this.guessNetFxVersion();
        if (netFxVersion.compareTo(NetFrameworkVersionNotSupportedKt.access$getREQUIRED_NET_FX_VERSION$p()) == -1 || Intrinsics.areEqual((Object)netFxVersion, (Object)NetFrameworkVersionNotSupportedKt.access$getUNKNOWN_VERSION$p())) {
            NetFrameworkVersionNotSupported $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NetFrameworkVersionNotSupported.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Detected .NET Framework version (" + netFxVersion + ") is lower than required (" + NetFrameworkVersionNotSupportedKt.access$getREQUIRED_NET_FX_VERSION$p() + ").");
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/protocol/NetFrameworkVersionNotSupported$Companion;", "", "()V", "NET_FRAMEWORK_KEY_NAME", "", "NET_FRAMEWORK_KEY_PATH", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

