/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.workspace.utils;

import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000f\u001a\u00020\u000bJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011J\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\b\u001a\u00020\rJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/projectView/workspace/utils/VirtualFileUrlTree;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "manager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;)V", "root", "Lcom/jetbrains/rider/projectView/workspace/utils/VirtualFileUrlTree$Node;", "add", "", "url", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "addNode", "clear", "collectAll", "", "collectNodes", "node", "result", "", "collectUnder", "findNode", "findRoot", "findRootNode", "Lkotlin/Pair;", "", "remove", "Node", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVirtualFileUrlTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileUrlTree.kt\ncom/jetbrains/rider/projectView/workspace/utils/VirtualFileUrlTree\n+ 2 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n66#2,3:95\n1#3:98\n*S KotlinDebug\n*F\n+ 1 VirtualFileUrlTree.kt\ncom/jetbrains/rider/projectView/workspace/utils/VirtualFileUrlTree\n*L\n53#1:95,3\n*E\n"})
public final class VirtualFileUrlTree {
    @NotNull
    private final VirtualFileUrlManager manager;
    @NotNull
    private Node root;

    public VirtualFileUrlTree(@NotNull VirtualFileUrlManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.root = new Node(null);
    }

    public VirtualFileUrlTree(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this(WorkspaceModel.Companion.getInstance(project2).getVirtualFileUrlManager());
    }

    public final void add(@NotNull VirtualFileUrl url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Node node = this.addNode(url2);
        int n = node.getReferences();
        node.setReferences(n + 1);
    }

    public final void remove(@NotNull VirtualFileUrl url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Node node = this.findNode(url2);
        if (node == null) {
            return;
        }
        Node node2 = node;
        int n = node2.getReferences();
        node2.setReferences(n + -1);
    }

    public final void clear() {
        this.root = new Node(null);
    }

    @Nullable
    public final VirtualFileUrl findRoot(@NotNull VirtualFileUrl url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Node rootNode = (Node)this.findRootNode(url2).getFirst();
        if (rootNode.getReferences() > 0) {
            return rootNode.getUrl();
        }
        return null;
    }

    @NotNull
    public final List<VirtualFileUrl> collectAll() {
        List result2 = new ArrayList();
        this.collectNodes(this.root, result2);
        return result2;
    }

    @NotNull
    public final List<VirtualFileUrl> collectUnder(@NotNull VirtualFileUrl root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Node node = this.findNode(root);
        if (node == null) {
            return CollectionsKt.emptyList();
        }
        Node node2 = node;
        List result2 = new ArrayList();
        this.collectNodes(node2, result2);
        return result2;
    }

    private final Node addNode(VirtualFileUrl url2) {
        VirtualFileUrl parentUrl = url2.getParent();
        Node parentNode = parentUrl == null ? this.root : this.addNode(parentUrl);
        Map $this$getOrCreate$iv = parentNode.getChildren();
        boolean $i$f$getOrCreate = false;
        Object object = $this$getOrCreate$iv.get(url2);
        if (object == null) {
            VirtualFileUrl it = url2;
            boolean bl = false;
            Node it$iv = new Node(url2);
            boolean bl2 = false;
            $this$getOrCreate$iv.put(url2, it$iv);
            object = it$iv;
        }
        return (Node)object;
    }

    private final void collectNodes(Node node, List<VirtualFileUrl> result2) {
        if (node.getReferences() > 0) {
            VirtualFileUrl virtualFileUrl = node.getUrl();
            if (virtualFileUrl != null) {
                VirtualFileUrl it = virtualFileUrl;
                boolean bl = false;
                result2.add(it);
            }
        } else {
            for (Node child : node.getChildren().values()) {
                Intrinsics.checkNotNull((Object)child);
                this.collectNodes(child, result2);
            }
        }
    }

    private final Node findNode(VirtualFileUrl url2) {
        Node parentNode;
        VirtualFileUrl parentUrl = url2.getParent();
        Node node = parentNode = parentUrl == null ? this.root : this.findNode(parentUrl);
        return node == null ? null : node.getChildren().get(url2);
    }

    private final Pair<Node, Boolean> findRootNode(VirtualFileUrl url2) {
        Node node;
        VirtualFileUrl parentUrl = url2.getParent();
        Pair pair2 = parentUrl == null ? new Pair((Object)this.root, (Object)true) : this.findRootNode(parentUrl);
        Node parentNode = (Node)pair2.component1();
        boolean continueSearch = (Boolean)pair2.component2();
        if (continueSearch && (node = parentNode.getChildren().get(url2)) != null) {
            return node.getReferences() > 0 ? new Pair((Object)node, (Object)false) : new Pair((Object)node, (Object)true);
        }
        return new Pair((Object)parentNode, (Object)false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R-\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00000\u0006j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0000`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/projectView/workspace/utils/VirtualFileUrlTree$Node;", "", "url", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;)V", "children", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getChildren", "()Ljava/util/HashMap;", "references", "", "getReferences", "()I", "setReferences", "(I)V", "getUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "intellij.rider.rdclient.dotnet"})
    private static final class Node {
        @Nullable
        private final VirtualFileUrl url;
        @NotNull
        private final HashMap<VirtualFileUrl, Node> children;
        private int references;

        public Node(@Nullable VirtualFileUrl url2) {
            this.url = url2;
            this.children = new HashMap();
        }

        @Nullable
        public final VirtualFileUrl getUrl() {
            return this.url;
        }

        @NotNull
        public final HashMap<VirtualFileUrl, Node> getChildren() {
            return this.children;
        }

        public final int getReferences() {
            return this.references;
        }

        public final void setReferences(int n) {
            this.references = n;
        }
    }
}

