/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.workspace.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdUnloadProjectDescriptor;
import com.jetbrains.rider.model.RdUnloadProjectState;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelEvents;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\u0011\u001a\u00020\u0012*\u00020\fH\u0002R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/HashMap;", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount$ProjectsCount;", "Lkotlin/collections/HashMap;", "calculateCount", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "calculateCountRecursively", "clearCache", "", "get", "isCountableEntity", "", "Companion", "CountableProjectsPolicy", "ProjectsCount", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nWorkspaceProjectsCount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceProjectsCount.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1747#2,3:107\n*S KotlinDebug\n*F\n+ 1 WorkspaceProjectsCount.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount\n*L\n61#1:107,3\n*E\n"})
public final class WorkspaceProjectsCount
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final HashMap<ProjectModelEntityReference, ProjectsCount> cache;

    public WorkspaceProjectsCount(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.cache = new HashMap();
        WorkspaceModelEvents.Companion.getInstance(this.project).getAddSignal().advise(this.getServiceLifetime(), (Function1)new Function1<WorkspaceModelEvents.AddEntityEvent, Unit>(){

            public final void invoke(@NotNull WorkspaceModelEvents.AddEntityEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.isCountableEntity(it.getEntity())) {
                    this.clearCache();
                }
            }
        });
        WorkspaceModelEvents.Companion.getInstance(this.project).getRemoveSignal().advise(this.getServiceLifetime(), (Function1)new Function1<WorkspaceModelEvents.RemoveEntityEvent, Unit>(){

            public final void invoke(@NotNull WorkspaceModelEvents.RemoveEntityEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.isCountableEntity(it.getEntity())) {
                    this.clearCache();
                }
            }
        });
        WorkspaceModelEvents.Companion.getInstance(this.project).getUpdateSignal().advise(this.getServiceLifetime(), (Function1)new Function1<WorkspaceModelEvents.UpdateEntityEvent, Unit>(){

            public final void invoke(@NotNull WorkspaceModelEvents.UpdateEntityEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.isCountableEntity(it.getOldEntity()) || this.isCountableEntity(it.getNewEntity())) {
                    this.clearCache();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ProjectsCount get(@NotNull ProjectModelEntity entity2) {
        ProjectsCount projectsCount;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        boolean bl2 = bl = ProjectModelEntityExtensionsKt.isSolution(entity2) || ProjectModelEntityExtensionsKt.isSolutionFolder(entity2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        HashMap<ProjectModelEntityReference, ProjectsCount> hashMap = this.cache;
        synchronized (hashMap) {
            ProjectsCount projectsCount2;
            ProjectModelEntity solutionEntity;
            boolean bl3 = false;
            if (this.cache.isEmpty() && (solutionEntity = WorkspaceModelExtensionsKt.getSolutionEntity(WorkspaceModel.Companion.getInstance(this.project))) != null) {
                this.calculateCountRecursively(solutionEntity);
            }
            if ((projectsCount2 = this.cache.get(ProjectModelEntityExtensionsKt.toReference(entity2))) == null) {
                projectsCount2 = new ProjectsCount(0, 0, 0, 0);
            }
            ProjectsCount projectsCount3 = projectsCount2;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl17 : MonitorExitStatement: MONITOREXIT : var4_4
            projectsCount = projectsCount3;
        }
        Intrinsics.checkNotNullExpressionValue((Object)projectsCount, (String)"synchronized(...)");
        return projectsCount;
    }

    private final ProjectsCount calculateCountRecursively(ProjectModelEntity entity2) {
        ProjectsCount count = this.calculateCount(entity2);
        for (ProjectModelEntity childEntity : entity2.getChildrenEntities()) {
            if (!this.isCountableEntity(childEntity)) continue;
            count.add(this.calculateCountRecursively(childEntity));
        }
        ((Map)this.cache).put(ProjectModelEntityExtensionsKt.toReference(entity2), count);
        return count;
    }

    private final ProjectsCount calculateCount(ProjectModelEntity entity2) {
        boolean bl;
        block11: {
            if (ProjectModelEntityExtensionsKt.isSolution(entity2) || ProjectModelEntityExtensionsKt.isSolutionFolder(entity2)) {
                return new ProjectsCount(0, 0, 0, 0, 15, null);
            }
            Iterable $this$any$iv = CountableProjectsPolicy.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CountableProjectsPolicy it = (CountableProjectsPolicy)element$iv;
                    boolean bl2 = false;
                    if (!it.shouldBeSkipped(this.project, entity2)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return new ProjectsCount(0, 0, 0, 0, 15, null);
        }
        ProjectsCount result2 = new ProjectsCount(1, 0, 0, 0, 14, null);
        RdProjectModelItemDescriptor descriptor = entity2.getDescriptor();
        if (descriptor instanceof RdUnloadProjectDescriptor) {
            switch (WhenMappings.$EnumSwitchMapping$0[((RdUnloadProjectDescriptor)descriptor).getState().ordinal()]) {
                case 1: {
                    int n = result2.getFailed();
                    result2.setFailed(n + 1);
                    break;
                }
                case 2: {
                    int n = result2.getUnloaded();
                    result2.setUnloaded(n + 1);
                    break;
                }
                case 3: {
                    int n = result2.getFiltered();
                    result2.setFiltered(n + 1);
                }
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearCache() {
        HashMap<ProjectModelEntityReference, ProjectsCount> hashMap = this.cache;
        synchronized (hashMap) {
            boolean bl = false;
            this.cache.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean isCountableEntity(ProjectModelEntity $this$isCountableEntity) {
        return ProjectModelEntityExtensionsKt.isSolution($this$isCountableEntity) || ProjectModelEntityExtensionsKt.isSolutionFolder($this$isCountableEntity) || ProjectModelEntityExtensionsKt.isUnloadedProject($this$isCountableEntity) || ProjectModelEntityExtensionsKt.isProject($this$isCountableEntity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nWorkspaceProjectsCount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceProjectsCount.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,106:1\n31#2,2:107\n*S KotlinDebug\n*F\n+ 1 WorkspaceProjectsCount.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount$Companion\n*L\n16#1:107,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorkspaceProjectsCount getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<WorkspaceProjectsCount> serviceClass$iv = WorkspaceProjectsCount.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (WorkspaceProjectsCount)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount$CountableProjectsPolicy;", "", "shouldBeSkipped", "", "project", "Lcom/intellij/openapi/project/Project;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "Companion", "intellij.rider.rdclient.dotnet"})
    public static interface CountableProjectsPolicy {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean shouldBeSkipped(@NotNull Project var1, @NotNull ProjectModelEntity var2);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount$CountableProjectsPolicy$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount$CountableProjectsPolicy;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.rider.rdclient.dotnet"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final ExtensionPointName<CountableProjectsPolicy> EP_NAME;

            private Companion() {
            }

            @NotNull
            public final ExtensionPointName<CountableProjectsPolicy> getEP_NAME() {
                return EP_NAME;
            }

            static {
                $$INSTANCE = new Companion();
                EP_NAME = ExtensionPointName.Companion.create("com.intellij.rider.workspaceCountableProjectsPolicy");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceProjectsCount$ProjectsCount;", "", "total", "", "failed", "unloaded", "filtered", "(IIII)V", "getFailed", "()I", "setFailed", "(I)V", "getFiltered", "setFiltered", "getTotal", "setTotal", "getUnloaded", "setUnloaded", "add", "", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "hashCode", "toString", "", "intellij.rider.rdclient.dotnet"})
    public static final class ProjectsCount {
        private int total;
        private int failed;
        private int unloaded;
        private int filtered;

        public ProjectsCount(int total, int failed, int unloaded, int filtered) {
            this.total = total;
            this.failed = failed;
            this.unloaded = unloaded;
            this.filtered = filtered;
        }

        public /* synthetic */ ProjectsCount(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                n = 0;
            }
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 4) != 0) {
                n3 = 0;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            this(n, n2, n3, n4);
        }

        public final int getTotal() {
            return this.total;
        }

        public final void setTotal(int n) {
            this.total = n;
        }

        public final int getFailed() {
            return this.failed;
        }

        public final void setFailed(int n) {
            this.failed = n;
        }

        public final int getUnloaded() {
            return this.unloaded;
        }

        public final void setUnloaded(int n) {
            this.unloaded = n;
        }

        public final int getFiltered() {
            return this.filtered;
        }

        public final void setFiltered(int n) {
            this.filtered = n;
        }

        public final void add(@NotNull ProjectsCount other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.total += other.total;
            this.failed += other.failed;
            this.unloaded += other.unloaded;
            this.filtered += other.filtered;
        }

        public final int component1() {
            return this.total;
        }

        public final int component2() {
            return this.failed;
        }

        public final int component3() {
            return this.unloaded;
        }

        public final int component4() {
            return this.filtered;
        }

        @NotNull
        public final ProjectsCount copy(int total, int failed, int unloaded, int filtered) {
            return new ProjectsCount(total, failed, unloaded, filtered);
        }

        public static /* synthetic */ ProjectsCount copy$default(ProjectsCount projectsCount, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = projectsCount.total;
            }
            if ((n5 & 2) != 0) {
                n2 = projectsCount.failed;
            }
            if ((n5 & 4) != 0) {
                n3 = projectsCount.unloaded;
            }
            if ((n5 & 8) != 0) {
                n4 = projectsCount.filtered;
            }
            return projectsCount.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "ProjectsCount(total=" + this.total + ", failed=" + this.failed + ", unloaded=" + this.unloaded + ", filtered=" + this.filtered + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.total);
            result2 = result2 * 31 + Integer.hashCode(this.failed);
            result2 = result2 * 31 + Integer.hashCode(this.unloaded);
            result2 = result2 * 31 + Integer.hashCode(this.filtered);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectsCount)) {
                return false;
            }
            ProjectsCount projectsCount = (ProjectsCount)other;
            if (this.total != projectsCount.total) {
                return false;
            }
            if (this.failed != projectsCount.failed) {
                return false;
            }
            if (this.unloaded != projectsCount.unloaded) {
                return false;
            }
            return this.filtered == projectsCount.filtered;
        }

        public ProjectsCount() {
            this(0, 0, 0, 0, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdUnloadProjectState.values().length];
            try {
                nArray[RdUnloadProjectState.LoadFailed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdUnloadProjectState.Unloaded.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdUnloadProjectState.Filtered.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

