/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.workspace.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SingleAlarm;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rider.projectView.ProjectModelViewUpdaterAsync;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceEntityErrorsSupport;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceModelUpdater;
import com.jetbrains.rider.solutionAnalysis.SolutionAnalysisHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000  2\u00020\u0001:\u0004 !\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u0015J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "errors", "Ljava/util/HashMap;", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EntityErrorData;", "Lkotlin/collections/HashMap;", "isReady", "", "()Z", "queue", "", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$Event;", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "addErrorMark", "", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "addErrorMarkForParents", "count", "", "forceUpdate", "hasErrors", "performUpdate", "removeErrorMark", "removeErrorMarkForParents", "Companion", "EntityErrorData", "Event", "EventType", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nWorkspaceEntityErrorsSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceEntityErrorsSupport.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,184:1\n372#2,7:185\n372#2,7:192\n13#3:199\n*S KotlinDebug\n*F\n+ 1 WorkspaceEntityErrorsSupport.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport\n*L\n143#1:185,7\n153#1:192,7\n26#1:199\n*E\n"})
public final class WorkspaceEntityErrorsSupport
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final HashMap<ProjectModelEntityReference, EntityErrorData> errors;
    @NotNull
    private final WorkspaceModel workspaceModel;
    @NotNull
    private final List<Event> queue;
    @NotNull
    private final SingleAlarm alarm;
    @NotNull
    private static final Logger logger;

    public WorkspaceEntityErrorsSupport(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.errors = new HashMap();
        this.workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        this.queue = new ArrayList();
        this.alarm = new SingleAlarm(() -> WorkspaceEntityErrorsSupport.alarm$lambda$0(this), 100, Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        ApplicationKt.getApplication().invokeLater(() -> WorkspaceEntityErrorsSupport._init_$lambda$1(this));
    }

    public final boolean isReady() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        return this.queue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasErrors(@NotNull ProjectModelEntity entity2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        HashMap<ProjectModelEntityReference, EntityErrorData> hashMap = this.errors;
        synchronized (hashMap) {
            boolean bl2 = false;
            EntityErrorData data2 = this.errors.get(ProjectModelEntityExtensionsKt.toReference(entity2));
            bl = data2 != null && (data2.getHasErrors() || data2.getChildrenErrors() > 0);
        }
        return bl;
    }

    public final void forceUpdate() {
        this.alarm.cancelAndRequest(true);
    }

    private final void performUpdate() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        WorkspaceModelUpdater updater = WorkspaceModelUpdater.Companion.getInstance(this.project);
        updater.doWhenReady((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WorkspaceEntityErrorsSupport this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                if (WorkspaceEntityErrorsSupport.access$getQueue$p(this.this$0).isEmpty()) {
                    return;
                }
                HashMap hashMap = WorkspaceEntityErrorsSupport.access$getErrors$p(this.this$0);
                WorkspaceEntityErrorsSupport workspaceEntityErrorsSupport = this.this$0;
                HashMap hashMap2 = hashMap;
                synchronized (hashMap2) {
                    boolean bl = false;
                    for (Event event : WorkspaceEntityErrorsSupport.access$getQueue$p(workspaceEntityErrorsSupport)) {
                        ProjectModelEntity entity2;
                        if (WorkspaceModelExtensionsKt.getProjectModelEntity(WorkspaceEntityErrorsSupport.access$getWorkspaceModel$p(workspaceEntityErrorsSupport), event.getId()) == null) continue;
                        Logger $this$trace$iv = WorkspaceEntityErrorsSupport.access$getLogger$cp();
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv;
                            boolean bl2 = false;
                            logger.trace("Update " + event.getId() + " " + entity2.getName());
                        }
                        switch (performUpdate.WhenMappings.$EnumSwitchMapping$0[event.getEventType().ordinal()]) {
                            case 1: {
                                WorkspaceEntityErrorsSupport.access$addErrorMark(workspaceEntityErrorsSupport, entity2);
                                break;
                            }
                            case 2: {
                                WorkspaceEntityErrorsSupport.access$removeErrorMark(workspaceEntityErrorsSupport, entity2);
                            }
                        }
                    }
                    WorkspaceEntityErrorsSupport.access$getQueue$p(workspaceEntityErrorsSupport).clear();
                    Unit unit = Unit.INSTANCE;
                }
                Logger $this$trace$iv = WorkspaceEntityErrorsSupport.access$getLogger$cp();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Errors were updated");
                }
                ProjectModelViewUpdaterAsync.Companion.getInstance(WorkspaceEntityErrorsSupport.access$getProject$p(this.this$0)).requestUpdatePresentation();
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void addErrorMark(ProjectModelEntity entity2) {
        EntityErrorData errorData;
        Object object;
        void $this$getOrPut$iv;
        Map map = this.errors;
        ProjectModelEntityReference key$iv = ProjectModelEntityExtensionsKt.toReference(entity2);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            EntityErrorData answer$iv = new EntityErrorData();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((errorData = (EntityErrorData)object).getHasErrors()) {
            return;
        }
        errorData.setHasErrors(true);
        this.addErrorMarkForParents(entity2, 1);
    }

    /*
     * WARNING - void declaration
     */
    private final void addErrorMarkForParents(ProjectModelEntity entity2, int count) {
        for (ProjectModelEntity parent = entity2.getParentEntity(); parent != null; parent = parent.getParentEntity()) {
            Object object;
            void $this$getOrPut$iv;
            Map map = this.errors;
            ProjectModelEntityReference key$iv = ProjectModelEntityExtensionsKt.toReference(parent);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                EntityErrorData answer$iv = new EntityErrorData();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            EntityErrorData errorData = (EntityErrorData)object;
            errorData.setChildrenErrors(errorData.getChildrenErrors() + count);
        }
    }

    private final void removeErrorMark(ProjectModelEntity entity2) {
        EntityErrorData entityErrorData = this.errors.remove(ProjectModelEntityExtensionsKt.toReference(entity2));
        if (entityErrorData == null) {
            return;
        }
        EntityErrorData errorData = entityErrorData;
        int count = errorData.getTotalErrors();
        if (count == 0) {
            return;
        }
        this.removeErrorMarkForParents(entity2, count);
    }

    private final void removeErrorMarkForParents(ProjectModelEntity entity2, int count) {
        for (ProjectModelEntity parent = entity2.getParentEntity(); parent != null; parent = parent.getParentEntity()) {
            EntityErrorData errorData = this.errors.get(ProjectModelEntityExtensionsKt.toReference(parent));
            if (errorData == null) continue;
            errorData.setChildrenErrors(errorData.getChildrenErrors() - count);
        }
    }

    private static final void alarm$lambda$0(WorkspaceEntityErrorsSupport this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.performUpdate();
    }

    private static final void _init_$lambda$1(WorkspaceEntityErrorsSupport this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.project.isDisposed()) {
            return;
        }
        SolutionAnalysisHost solutionAnalysisHost = SolutionAnalysisHost.Companion.getInstance(this$0.project);
        solutionAnalysisHost.getErrorsRegistered().advise(this$0.getServiceLifetime(), (Function1)new Function1<Integer, Unit>(this$0){
            final /* synthetic */ WorkspaceEntityErrorsSupport this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                ApplicationKt.getApplication().assertIsDispatchThread();
                Logger $this$trace$iv = WorkspaceEntityErrorsSupport.access$getLogger$cp();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Register error for " + it + "...");
                }
                WorkspaceEntityErrorsSupport.access$getQueue$p(this.this$0).add(new Event(it, EventType.Add));
                SingleAlarm.cancelAndRequest$default((SingleAlarm)WorkspaceEntityErrorsSupport.access$getAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
        });
        solutionAnalysisHost.getErrorsUnregistered().advise(this$0.getServiceLifetime(), (Function1)new Function1<Integer, Unit>(this$0){
            final /* synthetic */ WorkspaceEntityErrorsSupport this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                ApplicationKt.getApplication().assertIsDispatchThread();
                Logger $this$trace$iv = WorkspaceEntityErrorsSupport.access$getLogger$cp();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Unregister error for " + it + "...");
                }
                WorkspaceEntityErrorsSupport.access$getQueue$p(this.this$0).add(new Event(it, EventType.Remove));
                SingleAlarm.cancelAndRequest$default((SingleAlarm)WorkspaceEntityErrorsSupport.access$getAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
        });
        WorkspaceModelChangeListener listener2 = new WorkspaceModelChangeListener(this$0){
            final /* synthetic */ WorkspaceEntityErrorsSupport this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed(@NotNull VersionedStorageChange event) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                HashMap hashMap = WorkspaceEntityErrorsSupport.access$getErrors$p(this.this$0);
                Object object2 = this.this$0;
                Object object3 = hashMap;
                synchronized (object3) {
                    boolean bl = false;
                    if (WorkspaceEntityErrorsSupport.access$getErrors$p(object2).isEmpty()) {
                        return;
                    }
                    object = Unit.INSTANCE;
                }
                List changes2 = event.getChanges(ProjectModelEntity.class);
                if (!CollectionsKt.any((Iterable)changes2)) {
                    return;
                }
                object2 = WorkspaceEntityErrorsSupport.access$getErrors$p(this.this$0);
                object3 = this.this$0;
                object = object2;
                synchronized (object) {
                    boolean bl = false;
                    for (EntityChange change : changes2) {
                        if (change instanceof EntityChange.Removed) {
                            WorkspaceEntityErrorsSupport.access$removeErrorMark((WorkspaceEntityErrorsSupport)((Object)object3), (ProjectModelEntity)((EntityChange.Removed)change).getOldEntity());
                        }
                        if (!(change instanceof EntityChange.Replaced)) continue;
                        ProjectModelEntityReference reference = ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)((EntityChange.Replaced)change).getOldEntity());
                        EntityErrorData errorData = (EntityErrorData)WorkspaceEntityErrorsSupport.access$getErrors$p((WorkspaceEntityErrorsSupport)((Object)object3)).get(reference);
                        if (errorData == null || errorData.getTotalErrors() <= 0) continue;
                        WorkspaceEntityErrorsSupport.access$removeErrorMarkForParents((WorkspaceEntityErrorsSupport)((Object)object3), (ProjectModelEntity)((EntityChange.Replaced)change).getOldEntity(), errorData.getTotalErrors());
                        WorkspaceEntityErrorsSupport.access$addErrorMarkForParents((WorkspaceEntityErrorsSupport)((Object)object3), (ProjectModelEntity)((EntityChange.Replaced)change).getNewEntity(), errorData.getTotalErrors());
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        };
        this$0.project.getMessageBus().connect((Disposable)this$0).subscribe(WorkspaceModelTopics.CHANGED, (Object)listener2);
    }

    public static final /* synthetic */ List access$getQueue$p(WorkspaceEntityErrorsSupport $this) {
        return $this.queue;
    }

    public static final /* synthetic */ HashMap access$getErrors$p(WorkspaceEntityErrorsSupport $this) {
        return $this.errors;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Project access$getProject$p(WorkspaceEntityErrorsSupport $this) {
        return $this.project;
    }

    public static final /* synthetic */ WorkspaceModel access$getWorkspaceModel$p(WorkspaceEntityErrorsSupport $this) {
        return $this.workspaceModel;
    }

    public static final /* synthetic */ void access$addErrorMark(WorkspaceEntityErrorsSupport $this, ProjectModelEntity entity2) {
        $this.addErrorMark(entity2);
    }

    public static final /* synthetic */ void access$removeErrorMark(WorkspaceEntityErrorsSupport $this, ProjectModelEntity entity2) {
        $this.removeErrorMark(entity2);
    }

    public static final /* synthetic */ SingleAlarm access$getAlarm$p(WorkspaceEntityErrorsSupport $this) {
        return $this.alarm;
    }

    public static final /* synthetic */ void access$removeErrorMarkForParents(WorkspaceEntityErrorsSupport $this, ProjectModelEntity entity2, int count) {
        $this.removeErrorMarkForParents(entity2, count);
    }

    public static final /* synthetic */ void access$addErrorMarkForParents(WorkspaceEntityErrorsSupport $this, ProjectModelEntity entity2, int count) {
        $this.addErrorMarkForParents(entity2, count);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceEntityErrorsSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        WorkspaceEntityErrorsSupport.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorkspaceEntityErrorsSupport getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(WorkspaceEntityErrorsSupport.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (WorkspaceEntityErrorsSupport)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EntityErrorData;", "", "()V", "childrenErrors", "", "getChildrenErrors", "()I", "setChildrenErrors", "(I)V", "hasErrors", "", "getHasErrors", "()Z", "setHasErrors", "(Z)V", "totalErrors", "getTotalErrors", "intellij.rider.rdclient.dotnet"})
    private static final class EntityErrorData {
        private boolean hasErrors;
        private int childrenErrors;

        public final boolean getHasErrors() {
            return this.hasErrors;
        }

        public final void setHasErrors(boolean bl) {
            this.hasErrors = bl;
        }

        public final int getChildrenErrors() {
            return this.childrenErrors;
        }

        public final void setChildrenErrors(int n) {
            this.childrenErrors = n;
        }

        public final int getTotalErrors() {
            return this.childrenErrors + (this.hasErrors ? 1 : 0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$Event;", "", "id", "", "eventType", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EventType;", "(ILcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EventType;)V", "getEventType", "()Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EventType;", "getId", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.rdclient.dotnet"})
    private static final class Event {
        private final int id;
        @NotNull
        private final EventType eventType;

        public Event(int id, @NotNull EventType eventType) {
            Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
            this.id = id;
            this.eventType = eventType;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final EventType getEventType() {
            return this.eventType;
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final EventType component2() {
            return this.eventType;
        }

        @NotNull
        public final Event copy(int id, @NotNull EventType eventType) {
            Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
            return new Event(id, eventType);
        }

        public static /* synthetic */ Event copy$default(Event event, int n, EventType eventType, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = event.id;
            }
            if ((n2 & 2) != 0) {
                eventType = event.eventType;
            }
            return event.copy(n, eventType);
        }

        @NotNull
        public String toString() {
            return "Event(id=" + this.id + ", eventType=" + this.eventType + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.id);
            result2 = result2 * 31 + this.eventType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Event)) {
                return false;
            }
            Event event = (Event)other;
            if (this.id != event.id) {
                return false;
            }
            return this.eventType == event.eventType;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EventType;", "", "(Ljava/lang/String;I)V", "Add", "Remove", "intellij.rider.rdclient.dotnet"})
    private static final class EventType
    extends Enum<EventType> {
        public static final /* enum */ EventType Add = new EventType();
        public static final /* enum */ EventType Remove = new EventType();
        private static final /* synthetic */ EventType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EventType[] values() {
            return (EventType[])$VALUES.clone();
        }

        public static EventType valueOf(String value2) {
            return Enum.valueOf(EventType.class, value2);
        }

        @NotNull
        public static EnumEntries<EventType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = eventTypeArray = new EventType[]{EventType.Add, EventType.Remove};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

