/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.workspace.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.platform.backend.workspace.BuilderSnapshot;
import com.intellij.platform.backend.workspace.StorageReplacement;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.model.RdCustomLocation;
import com.jetbrains.rider.model.RdNameLocation;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemLocation;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityKt;
import com.jetbrains.rider.projectView.workspace.SolutionPointerEntity;
import com.jetbrains.rider.projectView.workspace.SolutionPointerEntityKt;
import com.jetbrains.rider.projectView.workspace.impl.ProjectModelEntityBuilderKt;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceModelUpdater;
import com.jetbrains.rider.services.LowMemoryDialogService;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002\u001a2\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u001a>\u0010\r\u001a\u00020\u000e*\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e\u001a\u0012\u0010\u0017\u001a\u00020\u000b*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e\u001a\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015*\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u001a\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u0013*\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u001c"}, d2={"tryUpdateWorkspaceModel", "", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "project", "Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "action", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "", "updateWorkspaceModelFromBackground", "addOrUpdateProjectModelEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "entity", "descriptor", "Lcom/jetbrains/rider/model/RdProjectModelItemDescriptor;", "url", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "alternativeUrls", "", "parentEntity", "addOrUpdateSolutionPointerEntity", "calculateAlternativeVirtualFileUrls", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "calculateVirtualFileUrl", "parent", "intellij.rider.rdclient.dotnet"})
public final class ProjectModelEntityBuilderKt {
    @NotNull
    public static final ProjectModelEntity addOrUpdateProjectModelEntity(@NotNull MutableEntityStorage $this$addOrUpdateProjectModelEntity, @Nullable ProjectModelEntity entity2, @NotNull RdProjectModelItemDescriptor descriptor, @Nullable VirtualFileUrl url2, @NotNull List<? extends VirtualFileUrl> alternativeUrls, @Nullable ProjectModelEntity parentEntity) {
        ProjectModelEntity projectModelEntity;
        Intrinsics.checkNotNullParameter((Object)$this$addOrUpdateProjectModelEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(alternativeUrls, (String)"alternativeUrls");
        if (entity2 != null) {
            projectModelEntity = parentEntity != null ? ProjectModelEntityKt.modifyProjectModelEntity($this$addOrUpdateProjectModelEntity, entity2, (Function1<? super ProjectModelEntity.Builder, Unit>)((Function1)new Function1<ProjectModelEntity.Builder, Unit>($this$addOrUpdateProjectModelEntity, parentEntity, descriptor, url2, alternativeUrls){
                final /* synthetic */ MutableEntityStorage $this_addOrUpdateProjectModelEntity;
                final /* synthetic */ ProjectModelEntity $parentEntity;
                final /* synthetic */ RdProjectModelItemDescriptor $descriptor;
                final /* synthetic */ VirtualFileUrl $url;
                final /* synthetic */ List<VirtualFileUrl> $alternativeUrls;
                {
                    this.$this_addOrUpdateProjectModelEntity = $receiver;
                    this.$parentEntity = $parentEntity;
                    this.$descriptor = $descriptor;
                    this.$url = $url;
                    this.$alternativeUrls = $alternativeUrls;
                    super(1);
                }

                public final void invoke(@NotNull ProjectModelEntity.Builder $this$child) {
                    Intrinsics.checkNotNullParameter((Object)$this$child, (String)"$this$child");
                    ProjectModelEntityKt.modifyProjectModelEntity(this.$this_addOrUpdateProjectModelEntity, this.$parentEntity, (Function1<? super ProjectModelEntity.Builder, Unit>)((Function1)new Function1<ProjectModelEntity.Builder, Unit>($this$child, this.$descriptor, this.$url, this.$alternativeUrls){
                        final /* synthetic */ ProjectModelEntity.Builder $this_child;
                        final /* synthetic */ RdProjectModelItemDescriptor $descriptor;
                        final /* synthetic */ VirtualFileUrl $url;
                        final /* synthetic */ List<VirtualFileUrl> $alternativeUrls;
                        {
                            this.$this_child = $this_child;
                            this.$descriptor = $descriptor;
                            this.$url = $url;
                            this.$alternativeUrls = $alternativeUrls;
                            super(1);
                        }

                        public final void invoke(@NotNull ProjectModelEntity.Builder $this$parent) {
                            Intrinsics.checkNotNullParameter((Object)$this$parent, (String)"$this$parent");
                            this.$this_child.setDescriptor(this.$descriptor);
                            this.$this_child.setUrl(this.$url);
                            this.$this_child.setParentEntity($this$parent);
                            this.$this_child.setAlternativeUrls(CollectionsKt.toMutableList((Collection)this.$alternativeUrls));
                        }
                    }));
                }
            })) : ProjectModelEntityKt.modifyProjectModelEntity($this$addOrUpdateProjectModelEntity, entity2, (Function1<? super ProjectModelEntity.Builder, Unit>)((Function1)new Function1<ProjectModelEntity.Builder, Unit>(descriptor, url2, alternativeUrls){
                final /* synthetic */ RdProjectModelItemDescriptor $descriptor;
                final /* synthetic */ VirtualFileUrl $url;
                final /* synthetic */ List<VirtualFileUrl> $alternativeUrls;
                {
                    this.$descriptor = $descriptor;
                    this.$url = $url;
                    this.$alternativeUrls = $alternativeUrls;
                    super(1);
                }

                public final void invoke(@NotNull ProjectModelEntity.Builder $this$modifyProjectModelEntity) {
                    Intrinsics.checkNotNullParameter((Object)$this$modifyProjectModelEntity, (String)"$this$modifyProjectModelEntity");
                    $this$modifyProjectModelEntity.setDescriptor(this.$descriptor);
                    $this$modifyProjectModelEntity.setUrl(this.$url);
                    $this$modifyProjectModelEntity.setAlternativeUrls(CollectionsKt.toMutableList((Collection)this.$alternativeUrls));
                }
            }));
        } else if (parentEntity != null) {
            Ref ref = Ref.create();
            Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
            Ref res2 = ref;
            ProjectModelEntityKt.modifyProjectModelEntity($this$addOrUpdateProjectModelEntity, parentEntity, (Function1<? super ProjectModelEntity.Builder, Unit>)((Function1)new Function1<ProjectModelEntity.Builder, Unit>($this$addOrUpdateProjectModelEntity, descriptor, alternativeUrls, (Ref<ProjectModelEntity>)res2, url2){
                final /* synthetic */ MutableEntityStorage $this_addOrUpdateProjectModelEntity;
                final /* synthetic */ RdProjectModelItemDescriptor $descriptor;
                final /* synthetic */ List<VirtualFileUrl> $alternativeUrls;
                final /* synthetic */ Ref<ProjectModelEntity> $res;
                final /* synthetic */ VirtualFileUrl $url;
                {
                    this.$this_addOrUpdateProjectModelEntity = $receiver;
                    this.$descriptor = $descriptor;
                    this.$alternativeUrls = $alternativeUrls;
                    this.$res = $res;
                    this.$url = $url;
                    super(1);
                }

                public final void invoke(@NotNull ProjectModelEntity.Builder $this$parent) {
                    Intrinsics.checkNotNullParameter((Object)$this$parent, (String)"$this$parent");
                    ProjectModelEntity added2 = (ProjectModelEntity)this.$this_addOrUpdateProjectModelEntity.addEntity((WorkspaceEntity.Builder)ProjectModelEntity.Companion.create(this.$descriptor, this.$alternativeUrls, WorkspaceModelUpdater.RiderBackendEntitySource.INSTANCE, (Function1<? super ProjectModelEntity.Builder, Unit>)((Function1)new Function1<ProjectModelEntity.Builder, Unit>(this.$descriptor, this.$url, $this$parent){
                        final /* synthetic */ RdProjectModelItemDescriptor $descriptor;
                        final /* synthetic */ VirtualFileUrl $url;
                        final /* synthetic */ ProjectModelEntity.Builder $this_parent;
                        {
                            this.$descriptor = $descriptor;
                            this.$url = $url;
                            this.$this_parent = $this_parent;
                            super(1);
                        }

                        public final void invoke(@NotNull ProjectModelEntity.Builder $this$invoke) {
                            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                            $this$invoke.setDescriptor(this.$descriptor);
                            $this$invoke.setUrl(this.$url);
                            $this$invoke.setParentEntity(this.$this_parent);
                        }
                    })));
                    this.$res.set((Object)added2);
                }
            }));
            Object object = res2.get();
            Intrinsics.checkNotNull((Object)object);
            projectModelEntity = (ProjectModelEntity)object;
        } else {
            projectModelEntity = (ProjectModelEntity)$this$addOrUpdateProjectModelEntity.addEntity((WorkspaceEntity.Builder)ProjectModelEntity.Companion.create(descriptor, alternativeUrls, WorkspaceModelUpdater.RiderBackendEntitySource.INSTANCE, (Function1<? super ProjectModelEntity.Builder, Unit>)((Function1)new Function1<ProjectModelEntity.Builder, Unit>(descriptor, url2){
                final /* synthetic */ RdProjectModelItemDescriptor $descriptor;
                final /* synthetic */ VirtualFileUrl $url;
                {
                    this.$descriptor = $descriptor;
                    this.$url = $url;
                    super(1);
                }

                public final void invoke(@NotNull ProjectModelEntity.Builder $this$invoke) {
                    Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                    $this$invoke.setDescriptor(this.$descriptor);
                    $this$invoke.setUrl(this.$url);
                    $this$invoke.setChildrenEntities(CollectionsKt.emptyList());
                }
            })));
        }
        return projectModelEntity;
    }

    public static final void addOrUpdateSolutionPointerEntity(@NotNull MutableEntityStorage $this$addOrUpdateSolutionPointerEntity, @NotNull ProjectModelEntity entity2) {
        Intrinsics.checkNotNullParameter((Object)$this$addOrUpdateSolutionPointerEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        SolutionPointerEntity solutionPointerEntity = (SolutionPointerEntity)SequencesKt.singleOrNull((Sequence)$this$addOrUpdateSolutionPointerEntity.entities(SolutionPointerEntity.class));
        if (solutionPointerEntity != null) {
            ProjectModelEntityKt.modifyProjectModelEntity($this$addOrUpdateSolutionPointerEntity, entity2, (Function1<? super ProjectModelEntity.Builder, Unit>)((Function1)new Function1<ProjectModelEntity.Builder, Unit>($this$addOrUpdateSolutionPointerEntity, solutionPointerEntity){
                final /* synthetic */ MutableEntityStorage $this_addOrUpdateSolutionPointerEntity;
                final /* synthetic */ SolutionPointerEntity $solutionPointerEntity;
                {
                    this.$this_addOrUpdateSolutionPointerEntity = $receiver;
                    this.$solutionPointerEntity = $solutionPointerEntity;
                    super(1);
                }

                public final void invoke(@NotNull ProjectModelEntity.Builder $this$root) {
                    Intrinsics.checkNotNullParameter((Object)$this$root, (String)"$this$root");
                    SolutionPointerEntityKt.modifySolutionPointerEntity(this.$this_addOrUpdateSolutionPointerEntity, this.$solutionPointerEntity, (Function1<? super SolutionPointerEntity.Builder, Unit>)((Function1)new Function1<SolutionPointerEntity.Builder, Unit>($this$root){
                        final /* synthetic */ ProjectModelEntity.Builder $this_root;
                        {
                            this.$this_root = $this_root;
                            super(1);
                        }

                        public final void invoke(@NotNull SolutionPointerEntity.Builder $this$modifySolutionPointerEntity) {
                            Intrinsics.checkNotNullParameter((Object)$this$modifySolutionPointerEntity, (String)"$this$modifySolutionPointerEntity");
                            $this$modifySolutionPointerEntity.setSolutionEntity(this.$this_root);
                        }
                    }));
                }
            }));
        } else {
            ProjectModelEntityKt.modifyProjectModelEntity($this$addOrUpdateSolutionPointerEntity, entity2, (Function1<? super ProjectModelEntity.Builder, Unit>)((Function1)addOrUpdateSolutionPointerEntity.2.INSTANCE));
        }
    }

    @Nullable
    public static final VirtualFileUrl calculateVirtualFileUrl(@NotNull VirtualFileUrlManager $this$calculateVirtualFileUrl, @NotNull RdProjectModelItemDescriptor descriptor, @Nullable ProjectModelEntity parent) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateVirtualFileUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        RdProjectModelItemLocation location = descriptor.getLocation();
        if (location instanceof RdCustomLocation) {
            String path = ((RdCustomLocation)location).getCustomLocation();
            if (((CharSequence)path).length() == 0) {
                return null;
            }
            String string = VfsUtilCore.pathToUrl((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathToUrl(...)");
            return $this$calculateVirtualFileUrl.getOrCreateFromUrl(string);
        }
        if (location instanceof RdNameLocation) {
            ProjectModelEntity baseLocation;
            ProjectModelEntity projectModelEntity = parent;
            if (projectModelEntity == null || (projectModelEntity = projectModelEntity.getUrl()) == null) {
                return null;
            }
            ProjectModelEntity parentLocation = projectModelEntity;
            ProjectModelEntity projectModelEntity2 = baseLocation = ProjectModelEntityExtensionsKt.isDirectory(parent) ? parentLocation : parentLocation.getParent();
            if (baseLocation == null) {
                return null;
            }
            String string = descriptor.getName();
            return Intrinsics.areEqual((Object)string, (Object)".") ? baseLocation : (Intrinsics.areEqual((Object)string, (Object)"..") ? baseLocation.getParent() : baseLocation.append(descriptor.getName()));
        }
        return null;
    }

    @NotNull
    public static final List<VirtualFileUrl> calculateAlternativeVirtualFileUrls(@NotNull VirtualFileUrlManager $this$calculateAlternativeVirtualFileUrls, @NotNull RdProjectModelItemDescriptor descriptor, @Nullable VirtualFileUrl url2) {
        VirtualFileUrl parentUrl;
        Intrinsics.checkNotNullParameter((Object)$this$calculateAlternativeVirtualFileUrls, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (url2 != null && Intrinsics.areEqual((Object)ProjectModelNodeExtensionKt.isDirectoryAware(descriptor), (Object)true) && (parentUrl = url2.getParent()) != null) {
            return CollectionsKt.listOf((Object)parentUrl);
        }
        return CollectionsKt.emptyList();
    }

    public static final void updateWorkspaceModelFromBackground(@NotNull WorkspaceModel workspaceModel, @NotNull Project project2, @NotNull Logger logger, @NotNull Function1<? super MutableEntityStorage, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)workspaceModel, (String)"workspaceModel");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        ApplicationKt.getApplication().assertIsNonDispatchThread();
        while (!ProjectModelEntityBuilderKt.tryUpdateWorkspaceModel(workspaceModel, project2, logger, action2)) {
            logger.info("Can not apply prototype workspace model, try one more time");
        }
    }

    private static final boolean tryUpdateWorkspaceModel(WorkspaceModel workspaceModel, Project project2, Logger logger, Function1<? super MutableEntityStorage, Unit> action2) {
        ApplicationKt.getApplication().assertIsNonDispatchThread();
        try {
            BuilderSnapshot builderSnapshot = (BuilderSnapshot)ApplicationKt.getApplication().runReadAction(() -> ProjectModelEntityBuilderKt.tryUpdateWorkspaceModel$lambda$0(workspaceModel));
            MutableEntityStorage builder = builderSnapshot.getBuilder();
            action2.invoke((Object)builder);
            StorageReplacement replacement = builderSnapshot.getStorageReplacement();
            Ref.BooleanRef result2 = new Ref.BooleanRef();
            result2.element = true;
            ApplicationKt.getApplication().invokeAndWait(() -> ProjectModelEntityBuilderKt.tryUpdateWorkspaceModel$lambda$2(project2, logger, result2, workspaceModel, replacement));
            return result2.element;
        }
        catch (OutOfMemoryError ex) {
            LowMemoryDialogService.Companion.getInstance(project2).showDialog();
            return false;
        }
    }

    private static final BuilderSnapshot tryUpdateWorkspaceModel$lambda$0(WorkspaceModel $workspaceModel) {
        Intrinsics.checkNotNullParameter((Object)$workspaceModel, (String)"$workspaceModel");
        return ((WorkspaceModelInternal)$workspaceModel).getBuilderSnapshot();
    }

    private static final void tryUpdateWorkspaceModel$lambda$2$lambda$1(Ref.BooleanRef $result, WorkspaceModel $workspaceModel, StorageReplacement $replacement) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$workspaceModel, (String)"$workspaceModel");
        Intrinsics.checkNotNullParameter((Object)$replacement, (String)"$replacement");
        $result.element = ((WorkspaceModelInternal)$workspaceModel).replaceProjectModel($replacement);
    }

    private static final void tryUpdateWorkspaceModel$lambda$2(Project $project, Logger $logger, Ref.BooleanRef $result, WorkspaceModel $workspaceModel, StorageReplacement $replacement) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$logger, (String)"$logger");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$workspaceModel, (String)"$workspaceModel");
        Intrinsics.checkNotNullParameter((Object)$replacement, (String)"$replacement");
        if ($project.isDisposed()) {
            return;
        }
        try {
            ApplicationKt.getApplication().runWriteAction(() -> ProjectModelEntityBuilderKt.tryUpdateWorkspaceModel$lambda$2$lambda$1($result, $workspaceModel, $replacement));
        }
        catch (ProcessCanceledException e) {
            $logger.warn("Workspace Model construction cancelled, probably project is closing");
        }
    }
}

