/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.model.RdAnalyzerReferenceDescriptor;
import com.jetbrains.rider.model.RdAssemblyReferenceDescriptor;
import com.jetbrains.rider.model.RdCustomLocation;
import com.jetbrains.rider.model.RdDependencyDescriptor;
import com.jetbrains.rider.model.RdDependencyFolderDescriptor;
import com.jetbrains.rider.model.RdDependencyFolderDescriptorType;
import com.jetbrains.rider.model.RdDependencyType;
import com.jetbrains.rider.model.RdImportDescriptor;
import com.jetbrains.rider.model.RdImportFolderDescriptor;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectFolderDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemLocation;
import com.jetbrains.rider.model.RdProjectReferenceDescriptor;
import com.jetbrains.rider.model.RdProjectReferenceType;
import com.jetbrains.rider.model.RdProjectType;
import com.jetbrains.rider.model.RdRoslynAnalyzerDiagnosticDescriptor;
import com.jetbrains.rider.model.RdSolutionDescriptor;
import com.jetbrains.rider.model.RdSolutionFolderDescriptor;
import com.jetbrains.rider.model.RdSourceGeneratorFileDescriptor;
import com.jetbrains.rider.model.RdSourceGeneratorFolderDescriptor;
import com.jetbrains.rider.model.RdTargetFrameworkFolderDescriptor;
import com.jetbrains.rider.model.RdUnloadProjectDescriptor;
import com.jetbrains.rider.model.RdUnresolvedReferenceDescriptor;
import com.jetbrains.rider.model.RdWebReferenceDescriptor;
import com.jetbrains.rider.model.RdWebReferenceDescriptorType;
import com.jetbrains.rider.projectView.ProjectModelIconProvider;
import com.jetbrains.rider.projectView.ProjectModelViewUpdater;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import icons.ReSharperIcons;
import icons.RiderIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a&\u0010\b\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"calculateDefaultFileSystemIcon", "Ljavax/swing/Icon;", "Lcom/intellij/openapi/vfs/VirtualFile;", "calculateFileSystemIcon", "project", "Lcom/intellij/openapi/project/Project;", "calculateIcon", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "getProjectFolderIcon", "descriptor", "Lcom/jetbrains/rider/model/RdProjectFolderDescriptor;", "virtualFile", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nProjectModelIcons.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectModelIcons.kt\ncom/jetbrains/rider/projectView/ProjectModelIconsKt\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,214:1\n13#2:215\n13#3:216\n*S KotlinDebug\n*F\n+ 1 ProjectModelIcons.kt\ncom/jetbrains/rider/projectView/ProjectModelIconsKt\n*L\n207#1:215\n207#1:216\n*E\n"})
public final class ProjectModelIconsKt {
    @Nullable
    public static final Icon calculateIcon(@NotNull ProjectModelEntity $this$calculateIcon, @NotNull Project project2) {
        Icon icon;
        block64: {
            RdProjectModelItemDescriptor descriptor;
            VirtualFile virtualFile2;
            block69: {
                block68: {
                    block67: {
                        block66: {
                            block65: {
                                block63: {
                                    Intrinsics.checkNotNullParameter((Object)$this$calculateIcon, (String)"<this>");
                                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                                    for (ProjectModelIconProvider provider2 : (ProjectModelIconProvider[])ProjectModelIconProvider.Companion.getEP_NAME().getExtensions()) {
                                        Icon customIcon;
                                        Icon icon2 = customIcon = provider2.getIcon(project2, $this$calculateIcon);
                                        if (icon2 == null) continue;
                                        return icon2;
                                    }
                                    VirtualFileUrl virtualFileUrl = $this$calculateIcon.getUrl();
                                    virtualFile2 = virtualFileUrl != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl) : null;
                                    descriptor = $this$calculateIcon.getDescriptor();
                                    if (!(descriptor instanceof RdSolutionDescriptor)) break block63;
                                    icon = ((RdSolutionDescriptor)descriptor).getFilterFilePath() != null ? RiderIcons.FileTypes.SolutionFiltered : RiderIcons.FileTypes.Solution;
                                    break block64;
                                }
                                if (descriptor instanceof RdProjectDescriptor) {
                                    String projectLocation;
                                    if (((RdProjectDescriptor)descriptor).getDirectoryBased()) {
                                        return ReSharperIcons.ProjectModel.Project;
                                    }
                                    switch (WhenMappings.$EnumSwitchMapping$0[((RdProjectDescriptor)descriptor).getSpecificType().ordinal()]) {
                                        case 1: {
                                            return RiderIcons.RunConfigurations.XamarinAndroid;
                                        }
                                        case 2: {
                                            return RiderIcons.RunConfigurations.XamarinApple;
                                        }
                                        case 3: {
                                            return ReSharperIcons.ProjectModel.MauiProject;
                                        }
                                    }
                                    RdProjectModelItemLocation rdProjectModelItemLocation = descriptor.getLocation();
                                    RdCustomLocation rdCustomLocation = rdProjectModelItemLocation instanceof RdCustomLocation ? (RdCustomLocation)rdProjectModelItemLocation : null;
                                    String string = projectLocation = rdCustomLocation != null ? rdCustomLocation.getCustomLocation() : null;
                                    if (projectLocation != null && StringsKt.endsWith((String)projectLocation, (String)"wixproj", (boolean)true)) {
                                        return ReSharperIcons.ProjectModel.WIXProject;
                                    }
                                    if (!((RdProjectDescriptor)descriptor).isDotNetCore()) {
                                        if (((RdProjectDescriptor)descriptor).getSpecificType() == RdProjectType.XamlProject) {
                                            return RiderIcons.Templates.TemplateWPFApp;
                                        }
                                        String string2 = projectLocation;
                                        boolean bl = string2 != null ? StringsKt.endsWith((String)string2, (String)"csproj", (boolean)true) : false;
                                        if (bl) {
                                            return ReSharperIcons.ProjectModel.CsharpLegacyProject;
                                        }
                                        String string3 = projectLocation;
                                        boolean bl2 = string3 != null ? StringsKt.endsWith((String)string3, (String)"vbproj", (boolean)true) : false;
                                        if (bl2) {
                                            return ReSharperIcons.ProjectModel.VbasicLegacyProject;
                                        }
                                        String string4 = projectLocation;
                                        boolean bl3 = string4 != null ? StringsKt.endsWith((String)string4, (String)"fsproj", (boolean)true) : false;
                                        if (bl3) {
                                            return ReSharperIcons.ProjectModel.FsharpLegacyProject;
                                        }
                                    }
                                    if (virtualFile2 != null && virtualFile2.isValid()) {
                                        FileType fileType = virtualFile2.getFileType();
                                        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
                                        FileType fileType2 = fileType;
                                        if (fileType2 instanceof PlainTextFileType) {
                                            return ReSharperIcons.ProjectModel.Project;
                                        }
                                        return fileType2.getIcon();
                                    }
                                    return ReSharperIcons.ProjectModel.UnloadedProject;
                                }
                                if (!(descriptor instanceof RdUnloadProjectDescriptor)) break block65;
                                icon = ReSharperIcons.ProjectModel.UnloadedProject;
                                break block64;
                            }
                            if (descriptor instanceof RdProjectFolderDescriptor) {
                                Icon icon3 = ProjectModelIconsKt.getProjectFolderIcon($this$calculateIcon, (RdProjectFolderDescriptor)descriptor, virtualFile2, project2);
                                if (((RdProjectFolderDescriptor)descriptor).isLinked()) {
                                    return LayeredIcon.Companion.create(icon3, ReSharperIcons.ProjectModel.ShortcutOverlay);
                                }
                                return icon3;
                            }
                            if (descriptor instanceof RdProjectFileDescriptor) {
                                Icon icon4;
                                if (virtualFile2 != null && virtualFile2.isValid()) {
                                    icon4 = ProjectModelIconsKt.calculateFileSystemIcon(virtualFile2, project2);
                                } else {
                                    Icon icon5 = ReSharperIcons.ProjectModel.MissingFile;
                                    icon4 = icon5;
                                    Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"MissingFile");
                                }
                                Icon icon6 = icon4;
                                if (((RdProjectFileDescriptor)descriptor).isLinked()) {
                                    return LayeredIcon.Companion.create(icon6, ReSharperIcons.ProjectModel.ShortcutOverlay);
                                }
                                return icon6;
                            }
                            if (descriptor instanceof RdSolutionFolderDescriptor) {
                                if (Intrinsics.areEqual((Object)ProjectModelNodeExtensionKt.getUserData(descriptor, "RdJsonProjectMark"), (Object)"RdJsonSolutionFolder")) {
                                    return RiderIcons.FileTypes.Solution;
                                }
                                return ReSharperIcons.ProjectModel.SolutionFolder;
                            }
                            if (descriptor instanceof RdAssemblyReferenceDescriptor) {
                                if (((RdAssemblyReferenceDescriptor)descriptor).getLinkWarning() != null) {
                                    return ReSharperIcons.ProjectModel.AssemblyReference;
                                }
                                return ReSharperIcons.ProjectModel.Assembly;
                            }
                            if (descriptor instanceof RdProjectReferenceDescriptor) {
                                return switch (WhenMappings.$EnumSwitchMapping$1[((RdProjectReferenceDescriptor)descriptor).getType().ordinal()]) {
                                    case 1 -> ReSharperIcons.ProjectModel.DependentProject;
                                    case 2 -> ReSharperIcons.ProjectModel.SharedProject;
                                    case 3 -> ReSharperIcons.ProjectModel.DependentProjectInactive;
                                    default -> throw new NoWhenBranchMatchedException();
                                };
                            }
                            if (descriptor instanceof RdAnalyzerReferenceDescriptor) {
                                return LayeredIcon.Companion.create(ReSharperIcons.ProjectModel.Assembly, RiderIcons.Roslyn.RoslynOverlay);
                            }
                            if (descriptor instanceof RdWebReferenceDescriptor) {
                                return switch (WhenMappings.$EnumSwitchMapping$2[((RdWebReferenceDescriptor)descriptor).getType().ordinal()]) {
                                    case 1 -> ReSharperIcons.Options.ConnectionSettings;
                                    case 2 -> ReSharperIcons.Options.ConnectionSettings;
                                    case 3 -> ReSharperIcons.Options.ConnectionSettings;
                                    default -> throw new NoWhenBranchMatchedException();
                                };
                            }
                            if (!(descriptor instanceof RdUnresolvedReferenceDescriptor)) break block66;
                            icon = ReSharperIcons.Common.Warning;
                            break block64;
                        }
                        if (!(descriptor instanceof RdTargetFrameworkFolderDescriptor)) break block67;
                        icon = ReSharperIcons.ProjectModel.TargetFramework;
                        break block64;
                    }
                    if (!(descriptor instanceof RdDependencyFolderDescriptor)) break block68;
                    switch (WhenMappings.$EnumSwitchMapping$3[((RdDependencyFolderDescriptor)descriptor).getType().ordinal()]) {
                        case 1: {
                            icon = ReSharperIcons.Common.CompositeElement;
                            break block64;
                        }
                        case 2: {
                            icon = ReSharperIcons.ProjectModel.FrameworkFolder;
                            break block64;
                        }
                        case 3: {
                            icon = ReSharperIcons.ProjectModel.Assemblies;
                            break block64;
                        }
                        case 4: {
                            icon = ReSharperIcons.ProjectModel.Assemblies;
                            break block64;
                        }
                        case 5: {
                            icon = ReSharperIcons.ProjectModel.Projects;
                            break block64;
                        }
                        case 6: {
                            icon = LayeredIcon.Companion.create(ReSharperIcons.ProjectModel.Folder, RiderIcons.Roslyn.RoslynOverlay);
                            break block64;
                        }
                        case 7: {
                            icon = ReSharperIcons.AssemblyExplorer.NugetFolderClosed;
                            break block64;
                        }
                        case 8: {
                            icon = ReSharperIcons.ProjectModel.SDKs;
                            break block64;
                        }
                        case 9: {
                            icon = ReSharperIcons.Options.ConnectionSettings;
                            break block64;
                        }
                        case 10: {
                            icon = ReSharperIcons.ProjectModel.SourceGenerator;
                            break block64;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (!(descriptor instanceof RdDependencyDescriptor)) break block69;
                switch (WhenMappings.$EnumSwitchMapping$4[((RdDependencyDescriptor)descriptor).getType().ordinal()]) {
                    case 1: {
                        icon = ReSharperIcons.FileLayout.DependencyProperty;
                        break block64;
                    }
                    case 2: {
                        icon = ReSharperIcons.ProjectModel.Assembly;
                        break block64;
                    }
                    case 3: {
                        icon = ReSharperIcons.ProjectModel.DependentProject;
                        break block64;
                    }
                    case 4: {
                        icon = ReSharperIcons.Ide.Tools;
                        break block64;
                    }
                    case 5: {
                        icon = ReSharperIcons.Common.Warning;
                        break block64;
                    }
                    case 6: {
                        icon = ReSharperIcons.ProjectModel.FrameworkRef;
                        break block64;
                    }
                    case 7: {
                        icon = ReSharperIcons.ProjectModel.FrameworkRefLock;
                        break block64;
                    }
                    case 8: {
                        icon = ReSharperIcons.ProjectModel.FrameworkRefIssue;
                        break block64;
                    }
                    case 9: {
                        icon = ReSharperIcons.ProjectModel.NuGet;
                        break block64;
                    }
                    case 10: {
                        icon = ReSharperIcons.Common.Warning;
                        break block64;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            icon = descriptor instanceof RdImportFolderDescriptor ? ReSharperIcons.Common.Behaivior : (descriptor instanceof RdImportDescriptor ? (virtualFile2 != null && virtualFile2.isValid() ? virtualFile2.getFileType().getIcon() : ReSharperIcons.ProjectModel.MissingFile) : (descriptor instanceof RdSourceGeneratorFolderDescriptor ? ReSharperIcons.FeaturesEnvironmentOptions.GeneratedCode : (descriptor instanceof RdSourceGeneratorFileDescriptor ? FileTypeRegistry.getInstance().getFileTypeByFileName($this$calculateIcon.getName()).getIcon() : (descriptor instanceof RdRoslynAnalyzerDiagnosticDescriptor ? RiderIcons.Roslyn.Roslyn : null))));
        }
        return icon;
    }

    private static final Icon getProjectFolderIcon(ProjectModelEntity $this$getProjectFolderIcon, RdProjectFolderDescriptor descriptor, VirtualFile virtualFile2, Project project2) {
        Icon icon;
        block30: {
            String string;
            if (descriptor.isAppDesigner()) {
                Icon icon2 = RiderIcons.Nodes.FolderResources;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FolderResources");
                return icon2;
            }
            if (ProjectModelNodeExtensionKt.isWwwRootFolder(descriptor)) {
                Icon icon3 = ReSharperIcons.ProjectModel.FolderWWWRootOpened;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"FolderWWWRootOpened");
                return icon3;
            }
            if (ProjectModelEntityExtensionsKt.isXcAssetsFolder($this$getProjectFolderIcon)) {
                Icon icon4 = AllIcons.Modules.ResourcesRoot;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"ResourcesRoot");
                return icon4;
            }
            ProjectModelEntity projectModelEntity = $this$getProjectFolderIcon.getParentEntity();
            boolean bl = projectModelEntity != null ? ProjectModelEntityExtensionsKt.isXcAssetsFolder(projectModelEntity) : false;
            if (bl) {
                if (StringsKt.endsWith$default((String)$this$getProjectFolderIcon.getName(), (String)".appiconset", (boolean)false, (int)2, null)) {
                    Icon icon5 = ReSharperIcons.Xamarin.AssetsIcons;
                    Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"AssetsIcons");
                    return icon5;
                }
                if (StringsKt.endsWith$default((String)$this$getProjectFolderIcon.getName(), (String)".imageset", (boolean)false, (int)2, null)) {
                    Icon icon6 = ReSharperIcons.Xamarin.AssetsImages;
                    Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"AssetsImages");
                    return icon6;
                }
                if (StringsKt.endsWith$default((String)$this$getProjectFolderIcon.getName(), (String)".colorset", (boolean)false, (int)2, null)) {
                    Icon icon7 = ReSharperIcons.Xamarin.AssetsColors;
                    Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"AssetsColors");
                    return icon7;
                }
            }
            if ((string = ProjectModelNodeExtensionKt.getUserData(descriptor, "MauiPlatformFolder")) == null) break block30;
            int n = -1;
            switch (string.hashCode()) {
                case -861391249: {
                    if (string.equals("android")) {
                        n = 1;
                    }
                    break;
                }
                case 110376974: {
                    if (string.equals("tizen")) {
                        n = 2;
                    }
                    break;
                }
                case 104461: {
                    if (string.equals("ios")) {
                        n = 3;
                    }
                    break;
                }
                case 1349493379: {
                    if (string.equals("windows")) {
                        n = 4;
                    }
                    break;
                }
                case 1316466888: {
                    if (string.equals("maccatalyst")) {
                        n = 5;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    Icon icon8 = ReSharperIcons.ProjectModel.FolderAndroid;
                    Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"FolderAndroid");
                    return icon8;
                }
                case 3: {
                    Icon icon9 = ReSharperIcons.ProjectModel.FolderIos;
                    Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"FolderIos");
                    return icon9;
                }
                case 5: {
                    Icon icon10 = ReSharperIcons.ProjectModel.FolderMacCatalyst;
                    Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"FolderMacCatalyst");
                    return icon10;
                }
                case 4: {
                    Icon icon11 = ReSharperIcons.ProjectModel.FolderWindows;
                    Intrinsics.checkNotNullExpressionValue((Object)icon11, (String)"FolderWindows");
                    return icon11;
                }
                case 2: {
                    Icon icon12 = ReSharperIcons.ProjectModel.FolderTizen;
                    Intrinsics.checkNotNullExpressionValue((Object)icon12, (String)"FolderTizen");
                    return icon12;
                }
            }
        }
        if (virtualFile2 != null && virtualFile2.isValid()) {
            icon = ProjectModelIconsKt.calculateFileSystemIcon(virtualFile2, project2);
        } else if (descriptor.getAllowsNonExistence()) {
            Icon icon13 = ReSharperIcons.ProjectModel.Folder;
            icon = icon13;
            Intrinsics.checkNotNullExpressionValue((Object)icon13, (String)"Folder");
        } else {
            Icon icon14 = ReSharperIcons.ProjectModel.MissingFolder;
            icon = icon14;
            Intrinsics.checkNotNullExpressionValue((Object)icon14, (String)"MissingFolder");
        }
        return icon;
    }

    @NotNull
    public static final Icon calculateFileSystemIcon(@NotNull VirtualFile $this$calculateFileSystemIcon, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateFileSystemIcon, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        try {
            if (!WorkspaceModelTopics.Companion.getInstance(project2).getModulesAreLoaded()) {
                return ProjectModelIconsKt.calculateDefaultFileSystemIcon($this$calculateFileSystemIcon);
            }
            Object object = ApplicationKt.getApplication().runReadAction(() -> ProjectModelIconsKt.calculateFileSystemIcon$lambda$0(project2, $this$calculateFileSystemIcon));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
            return (Icon)object;
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Icon icon;
            boolean $i$f$getLogger = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ProjectModelViewUpdater.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(ex);
            if ($this$calculateFileSystemIcon.isDirectory()) {
                Icon icon2 = ReSharperIcons.ProjectModel.Folder;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Folder");
            } else {
                Icon icon3 = AllIcons.FileTypes.Any_type;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Any_type");
            }
            return icon;
        }
    }

    private static final Icon calculateDefaultFileSystemIcon(VirtualFile $this$calculateDefaultFileSystemIcon) {
        Icon icon;
        if ($this$calculateDefaultFileSystemIcon.isDirectory()) {
            Icon icon2 = ReSharperIcons.ProjectModel.Folder;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Folder");
        } else {
            Icon icon3 = $this$calculateDefaultFileSystemIcon.getFileType().getIcon();
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getIcon(...)");
        }
        return icon;
    }

    private static final Icon calculateFileSystemIcon$lambda$0(Project $project, VirtualFile $this_calculateFileSystemIcon) {
        Icon psiFileIcon;
        PsiFileSystemItem psiFile;
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$this_calculateFileSystemIcon, (String)"$this_calculateFileSystemIcon");
        PsiManager psiManager = PsiManager.getInstance((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        PsiFileSystemItem psiFileSystemItem = psiFile = $this_calculateFileSystemIcon.isDirectory() ? (PsiFileSystemItem)psiManager2.findDirectory($this_calculateFileSystemIcon) : (PsiFileSystemItem)psiManager2.findFile($this_calculateFileSystemIcon);
        Icon icon = psiFileIcon = psiFileSystemItem != null ? psiFileSystemItem.getIcon(0) : null;
        if (icon != null) {
            return icon;
        }
        return ProjectModelIconsKt.calculateDefaultFileSystemIcon($this_calculateFileSystemIcon);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[RdProjectType.values().length];
            try {
                nArray[RdProjectType.Android.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdProjectType.Macios.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdProjectType.MAUI.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RdProjectReferenceType.values().length];
            try {
                nArray[RdProjectReferenceType.Regular.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdProjectReferenceType.Shared.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdProjectReferenceType.Inactive.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[RdWebReferenceDescriptorType.values().length];
            try {
                nArray[RdWebReferenceDescriptorType.Reference.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdWebReferenceDescriptorType.Metadata.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdWebReferenceDescriptorType.MetadataStorage.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[RdDependencyFolderDescriptorType.values().length];
            try {
                nArray[RdDependencyFolderDescriptorType.Dependencies.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyFolderDescriptorType.FrameworkReferences.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyFolderDescriptorType.Assemblies.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyFolderDescriptorType.ImplicitAssemblies.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyFolderDescriptorType.Projects.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyFolderDescriptorType.Analyzers.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyFolderDescriptorType.Packages.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyFolderDescriptorType.SDK.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyFolderDescriptorType.WebReference.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyFolderDescriptorType.SourceGenerator.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[RdDependencyType.values().length];
            try {
                nArray[RdDependencyType.Dependency.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyType.Reference.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyType.Project.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyType.SDK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyType.UnresolvedSDK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyType.FrameworkReference.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyType.PrivateFrameworkReference.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyType.UnresolvedFrameworkReference.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyType.Package.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDependencyType.UnresolvedPackage.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

