/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.internal.dump;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.platform.internal.DumpAction;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/internal/dump/DumpShortcutsAction;", "Lcom/jetbrains/rd/platform/internal/DumpAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "printShortcuts", "keymap", "Lcom/intellij/openapi/keymap/Keymap;", "id", "", "writer", "Ljava/io/OutputStreamWriter;", "intellij.rider.rdclient.dotnet"})
public final class DumpShortcutsAction
extends DumpAction {
    public DumpShortcutsAction() {
        super(RdClientDotnetBundle.INSTANCE.message("action.keyboard.shortcuts.text", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        ActionManagerEx actionManager2 = ActionManagerEx.Companion.getInstanceEx();
        List list = actionManager2.getActionIdList("");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getActionIdList(...)");
        List registeredActionIds = list;
        Keymap defKeymap = KeymapManagerEx.getInstanceEx().getKeymap("$default");
        Keymap rsKeymap = KeymapManagerEx.getInstanceEx().getKeymap("ReSharper");
        Keymap vsKeymap = KeymapManagerEx.getInstanceEx().getKeymap("Visual Studio");
        Keymap rdKeymap = KeymapManagerEx.getInstanceEx().getKeymap("Rider");
        Keymap osxKeymap = KeymapManagerEx.getInstanceEx().getKeymap("Mac OS X");
        Keymap rsMacKeymap = KeymapManagerEx.getInstanceEx().getKeymap("ReSharper OSX");
        Keymap vsMacKeymap = KeymapManagerEx.getInstanceEx().getKeymap("Visual Studio OSX");
        Keymap rdMacKeymap = KeymapManagerEx.getInstanceEx().getKeymap("Rider OSX");
        this.dump(project3, (Function1)new Function1<OutputStreamWriter, Unit>((List<String>)registeredActionIds, actionManager2, defKeymap, vsKeymap, this, rsKeymap, rdKeymap, osxKeymap, vsMacKeymap, rsMacKeymap, rdMacKeymap){
            final /* synthetic */ List<String> $registeredActionIds;
            final /* synthetic */ ActionManagerEx $actionManager;
            final /* synthetic */ Keymap $defKeymap;
            final /* synthetic */ Keymap $vsKeymap;
            final /* synthetic */ DumpShortcutsAction this$0;
            final /* synthetic */ Keymap $rsKeymap;
            final /* synthetic */ Keymap $rdKeymap;
            final /* synthetic */ Keymap $osxKeymap;
            final /* synthetic */ Keymap $vsMacKeymap;
            final /* synthetic */ Keymap $rsMacKeymap;
            final /* synthetic */ Keymap $rdMacKeymap;
            {
                this.$registeredActionIds = $registeredActionIds;
                this.$actionManager = $actionManager;
                this.$defKeymap = $defKeymap;
                this.$vsKeymap = $vsKeymap;
                this.this$0 = $receiver;
                this.$rsKeymap = $rsKeymap;
                this.$rdKeymap = $rdKeymap;
                this.$osxKeymap = $osxKeymap;
                this.$vsMacKeymap = $vsMacKeymap;
                this.$rsMacKeymap = $rsMacKeymap;
                this.$rdMacKeymap = $rdMacKeymap;
                super(1);
            }

            public final void invoke(@NotNull OutputStreamWriter writer) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Appendable appendable = ((Appendable)writer).append("=== Keyboard Shortcuts ===\n");
                Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
                for (String id : this.$registeredActionIds) {
                    AnAction action2 = this.$actionManager.getAction(id);
                    if (action2 != null) {
                        String text;
                        Shortcut[] shortcutArray = this.$defKeymap;
                        boolean bl = this.$defKeymap != null && (shortcutArray = shortcutArray.getShortcuts(id)) != null ? shortcutArray.length == 0 : false;
                        if (bl) {
                            Shortcut[] shortcutArray2 = this.$vsKeymap;
                            if (this.$vsKeymap != null && (shortcutArray2 = shortcutArray2.getShortcuts(id)) != null ? shortcutArray2.length == 0 : false) continue;
                        }
                        if ((text = action2.getTemplatePresentation().getText()) == null || ((CharSequence)text).length() == 0) {
                            text = id;
                        }
                        Appendable appendable2 = writer;
                        Object[] objectArray = new Object[]{id, text};
                        Appendable appendable3 = appendable2.append(String.format("%-40s%s", objectArray));
                        Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append(...)");
                        Intrinsics.checkNotNull((Object)id);
                        DumpShortcutsAction.access$printShortcuts(this.this$0, this.$defKeymap, id, writer);
                        DumpShortcutsAction.access$printShortcuts(this.this$0, this.$vsKeymap, id, writer);
                        DumpShortcutsAction.access$printShortcuts(this.this$0, this.$rsKeymap, id, writer);
                        DumpShortcutsAction.access$printShortcuts(this.this$0, this.$rdKeymap, id, writer);
                        DumpShortcutsAction.access$printShortcuts(this.this$0, this.$osxKeymap, id, writer);
                        DumpShortcutsAction.access$printShortcuts(this.this$0, this.$vsMacKeymap, id, writer);
                        DumpShortcutsAction.access$printShortcuts(this.this$0, this.$rsMacKeymap, id, writer);
                        DumpShortcutsAction.access$printShortcuts(this.this$0, this.$rdMacKeymap, id, writer);
                    }
                    Appendable appendable4 = ((Appendable)writer).append("\n");
                    Intrinsics.checkNotNullExpressionValue((Object)appendable4, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)appendable4.append('\n'), (String)"append(...)");
                }
            }
        });
    }

    private final void printShortcuts(Keymap keymap, String id, OutputStreamWriter writer) {
        Shortcut[] shortcutArray = keymap;
        if (keymap == null || (shortcutArray = shortcutArray.getShortcuts(id)) == null) {
            return;
        }
        Shortcut[] shortcuts = shortcutArray;
        Object[] objectArray = new Object[]{"\t" + keymap.getName()};
        writer.append(String.format("%-38s", objectArray));
        for (Shortcut shortcut : shortcuts) {
            Map conflicts;
            writer.append("\t " + KeymapUtil.getShortcutText((Shortcut)shortcut));
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)keymap.getConflicts(id, (KeyboardShortcut)shortcut), (String)"getConflicts(...)");
            if (!(!conflicts.isEmpty())) continue;
            writer.append(" (Conflicts with:");
            for (String confId : conflicts.keySet()) {
                Object v = conflicts.get(confId);
                Intrinsics.checkNotNull(v);
                for (KeyboardShortcut s : (List)v) {
                    writer.append(" " + confId);
                }
            }
            writer.append(")");
        }
        writer.append("\n");
    }

    public static final /* synthetic */ void access$printShortcuts(DumpShortcutsAction $this, Keymap keymap, String id, OutputStreamWriter writer) {
        $this.printShortcuts(keymap, id, writer);
    }
}

