/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.intentions.altEnter;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.ide.model.popups.CanceledPopupMenuMarker;
import com.jetbrains.ide.model.popups.IRdPopupMenuModel;
import com.jetbrains.ide.model.popups.RdEmptyPopupMenuModel;
import com.jetbrains.ide.model.popups.RdPopupMenuModel;
import com.jetbrains.ide.model.popups.RdPopupMenuModelBase;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.services.popups.FrontendIntentionMenuContributorKt;
import com.jetbrains.rdclient.services.uiContext.UiContextManager;
import com.jetbrains.rider.actions.InterruptibleBackendActionHost;
import com.jetbrains.rider.editors.LastFocusedEditorSuppressor;
import com.jetbrains.rider.editors.RiderBackendInteractionHelper;
import com.jetbrains.rider.intentions.altEnter.BulbMenuModelFactory;
import com.jetbrains.rider.intentions.altEnter.BulbMenuModelFactoryPriority;
import com.jetbrains.rider.intentions.altEnter.PopupInvocationRequest;
import com.jetbrains.rider.intentions.altEnter.PopupModel;
import com.jetbrains.rider.intentions.altEnter.ReSharperBulbMenu;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000  *\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002 !B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016JR\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/intentions/altEnter/ReSharperPopupMenuModelFactory;", "T", "Lcom/jetbrains/rider/intentions/altEnter/BulbMenuModelFactory;", "request", "Lcom/jetbrains/rider/intentions/altEnter/PopupInvocationRequest;", "(Lcom/jetbrains/rider/intentions/altEnter/PopupInvocationRequest;)V", "priority", "", "getPriority", "()I", "create", "Lorg/jetbrains/concurrency/Promise;", "Lcom/jetbrains/rider/intentions/altEnter/PopupModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "needsBackend", "", "processProtocolModel", "model", "Lcom/jetbrains/ide/model/popups/IRdPopupMenuModel;", "executionLifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "waitLifetimeDef", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "executionLifetime", "result", "Lorg/jetbrains/concurrency/AsyncPromise;", "Companion", "StateHolder", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nReSharperAltEnterMenuModelFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperAltEnterMenuModelFactory.kt\ncom/jetbrains/rider/intentions/altEnter/ReSharperPopupMenuModelFactory\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,180:1\n17#2,2:181\n65#3,4:183\n65#3,4:187\n65#3,4:191\n13#3:196\n13#4:195\n*S KotlinDebug\n*F\n+ 1 ReSharperAltEnterMenuModelFactory.kt\ncom/jetbrains/rider/intentions/altEnter/ReSharperPopupMenuModelFactory\n*L\n66#1:181,2\n125#1:183,4\n130#1:187,4\n137#1:191,4\n56#1:196\n56#1:195\n*E\n"})
public class ReSharperPopupMenuModelFactory<T>
implements BulbMenuModelFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PopupInvocationRequest<T> request;
    @NotNull
    private static final Logger LOG;

    public ReSharperPopupMenuModelFactory(@NotNull PopupInvocationRequest<T> request2) {
        Intrinsics.checkNotNullParameter(request2, (String)"request");
        this.request = request2;
    }

    @Override
    public int getPriority() {
        return BulbMenuModelFactoryPriority.First.getValue();
    }

    @Override
    @NotNull
    public Promise<PopupModel> create(@NotNull Lifetime lifetime2, @NotNull Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        try {
            LastFocusedEditorSuppressor.Companion.getInstance(project2).forceReleaseSuppressionForLastFocusedEditor("Release all frontend changes before executing the action");
            ComponentManager $this$getService$iv = (ComponentManager)project2;
            boolean $i$f$getService = false;
            Object object = $this$getService$iv.getService(StateHolder.class);
            if (object == null) {
                throw new IllegalStateException("Service " + StateHolder.class + " not found in container " + $this$getService$iv);
            }
            StateHolder stateHolder = (StateHolder)((Object)object);
            LifetimeDefinition executionLifetimeDef = RLifetimeKt.defineIntersection((Lifetime)((Lifetime)stateHolder.getExecutionLifetimes().next()), (Lifetime)lifetime2);
            Lifetime executionLifetime = executionLifetimeDef.getLifetime();
            LifetimeDefinition waitLifetimeDef = executionLifetime.createNested();
            IdeBackend backend = IdeBackend.Companion.getInstance(project2);
            AsyncPromise result2 = new AsyncPromise();
            executionLifetime.onTermination((Function0)new Function0<Unit>((AsyncPromise<PopupModel>)result2){
                final /* synthetic */ AsyncPromise<PopupModel> $result;
                {
                    this.$result = $result;
                    super(0);
                }

                public final void invoke() {
                    ReSharperPopupMenuModelFactory.access$getLOG$cp().info("Popup menu execution lifetime was terminated");
                    if (Promises.isPending((Promise)((Promise)this.$result))) {
                        this.$result.cancel();
                    }
                }
            });
            UiContextManager.Companion.getInstance(project2).getAnyChange().advise(waitLifetimeDef.getLifetime(), (Function1)new Function1<Boolean, Unit>(executionLifetimeDef){
                final /* synthetic */ LifetimeDefinition $executionLifetimeDef;
                {
                    this.$executionLifetimeDef = $executionLifetimeDef;
                    super(1);
                }

                public final void invoke(boolean it) {
                    Logger $this$trace$iv = ReSharperPopupMenuModelFactory.access$getLOG$cp();
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl = false;
                        logger.trace("Terminating popup menu execution lifetime because of UI context changes");
                    }
                    LifetimeDefinition.terminate$default((LifetimeDefinition)this.$executionLifetimeDef, (boolean)false, (int)1, null);
                }
            });
            InterruptibleBackendActionHost.Companion.getInstance(project2).showLongExecutionTooltip(waitLifetimeDef.getLifetime(), editor2, RdClientDotnetBundle.INSTANCE.message("hint.text.waiting.for.intention.actions", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>(executionLifetimeDef){
                final /* synthetic */ LifetimeDefinition $executionLifetimeDef;
                {
                    this.$executionLifetimeDef = $executionLifetimeDef;
                    super(0);
                }

                public final void invoke() {
                    LifetimeDefinition.terminate$default((LifetimeDefinition)this.$executionLifetimeDef, (boolean)false, (int)1, null);
                }
            }));
            this.request.executePopupInvocation(executionLifetime, backend, editor2, LOG, (Function1<IRdPopupMenuModel, Boolean>)((Function1)new Function1<IRdPopupMenuModel, Boolean>(this, project2, executionLifetimeDef, waitLifetimeDef, backend, executionLifetime, (AsyncPromise<PopupModel>)result2, editor2){
                final /* synthetic */ ReSharperPopupMenuModelFactory<T> this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ LifetimeDefinition $executionLifetimeDef;
                final /* synthetic */ LifetimeDefinition $waitLifetimeDef;
                final /* synthetic */ IdeBackend $backend;
                final /* synthetic */ Lifetime $executionLifetime;
                final /* synthetic */ AsyncPromise<PopupModel> $result;
                final /* synthetic */ Editor $editor;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$executionLifetimeDef = $executionLifetimeDef;
                    this.$waitLifetimeDef = $waitLifetimeDef;
                    this.$backend = $backend;
                    this.$executionLifetime = $executionLifetime;
                    this.$result = $result;
                    this.$editor = $editor;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@Nullable IRdPopupMenuModel model) {
                    return ReSharperPopupMenuModelFactory.access$processProtocolModel(this.this$0, model, this.$project, this.$executionLifetimeDef, this.$waitLifetimeDef, this.$backend, this.$executionLifetime, this.$result, this.$editor);
                }
            }));
            return (Promise)result2;
        }
        catch (Throwable t) {
            LOG.error(t);
            return Promises.rejectedPromise((Throwable)t);
        }
    }

    private final boolean processProtocolModel(IRdPopupMenuModel model, Project project2, LifetimeDefinition executionLifetimeDef, LifetimeDefinition waitLifetimeDef, IdeBackend backend, Lifetime executionLifetime, AsyncPromise<PopupModel> result2, Editor editor2) {
        Logger logger;
        ApplicationKt.getApplication().assertIsDispatchThread();
        IRdPopupMenuModel iRdPopupMenuModel = model;
        if (iRdPopupMenuModel == null) {
            return false;
        }
        IRdPopupMenuModel protocolModel = iRdPopupMenuModel;
        if (protocolModel instanceof CanceledPopupMenuMarker) {
            return false;
        }
        if (!FrontendIntentionMenuContributorKt.isCurrent(protocolModel, project2)) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl = false;
                logger2.trace("Popup menu model is out-of-date");
            }
            executionLifetimeDef.terminate(true);
            return true;
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)waitLifetimeDef, (boolean)false, (int)1, null);
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Received popup menu model: " + IPrintableKt.printToString((Object)protocolModel));
        }
        if (ClientId.Companion.isCurrentlyUnderLocalId() && !RiderBackendInteractionHelper.Companion.getInstance(project2).syncFromBackend(executionLifetime)) {
            $this$trace$iv = LOG;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("The action handshake is executing in the middle of another synchronous activity. Interrupt it.");
            }
            executionLifetimeDef.terminate(true);
            return true;
        }
        try {
            $this$trace$iv = protocolModel;
            if ($this$trace$iv instanceof RdEmptyPopupMenuModel) {
                result2.setResult(null);
                executionLifetimeDef.terminate(true);
            } else if ($this$trace$iv instanceof RdPopupMenuModel) {
                BoolPropertyExKt.whenTrue((IViewable)((IViewable)((RdPopupMenuModel)protocolModel).isPrepared()), (Lifetime)executionLifetimeDef.getLifetime(), (Function1)((Function1)new Function1<Lifetime, Unit>(project2, editor2, backend, executionLifetimeDef, protocolModel, result2){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ IdeBackend $backend;
                    final /* synthetic */ LifetimeDefinition $executionLifetimeDef;
                    final /* synthetic */ IRdPopupMenuModel $protocolModel;
                    final /* synthetic */ AsyncPromise<PopupModel> $result;
                    {
                        this.$project = $project;
                        this.$editor = $editor;
                        this.$backend = $backend;
                        this.$executionLifetimeDef = $executionLifetimeDef;
                        this.$protocolModel = $protocolModel;
                        this.$result = $result;
                        super(1);
                    }

                    public final void invoke(@NotNull Lifetime it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ReSharperPopupMenuModelFactory.access$getLOG$cp().info("Backend bulb menu model is ready.");
                        ReSharperBulbMenu menuModel = new ReSharperBulbMenu(this.$project, this.$editor, this.$backend, this.$executionLifetimeDef, (RdPopupMenuModelBase)this.$protocolModel, this.$executionLifetimeDef.getLifetime());
                        this.$result.setResult((Object)menuModel);
                    }
                }));
                IRdDispatcher rdDispatcher = IRdDispatcherKt.getAsRdDispatcher((IScheduler)backend.getProtocol().getScheduler());
                IRdDispatcherKt.pumpProtocolQueue((IRdDispatcher)rdDispatcher, (Lifetime)executionLifetimeDef.getLifetime());
            } else {
                executionLifetimeDef.terminate(true);
                LOG.error("Unexpected type: " + protocolModel.getClass().getTypeName());
            }
        }
        catch (Throwable t) {
            executionLifetimeDef.terminate(true);
            throw t;
        }
        return true;
    }

    @Override
    public boolean needsBackend() {
        return true;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$processProtocolModel(ReSharperPopupMenuModelFactory $this, IRdPopupMenuModel model, Project project2, LifetimeDefinition executionLifetimeDef, LifetimeDefinition waitLifetimeDef, IdeBackend backend, Lifetime executionLifetime, AsyncPromise result2, Editor editor2) {
        return $this.processProtocolModel(model, project2, executionLifetimeDef, waitLifetimeDef, backend, executionLifetime, (AsyncPromise<PopupModel>)result2, editor2);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ReSharperPopupMenuModelFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/intentions/altEnter/ReSharperPopupMenuModelFactory$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/intentions/altEnter/ReSharperPopupMenuModelFactory$StateHolder;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "()V", "executionLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "getExecutionLifetimes", "()Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "intellij.rider.rdclient.dotnet"})
    public static final class StateHolder
    extends LifetimedService {
        @NotNull
        private final SequentialLifetimes executionLifetimes = new SequentialLifetimes(this.getServiceLifetime());

        @NotNull
        public final SequentialLifetimes getExecutionLifetimes() {
            return this.executionLifetimes;
        }
    }
}

