/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.inspections.suppression;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import com.jetbrains.rider.inspections.suppression.IdeaInspectionBackendSuppressionDataKeys;
import com.jetbrains.rider.inspections.suppression.InspectionSuppressionInfo;
import com.jetbrains.rider.model.inspections.RdIdeaInspectionBackendSuppressionDataConstant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/inspections/suppression/DisableWarningOnBackendFixBase;", "Lcom/intellij/codeInspection/SuppressQuickFix;", "actionName", "", "suppressionInfo", "Lcom/jetbrains/rider/inspections/suppression/InspectionSuppressionInfo;", "(Ljava/lang/String;Lcom/jetbrains/rider/inspections/suppression/InspectionSuppressionInfo;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "isAvailable", "", "context", "Lcom/intellij/psi/PsiElement;", "isSuppressAll", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nDisableWarningOnBackendFixBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisableWarningOnBackendFixBase.kt\ncom/jetbrains/rider/inspections/suppression/DisableWarningOnBackendFixBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,54:1\n23#2:55\n23#2:56\n*S KotlinDebug\n*F\n+ 1 DisableWarningOnBackendFixBase.kt\ncom/jetbrains/rider/inspections/suppression/DisableWarningOnBackendFixBase\n*L\n23#1:55\n27#1:56\n*E\n"})
public abstract class DisableWarningOnBackendFixBase
implements SuppressQuickFix {
    @NotNull
    private final String actionName;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final InspectionSuppressionInfo suppressionInfo;

    public DisableWarningOnBackendFixBase(@NotNull String actionName2, @NotNull InspectionSuppressionInfo suppressionInfo) {
        Intrinsics.checkNotNullParameter((Object)actionName2, (String)"actionName");
        Intrinsics.checkNotNullParameter((Object)suppressionInfo, (String)"suppressionInfo");
        this.actionName = actionName2;
        this.suppressionInfo = suppressionInfo;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!(descriptor instanceof ProblemDescriptorBase)) {
            DisableWarningOnBackendFixBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DisableWarningOnBackendFixBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Got descriptor " + descriptor + ", not ProblemDescriptorBase");
            return;
        }
        if (((ProblemDescriptorBase)descriptor).getTextRange() == null) {
            DisableWarningOnBackendFixBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DisableWarningOnBackendFixBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("TextRange of descriptor is null");
            return;
        }
        PsiFile psiFile = ((ProblemDescriptorBase)descriptor).getPsiElement().getContainingFile();
        if (psiFile == null) {
            throw new AssertionError((Object)"file != null");
        }
        PsiFile file2 = psiFile;
        FileEditor selectedEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor(file2.getVirtualFile());
        if (!(selectedEditor instanceof TextEditor)) {
            return;
        }
        Editor editor2 = ((TextEditor)selectedEditor).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
        if (textRange == null) {
            return;
        }
        TextRange range2 = textRange;
        DataContext dataContext2 = SimpleDataContext.builder().add(CommonDataKeys.EDITOR, (Object)editor3).add(CommonDataKeys.PROJECT, (Object)project2).add(IdeaInspectionBackendSuppressionDataKeys.INSTANCE.getDISABLE_INSPECTION_DATA(), (Object)new RdIdeaInspectionBackendSuppressionDataConstant(RangeUtilKt.toRdTextRange(range2), this.suppressionInfo.getIdeaToolId(), this.suppressionInfo.getResharperSeverityId())).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"build(...)");
        DataContext dataContext3 = dataContext2;
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext3);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        AnActionEvent event = anActionEvent;
        BackendActionDelegationKt.backendActionPerformed(this.actionName, event);
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return true;
    }

    public boolean isSuppressAll() {
        return true;
    }
}

