/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs.structure;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.ideaInterop.vfs.structure.FilePathComponentComparator;
import com.jetbrains.rider.ideaInterop.vfs.structure.FilePathTreeVisitor;
import com.jetbrains.rider.ideaInterop.vfs.structure.VisitResult;
import java.io.File;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 3*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u000234B\u001f\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0007JE\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00028\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\n\u00a2\u0006\u0002\u0010\"J\u0013\u0010#\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u0015\u0010%\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nH\u0002J\u001b\u0010)\u001a\u00020*2\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010+J\u000e\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u0018J2\u0010,\u001a\u00020*2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u001c\b\u0002\u0010-\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\u0013\u0018\u00010.Jm\u0010/\u001a\u00020*2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00028\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0018\u00100\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n010\u000b2\u001a\u0010-\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\u0013\u0018\u00010.H\u0002\u00a2\u0006\u0002\u00102R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u000bj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u0000`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u00065"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree;", "T", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "", "entryFactory", "Lkotlin/Function2;", "", "(Lkotlin/jvm/functions/Function2;)V", "childrenMap", "Ljava/util/TreeMap;", "", "Ljava/util/HashMap;", "entryMap", "Lkotlin/collections/HashMap;", "nextId", "parentCountMap", "root", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "doVisit", "Lkotlin/Pair;", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/VisitResult;", "visitor", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTreeVisitor;", "file", "Ljava/io/File;", "entry", "context", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTreeVisitor;Ljava/io/File;Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;Ljava/lang/Object;)Lkotlin/Pair;", "get", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "(Ljava/io/File;)Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "getChild", "pathComponent", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;Ljava/lang/String;)Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "getOrCreate", "getOrFindExistingParent", "getParent", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;)Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "normalize", "part", "removeIfEmpty", "", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;Ljava/io/File;)V", "visit", "comparator", "Ljava/util/Comparator;", "visitInternal", "allChildren", "Ljava/util/ArrayList;", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTreeVisitor;Ljava/io/File;Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;Ljava/lang/Object;Ljava/util/HashMap;Ljava/util/Comparator;)V", "Companion", "Entry", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nFilePathTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilePathTree.kt\ncom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,194:1\n372#2,7:195\n372#2,7:202\n*S KotlinDebug\n*F\n+ 1 FilePathTree.kt\ncom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree\n*L\n76#1:195,7\n119#1:202,7\n*E\n"})
public final class FilePathTree<T extends Entry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<Integer, Integer, T> entryFactory;
    private int nextId;
    @NotNull
    private final T root;
    @NotNull
    private final TreeMap<String, HashMap<Integer, T>> childrenMap;
    @NotNull
    private final HashMap<Integer, T> entryMap;
    @NotNull
    private final HashMap<Integer, Integer> parentCountMap;
    private static final int RootId;

    public FilePathTree(@NotNull Function2<? super Integer, ? super Integer, ? extends T> entryFactory) {
        Intrinsics.checkNotNullParameter(entryFactory, (String)"entryFactory");
        this.entryFactory = entryFactory;
        this.nextId = RootId + 1;
        this.root = (Entry)this.entryFactory.invoke((Object)RootId, (Object)(RootId - 1));
        this.childrenMap = new TreeMap(FilePathComponentComparator.INSTANCE);
        this.entryMap = new HashMap();
        this.parentCountMap = new HashMap();
        this.entryMap.put(((Entry)this.root).getId(), this.root);
    }

    @Nullable
    public final T get(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        File file3 = VfsUtil.virtualToIoFile((VirtualFile)file2);
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"virtualToIoFile(...)");
        return this.get(file3);
    }

    @Nullable
    public final T get(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List list = FileUtil.splitPath((String)file2.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitPath(...)");
        List parts = list;
        T entry2 = this.root;
        for (String part : parts) {
            Intrinsics.checkNotNull((Object)part);
            if (this.getChild(entry2, part) != null) continue;
            return null;
        }
        return entry2;
    }

    @NotNull
    public final Pair<T, File> getOrFindExistingParent(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List list = FileUtil.splitPath((String)file2.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitPath(...)");
        List parts = list;
        T entry2 = this.root;
        Iterator iterator2 = parts.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            String part = (String)iterator2.next();
            Intrinsics.checkNotNull((Object)part);
            T childEntry = this.getChild(entry2, part);
            if (childEntry == null) {
                File currentFile = file2;
                int n2 = ((Collection)parts).size() - index;
                for (int i = 0; i < n2; ++i) {
                    File parentFile = currentFile.getParentFile();
                    if (parentFile == null) continue;
                    currentFile = parentFile;
                }
                return new Pair(entry2, (Object)currentFile);
            }
            entry2 = childEntry;
        }
        return new Pair(entry2, (Object)file2);
    }

    @NotNull
    public final T getOrCreate(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List list = FileUtil.splitPath((String)file2.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitPath(...)");
        List parts = list;
        T entry2 = this.root;
        for (String part : parts) {
            Intrinsics.checkNotNull((Object)part);
            Object childEntry = this.getChild(entry2, part);
            if (childEntry == null) {
                Object object;
                int n = this.nextId;
                this.nextId = n + 1;
                childEntry = (Entry)this.entryFactory.invoke((Object)n, (Object)((Entry)entry2).getId());
                this.entryMap.put(((Entry)childEntry).getId(), childEntry);
                Integer n2 = this.parentCountMap.getOrDefault(((Entry)entry2).getId(), 0);
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getOrDefault(...)");
                int parentCount = ((Number)n2).intValue();
                ((Map)this.parentCountMap).put(((Entry)entry2).getId(), parentCount + 1);
                String normalizedPart = this.normalize(part);
                Map $this$getOrPut$iv = this.childrenMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(normalizedPart);
                if (value$iv == null) {
                    boolean bl = false;
                    HashMap answer$iv = new HashMap();
                    $this$getOrPut$iv.put(normalizedPart, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                HashMap map = (HashMap)object;
                map.put(((Entry)entry2).getId(), childEntry);
            }
            entry2 = childEntry;
        }
        return entry2;
    }

    public final void removeIfEmpty(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        T t = this.get(file2);
        if (t == null) {
            return;
        }
        T entry2 = t;
        this.removeIfEmpty(entry2, file2);
    }

    public final void removeIfEmpty(@NotNull T entry2, @NotNull File file2) {
        Intrinsics.checkNotNullParameter(entry2, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.entryMap.containsKey(((Entry)entry2).getId())) {
            return;
        }
        if (!((Entry)entry2).isEmpty()) {
            return;
        }
        if (this.parentCountMap.containsKey(((Entry)entry2).getId())) {
            return;
        }
        this.entryMap.remove(((Entry)entry2).getId());
        HashMap<Integer, T> hashMap = this.childrenMap.get(file2.getName());
        if (hashMap != null) {
            Entry cfr_ignored_0 = (Entry)hashMap.remove(((Entry)entry2).getParentId());
        }
        Integer n = this.parentCountMap.getOrDefault(((Entry)entry2).getParentId(), 0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
        int parentsCount = ((Number)n).intValue();
        if (parentsCount == 1) {
            this.parentCountMap.remove(((Entry)entry2).getParentId());
        } else if (parentsCount > 1) {
            ((Map)this.parentCountMap).put(((Entry)entry2).getParentId(), parentsCount - 1);
        }
        T t = this.getParent(entry2);
        if (t == null) {
            return;
        }
        T parent = t;
        File file3 = file2.getParentFile();
        if (file3 == null) {
            return;
        }
        File parentFile = file3;
        this.removeIfEmpty(parent, parentFile);
    }

    /*
     * WARNING - void declaration
     */
    public final void visit(@NotNull FilePathTreeVisitor<? super T> visitor2, @Nullable Comparator<Pair<String, T>> comparator) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        HashMap<Integer, ArrayList<String>> children = new HashMap<Integer, ArrayList<String>>();
        for (Map.Entry entry2 : ((Map)this.childrenMap).entrySet()) {
            String childName = (String)entry2.getKey();
            HashMap childList = (HashMap)entry2.getValue();
            Iterator iterator2 = ((Map)childList).entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object;
                void $this$getOrPut$iv;
                int id = ((Number)iterator2.next().getKey()).intValue();
                Map map = children;
                Integer key$iv = id;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    ArrayList answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ArrayList nameList = (ArrayList)object;
                nameList.add(childName);
            }
        }
        this.visitInternal(visitor2, null, this.root, null, children, comparator);
    }

    public static /* synthetic */ void visit$default(FilePathTree filePathTree, FilePathTreeVisitor filePathTreeVisitor, Comparator comparator, int n, Object object) {
        if ((n & 2) != 0) {
            comparator = null;
        }
        filePathTree.visit(filePathTreeVisitor, comparator);
    }

    private final void visitInternal(FilePathTreeVisitor<? super T> visitor2, File file2, T entry2, Object context2, HashMap<Integer, ArrayList<String>> allChildren, Comparator<Pair<String, T>> comparator) {
        ProgressManager.checkCanceled();
        Pair<VisitResult, Object> pair2 = this.doVisit(visitor2, file2, entry2, context2);
        VisitResult result2 = (VisitResult)((Object)pair2.component1());
        Object childContext = pair2.component2();
        if (result2 == VisitResult.Stop) {
            return;
        }
        ArrayList<Pair> children = new ArrayList<Pair>();
        ArrayList<String> arrayList = allChildren.get(((Entry)entry2).getId());
        if (arrayList == null) {
            return;
        }
        ArrayList<String> childList = arrayList;
        for (String childName : childList) {
            Intrinsics.checkNotNull((Object)childName);
            T child = this.getChild(entry2, childName);
            if (child == null) continue;
            children.add(new Pair((Object)childName, child));
        }
        if (comparator != null) {
            CollectionsKt.sortWith((List)children, comparator);
        }
        for (Pair pair3 : children) {
            String childName = (String)pair3.component1();
            Entry childNode = (Entry)pair3.component2();
            File childFile = new File(file2, childName);
            this.visitInternal(visitor2, childFile, childNode, childContext, allChildren, comparator);
        }
    }

    private final Pair<VisitResult, Object> doVisit(FilePathTreeVisitor<? super T> visitor2, File file2, T entry2, Object context2) {
        if (file2 == null) {
            return new Pair((Object)VisitResult.Continue, context2);
        }
        return visitor2.visitEntry(file2, entry2, context2);
    }

    @Nullable
    public final T getParent(@NotNull T entry2) {
        Intrinsics.checkNotNullParameter(entry2, (String)"entry");
        ProgressManager.checkCanceled();
        return (T)((Entry)this.entryMap.get(((Entry)entry2).getParentId()));
    }

    @Nullable
    public final T getChild(@NotNull T entry2, @NotNull String pathComponent) {
        Intrinsics.checkNotNullParameter(entry2, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)pathComponent, (String)"pathComponent");
        ProgressManager.checkCanceled();
        String normalizedPart = this.normalize(pathComponent);
        HashMap<Integer, T> hashMap = this.childrenMap.get(normalizedPart);
        if (hashMap == null) {
            return null;
        }
        HashMap<Integer, T> map = hashMap;
        return (T)((Entry)map.get(((Entry)entry2).getId()));
    }

    private final String normalize(String part) {
        if (SystemInfo.isMac) {
            String string = Normalizer.normalize(part, Normalizer.Form.NFC);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalize(...)");
            return string;
        }
        if (SystemInfo.isWindows && StringsKt.endsWith$default((String)part, (String)":", (boolean)false, (int)2, null)) {
            return part + "\\";
        }
        return part;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Companion;", "", "()V", "RootId", "", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "", "id", "", "parentId", "(II)V", "getId", "()I", "getParentId", "isEmpty", "", "intellij.rider.rdclient.dotnet"})
    public static abstract class Entry {
        private final int id;
        private final int parentId;

        public Entry(int id, int parentId) {
            this.id = id;
            this.parentId = parentId;
        }

        public final int getId() {
            return this.id;
        }

        public final int getParentId() {
            return this.parentId;
        }

        public abstract boolean isEmpty();
    }
}

