/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchPathTree;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootEntry;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootType;
import com.jetbrains.rider.model.RdDeltaType;
import com.jetbrains.rider.vfs.VfsIgnoreChangesRequester;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0018\u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J \u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110'*\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010(R-\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsDeltaCollector;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "index", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;", "(Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;)V", "deltas", "Ljava/util/LinkedHashMap;", "", "Lcom/jetbrains/rider/model/RdDeltaType;", "Lkotlin/collections/LinkedHashMap;", "getDeltas", "()Ljava/util/LinkedHashMap;", "getIndex", "()Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;", "add", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "type", "addInternal", "addRecursively", "beforeFileDeletion", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "beforeFileMovement", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "beforePropertyChange", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "contentsChanged", "fileCopied", "Lcom/intellij/openapi/vfs/VirtualFileCopyEvent;", "fileCreated", "fileMoved", "processAllRecursively", "processRecursively", "entry", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootEntry;", "propertyChanged", "getChildrenSafe", "", "(Lcom/intellij/openapi/vfs/VirtualFile;)[Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVfsDeltaCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsDeltaCollector.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsDeltaCollector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,209:1\n65#2,4:210\n65#2,4:214\n65#2,4:218\n13#2:223\n13#3:222\n*S KotlinDebug\n*F\n+ 1 VfsDeltaCollector.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsDeltaCollector\n*L\n75#1:210,4\n79#1:214,4\n84#1:218,4\n13#1:223\n13#1:222\n*E\n"})
public final class VfsDeltaCollector
implements VirtualFileListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VfsWatchPathTree index;
    @NotNull
    private final LinkedHashMap<String, RdDeltaType> deltas;
    @NotNull
    private static final Logger logger;

    public VfsDeltaCollector(@NotNull VfsWatchPathTree index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        this.index = index;
        this.deltas = new LinkedHashMap();
    }

    @NotNull
    public final VfsWatchPathTree getIndex() {
        return this.index;
    }

    @NotNull
    public final LinkedHashMap<String, RdDeltaType> getDeltas() {
        return this.deltas;
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.addRecursively(virtualFile2, RdDeltaType.Created);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.addRecursively(virtualFile2, RdDeltaType.Deleted);
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.addRecursively(virtualFile2, RdDeltaType.Deleted);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.addRecursively(virtualFile2, RdDeltaType.Created);
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.addRecursively(virtualFile2, RdDeltaType.Created);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.add(virtualFile2, RdDeltaType.Changed);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name")) {
            VirtualFile virtualFile2 = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
            this.add(virtualFile2, RdDeltaType.Deleted);
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        VirtualFile file2 = virtualFile2;
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name")) {
            if (file2.isDirectory()) {
                this.addRecursively(file2, RdDeltaType.Created);
            } else {
                this.add(file2, RdDeltaType.Created);
            }
        } else {
            this.add(file2, RdDeltaType.Changed);
        }
    }

    private final void add(VirtualFile file2, RdDeltaType type) {
        if (this.index.findWatchRoot(file2) != null || this.index.containsRequestedFile(file2)) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Process " + file2 + " with type " + type.name());
            }
            this.addInternal(file2, type);
        } else {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Skip " + file2 + " with type " + type.name() + ", no watch root found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addRecursively(VirtualFile file2, RdDeltaType type) {
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Recursively process " + file2);
        }
        long startTimeMs = System.currentTimeMillis();
        try {
            VfsWatchRootEntry vfsWatchRootEntry;
            VfsWatchRootEntry watchRoot = this.index.findWatchRoot(file2);
            if (watchRoot != null && watchRoot.getType() == VfsWatchRootType.Recursive) {
                this.addInternal(file2, type);
                this.processAllRecursively(file2, type);
                return;
            }
            if (watchRoot != null && watchRoot.getType() == VfsWatchRootType.Flat) {
                this.addInternal(file2, type);
            }
            if (this.index.getEntry(file2) == null) {
                return;
            }
            VfsWatchRootEntry entry2 = vfsWatchRootEntry;
            this.processRecursively(file2, type, entry2);
        }
        finally {
            int threshold = 200;
            long totalTimeMs = System.currentTimeMillis() - startTimeMs;
            if (totalTimeMs > (long)threshold && !ApplicationKt.getApplication().isUnitTestMode()) {
                logger.warn("Recursively process " + file2 + " took " + totalTimeMs + " ms, threshold " + threshold + " ms");
            }
        }
    }

    private final void processRecursively(VirtualFile file2, RdDeltaType type, VfsWatchRootEntry entry2) {
        if (this.index.containsRequestedFile(file2)) {
            this.addInternal(file2, type);
        }
        for (VirtualFile child : this.getChildrenSafe(file2)) {
            VfsWatchRootEntry childEntry;
            if (entry2.getType() == VfsWatchRootType.Flat) {
                this.addInternal(child, type);
            }
            String string = child.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (this.index.getChildEntry(entry2, string) == null) continue;
            if (childEntry.getType() == VfsWatchRootType.Recursive) {
                this.addInternal(child, type);
                this.processAllRecursively(child, type);
                continue;
            }
            if (childEntry.getType() == VfsWatchRootType.Flat) {
                this.addInternal(child, type);
            }
            this.processRecursively(child, type, childEntry);
        }
    }

    private final void processAllRecursively(VirtualFile file2, RdDeltaType type) {
        for (VirtualFile child : this.getChildrenSafe(file2)) {
            this.addInternal(child, type);
            this.processAllRecursively(child, type);
        }
    }

    private final VirtualFile[] getChildrenSafe(VirtualFile $this$getChildrenSafe) {
        VirtualFile[] virtualFileArray;
        try {
            virtualFileArray = $this$getChildrenSafe.getChildren();
            Intrinsics.checkNotNull((Object)virtualFileArray);
        }
        catch (InvalidVirtualFileAccessException e) {
            virtualFileArray = new VirtualFile[]{};
        }
        return virtualFileArray;
    }

    private final void addInternal(VirtualFile file2, RdDeltaType type) {
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        RdDeltaType existingType = this.deltas.get(path);
        if (existingType == RdDeltaType.Created) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    this.deltas.remove(path);
                }
            }
            return;
        }
        if (existingType == RdDeltaType.Deleted) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 3: {
                    ((Map)this.deltas).put(path, RdDeltaType.Changed);
                }
            }
            return;
        }
        if (existingType == RdDeltaType.Changed) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 3: {
                    break;
                }
                case 1: {
                    ((Map)this.deltas).put(path, RdDeltaType.Deleted);
                }
            }
            return;
        }
        ((Map)this.deltas).put(path, type);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VfsDeltaCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VfsDeltaCollector.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsDeltaCollector$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdDeltaType.values().length];
            try {
                nArray[RdDeltaType.Deleted.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDeltaType.Changed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDeltaType.Created.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

