/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.model.RdShellModel;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.ProtocolComponent;
import com.jetbrains.rider.protocol.components.ShellHost;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/ideaInterop/RiderFrameStateTracker;", "Lcom/intellij/openapi/Disposable;", "()V", "windowEventHandler", "Ljava/awt/event/AWTEventListener;", "dispose", "", "findShellModelForWindow", "Lcom/jetbrains/rider/model/RdShellModel;", "window", "Ljava/awt/Window;", "tryActiveFrameForProject", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderFrameStateTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFrameStateTracker.kt\ncom/jetbrains/rider/ideaInterop/RiderFrameStateTracker\n+ 2 IProtocolHost.kt\ncom/jetbrains/rider/protocol/IProtocolHostKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n24#2:75\n24#2:87\n800#3,11:76\n800#3,11:88\n*S KotlinDebug\n*F\n+ 1 RiderFrameStateTracker.kt\ncom/jetbrains/rider/ideaInterop/RiderFrameStateTracker\n*L\n59#1:75\n68#1:87\n59#1:76,11\n68#1:88,11\n*E\n"})
public final class RiderFrameStateTracker
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AWTEventListener windowEventHandler = arg_0 -> RiderFrameStateTracker.windowEventHandler$lambda$0(this, arg_0);

    public RiderFrameStateTracker() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.windowEventHandler, 64L);
    }

    public void dispose() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.windowEventHandler);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final RdShellModel findShellModelForWindow(Window window) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        if (ApplicationKt.getApplication().isDisposed()) {
            return null;
        }
        if (window == null) {
            return null;
        }
        if (!(window instanceof IdeFrameImpl)) {
            return null;
        }
        Component component = ComponentUtil.findUltimateParent((Component)window);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"findUltimateParent(...)");
        Component frame = component;
        if (!(frame instanceof IdeFrame)) return null;
        ProjectFrameHelper projectFrameHelper = ProjectFrameHelper.Companion.getFrameHelper(window);
        ProjectFrameHelper projectFrameHelper2 = projectFrameHelper;
        if (projectFrameHelper == null) return null;
        if ((projectFrameHelper2 = projectFrameHelper2.getProject()) == null) {
            return null;
        }
        ProjectFrameHelper project2 = projectFrameHelper2;
        if (project2.isDefault()) {
            return null;
        }
        IProtocolHost iProtocolHost = ApplicationProtocolKt.getProtocolHostIfExists((Project)project2);
        Object object = iProtocolHost;
        if (iProtocolHost == null) return null;
        IProtocolHost $this$getComponent$iv = object;
        boolean $i$f$getComponent = false;
        Iterable $this$filterIsInstance$iv$iv = $this$getComponent$iv.getComponents();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof ShellHost)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        ShellHost shellHost = (ShellHost)((ProtocolComponent)CollectionsKt.single((List)((List)destination$iv$iv$iv)));
        object = shellHost;
        if (shellHost == null) return null;
        RdShellModel rdShellModel2 = ((ShellHost)object).getModel();
        return rdShellModel2;
    }

    public final void tryActiveFrameForProject(@NotNull Project project2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            IdeFrame ideFrame = WindowManagerEx.getInstanceEx().findFrameFor(project2);
            if (ideFrame == null) break block1;
            IdeFrame it = ideFrame;
            boolean bl = false;
            if (it instanceof ProjectFrameHelper && ((ProjectFrameHelper)it).getFrame().isActive()) {
                ApplicationKt.getApplication().invokeLater(() -> RiderFrameStateTracker.tryActiveFrameForProject$lambda$2$lambda$1(project2));
            }
        }
    }

    private static final void windowEventHandler$lambda$0(RiderFrameStateTracker this$0, AWTEvent event) {
        block0: {
            IOptProperty<Boolean> iOptProperty;
            block1: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (!(event instanceof WindowEvent)) break block0;
                if (((WindowEvent)event).getID() != 205) break block1;
                IOptProperty<Boolean> iOptProperty2 = this$0.findShellModelForWindow(((WindowEvent)event).getWindow());
                if (iOptProperty2 == null || (iOptProperty2 = iOptProperty2.isApplicationActive()) == null) break block0;
                iOptProperty2.set((Object)true);
                break block0;
            }
            if (((WindowEvent)event).getID() != 206 || (iOptProperty = this$0.findShellModelForWindow(((WindowEvent)event).getWindow())) == null || (iOptProperty = iOptProperty.isApplicationActive()) == null) break block0;
            iOptProperty.set((Object)false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void tryActiveFrameForProject$lambda$2$lambda$1(Project $project) {
        block2: {
            void $this$filterIsInstanceTo$iv$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Object object = ApplicationProtocolKt.getProtocolHostIfExists($project);
            if (object == null) break block2;
            IProtocolHost $this$getComponent$iv = object;
            boolean $i$f$getComponent = false;
            Iterable $this$filterIsInstance$iv$iv = $this$getComponent$iv.getComponents();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof ShellHost)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            object = (ShellHost)((ProtocolComponent)CollectionsKt.single((List)((List)destination$iv$iv$iv)));
            if (object != null && (object = ((ShellHost)object).getModel()) != null && (object = ((RdShellModel)((Object)object)).isApplicationActive()) != null) {
                object.set((Object)true);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/ideaInterop/RiderFrameStateTracker$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/ideaInterop/RiderFrameStateTracker;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderFrameStateTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFrameStateTracker.kt\ncom/jetbrains/rider/ideaInterop/RiderFrameStateTracker$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,74:1\n40#2,3:75\n*S KotlinDebug\n*F\n+ 1 RiderFrameStateTracker.kt\ncom/jetbrains/rider/ideaInterop/RiderFrameStateTracker$Companion\n*L\n27#1:75,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderFrameStateTracker getInstance() {
            boolean $i$f$service = false;
            Class<RiderFrameStateTracker> serviceClass$iv = RiderFrameStateTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (RiderFrameStateTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

