/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PathUtil;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdFileDocumentId;
import com.jetbrains.rd.ide.model.RdOpenFileDescriptor;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.actions.RiderActionsSupport;
import com.jetbrains.rider.actions.impl.cleanup.RiderCodeCleanupSupport;
import com.jetbrains.rider.completion.ClientCompletionSupport;
import com.jetbrains.rider.daemon.RiderHighlightingSupport;
import com.jetbrains.rider.document.RiderDocumentBindingService;
import com.jetbrains.rider.document.RiderDocumentExKt;
import com.jetbrains.rider.editorActions.RiderTypedHandlersSupport;
import com.jetbrains.rider.editors.DocCoordinates;
import com.jetbrains.rider.editors.RiderTextControlHost;
import com.jetbrains.rider.intentions.RiderAutoImportSupport;
import com.jetbrains.rider.intentions.altEnter.RiderAltEnterSupport;
import com.jetbrains.rider.model.RdFrontendDocumentId;
import com.jetbrains.rider.model.RdProjectFileDocumentId;
import com.jetbrains.rider.parameterInfo.RiderParameterInfoSupport;
import com.jetbrains.rider.platform.ProtocolLanguageFeatureProvider;
import com.jetbrains.rider.projectView.RiderOpenFileDescriptorKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.quickDoc.RiderQuickDocSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\r\u001a\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u001a\u0016\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r\u001a%\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019\u001a \u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\n\u0010\u001f\u001a\u00020 *\u00020\u001b\u001a\n\u0010!\u001a\u00020\u000b*\u00020\u001b\u001a\u0012\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010%\u001a\u00020 \u001a\u0014\u0010&\u001a\u0004\u0018\u00010\u001b*\u00020\u00142\u0006\u0010'\u001a\u00020(\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006)"}, d2={"allBackendProviders", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/platform/ProtocolLanguageFeatureProvider;", "Lkotlin/collections/ArrayList;", "assertCorrectContextForSharedFile", "", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "project", "Lcom/intellij/openapi/project/Project;", "dumpAllIdeaEditors", "", "precisePath", "", "dumpIdeaFileEditors", "hasAnyBackendFeature", "psiFile", "Lcom/intellij/psi/PsiFile;", "pmIdToString", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "suspendPatchEngineProcessingCookie", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "tryOpenTextEditorWithProjectModelId", "Lcom/intellij/openapi/editor/Editor;", "activate", "descriptor", "Lcom/jetbrains/rd/ide/model/RdOpenFileDescriptor;", "getProjectModelId", "", "getProjectName", "offsetToDocCoordinates", "Lcom/jetbrains/rider/editors/DocCoordinates;", "Lcom/intellij/openapi/editor/Document;", "offset", "tryGetEditor", "textControlHost", "Lcom/jetbrains/rdclient/editors/FrontendTextControlHost;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTextControlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextControlUtils.kt\ncom/jetbrains/rider/editors/TextControlUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n*L\n1#1,296:1\n260#1,5:305\n265#1:313\n273#1,8:315\n282#1:324\n6442#2:297\n1747#3,3:298\n766#3:301\n857#3,2:302\n1855#3:314\n1856#3:323\n1855#3,2:329\n1#4:304\n39#5,3:310\n43#5:325\n39#5,3:326\n43#5:331\n*S KotlinDebug\n*F\n+ 1 TextControlUtils.kt\ncom/jetbrains/rider/editors/TextControlUtilsKt\n*L\n242#1:305,5\n242#1:313\n242#1:315,8\n242#1:324\n119#1:297\n222#1:298,3\n233#1:301\n233#1:302,2\n242#1:314\n242#1:323\n265#1:329,2\n242#1:310,3\n242#1:325\n264#1:326,3\n264#1:331\n*E\n"})
public final class TextControlUtilsKt {
    @NotNull
    private static final ArrayList<ProtocolLanguageFeatureProvider> allBackendProviders;

    @NotNull
    public static final String dumpAllIdeaEditors(@NotNull Project project2, boolean precisePath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        StringBuilder result2 = new StringBuilder();
        StringBuilder stringBuilder = result2.append("Idea editors:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
        Editor[] editors = editorArray;
        int i = 1;
        for (Editor editor2 : editors) {
            Document document;
            Object object;
            Object documentId;
            StringBuilder stringBuilder2 = result2.append("Editor #" + i);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder3 = result2.append("ToString(): " + editor2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            if (editor2 == null) {
                StringBuilder stringBuilder4 = result2.append("no Editor associated with this FileEditor");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                continue;
            }
            TextControlId textControlId = DocumentExKt.getTextControlId(editor2);
            if (textControlId != null) {
                String pmIdState = TextControlUtilsKt.pmIdToString(textControlId, precisePath);
                RdDocumentId rdDocumentId = textControlId.getDocumentId();
                documentId = rdDocumentId instanceof RdFileDocumentId ? (RdFileDocumentId)rdDocumentId : null;
                Object object2 = documentId;
                String name = object2 != null && (object2 = object2.getFilePath()) != null && (object2 = DocumentUtilKt.toVirtualFile((String)object2, true)) != null ? object2.getName() : null;
                object = "file=" + name + " projectModelId:" + pmIdState + " tabId:" + textControlId.getTabIndex();
            } else {
                object = "null";
            }
            String textControlIdDump = object;
            StringBuilder stringBuilder5 = result2.append("Model id: " + textControlIdDump);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
            documentId = result2;
            Object object3 = virtualFile2;
            if (object3 == null || (object3 = object3.getName()) == null) {
                object3 = "null file";
            }
            StringBuilder stringBuilder6 = ((StringBuilder)documentId).append("Virtual file: " + (String)object3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)editor2.getDocument(), (String)"getDocument(...)");
            DocCoordinates pos = TextControlUtilsKt.offsetToDocCoordinates(document, editor2.getCaretModel().getCurrentCaret().getOffset());
            StringBuilder stringBuilder7 = result2.append("Current caret: (" + pos.getLine() + ", " + pos.getColumn() + ")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
            DocCoordinates selectionStart = TextControlUtilsKt.offsetToDocCoordinates(document, editor2.getSelectionModel().getSelectionStart());
            DocCoordinates selectionEnd = TextControlUtilsKt.offsetToDocCoordinates(document, editor2.getSelectionModel().getSelectionEnd());
            StringBuilder stringBuilder8 = result2.append("Current selection:  startPosition = (" + selectionStart.getLine() + ", " + selectionStart.getColumn() + ") endPosition = (" + selectionEnd.getLine() + ", " + selectionEnd.getColumn() + ")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
            ++i;
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String dumpAllIdeaEditors$default(Project project2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return TextControlUtilsKt.dumpAllIdeaEditors(project2, bl);
    }

    @NotNull
    public static final String pmIdToString(@NotNull TextControlId textControlId, boolean precisePath) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Integer projectModelId = RiderDocumentExKt.getProjectModelId(textControlId.getDocumentId());
        if (projectModelId != null) {
            String pmIdState = projectModelId.toString();
            if (!precisePath) {
                pmIdState = projectModelId != 0 ? "!=0" : "=0(Misc Files)";
            }
            return pmIdState;
        }
        return "<no model>";
    }

    @NotNull
    public static final String dumpIdeaFileEditors(@NotNull Project project2, boolean precisePath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        StringBuilder result2 = new StringBuilder();
        StringBuilder stringBuilder = result2.append("Idea editors:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        Object[] objectArray = FileEditorManager.getInstance((Project)project2).getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAllEditors(...)");
        Object[] fileEditors = objectArray;
        int i = 1;
        Object[] $this$sortedBy$iv = fileEditors;
        boolean $i$f$sortedBy = false;
        for (FileEditor fileEditor : ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(project2){
            final /* synthetic */ Project $project$inlined;
            {
                this.$project$inlined = project2;
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final int compare(T a, T b) {
                fileEditor = (FileEditor)a;
                $i$a$-sortedBy-TextControlUtilsKt$dumpIdeaFileEditors$1 = false;
                v0 = fileEditor instanceof TextEditor != false ? (TextEditor)fileEditor : null;
                if (v0 == null || (v0 = (var5_5 = v0.getEditor())) == null) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)v0);
                v0 = DocumentExKt.getTextControlId((Editor)var5_5);
                if (v0 != null) {
                    v1 = v0.getDocumentId();
                } else lbl-1000:
                // 2 sources

                {
                    v1 = null;
                }
                if ((v2 = (documentId = v1)) != null && (v2 = RiderDocumentExKt.getPath(v2, this.$project$inlined)) != null) {
                    var5_5 = v2;
                    if (var5_5.length() == 0) {
                        $i$a$-ifEmpty-TextControlUtilsKt$dumpIdeaFileEditors$1$1 = false;
                        v3 = documentId.toString();
                    } else {
                        v3 = var5_5;
                    }
                    v4 = (String)v3;
                } else {
                    v4 = null;
                }
                fileEditor = (FileEditor)b;
                var8_8 = (Comparable)v4;
                $i$a$-sortedBy-TextControlUtilsKt$dumpIdeaFileEditors$1 = false;
                v5 /* !! */  = fileEditor instanceof TextEditor != false ? (TextEditor)fileEditor : null;
                if (v5 /* !! */  == null || (v5 /* !! */  = (var5_5 = v5 /* !! */ .getEditor())) == null) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)v5 /* !! */ );
                v5 /* !! */  = DocumentExKt.getTextControlId((Editor)var5_5);
                if (v5 /* !! */  != null) {
                    v6 = v5 /* !! */ .getDocumentId();
                } else lbl-1000:
                // 2 sources

                {
                    v6 = null;
                }
                if ((v7 = (documentId = v6)) != null && (v7 = RiderDocumentExKt.getPath((RdDocumentId)v7, this.$project$inlined)) != null) {
                    var5_5 = v7;
                    if (var5_5.length() == 0) {
                        $i$a$-ifEmpty-TextControlUtilsKt$dumpIdeaFileEditors$1$1 = false;
                        v8 = documentId.toString();
                    } else {
                        v8 = var5_5;
                    }
                    v9 = (String)v8;
                } else {
                    v9 = null;
                }
                return ComparisonsKt.compareValues((Comparable)var8_8, (Comparable)((Comparable)v9));
            }
        })) {
            Document document;
            Object object;
            CharSequence fileName;
            Editor editor2;
            StringBuilder stringBuilder2 = result2.append("Editor #" + i);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder3 = result2.append("Name: " + fileEditor.getName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
            Object object2 = editor2 = textEditor != null ? textEditor.getEditor() : null;
            if (editor2 == null) {
                StringBuilder stringBuilder4 = result2.append("no Editor associated with this FileEditor");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                continue;
            }
            TextControlId textControlId = DocumentExKt.getTextControlId(editor2);
            if (textControlId != null) {
                RdDocumentId documentId = textControlId.getDocumentId();
                String string = PathUtil.getFileName((String)RiderDocumentExKt.getPath(documentId, project2));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
                fileName = string;
                String projectModelIdString = TextControlUtilsKt.pmIdToString(textControlId, precisePath);
                object = "file=" + (String)fileName + " projectModelId" + projectModelIdString;
            } else {
                object = "null";
            }
            String textControlIdDump = object;
            StringBuilder stringBuilder5 = result2.append("Model id: " + textControlIdDump);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
            fileName = result2;
            Object object3 = virtualFile2;
            if (object3 == null || (object3 = object3.getName()) == null) {
                object3 = "null file";
            }
            StringBuilder stringBuilder6 = ((StringBuilder)fileName).append("Virtual file: " + (String)object3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)editor2.getDocument(), (String)"getDocument(...)");
            DocCoordinates pos = TextControlUtilsKt.offsetToDocCoordinates(document, editor2.getCaretModel().getCurrentCaret().getOffset());
            StringBuilder stringBuilder7 = result2.append("Current caret: (" + pos.getLine() + ", " + pos.getColumn() + ")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
            DocCoordinates selectionStart = TextControlUtilsKt.offsetToDocCoordinates(document, editor2.getSelectionModel().getSelectionStart());
            DocCoordinates selectionEnd = TextControlUtilsKt.offsetToDocCoordinates(document, editor2.getSelectionModel().getSelectionEnd());
            StringBuilder stringBuilder8 = result2.append("Current selection:  startPosition = (" + selectionStart.getLine() + ", " + selectionStart.getColumn() + ") endPosition = (" + selectionEnd.getLine() + ", " + selectionEnd.getColumn() + ")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
            ++i;
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String dumpIdeaFileEditors$default(Project project2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return TextControlUtilsKt.dumpIdeaFileEditors(project2, bl);
    }

    @NotNull
    public static final DocCoordinates offsetToDocCoordinates(@NotNull Document $this$offsetToDocCoordinates, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$offsetToDocCoordinates, (String)"<this>");
        if (!(0 <= offset ? offset <= $this$offsetToDocCoordinates.getTextLength() : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int line = $this$offsetToDocCoordinates.getLineNumber(offset);
        int lineStartOffset = $this$offsetToDocCoordinates.getLineStartOffset(line);
        int column = offset - lineStartOffset;
        return new DocCoordinates(line, column);
    }

    public static final int getProjectModelId(@NotNull Editor $this$getProjectModelId) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectModelId, (String)"<this>");
        Project project2 = $this$getProjectModelId.getProject();
        if (project2 != null) {
            RdFrontendDocumentId id;
            Document document = $this$getProjectModelId.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            RdDocumentId rdDocumentId = DocumentExKt.getDocumentId(document, project2);
            RdFrontendDocumentId rdFrontendDocumentId = id = rdDocumentId instanceof RdFrontendDocumentId ? (RdFrontendDocumentId)rdDocumentId : null;
            if (id != null) {
                Integer n = RiderDocumentBindingService.Companion.getInstance(project2).getProjectModelId(id);
                return n != null ? n : 0;
            }
        }
        Integer n = (Integer)$this$getProjectModelId.getUserData(RiderTextControlHost.Companion.getProjectModelIdKey());
        return n == null ? 0 : n;
    }

    @NotNull
    public static final String getProjectName(@NotNull Editor $this$getProjectName) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectName, (String)"<this>");
        String miscProjectName = "Misc Files";
        Project project2 = $this$getProjectName.getProject();
        if (project2 == null) {
            return miscProjectName;
        }
        Project project3 = project2;
        int projectModelId = TextControlUtilsKt.getProjectModelId($this$getProjectName);
        if (projectModelId == 0) {
            return miscProjectName;
        }
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getProjectModelEntity(WorkspaceModel.Companion.getInstance(project3), projectModelId);
        if (projectModelEntity == null) {
            return miscProjectName;
        }
        ProjectModelEntity entity2 = projectModelEntity;
        ProjectModelEntity projectModelEntity2 = ProjectModelEntityExtensionsKt.containingProjectEntity(entity2);
        if (projectModelEntity2 == null) {
            return miscProjectName;
        }
        ProjectModelEntity containingProjectEntity = projectModelEntity2;
        return containingProjectEntity.getName();
    }

    @Nullable
    public static final Editor tryGetEditor(@NotNull TextControlId $this$tryGetEditor, @NotNull FrontendTextControlHost textControlHost) {
        Intrinsics.checkNotNullParameter((Object)$this$tryGetEditor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)textControlHost), (String)"textControlHost");
        return textControlHost.getEditor($this$tryGetEditor);
    }

    @Deprecated(message="to be removed")
    public static final boolean hasAnyBackendFeature(@NotNull PsiFile psiFile) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            if (ClientCompletionSupport.Companion.getInstance().backendCompletionEnabledInFile(psiFile)) {
                return true;
            }
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 != null && RiderHighlightingSupport.isAvailable(virtualFile2)) {
                return true;
            }
            List list = psiFile.getViewProvider().getAllFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllFiles(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        PsiFile file2 = (PsiFile)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = allBackendProviders;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ProtocolLanguageFeatureProvider it = (ProtocolLanguageFeatureProvider)element$iv2;
                                boolean bl4 = false;
                                Intrinsics.checkNotNull((Object)file2);
                                if (!it.isAvailable(file2)) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertCorrectContextForSharedFile(@NotNull RdDocumentId documentId, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        RdProjectFileDocumentId rdProjectFileDocumentId = documentId instanceof RdProjectFileDocumentId ? (RdProjectFileDocumentId)documentId : null;
        if (rdProjectFileDocumentId == null) {
            return;
        }
        RdProjectFileDocumentId projectFileDocumentId = rdProjectFileDocumentId;
        int projectModelId = projectFileDocumentId.getProjectModelElementId();
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project2);
        if (ProjectModelEntityExtensionsKt.isFromSharedProject(workspaceModel, projectModelId)) {
            VirtualFile virtualFile2 = AppLevelIdeBackend.Companion.getInstance().findVirtualFile(documentId);
            Intrinsics.checkNotNull((Object)virtualFile2);
            VirtualFile file2 = virtualFile2;
            List<ProjectModelEntity> entities2 = WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, file2, project2);
            if (CollectionsKt.any((Iterable)entities2)) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = entities2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
                    boolean bl = false;
                    if (!(!ProjectModelEntityExtensionsKt.isFromSharedProject(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                int normalProjectsCount = ((Collection)((List)destination$iv$iv)).size();
                if (!(normalProjectsCount == 0)) {
                    boolean bl = false;
                    String string = "Request to sync shared projectFile when there are normal project contexts";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Editor tryOpenTextEditorWithProjectModelId(@NotNull TextControlId textControlId, boolean activate, @NotNull RdOpenFileDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        boolean $i$f$suspendPatchEngineProcessingCookie = false;
        if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
            VirtualFile file2;
            boolean bl = false;
            RdDocumentId documentId = textControlId.getDocumentId();
            VirtualFile virtualFile2 = file2 = AppLevelIdeBackend.Companion.getInstance().findVirtualFile(documentId);
            if (!(virtualFile2 != null ? virtualFile2.exists() : false)) {
                return null;
            }
            RdProjectId rdProjectId = textControlId.getProjectId();
            if (rdProjectId == null || (rdProjectId = ProjectUtilKt.toProject((RdProjectId)rdProjectId)) == null) {
                return null;
            }
            RdProjectId project2 = rdProjectId;
            Integer projectModelId = RiderDocumentExKt.getProjectModelId(documentId);
            if (projectModelId == null || projectModelId == 0) {
                Integer n = descriptor.getDocOffset();
                return FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor((Project)project2, file2, n != null ? n : -1), activate);
            }
            return (Editor)RiderOpenFileDescriptorKt.withProjectModelId(projectModelId, (Function0)new Function0<Editor>((Project)project2, file2, descriptor, activate){
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ RdOpenFileDescriptor $descriptor;
                final /* synthetic */ boolean $activate;
                {
                    this.$project = $project;
                    this.$file = $file;
                    this.$descriptor = $descriptor;
                    this.$activate = $activate;
                    super(0);
                }

                @Nullable
                public final Editor invoke() {
                    Integer n = this.$descriptor.getDocOffset();
                    return FileEditorManager.getInstance((Project)this.$project).openTextEditor(new OpenFileDescriptor(this.$project, this.$file, n != null ? n : -1), this.$activate);
                }
            });
        }
        Lifetime.Companion this_$iv$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv$iv = new LifetimeDefinition();
        try {
            VirtualFile file3;
            Lifetime lifetime$iv = def$iv$iv.getLifetime();
            boolean bl = false;
            Iterable $this$forEach$iv$iv = FrontendSessionsUtilKt.getFrontendSessions(ApplicationKt.getApplication());
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                ClientAppSession it$iv = (ClientAppSession)element$iv$iv;
                boolean bl2 = false;
                BuildersKt.launch((CoroutineScope)lifetime$iv.getCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it$iv, null){
                    int label;
                    final /* synthetic */ ClientAppSession $it;
                    {
                        this.$it = $it;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = FrontendAsyncRequestExecutor.Companion.getInstance(this.$it).synchronizeWithPatchEngine((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                                    int label;

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                                                if (object3 != object2) throw new KotlinNothingValueException();
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                throw new KotlinNothingValueException();
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation<? super Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            boolean bl3 = false;
            RdDocumentId documentId = textControlId.getDocumentId();
            VirtualFile virtualFile3 = file3 = AppLevelIdeBackend.Companion.getInstance().findVirtualFile(documentId);
            if (!(virtualFile3 != null ? virtualFile3.exists() : false)) {
                Editor editor2 = null;
                return editor2;
            }
            RdProjectId rdProjectId = textControlId.getProjectId();
            if (rdProjectId == null || (rdProjectId = ProjectUtilKt.toProject((RdProjectId)rdProjectId)) == null) {
                Editor editor3 = null;
                return editor3;
            }
            RdProjectId project3 = rdProjectId;
            Integer projectModelId = RiderDocumentExKt.getProjectModelId(documentId);
            if (projectModelId == null || projectModelId == 0) {
                Integer n = descriptor.getDocOffset();
                Editor editor4 = FileEditorManager.getInstance((Project)project3).openTextEditor(new OpenFileDescriptor((Project)project3, file3, n != null ? n : -1), activate);
                return editor4;
            }
            Editor editor5 = (Editor)RiderOpenFileDescriptorKt.withProjectModelId(projectModelId, (Function0)new /* invalid duplicate definition of identical inner class */);
            return editor5;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv$iv, (boolean)false, (int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T suspendPatchEngineProcessingCookie(@NotNull Function0<? extends T> action2) {
        Object object;
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$suspendPatchEngineProcessingCookie = false;
        if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return (T)action2.invoke();
        }
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            Lifetime lifetime2 = def$iv.getLifetime();
            boolean bl = false;
            Iterable $this$forEach$iv = FrontendSessionsUtilKt.getFrontendSessions(ApplicationKt.getApplication());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClientAppSession it = (ClientAppSession)element$iv;
                boolean bl2 = false;
                BuildersKt.launch((CoroutineScope)lifetime2.getCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */));
            }
            object = action2.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    static {
        Object[] objectArray = new ProtocolLanguageFeatureProvider[]{RiderTypedHandlersSupport.INSTANCE, RiderActionsSupport.INSTANCE, RiderAltEnterSupport.INSTANCE, RiderAutoImportSupport.INSTANCE, RiderParameterInfoSupport.INSTANCE, RiderQuickDocSupport.INSTANCE, RiderCodeCleanupSupport.INSTANCE};
        allBackendProviders = CollectionsKt.arrayListOf((Object[])objectArray);
    }
}

