/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.editors.ILastFocusedEditorSuppressor;
import com.jetbrains.rider.editors.LastFocusedEditorSuppressor;
import com.jetbrains.rider.editors.StateForBackend;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001c\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/editors/RiderBackendInteractionHelper;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "backendToGateway", "", "Lcom/jetbrains/rider/editors/StateForBackend;", "isInAfterFinishedCallback", "", "doAfterSyncFinished", "", "gatewayForBackend", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "action", "Lkotlin/Function0;", "isAnyGatewaySyncing", "isSyncFromBackendInProgress", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "onSyncFromBackendFinished", "syncFromBackend", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderBackendInteractionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderBackendInteractionHelper.kt\ncom/jetbrains/rider/editors/RiderBackendInteractionHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n1747#2,3:128\n1#3:131\n13#4:132\n13#5:133\n*S KotlinDebug\n*F\n+ 1 RiderBackendInteractionHelper.kt\ncom/jetbrains/rider/editors/RiderBackendInteractionHelper\n*L\n46#1:128,3\n25#1:132\n25#1:133\n*E\n"})
public final class RiderBackendInteractionHelper
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    private boolean isInAfterFinishedCallback;
    @NotNull
    private final Map<ClientAppSession, StateForBackend> backendToGateway;
    @NotNull
    private static final Logger logger;

    public RiderBackendInteractionHelper(@NotNull ClientAppSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.backendToGateway = new LinkedHashMap();
        this.backendToGateway.put(this.session, new StateForBackend());
    }

    public final boolean isSyncFromBackendInProgress(@Nullable VirtualFile file2) {
        return this.isSyncFromBackendInProgress();
    }

    public final boolean isSyncFromBackendInProgress() {
        StateForBackend stateForBackend = this.backendToGateway.get(this.session);
        Intrinsics.checkNotNull((Object)stateForBackend);
        return (Boolean)stateForBackend.getSyncFromBackendInProgress().getValue();
    }

    public final boolean isAnyGatewaySyncing() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.backendToGateway.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StateForBackend it = (StateForBackend)element$iv;
                    boolean bl2 = false;
                    if (!((Boolean)it.getSyncFromBackendInProgress().getValue()).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @RequiresEdt
    public final boolean syncFromBackend(@NotNull Lifetime lifetime2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        if (PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return true;
        }
        if (!(!this.isInAfterFinishedCallback)) {
            boolean bl = false;
            String string = "Cannot use this api while executing afterFinished callback. Try to use 'callSynchronously'";
            throw new IllegalArgumentException(string.toString());
        }
        StateForBackend stateForBackend = this.backendToGateway.get(this.session);
        Intrinsics.checkNotNull((Object)stateForBackend);
        StateForBackend gateway2 = stateForBackend;
        if (((Boolean)gateway2.getSyncFromBackendInProgress().getValue()).booleanValue()) {
            return false;
        }
        lifetime2.bracket((Function0)new Function0<Unit>(this, lifetime2, gateway2){
            final /* synthetic */ RiderBackendInteractionHelper this$0;
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ StateForBackend $gateway;
            {
                this.this$0 = $receiver;
                this.$lifetime = $lifetime;
                this.$gateway = $gateway;
                super(0);
            }

            public final void invoke() {
                RiderBackendInteractionHelper.access$getLogger$cp().trace("Begin syncing from backend...");
                ClientProjectSession projectSession = (ClientProjectSession)CollectionsKt.singleOrNull((List)RiderBackendInteractionHelper.access$getSession$p(this.this$0).getProjectSessions());
                if (projectSession != null) {
                    ILastFocusedEditorSuppressor editorSuppressor = LastFocusedEditorSuppressor.Companion.getInstance(projectSession);
                    boolean success2 = editorSuppressor.forceReleaseSuppressionForLastFocusedEditor("Release all frontend changes before syncing the backend");
                    if (!success2) {
                        throw new IllegalStateException("Can't release editor suppression.");
                    }
                    editorSuppressor.vetoSuppression(this.$lifetime, "Syncing from backend");
                }
                this.$gateway.getSyncFromBackendInProgress().setValue((Object)true);
            }
        }, (Function0)new Function0<Unit>(gateway2){
            final /* synthetic */ StateForBackend $gateway;
            {
                this.$gateway = $gateway;
                super(0);
            }

            public final void invoke() {
                this.$gateway.getSyncFromBackendInProgress().setValue((Object)false);
                RiderBackendInteractionHelper.access$getLogger$cp().trace("Syncing from backend has finished.");
            }
        });
        return true;
    }

    private final void doAfterSyncFinished(StateForBackend gatewayForBackend, Lifetime lifetime2, Function0<Unit> action2) {
        if (!((Boolean)gatewayForBackend.getSyncFromBackendInProgress().getValue()).booleanValue()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        LifetimeDefinition definition = lifetime2.createNested();
        gatewayForBackend.getSyncFromBackendInProgress().advise(definition.getLifetime(), (Function1)new Function1<Boolean, Unit>(definition, this, action2){
            final /* synthetic */ LifetimeDefinition $definition;
            final /* synthetic */ RiderBackendInteractionHelper this$0;
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$definition = $definition;
                this.this$0 = $receiver;
                this.$action = $action;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(boolean value2) {
                if (!value2) {
                    LifetimeDefinition.terminate$default((LifetimeDefinition)this.$definition, (boolean)false, (int)1, null);
                    Lifetime.Companion companion = Lifetime.Companion;
                    RiderBackendInteractionHelper riderBackendInteractionHelper = this.this$0;
                    Function0<Unit> function0 = this.$action;
                    boolean $i$f$using = false;
                    LifetimeDefinition def$iv = new LifetimeDefinition();
                    try {
                        Lifetime lt = def$iv.getLifetime();
                        boolean bl = false;
                        Iterable $this$forEach$iv = RiderBackendInteractionHelper.access$getSession$p(riderBackendInteractionHelper).getProjectSessions();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            ClientProjectSession it = (ClientProjectSession)element$iv;
                            boolean bl2 = false;
                            ILastFocusedEditorSuppressor editorSuppressor = LastFocusedEditorSuppressor.Companion.getInstance(it);
                            editorSuppressor.vetoSuppression(lt, "doAfterSyncFinished");
                        }
                        try {
                            RiderBackendInteractionHelper.access$setInAfterFinishedCallback$p(riderBackendInteractionHelper, true);
                            function0.invoke();
                        }
                        finally {
                            RiderBackendInteractionHelper.access$setInAfterFinishedCallback$p(riderBackendInteractionHelper, false);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
                    }
                }
            }
        });
    }

    public final void onSyncFromBackendFinished(@NotNull Lifetime lifetime2, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        StateForBackend gateway2 = this.backendToGateway.get(this.session);
        if (gateway2 == null) {
            action2.invoke();
            return;
        }
        if (!((Boolean)gateway2.getSyncFromBackendInProgress().getValue()).booleanValue()) {
            action2.invoke();
        } else {
            this.doAfterSyncFinished(gateway2, lifetime2, action2);
        }
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ ClientAppSession access$getSession$p(RiderBackendInteractionHelper $this) {
        return $this.session;
    }

    public static final /* synthetic */ void access$setInAfterFinishedCallback$p(RiderBackendInteractionHelper $this, boolean bl) {
        $this.isInAfterFinishedCallback = bl;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderBackendInteractionHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderBackendInteractionHelper.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/editors/RiderBackendInteractionHelper$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/editors/RiderBackendInteractionHelper;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderBackendInteractionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderBackendInteractionHelper.kt\ncom/jetbrains/rider/editors/RiderBackendInteractionHelper$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,127:1\n31#2,2:128\n*S KotlinDebug\n*F\n+ 1 RiderBackendInteractionHelper.kt\ncom/jetbrains/rider/editors/RiderBackendInteractionHelper$Companion\n*L\n28#1:128,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderBackendInteractionHelper getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project2).getAppSession());
        }

        @NotNull
        public final RiderBackendInteractionHelper getInstance(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session2;
            boolean $i$f$service = false;
            Class<RiderBackendInteractionHelper> serviceClass$iv = RiderBackendInteractionHelper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RiderBackendInteractionHelper)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

