/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.DocOffsetAndVirtualModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.SelectionRange;
import com.jetbrains.rd.ide.model.SelectionRangeWithVersion;
import com.jetbrains.rd.ide.model.SelectionVersion;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlLocation;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\u001a\f\u0010\u0014\u001a\u00020\n*\u00020\u0002H\u0007\u001a\u0014\u0010\u0015\u001a\u00020\u0010*\u00020\u00052\u0006\u0010\u0016\u001a\u00020\rH\u0002\u001a\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u0005*\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019\u001a\f\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u0005\u001a\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0002H\u0002\u001a\n\u0010\u001e\u001a\u00020\u0012*\u00020\n\u001a\n\u0010\u001e\u001a\u00020\u0012*\u00020\u001f\u001a\n\u0010\u001e\u001a\u00020\u0012*\u00020 \"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006!"}, d2={"startOffset", "", "Lcom/intellij/openapi/editor/CaretModel;", "getStartOffset", "(Lcom/intellij/openapi/editor/CaretModel;)I", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)I", "applyTo", "", "selectionModel", "Lcom/jetbrains/rd/ide/model/SelectionRange;", "editor", "createSelectionModelPosition", "Lcom/jetbrains/rd/ide/model/DocOffsetAndVirtualModel;", "offset", "visualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "createLogCategory", "", "Lcom/jetbrains/rd/ide/model/TextControlId;", "createSelectionRange", "docOffsetAndVirtualToVisualPosition", "pos", "getEditor", "project", "Lcom/intellij/openapi/project/Project;", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "getTheFirstCaretOffset", "Lcom/intellij/openapi/editor/Caret;", "toDebugString", "Lcom/jetbrains/rd/ide/model/SelectionRangeWithVersion;", "Lcom/jetbrains/rd/ide/model/SelectionVersion;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nPlatformTextControlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformTextControlUtils.kt\ncom/jetbrains/rider/editors/PlatformTextControlUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1045#2:135\n*S KotlinDebug\n*F\n+ 1 PlatformTextControlUtils.kt\ncom/jetbrains/rider/editors/PlatformTextControlUtilsKt\n*L\n16#1:135\n*E\n"})
public final class PlatformTextControlUtilsKt {
    private static final Caret getTheFirstCaretOffset(CaretModel $this$getTheFirstCaretOffset) {
        List list = $this$getTheFirstCaretOffset.getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        Object object = CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Caret it = (Caret)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOffset());
                it = (Caret)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOffset()));
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        return (Caret)object;
    }

    private static final VisualPosition docOffsetAndVirtualToVisualPosition(Editor $this$docOffsetAndVirtualToVisualPosition, DocOffsetAndVirtualModel pos) {
        if (!(pos.getVirtualDelta() >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        VisualPosition visualPosition = $this$docOffsetAndVirtualToVisualPosition.offsetToVisualPosition(pos.getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
        VisualPosition vPos = visualPosition;
        return pos.getVirtualDelta() == 0 ? vPos : new VisualPosition(vPos.line, vPos.column + pos.getVirtualDelta(), vPos.leansRight);
    }

    public static final void applyTo(@NotNull SelectionRange selectionModel, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        Caret caretToSync = PlatformTextControlUtilsKt.getTheFirstCaretOffset(caretModel);
        DocOffsetAndVirtualModel docOffsetAndVirtualModel = selectionModel.getSelectionAnchor();
        int anchorPosOffset = docOffsetAndVirtualModel.component1();
        int anchorVDelta = docOffsetAndVirtualModel.component2();
        DocOffsetAndVirtualModel docOffsetAndVirtualModel2 = selectionModel.getActivePosition();
        int activePosOffset = docOffsetAndVirtualModel2.component1();
        int activePosVDelta = docOffsetAndVirtualModel2.component2();
        if (Intrinsics.areEqual((Object)selectionModel.getActivePosition(), (Object)selectionModel.getSelectionAnchor())) {
            if (caretToSync.hasSelection()) {
                caretToSync.removeSelection();
            }
        } else if (anchorVDelta > 0 || activePosVDelta > 0) {
            VisualPosition anchorVPos = PlatformTextControlUtilsKt.docOffsetAndVirtualToVisualPosition(editor2, selectionModel.getSelectionAnchor());
            VisualPosition activeVPos = PlatformTextControlUtilsKt.docOffsetAndVirtualToVisualPosition(editor2, selectionModel.getActivePosition());
            caretToSync.setSelection(anchorVPos, anchorPosOffset, activeVPos, activePosOffset);
        } else {
            caretToSync.setSelection(anchorPosOffset, activePosOffset);
        }
        if (activePosVDelta > 0) {
            VisualPosition activeVPos = PlatformTextControlUtilsKt.docOffsetAndVirtualToVisualPosition(editor2, selectionModel.getActivePosition());
            caretToSync.moveToVisualPosition(activeVPos);
        } else {
            caretToSync.moveToOffset(activePosOffset);
        }
    }

    @RiderOnly
    @NotNull
    public static final SelectionRange createSelectionRange(@NotNull CaretModel $this$createSelectionRange) {
        DocOffsetAndVirtualModel docOffsetAndVirtualModel;
        DocOffsetAndVirtualModel activePos;
        Intrinsics.checkNotNullParameter((Object)$this$createSelectionRange, (String)"<this>");
        Caret caret = PlatformTextControlUtilsKt.getTheFirstCaretOffset($this$createSelectionRange);
        Editor editor2 = caret.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        Document document = editor3.getDocument();
        DocumentEx documentEx = document instanceof DocumentEx ? (DocumentEx)document : null;
        boolean isInBulkUpdate = documentEx != null ? documentEx.isInBulkUpdate() : false;
        int caretOffset = caret.getOffset();
        if (isInBulkUpdate) {
            v2 = PlatformTextControlUtilsKt.createSelectionModelPosition(caretOffset);
        } else {
            VisualPosition visualPosition = caret.getVisualPosition();
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
            v2 = activePos = PlatformTextControlUtilsKt.createSelectionModelPosition(editor3, caretOffset, visualPosition);
        }
        if (!caret.hasSelection()) {
            return new SelectionRange(activePos, activePos);
        }
        int selMin = Math.min(caret.getSelectionStart(), caret.getSelectionEnd());
        int selMax = Math.max(caret.getSelectionStart(), caret.getSelectionEnd());
        if (selMin < caretOffset && caretOffset < selMax) {
            int offset;
            boolean isSelStartActivePos = caret.getLeadSelectionOffset() != caret.getSelectionStart();
            int n = offset = isSelStartActivePos ? caret.getSelectionStart() : caret.getSelectionEnd();
            if (isInBulkUpdate) {
                v5 = PlatformTextControlUtilsKt.createSelectionModelPosition(offset);
            } else {
                VisualPosition visualPosition = isSelStartActivePos ? caret.getSelectionStartPosition() : caret.getSelectionEndPosition();
                Intrinsics.checkNotNull((Object)visualPosition);
                VisualPosition visualPosition2 = visualPosition;
                v5 = activePos = PlatformTextControlUtilsKt.createSelectionModelPosition(editor3, offset, visualPosition2);
            }
        }
        if (isInBulkUpdate) {
            docOffsetAndVirtualModel = PlatformTextControlUtilsKt.createSelectionModelPosition(caret.getLeadSelectionOffset());
        } else {
            int n = caret.getLeadSelectionOffset();
            VisualPosition visualPosition = caret.getLeadSelectionPosition();
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getLeadSelectionPosition(...)");
            docOffsetAndVirtualModel = PlatformTextControlUtilsKt.createSelectionModelPosition(editor3, n, visualPosition);
        }
        DocOffsetAndVirtualModel anchorPos = docOffsetAndVirtualModel;
        return new SelectionRange(anchorPos, activePos);
    }

    private static final DocOffsetAndVirtualModel createSelectionModelPosition(int offset) {
        return new DocOffsetAndVirtualModel(offset, 0, Boolean.valueOf(false));
    }

    private static final DocOffsetAndVirtualModel createSelectionModelPosition(Editor editor2, int offset, VisualPosition visualPosition) {
        int virtualDelta = UtilKt.calcVirtualDelta((Editor)editor2, (int)offset, (VisualPosition)visualPosition);
        return new DocOffsetAndVirtualModel(offset, virtualDelta, Boolean.valueOf(false));
    }

    @Nullable
    public static final PsiFile getPsiFile(@NotNull Editor $this$getPsiFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getPsiFile, (String)"<this>");
        Project project2 = $this$getPsiFile.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        return PsiDocumentManager.getInstance((Project)project3).getPsiFile($this$getPsiFile.getDocument());
    }

    @NotNull
    public static final String toDebugString(@NotNull SelectionRange $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(active: " + UtilKt.toDebugString((DocOffsetAndVirtualModel)$this$toDebugString.getActivePosition()) + " - anchor: " + UtilKt.toDebugString((DocOffsetAndVirtualModel)$this$toDebugString.getSelectionAnchor()) + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull SelectionVersion $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(master: " + $this$toDebugString.getMasterVersion() + ", slave: " + $this$toDebugString.getSlaveVersion() + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull SelectionRangeWithVersion $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return PlatformTextControlUtilsKt.toDebugString($this$toDebugString.getSelection()) + " with version " + PlatformTextControlUtilsKt.toDebugString($this$toDebugString.getVersion());
    }

    private static final int getStartOffset(CaretModel $this$startOffset) {
        return PlatformTextControlUtilsKt.getTheFirstCaretOffset($this$startOffset).getOffset();
    }

    public static final int getStartOffset(@NotNull Editor $this$startOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$startOffset, (String)"<this>");
        if ($this$startOffset.getSelectionModel().hasSelection()) {
            return $this$startOffset.getSelectionModel().getSelectionStart();
        }
        CaretModel caretModel = $this$startOffset.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        return PlatformTextControlUtilsKt.getStartOffset(caretModel);
    }

    @Nullable
    public static final Editor getEditor(@NotNull TextControlId $this$getEditor, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$getEditor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return FrontendTextControlHost.Companion.getInstance(project2).getEditor($this$getEditor);
    }

    @NotNull
    public static final String createLogCategory(@NotNull TextControlId $this$createLogCategory) {
        Intrinsics.checkNotNullParameter((Object)$this$createLogCategory, (String)"<this>");
        String fileName = DocumentExKt.createLogCategory((RdDocumentId)$this$createLogCategory.getDocumentId());
        int tabIndex = $this$createLogCategory.getTabIndex();
        TextControlLocation kind = $this$createLogCategory.getKind();
        return fileName + ", " + tabIndex + ", " + kind;
    }
}

