/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.actions.RdDataContextManager;
import com.jetbrains.rd.ide.Suppressor;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.Operation;
import com.jetbrains.rd.ide.model.RiderProjectDocumentOperationModel_PregeneratedKt;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.model.TypedAction;
import com.jetbrains.rd.ide.model.TypedKey;
import com.jetbrains.rd.ide.model.TypingSessionState;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editorActions.cwm.FrontendTypeKeyRequest;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.EditorUtilKt;
import com.jetbrains.rider.document.FrontendCommandsHost;
import com.jetbrains.rider.document.TextBufferDocumentSynchronizer;
import com.jetbrains.rider.editorActions.CommitResult;
import com.jetbrains.rider.editorActions.CustomTypingSessionPolicy;
import com.jetbrains.rider.editorActions.FrontendTypedHandler;
import com.jetbrains.rider.editorActions.FrontendTypedHandlerManager;
import com.jetbrains.rider.editorActions.IFrontendTypingListener;
import com.jetbrains.rider.editorActions.ITypingSessions;
import com.jetbrains.rider.editorActions.SynchronousFrontendTypedHandlerStrategy;
import com.jetbrains.rider.editorActions.TerminationOnModificationAfterMoveCaret;
import com.jetbrains.rider.editorActions.TypingSessionMediator;
import com.jetbrains.rider.editorActions.TypingSessions;
import com.jetbrains.rider.editors.EditorSynchronizerWithTypingSession;
import com.jetbrains.rider.editors.ILastFocusedEditorSuppressor;
import com.jetbrains.rider.editors.LastFocusedEditorSuppressor;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@RiderOnly(reason="Replaced with requests system", see=FrontendTypeKeyRequest.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 P2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001PB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0%H\u0016J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\bH\u0014J\u001a\u0010.\u001a\u00020\u001f2\b\u0010/\u001a\u0004\u0018\u00010\b2\u0006\u00100\u001a\u00020+H\u0014J.\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001f0%H\u0016J$\u00106\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u001f08H\u0016J\u0010\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020!H\u0016J\b\u0010<\u001a\u00020\u000bH\u0017J\b\u0010=\u001a\u00020\u000bH\u0016J\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010>\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010?\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010?\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020!H\u0002J(\u0010A\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010B\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010-\u001a\u00020\bH\u0002JB\u0010C\u001a\u00020D2\u0006\u0010'\u001a\u00020(2\u0006\u0010E\u001a\u00020F2\u0006\u0010*\u001a\u00020+2\u0006\u0010G\u001a\u00020H2\u0018\u0010I\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u001f0JH\u0016JB\u0010C\u001a\u00020D2\u0006\u0010'\u001a\u00020(2\u0006\u0010B\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0018\u0010I\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u001f0JH\u0002J \u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010O\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020!H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\fR\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/jetbrains/rider/editorActions/TypingSessions;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "Lcom/jetbrains/rider/editorActions/ITypingSessions;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "activeSessionMediator", "Lcom/jetbrains/rider/editorActions/TypingSessionMediator;", "isSessionActive", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "", "()Lcom/jetbrains/rd/util/reactive/IOptProperty;", "isUnderOptimisticTyping", "isUnderTypingContextCalculation", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "suppressor", "Lcom/jetbrains/rd/ide/Suppressor;", "getSuppressor", "()Lcom/jetbrains/rd/ide/Suppressor;", "suppressor$delegate", "Lkotlin/Lazy;", "terminationRules", "", "Lcom/jetbrains/rider/editorActions/TerminationOnModificationAfterMoveCaret;", "adviseBackendTypingsSynced", "", "id", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "action", "Lkotlin/Function0;", "afterAppend", "c", "", "beforeAppend", "editor", "Lcom/intellij/openapi/editor/Editor;", "beforeFirstWritableOperation", "mediator", "beforeNewTypingSessionCreated", "currentSessionMediator", "newTypingSessionSource", "executeTypedAction", "actionId", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "optimisticTypedAction", "executeUnderSessionWithNextTimestamp", "block", "Lkotlin/Function1;", "", "forceCloseActiveSession", "reason", "hasActiveSession", "isTypingSessionSynced", "openNewTypingSession", "reopenSessionIfNeeded", "frontendId", "sendTypedKey", "isCompletionTerminator", "type", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "typedHandler", "Lcom/jetbrains/rider/editorActions/FrontendTypedHandler;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "optimisticTypedHandler", "Lkotlin/Function2;", "isWritableTypingAssist", "typeCharCookie", "Lcom/intellij/openapi/Disposable;", "ch", "waitForSessionTermination", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTypingSessions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypingSessions.kt\ncom/jetbrains/rider/editorActions/TypingSessions\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n*L\n1#1,427:1\n65#2,4:428\n65#2,4:432\n65#2,4:436\n65#2,4:440\n65#2,4:444\n65#2,4:460\n65#2,4:464\n13#2:474\n22#3,6:448\n22#3,6:454\n22#3,6:468\n*S KotlinDebug\n*F\n+ 1 TypingSessions.kt\ncom/jetbrains/rider/editorActions/TypingSessions\n*L\n107#1:428,4\n141#1:432,4\n239#1:436,4\n243#1:440,4\n250#1:444,4\n339#1:460,4\n349#1:464,4\n54#1:474\n261#1:448,6\n317#1:454,6\n366#1:468,6\n*E\n"})
public class TypingSessions
extends LifetimedService
implements EditorFactoryListener,
ITypingSessions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final List<TerminationOnModificationAfterMoveCaret> terminationRules;
    @Nullable
    private TypingSessionMediator activeSessionMediator;
    private boolean isUnderTypingContextCalculation;
    private boolean isUnderOptimisticTyping;
    @NotNull
    private final IOptProperty<Boolean> isSessionActive;
    @NotNull
    private final Lazy suppressor$delegate;
    private static int sessionId;
    @NotNull
    private static final String asyncTypingKey = "rider.typing.async";
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Set<String> allowedActions;
    @NotNull
    private static final Set<String> allowedActionsWithActiveLookup;

    public TypingSessions(@NotNull ClientProjectSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.terminationRules = CollectionsKt.listOf((Object)new TerminationOnModificationAfterMoveCaret());
        this.isSessionActive = (IOptProperty)new OptProperty((Object)false);
        this.suppressor$delegate = LazyKt.lazy((Function0)suppressor.2.INSTANCE);
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    @NotNull
    public final Project getProject() {
        return this.session.getProject();
    }

    @Override
    @NotNull
    public IOptProperty<Boolean> isSessionActive() {
        return this.isSessionActive;
    }

    @Override
    @NotNull
    public Suppressor getSuppressor() {
        Lazy lazy = this.suppressor$delegate;
        return (Suppressor)lazy.getValue();
    }

    @Override
    public boolean isTypingSessionSynced() {
        TypingSessionMediator mediator = this.activeSessionMediator;
        return mediator == null || !mediator.getHasWritableTypingAssist();
    }

    @Override
    public void adviseBackendTypingsSynced(@NotNull String id, @NotNull Lifetime lifetime2, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        TypingSessionMediator mediator = this.activeSessionMediator;
        if (mediator == null) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Document is synced, execute '" + id + "' right away");
            }
            action2.invoke();
        } else if (!mediator.getHasWritableTypingAssist()) {
            logger.trace("Only readonly typing assists are suppressed on the frontend, execute right away");
            action2.invoke();
        } else {
            mediator.getSessionFinishedSignal$intellij_rider_rdclient_dotnet().advise(lifetime2, (Function1)new Function1<CommitResult, Unit>(action2, id){
                final /* synthetic */ Function0<Unit> $action;
                final /* synthetic */ String $id;
                {
                    this.$action = $action;
                    this.$id = $id;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull CommitResult result2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
                    if (result2 == CommitResult.Commited) {
                        void $this$trace$iv;
                        Logger logger = TypingSessions.access$getLogger$cp();
                        String string = this.$id;
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            void var6_8 = $this$trace$iv;
                            boolean bl = false;
                            var6_8.trace("executing action " + string + " after successful document sync");
                        }
                        this.$action.invoke();
                    } else {
                        Logger $this$trace$iv = TypingSessions.access$getLogger$cp();
                        String string = this.$id;
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv;
                            boolean bl = false;
                            logger.trace("Action '" + string + "' was not executed, cause the document was rolled back");
                        }
                    }
                }
            });
        }
    }

    public final boolean isUnderTypingContextCalculation() {
        return this.isUnderTypingContextCalculation;
    }

    public final boolean isUnderOptimisticTyping() {
        return this.isUnderOptimisticTyping;
    }

    protected void beforeFirstWritableOperation(@NotNull TypingSessionMediator mediator) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        mediator.beforeWritableOperation();
    }

    private final TypingSessionMediator openNewTypingSession(Editor editor2) {
        int n = sessionId;
        sessionId = n + 1;
        int id = n;
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(">> Open typing session " + id);
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        DocumentSynchronizer documentSynchronizer2 = DocumentExKt.getDocumentSynchronizer(document2, this.session.getAppSession());
        TextBufferDocumentSynchronizer textBufferDocumentSynchronizer = documentSynchronizer2 instanceof TextBufferDocumentSynchronizer ? (TextBufferDocumentSynchronizer)documentSynchronizer2 : null;
        if (textBufferDocumentSynchronizer == null) {
            throw new IllegalStateException("documentSynchronizer is null".toString());
        }
        TextBufferDocumentSynchronizer documentSynchronizer3 = textBufferDocumentSynchronizer;
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor2);
        EditorSynchronizerWithTypingSession editorSynchronizerWithTypingSession = editorSynchronizer instanceof EditorSynchronizerWithTypingSession ? (EditorSynchronizerWithTypingSession)editorSynchronizer : null;
        if (editorSynchronizerWithTypingSession == null) {
            throw new IllegalStateException("editorSynchronizer is null".toString());
        }
        EditorSynchronizerWithTypingSession editorSynchronizer2 = editorSynchronizerWithTypingSession;
        TextControlId typingSessionTextControlId = editorSynchronizer2.getTextControlId();
        this.beforeNewTypingSessionCreated(this.activeSessionMediator, editor2);
        TypingSessionState typingSession = new TypingSessionState(typingSessionTextControlId, id);
        TypingSessionMediator mediator = new TypingSessionMediator(logger, typingSession, editor2, editorSynchronizer2, documentSynchronizer3, this.getSuppressor(), this.session.getAppSession());
        Lifetime sessionLifetime = mediator.getLifetime();
        FrontendCommandsHost.Companion.getInstance(this.session.getAppSession()).suppress(sessionLifetime);
        this.getSuppressor().onRelease(sessionLifetime, (Function0)new Function0<Unit>(mediator){
            final /* synthetic */ TypingSessionMediator $mediator;
            {
                this.$mediator = $mediator;
                super(0);
            }

            public final void invoke() {
                this.$mediator.flushQueuedOperations();
            }
        });
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable((Lifetime)sessionLifetime, (String)"TypingSessionMediator");
        editor2.getCaretModel().addCaretListener((CaretListener)mediator, disposable);
        editor2.getSelectionModel().addSelectionListener((SelectionListener)mediator, disposable);
        document2.addDocumentListener((DocumentListener)mediator, disposable);
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect(disposable);
        Project myProject = this.getProject();
        ApplicationKt.getApplication().getMessageBus().connect((Disposable)myProject).subscribe(FrontendTextControlHostListener.Companion.getTOPIC(), (Object)new FrontendTextControlHostListener(myProject, typingSessionTextControlId, mediator){
            final /* synthetic */ Project $myProject;
            final /* synthetic */ TextControlId $typingSessionTextControlId;
            final /* synthetic */ TypingSessionMediator $mediator;
            {
                this.$myProject = $myProject;
                this.$typingSessionTextControlId = $typingSessionTextControlId;
                this.$mediator = $mediator;
            }

            public void editorBound(@NotNull Lifetime lifetime2, @NotNull ClientAppSession appSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
                Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
                Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                if (!Intrinsics.areEqual((Object)editor2.getProject(), (Object)this.$myProject)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)this.$typingSessionTextControlId, (Object)textControlId)) {
                    lifetime2.onTerminationIfAlive((Function0)new Function0<Unit>(this.$mediator){
                        final /* synthetic */ TypingSessionMediator $mediator;
                        {
                            this.$mediator = $mediator;
                            super(0);
                        }

                        public final void invoke() {
                            this.$mediator.close("editor was closed");
                        }
                    });
                }
            }
        });
        Topic topic = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new AnActionListener(mediator){
            final /* synthetic */ TypingSessionMediator $mediator;
            {
                this.$mediator = $mediator;
            }

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String actionId = ActionManager.getInstance().getId(action2);
                if (!CollectionsKt.contains((Iterable)TypingSessions.access$getAllowedActions$cp(), (Object)actionId) && !CollectionsKt.contains((Iterable)TypingSessions.access$getAllowedActionsWithActiveLookup$cp(), (Object)actionId)) {
                    this.$mediator.close("Executing action with id: " + actionId);
                }
            }
        });
        sessionLifetime.bracket((Function0)new Function0<Unit>(this, mediator, typingSession){
            final /* synthetic */ TypingSessions this$0;
            final /* synthetic */ TypingSessionMediator $mediator;
            final /* synthetic */ TypingSessionState $typingSession;
            {
                this.this$0 = $receiver;
                this.$mediator = $mediator;
                this.$typingSession = $typingSession;
                super(0);
            }

            public final void invoke() {
                this.this$0.isSessionActive().set((Object)true);
                TypingSessions.access$setActiveSessionMediator$p(this.this$0, this.$mediator);
                RiderProjectDocumentOperationModel_PregeneratedKt.getRiderProjectDocumentOperationModel(FrontendSessionsUtilKt.getProtocolModel(this.this$0.getSession())).getTypingSession().setValue((Object)this.$typingSession);
            }
        }, (Function0)new Function0<Unit>(this, id){
            final /* synthetic */ TypingSessions this$0;
            final /* synthetic */ int $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$trace$iv;
                TypingSessions.access$setActiveSessionMediator$p(this.this$0, null);
                RiderProjectDocumentOperationModel_PregeneratedKt.getRiderProjectDocumentOperationModel(FrontendSessionsUtilKt.getProtocolModel(this.this$0.getSession())).getTypingSession().setValue(null);
                Iterable $this$forEach$iv = TypingSessions.access$getTerminationRules$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TerminationOnModificationAfterMoveCaret it = (TerminationOnModificationAfterMoveCaret)element$iv;
                    boolean bl = false;
                    it.clearState();
                }
                $this$forEach$iv = TypingSessions.access$getLogger$cp();
                int n = this.$id;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    void var7_9 = $this$trace$iv;
                    boolean bl = false;
                    var7_9.trace(">> Close typing session " + n);
                }
                this.this$0.isSessionActive().set((Object)false);
            }
        });
        return mediator;
    }

    protected void beforeNewTypingSessionCreated(@Nullable TypingSessionMediator currentSessionMediator, @NotNull Editor newTypingSessionSource) {
        Intrinsics.checkNotNullParameter((Object)newTypingSessionSource, (String)"newTypingSessionSource");
    }

    @Override
    @NotNull
    public TypedHandlerDelegate.Result type(char c, @NotNull FrontendTypedHandler typedHandler, @NotNull Editor editor2, @NotNull IdeBackend backend, @NotNull Function2<? super Character, ? super Editor, Unit> optimisticTypedHandler) {
        boolean hasMultipleEditPoints;
        Intrinsics.checkNotNullParameter((Object)typedHandler, (String)"typedHandler");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        Intrinsics.checkNotNullParameter(optimisticTypedHandler, (String)"optimisticTypedHandler");
        boolean isCompletionTerminator = typedHandler.isCompletionTerminator(editor2, c);
        boolean isWritableTypingAssist = typedHandler.isWritableTypingAssist(editor2, c);
        ILastFocusedEditorSuppressor editorSuppressor = LastFocusedEditorSuppressor.Companion.getInstance(this.getProject());
        if (isCompletionTerminator) {
            editorSuppressor.forceReleaseSuppressionForLastFocusedEditor("typed completion terminator character '" + c + "'");
        }
        if (hasMultipleEditPoints = EditorUtilKt.hasMultipleEditPoints(editor2)) {
            return SynchronousFrontendTypedHandlerStrategy.INSTANCE.typeChar(c, typedHandler, editor2, backend);
        }
        return this.type(c, isCompletionTerminator, isWritableTypingAssist, editor2, optimisticTypedHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TypedHandlerDelegate.Result type(char c, boolean isCompletionTerminator, boolean isWritableTypingAssist, Editor editor2, Function2<? super Character, ? super Editor, Unit> optimisticTypedHandler) {
        try {
            TypingSessionMediator mediator;
            this.reopenSessionIfNeeded(c);
            TypingSessionMediator currentTypingSession = this.activeSessionMediator;
            if (currentTypingSession != null) {
                if (Intrinsics.areEqual((Object)currentTypingSession.getEditor(), (Object)editor2)) {
                    $this$trace$iv = logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var13_10 = $this$trace$iv;
                        boolean bl = false;
                        var13_10.trace("Editors match. Using current sessions for " + DocumentExKt.getTextControlId(editor2));
                    }
                    v0 = currentTypingSession;
                } else {
                    $this$trace$iv = logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var13_10 = $this$trace$iv;
                        boolean bl = false;
                        var13_10.trace("Current session is for " + DocumentExKt.getTextControlId(currentTypingSession.getEditor()) + " but typing is requested for " + DocumentExKt.getTextControlId(editor2) + ". Replacing the session with a new one.");
                    }
                    currentTypingSession.close("Editors don't match: current session editor is " + DocumentExKt.getTextControlId(currentTypingSession.getEditor()) + ", typing requested for " + DocumentExKt.getTextControlId(editor2));
                    v0 = this.openNewTypingSession(editor2);
                }
            } else {
                $this$trace$iv = logger;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var13_10 = $this$trace$iv;
                    boolean bl = false;
                    var13_10.trace("Current session is null. Opening a new one for editor " + DocumentExKt.getTextControlId(editor2));
                }
                v0 = mediator = this.openNewTypingSession(editor2);
            }
            if (!mediator.getHasWritableTypingAssist() && isWritableTypingAssist) {
                this.beforeFirstWritableOperation(mediator);
            }
            this.sendTypedKey(c, isCompletionTerminator, editor2, mediator);
            Disposable $this$use$iv = mediator.allowModifications();
            boolean $i$f$use = false;
            try {
                Disposable it = $this$use$iv;
                boolean bl = false;
                optimisticTypedHandler.invoke((Object)Character.valueOf(c), (Object)editor2);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                if ($this$use$iv != null) {
                    Disposer.dispose((Disposable)$this$use$iv);
                }
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        catch (Throwable t) {
            block15: {
                logger.error(t);
                TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
                if (typingSessionMediator == null) break block15;
                typingSessionMediator.close("exception while '" + c + "' is typing");
            }
            return TypedHandlerDelegate.Result.CONTINUE;
        }
    }

    private final void sendTypedKey(char c, boolean isCompletionTerminator, Editor editor2, TypingSessionMediator mediator) {
        long typedTime = System.nanoTime();
        int timestamp = mediator.getNextOperationTimestamp();
        TypedKey typedKey = new TypedKey(c, isCompletionTerminator, typedTime, timestamp);
        ((IFrontendTypingListener)this.getProject().getMessageBus().syncPublisher(FrontendTypedHandlerManager.Companion.getBEFORE_TYPING_SENT())).beforeSendType(editor2, timestamp, isCompletionTerminator);
        if (this.getSuppressor().shouldSuppress()) {
            mediator.sendReadonlyTypedKey(typedKey);
        }
        mediator.sendOperation((Operation)typedKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTypedAction(@NotNull String actionId, @NotNull Editor editor2, @NotNull DataContext dataContext2, @NotNull Function0<Unit> optimisticTypedAction) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Intrinsics.checkNotNullParameter(optimisticTypedAction, (String)"optimisticTypedAction");
        try {
            List list;
            TypingSessionMediator mediator;
            this.reopenSessionIfNeeded(actionId);
            TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
            if (typingSessionMediator == null) {
                typingSessionMediator = this.openNewTypingSession(editor2);
            }
            if (!(mediator = typingSessionMediator).getHasWritableTypingAssist()) {
                this.beforeFirstWritableOperation(mediator);
            }
            try {
                this.isUnderTypingContextCalculation = true;
                list = RdDataContextManager.Companion.createDataContextModel(dataContext2);
            }
            finally {
                this.isUnderTypingContextCalculation = false;
            }
            List modelDataContext2 = list;
            String backendId = AppLevelIdeBackend.Companion.getInstance().getBackendActionId(actionId);
            mediator.sendOperation((Operation)new TypedAction(backendId, modelDataContext2, mediator.getNextOperationTimestamp()));
            Disposable $this$use$iv = mediator.allowModifications();
            boolean $i$f$use = false;
            try {
                Disposable it = $this$use$iv;
                boolean bl = false;
                this.isUnderOptimisticTyping = true;
                try {
                    optimisticTypedAction.invoke();
                }
                finally {
                    this.isUnderOptimisticTyping = false;
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                if ($this$use$iv != null) {
                    Disposer.dispose((Disposable)$this$use$iv);
                }
            }
        }
        catch (Throwable t) {
            logger.error(t);
            TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
            if (typingSessionMediator != null) {
                typingSessionMediator.close("exception while '" + actionId + "' action is executing");
            }
            optimisticTypedAction.invoke();
        }
    }

    private final void reopenSessionIfNeeded(String frontendId) {
        for (TerminationOnModificationAfterMoveCaret rule : this.terminationRules) {
            if (!rule.shouldTerminateBeforeAction(frontendId)) continue;
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Before execute action '" + frontendId + "' ");
            }
            this.forceCloseActiveSession("Terminate by '" + rule.getClass().getSimpleName() + "' rule");
            break;
        }
    }

    private final void reopenSessionIfNeeded(char c) {
        for (TerminationOnModificationAfterMoveCaret rule : this.terminationRules) {
            if (!rule.shouldTerminateBeforeType(c)) continue;
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Before type '" + c + "' char");
            }
            this.forceCloseActiveSession("Terminate by '" + rule.getClass().getSimpleName() + "' rule");
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeUnderSessionWithNextTimestamp(@NotNull Editor editor2, @NotNull Function1<? super Integer, Unit> block) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            try {
                TypingSessionMediator mediator;
                TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
                if (typingSessionMediator == null) {
                    typingSessionMediator = this.openNewTypingSession(editor2);
                }
                if (!(mediator = typingSessionMediator).getHasWritableTypingAssist()) {
                    this.beforeFirstWritableOperation(mediator);
                }
                Disposable $this$use$iv = mediator.allowModifications();
                boolean $i$f$use = false;
                try {
                    Disposable it = $this$use$iv;
                    boolean bl = false;
                    block.invoke((Object)mediator.getNextOperationTimestamp());
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if ($this$use$iv != null) {
                        Disposer.dispose((Disposable)$this$use$iv);
                    }
                }
            }
            catch (Throwable t) {
                logger.error(t);
                TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
                if (typingSessionMediator == null) break block8;
                typingSessionMediator.close("exception while async operation is executing");
            }
        }
    }

    @Override
    @NotNull
    public Disposable typeCharCookie(char ch, @NotNull Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.beforeAppend(ch, editor2);
        return new Disposable(this, ch){
            final /* synthetic */ TypingSessions this$0;
            final /* synthetic */ char $ch;
            {
                this.this$0 = $receiver;
                this.$ch = $ch;
            }

            public void dispose() {
                TypingSessions.access$afterAppend(this.this$0, this.$ch);
            }
        };
    }

    private final void beforeAppend(char c, Editor editor2) {
        block3: {
            try {
                this.reopenSessionIfNeeded(c);
                TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
                if (typingSessionMediator == null) {
                    typingSessionMediator = this.openNewTypingSession(editor2);
                }
                TypingSessionMediator mediator = typingSessionMediator;
                this.sendTypedKey(c, false, editor2, mediator);
                mediator.startAllowModifications();
            }
            catch (Throwable t) {
                logger.error(t);
                TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
                if (typingSessionMediator == null) break block3;
                typingSessionMediator.close("exception while '" + c + "' is typing");
            }
        }
    }

    private final void afterAppend(char c) {
        TypingSessionMediator mediator = this.activeSessionMediator;
        if (mediator == null) {
            logger.error("activeSessionMediator == null");
            return;
        }
        mediator.endAllowModifications();
    }

    @Override
    public void forceCloseActiveSession(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
        if (typingSessionMediator == null) {
            return;
        }
        TypingSessionMediator mediator = typingSessionMediator;
        mediator.close(reason);
    }

    @Override
    public void waitForSessionTermination(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
        if (typingSessionMediator == null) {
            return;
        }
        TypingSessionMediator sessionMediator = typingSessionMediator;
        LastFocusedEditorSuppressor.Companion.getInstance(this.getProject()).forceReleaseSuppressionForLastFocusedEditor(reason);
        IRdDispatcher rdDispatcher = IRdDispatcherKt.getAsRdDispatcher((IScheduler)FrontendSessionsUtilKt.getProtocol(sessionMediator.getSession()).getScheduler());
        rdDispatcher.pumpProtocolQueue((Function0)new Function0<Boolean>(this){
            final /* synthetic */ TypingSessions this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.hasActiveSession();
            }
        });
    }

    @Override
    @TestOnly
    public boolean hasActiveSession() {
        return this.activeSessionMediator != null;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$setActiveSessionMediator$p(TypingSessions $this, TypingSessionMediator typingSessionMediator) {
        $this.activeSessionMediator = typingSessionMediator;
    }

    public static final /* synthetic */ List access$getTerminationRules$p(TypingSessions $this) {
        return $this.terminationRules;
    }

    public static final /* synthetic */ void access$afterAppend(TypingSessions $this, char c) {
        $this.afterAppend(c);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TypingSessions.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TypingSessions.logger = logger;
        Object[] objectArray = new String[]{"EditorEnter", "EditorTab", "EditorUnindentSelection", "EditorDelete", "EditorBackSpace", "EditorLeft", "EditorRight", "EditorEscape", "EditorChooseLookupItem", "EditorChooseLookupItemReplace", "EditorChooseLookupItemCompleteStatement"};
        allowedActions = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"EditorDown", "EditorUp"};
        allowedActionsWithActiveLookup = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0018J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/editorActions/TypingSessions$Companion;", "", "()V", "allowedActions", "", "", "allowedActionsWithActiveLookup", "asyncTypingKey", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "sessionId", "", "getInstance", "Lcom/jetbrains/rider/editorActions/ITypingSessions;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "project", "Lcom/intellij/openapi/project/Project;", "isAllowedActions", "", "actionId", "editor", "Lcom/intellij/openapi/editor/Editor;", "isEnabled", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nTypingSessions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypingSessions.kt\ncom/jetbrains/rider/editorActions/TypingSessions$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,427:1\n23#2:428\n*S KotlinDebug\n*F\n+ 1 TypingSessions.kt\ncom/jetbrains/rider/editorActions/TypingSessions$Companion\n*L\n61#1:428\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEnabled(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return this.isEnabled(FrontendSessionsUtilKt.getFrontendProjectSession(project2));
        }

        public final boolean isEnabled(@NotNull ClientProjectSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return this.isEnabled(session2.getAppSession());
        }

        public final boolean isEnabled(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return PatchEngineRegistryKt.isTypingSessionEnabled() && !CustomTypingSessionPolicy.Companion.forceDisableAsyncTyping(session2) && Registry.is((String)TypingSessions.asyncTypingKey);
        }

        @NotNull
        public final ITypingSessions getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project2));
        }

        @NotNull
        public final ITypingSessions getInstance(@NotNull ClientProjectSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(ITypingSessions.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (ITypingSessions)object;
        }

        @TestOnly
        public final boolean isAllowedActions(@NotNull String actionId, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return allowedActions.contains(actionId) || LookupManager.getActiveLookup((Editor)editor2) != null && allowedActionsWithActiveLookup.contains(actionId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

