/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rider.completion.AutoPopupFrontendSupportPolicy;
import com.jetbrains.rider.editorActions.FrontendTypedHandlerManager;
import com.jetbrains.rider.services.RiderDefaultBackend;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/editorActions/FrontendTypedHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "beforeSelectionRemoved", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "checkAutoPopup", "charTyped", "intellij.rider.rdclient.dotnet"})
public class FrontendTypedHandlerDelegate
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        IdeBackend ideBackend = IdeBackend.Companion.tryGetInstance(project2);
        RiderDefaultBackend riderDefaultBackend = ideBackend instanceof RiderDefaultBackend ? (RiderDefaultBackend)ideBackend : null;
        if (riderDefaultBackend == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        RiderDefaultBackend backend = riderDefaultBackend;
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        AutoPopupFrontendSupportPolicy policy = backend.getAutoPopupFrontendSupportPolicy(language);
        if (!policy.checkAutoPopup(charTyped, project2, editor2)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        TypedHandlerDelegate.Result result2 = super.checkAutoPopup(charTyped, project2, editor2, file2);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"checkAutoPopup(...)");
        return result2;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FrontendTypedHandlerManager frontendTypedHandlerManager = FrontendTypedHandlerManager.Companion.getInstance(project2);
        if (frontendTypedHandlerManager == null) {
            TypedHandlerDelegate.Result result2 = super.beforeSelectionRemoved(c, project2, editor2, file2);
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"beforeSelectionRemoved(...)");
            return result2;
        }
        FrontendTypedHandlerManager component = frontendTypedHandlerManager;
        return component.typeCharOnBackend(c, editor2, file2);
    }
}

