/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.CommandDescriptor;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdCommandProcessor;
import com.jetbrains.rd.ide.model.RdCommandProcessor_GeneratedKt;
import com.jetbrains.rd.ide.model.SelectionRange;
import com.jetbrains.rd.rdtext.ITypingSession;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rider.document.DocumentChangeModelConversion;
import com.jetbrains.rider.editorActions.UndoableEditorChange;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import com.jetbrains.rider.rdclient.languages.RiderBreakingWorkflowChangeInterceptor;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u0006\u0010\u0017\u001a\u00020\u0014J\b\u0010\u0018\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/editorActions/FairMergeStrategy;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentTypingSession", "Lcom/jetbrains/rd/rdtext/ITypingSession;", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "editorTypingSession", "Lcom/jetbrains/rd/ide/model/SelectionRange;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/client/ClientAppSession;Lcom/jetbrains/rd/rdtext/ITypingSession;Lcom/jetbrains/rd/rdtext/ITypingSession;)V", "localChanges", "", "localInitialSelection", "remoteChanges", "Lcom/jetbrains/rider/editorActions/UndoableEditorChange;", "fireAfterMerge", "", "fireBeforeMerge", "getOrCreateUndoableEditorChange", "merge", "revertLocalChanges", "intellij.rider.rdclient.dotnet"})
public final class FairMergeStrategy {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Editor editor;
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final List<UndoableEditorChange> remoteChanges;
    @NotNull
    private final List<RdTextChange> localChanges;
    @NotNull
    private final SelectionRange localInitialSelection;

    public FairMergeStrategy(@NotNull Lifetime lifetime2, @NotNull Editor editor2, @NotNull ClientAppSession session2, @NotNull ITypingSession<RdTextChange> documentTypingSession, @NotNull ITypingSession<SelectionRange> editorTypingSession) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter(documentTypingSession, (String)"documentTypingSession");
        Intrinsics.checkNotNullParameter(editorTypingSession, (String)"editorTypingSession");
        this.lifetime = lifetime2;
        this.editor = editor2;
        this.session = session2;
        this.remoteChanges = new ArrayList();
        this.localChanges = new ArrayList();
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        this.localInitialSelection = PlatformTextControlUtilsKt.createSelectionRange(caretModel);
        documentTypingSession.getOnRemoteChange().advise(this.lifetime, (Function1)new Function1<RdTextChange, Unit>(){

            public final void invoke(@NotNull RdTextChange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                UndoableEditorChange editorChange = this.getOrCreateUndoableEditorChange();
                editorChange.appendDocumentChange(it);
            }
        });
        documentTypingSession.getOnLocalChange().advise(this.lifetime, (Function1)new Function1<RdTextChange, Unit>(){

            public final void invoke(@NotNull RdTextChange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                localChanges.add(it);
            }
        });
        editorTypingSession.getOnRemoteChange().advise(this.lifetime, (Function1)new Function1<SelectionRange, Unit>(){

            public final void invoke(@NotNull SelectionRange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                UndoableEditorChange editorChange = this.getOrCreateUndoableEditorChange();
                editorChange.setLastSelection(it);
            }
        });
    }

    private final UndoableEditorChange getOrCreateUndoableEditorChange() {
        CommandDescriptor currentCommand;
        RLifetimeKt.assertAlive((Lifetime)this.lifetime);
        RdCommandProcessor commandProcessorModel = RdCommandProcessor_GeneratedKt.getRdCommandProcessor((DocumentsOperationModel)DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel((IProtocol)FrontendSessionsUtilKt.getProtocol(this.session)));
        CommandDescriptor commandDescriptor = currentCommand = (CommandDescriptor)commandProcessorModel.getCurrentCommand().getValue();
        String name = commandDescriptor != null ? commandDescriptor.getName() : null;
        UndoableEditorChange change = (UndoableEditorChange)CollectionsKt.lastOrNull(this.remoteChanges);
        if (change != null && Intrinsics.areEqual((Object)change.getUndoCommandName(), (Object)name)) {
            return change;
        }
        UndoableEditorChange newChange = new UndoableEditorChange(name);
        this.remoteChanges.add(newChange);
        return newChange;
    }

    public final void merge() {
        RLifetimeKt.assertAlive((Lifetime)this.lifetime);
        this.fireBeforeMerge();
        if (this.remoteChanges.isEmpty()) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> FairMergeStrategy.merge$lambda$0(this));
            return;
        }
        Project project2 = this.editor.getProject();
        Ref.BooleanRef isFirst = new Ref.BooleanRef();
        isFirst.element = true;
        for (UndoableEditorChange editorChange : this.remoteChanges) {
            Runnable doApply = () -> FairMergeStrategy.merge$lambda$1(this, isFirst, editorChange);
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(isFirst, doApply, project2, editorChange){
                final /* synthetic */ Ref.BooleanRef $isFirst;
                final /* synthetic */ Runnable $doApply;
                final /* synthetic */ Project $project;
                final /* synthetic */ UndoableEditorChange $editorChange;
                {
                    this.$isFirst = $isFirst;
                    this.$doApply = $doApply;
                    this.$project = $project;
                    this.$editorChange = $editorChange;
                    super(0);
                }

                public final void invoke() {
                    if (this.$isFirst.element) {
                        CommandProcessor.getInstance().runUndoTransparentAction(this.$doApply);
                    } else {
                        CommandProcessor.getInstance().executeCommand(this.$project, this.$doApply, this.$editorChange.getUndoCommandName(), null);
                    }
                }
            }));
        }
    }

    private final void fireBeforeMerge() {
        RiderBreakingWorkflowChangeInterceptor.Companion.beforeExpectedChange(this.editor);
    }

    private final void fireAfterMerge() {
        RiderBreakingWorkflowChangeInterceptor.Companion.afterExpectedChange(this.editor);
    }

    private final void revertLocalChanges() {
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        for (RdTextChange change : CollectionsKt.asReversedMutable(this.localChanges)) {
            DocumentChangeModelConversion.INSTANCE.applyModelChange(RdTextChangeKt.reverse((RdTextChange)change), document2, false);
        }
        PlatformTextControlUtilsKt.applyTo(this.localInitialSelection, this.editor);
    }

    private static final void merge$lambda$0(FairMergeStrategy this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this$0){
            final /* synthetic */ FairMergeStrategy this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                FairMergeStrategy.access$getEditor$p(this.this$0).putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, (Object)true);
                try {
                    FairMergeStrategy.access$revertLocalChanges(this.this$0);
                }
                finally {
                    FairMergeStrategy.access$getEditor$p(this.this$0).putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, null);
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void merge$lambda$1(FairMergeStrategy this$0, Ref.BooleanRef $isFirst, UndoableEditorChange $editorChange) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$isFirst, (String)"$isFirst");
        Intrinsics.checkNotNullParameter((Object)$editorChange, (String)"$editorChange");
        try {
            this$0.editor.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, (Object)true);
            Document document = this$0.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            if ($isFirst.element) {
                $isFirst.element = false;
                this$0.revertLocalChanges();
            }
            for (RdTextChange documentChange : $editorChange.getDocumentChanges()) {
                DocumentChangeModelConversion.INSTANCE.applyModelChange(documentChange, document2, false);
            }
        }
        finally {
            this$0.editor.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, null);
        }
        SelectionRange remoteSelection = $editorChange.getLastSelection();
        if (remoteSelection != null) {
            PlatformTextControlUtilsKt.applyTo(remoteSelection, this$0.editor);
        }
        EditorModificationUtil.scrollToCaret((Editor)this$0.editor);
        this$0.fireAfterMerge();
    }

    public static final /* synthetic */ Editor access$getEditor$p(FairMergeStrategy $this) {
        return $this.editor;
    }

    public static final /* synthetic */ void access$revertLocalChanges(FairMergeStrategy $this) {
        $this.revertLocalChanges();
    }
}

