/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.threading.SchedulerUtilKt;
import com.jetbrains.rider.document.RiderDocumentBindingService;
import com.jetbrains.rider.model.RdCreateDocumentIdRequest;
import com.jetbrains.rider.model.RdCreateDocumentIdResult;
import com.jetbrains.rider.model.RdFrontendDocumentId;
import com.jetbrains.rider.model.RdFrontendDocumentInfo;
import com.jetbrains.rider.model.RiderDocumentModel;
import com.jetbrains.rider.model.RiderDocumentModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 62\u00020\u0001:\u000267B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000eJ\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u001fJ5\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020!0 2\b\u0010\"\u001a\u0004\u0018\u00010\u00172\u0006\u0010#\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010$J\u001a\u0010%\u001a\u00020\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u00172\u0006\u0010#\u001a\u00020\rH\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u000eJ\u0015\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u000e\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020!H\u0002J\u0010\u0010,\u001a\u0004\u0018\u00010'2\u0006\u0010\u001a\u001a\u00020\u000eJ$\u0010-\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0/H\u0002J\u0016\u00100\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020'J\u001d\u00101\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u00102J\u0014\u00103\u001a\u00020!*\u00020!2\u0006\u0010#\u001a\u00020'H\u0002J\u001b\u00104\u001a\u00020!*\u00020!2\b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u00105R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/jetbrains/rider/document/RiderDocumentBindingService;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "locker", "", "model", "Lcom/jetbrains/rider/model/RiderDocumentModel;", "nextId", "", "pathToIdMap", "Ljava/util/HashMap;", "Ljava/nio/file/Path;", "Lcom/jetbrains/rider/model/RdFrontendDocumentId;", "Lkotlin/collections/HashMap;", "getProject", "()Lcom/intellij/openapi/project/Project;", "updateSignal", "Lcom/jetbrains/rd/util/reactive/Signal;", "getUpdateSignal", "()Lcom/jetbrains/rd/util/reactive/Signal;", "virtualFileToIdMap", "Lcom/intellij/openapi/vfs/VirtualFile;", "cleanup", "", "documentId", "create", "document", "Lcom/intellij/openapi/editor/Document;", "projectModelId", "(Lcom/intellij/openapi/editor/Document;Ljava/lang/Integer;)Lcom/jetbrains/rider/model/RdFrontendDocumentId;", "Lkotlin/Pair;", "Lcom/jetbrains/rider/model/RdFrontendDocumentInfo;", "virtualFile", "path", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/nio/file/Path;Ljava/lang/Integer;)Lkotlin/Pair;", "getFrontendDocumentIdUnderLock", "getPath", "", "getProjectModelId", "(Lcom/jetbrains/rider/model/RdFrontendDocumentId;)Ljava/lang/Integer;", "setInfoInProtocol", "info", "tryGetPath", "update", "changeAction", "Lkotlin/Function1;", "updatePath", "updateProjectModelId", "(Lcom/jetbrains/rider/model/RdFrontendDocumentId;Ljava/lang/Integer;)V", "withPath", "withProjectModelId", "(Lcom/jetbrains/rider/model/RdFrontendDocumentInfo;Ljava/lang/Integer;)Lcom/jetbrains/rider/model/RdFrontendDocumentInfo;", "Companion", "ProtocolListener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderDocumentBindingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDocumentBindingService.kt\ncom/jetbrains/rider/document/RiderDocumentBindingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,150:1\n1#2:151\n66#3,3:152\n13#4:155\n*S KotlinDebug\n*F\n+ 1 RiderDocumentBindingService.kt\ncom/jetbrains/rider/document/RiderDocumentBindingService\n*L\n60#1:152,3\n32#1:155\n*E\n"})
public final class RiderDocumentBindingService
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RiderDocumentModel model;
    @NotNull
    private final Object locker;
    @NotNull
    private final HashMap<VirtualFile, RdFrontendDocumentId> virtualFileToIdMap;
    @NotNull
    private final HashMap<Path, RdFrontendDocumentId> pathToIdMap;
    private int nextId;
    @NotNull
    private final Signal<RdFrontendDocumentId> updateSignal;
    @NotNull
    private static final Logger logger;

    public RiderDocumentBindingService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.model = RiderDocumentModel_PregeneratedKt.getRiderDocumentModel(SolutionHostExtensionsKt.getSolution(this.project));
        this.locker = new Object();
        this.virtualFileToIdMap = new HashMap();
        this.pathToIdMap = new HashMap();
        this.updateSignal = new Signal();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Signal<RdFrontendDocumentId> getUpdateSignal() {
        return this.updateSignal;
    }

    @Nullable
    public final RdFrontendDocumentId create(@NotNull Document document, @Nullable Integer projectModelId) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document);
        NewVirtualFile newVirtualFile = virtualFile2 instanceof NewVirtualFile ? (NewVirtualFile)virtualFile2 : null;
        if (newVirtualFile == null) {
            return null;
        }
        NewVirtualFile virtualFile3 = newVirtualFile;
        VirtualFile virtualFile4 = (VirtualFile)virtualFile3;
        Path path = virtualFile3.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        RdFrontendDocumentId documentId = (RdFrontendDocumentId)((Object)this.create(virtualFile4, path, projectModelId).component1());
        return documentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<RdFrontendDocumentId, RdFrontendDocumentInfo> create(VirtualFile virtualFile2, Path path, Integer projectModelId) {
        RdFrontendDocumentId rdFrontendDocumentId;
        Object object = this.locker;
        synchronized (object) {
            boolean bl = false;
            rdFrontendDocumentId = this.getFrontendDocumentIdUnderLock(virtualFile2, path);
        }
        RdFrontendDocumentId documentId = rdFrontendDocumentId;
        RdFrontendDocumentInfo documentInfo = new RdFrontendDocumentInfo(PathsKt.getInvariantSeparatorsPathString((Path)path), projectModelId);
        RdFrontendDocumentInfo protocolDocumentInfo = this.setInfoInProtocol(documentId, documentInfo);
        logger.trace("Create document info for " + documentId + " : " + documentInfo.getPath() + " [" + documentInfo.getProjectModelId() + "]");
        return new Pair((Object)documentId, (Object)protocolDocumentInfo);
    }

    private final RdFrontendDocumentId getFrontendDocumentIdUnderLock(VirtualFile virtualFile2, Path path) {
        if (virtualFile2 == null) {
            Map $this$getOrCreate$iv = this.pathToIdMap;
            boolean $i$f$getOrCreate = false;
            Object object = $this$getOrCreate$iv.get(path);
            if (object == null) {
                Path it = path;
                boolean bl = false;
                RdProjectId rdProjectId = ProjectUtilKt.getRdProjectId((Project)this.getProject());
                int n = this.nextId;
                this.nextId = n + 1;
                RdFrontendDocumentId it$iv = new RdFrontendDocumentId(rdProjectId, n);
                boolean bl2 = false;
                $this$getOrCreate$iv.put(path, it$iv);
                object = it$iv;
            }
            return (RdFrontendDocumentId)((Object)object);
        }
        RdFrontendDocumentId existingVirtualFileId = this.virtualFileToIdMap.get(virtualFile2);
        if (existingVirtualFileId != null) {
            return existingVirtualFileId;
        }
        RdFrontendDocumentId existingPathId = this.pathToIdMap.get(path);
        if (existingPathId != null) {
            ((Map)this.virtualFileToIdMap).put(virtualFile2, existingPathId);
            this.pathToIdMap.remove(path);
            return existingPathId;
        }
        int n = this.nextId;
        this.nextId = n + 1;
        RdFrontendDocumentId newVirtualFileId = new RdFrontendDocumentId(ProjectUtilKt.getRdProjectId((Project)this.project), n);
        ((Map)this.virtualFileToIdMap).put(virtualFile2, newVirtualFileId);
        return newVirtualFileId;
    }

    public final void cleanup(@NotNull RdFrontendDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        logger.trace("Cleanup document info for " + documentId);
        RdFrontendDocumentInfo existingInfo = (RdFrontendDocumentInfo)this.model.getDocumentInfo().remove((Object)documentId);
        if (existingInfo != null) {
            Path path = Paths.get(existingInfo.getPath(), new String[0]);
            this.pathToIdMap.remove(path);
            VirtualFile file2 = VfsUtil.findFile((Path)path, (boolean)false);
            if (file2 != null) {
                this.virtualFileToIdMap.remove(file2);
            }
        }
    }

    @NotNull
    public final String getPath(@NotNull RdFrontendDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        String string = this.tryGetPath(documentId);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Nullable
    public final String tryGetPath(@NotNull RdFrontendDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        RdFrontendDocumentInfo rdFrontendDocumentInfo = (RdFrontendDocumentInfo)this.model.getDocumentInfo().get((Object)documentId);
        return rdFrontendDocumentInfo != null ? rdFrontendDocumentInfo.getPath() : null;
    }

    public final void updatePath(@NotNull RdFrontendDocumentId documentId, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.update(documentId, (Function1<? super RdFrontendDocumentInfo, RdFrontendDocumentInfo>)((Function1)new Function1<RdFrontendDocumentInfo, RdFrontendDocumentInfo>(this, path){
            final /* synthetic */ RiderDocumentBindingService this$0;
            final /* synthetic */ String $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(1);
            }

            @NotNull
            public final RdFrontendDocumentInfo invoke(@NotNull RdFrontendDocumentInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return RiderDocumentBindingService.access$withPath(this.this$0, it, this.$path);
            }
        }));
    }

    @Nullable
    public final Integer getProjectModelId(@NotNull RdFrontendDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        RdFrontendDocumentInfo rdFrontendDocumentInfo = (RdFrontendDocumentInfo)this.model.getDocumentInfo().get((Object)documentId);
        return rdFrontendDocumentInfo != null ? rdFrontendDocumentInfo.getProjectModelId() : null;
    }

    public final void updateProjectModelId(@NotNull RdFrontendDocumentId documentId, @Nullable Integer projectModelId) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        this.update(documentId, (Function1<? super RdFrontendDocumentInfo, RdFrontendDocumentInfo>)((Function1)new Function1<RdFrontendDocumentInfo, RdFrontendDocumentInfo>(this, projectModelId){
            final /* synthetic */ RiderDocumentBindingService this$0;
            final /* synthetic */ Integer $projectModelId;
            {
                this.this$0 = $receiver;
                this.$projectModelId = $projectModelId;
                super(1);
            }

            @NotNull
            public final RdFrontendDocumentInfo invoke(@NotNull RdFrontendDocumentInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return RiderDocumentBindingService.access$withProjectModelId(this.this$0, it, this.$projectModelId);
            }
        }));
    }

    private final void update(RdFrontendDocumentId documentId, Function1<? super RdFrontendDocumentInfo, RdFrontendDocumentInfo> changeAction) {
        RdFrontendDocumentInfo existingInfo = (RdFrontendDocumentInfo)this.model.getDocumentInfo().get((Object)documentId);
        if (existingInfo != null) {
            this.setInfoInProtocol(documentId, (RdFrontendDocumentInfo)changeAction.invoke((Object)existingInfo));
            this.updateSignal.fire((Object)documentId);
        }
    }

    private final RdFrontendDocumentInfo setInfoInProtocol(RdFrontendDocumentId documentId, RdFrontendDocumentInfo info2) {
        RdFrontendDocumentInfo existingInfo = (RdFrontendDocumentInfo)this.model.getDocumentInfo().get((Object)documentId);
        if (existingInfo != null && Intrinsics.areEqual((Object)existingInfo.getPath(), (Object)info2.getPath())) {
            Integer n = info2.getProjectModelId();
            if (n != null && n == 0) {
                return existingInfo;
            }
        }
        logger.trace("Update document info for " + documentId + " : " + info2.getPath() + " [" + info2.getProjectModelId() + "]");
        ((Map)this.model.getDocumentInfo()).put(documentId, info2);
        return info2;
    }

    private final RdFrontendDocumentInfo withPath(RdFrontendDocumentInfo $this$withPath, String path) {
        return new RdFrontendDocumentInfo(path, $this$withPath.getProjectModelId());
    }

    private final RdFrontendDocumentInfo withProjectModelId(RdFrontendDocumentInfo $this$withProjectModelId, Integer projectModelId) {
        return new RdFrontendDocumentInfo($this$withProjectModelId.getPath(), projectModelId);
    }

    public static final /* synthetic */ RdFrontendDocumentInfo access$withPath(RiderDocumentBindingService $this, RdFrontendDocumentInfo $receiver, String path) {
        return $this.withPath($receiver, path);
    }

    public static final /* synthetic */ RdFrontendDocumentInfo access$withProjectModelId(RiderDocumentBindingService $this, RdFrontendDocumentInfo $receiver, Integer projectModelId) {
        return $this.withProjectModelId($receiver, projectModelId);
    }

    public static final /* synthetic */ Pair access$create(RiderDocumentBindingService $this, VirtualFile virtualFile2, Path path, Integer projectModelId) {
        return $this.create(virtualFile2, path, projectModelId);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderDocumentBindingService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderDocumentBindingService.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/document/RiderDocumentBindingService$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/document/RiderDocumentBindingService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderDocumentBindingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDocumentBindingService.kt\ncom/jetbrains/rider/document/RiderDocumentBindingService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,150:1\n31#2,2:151\n*S KotlinDebug\n*F\n+ 1 RiderDocumentBindingService.kt\ncom/jetbrains/rider/document/RiderDocumentBindingService$Companion\n*L\n31#1:151,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderDocumentBindingService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<RiderDocumentBindingService> serviceClass$iv = RiderDocumentBindingService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RiderDocumentBindingService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/document/RiderDocumentBindingService$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/RiderDocumentModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.rdclient.dotnet"})
    public static final class ProtocolListener
    implements SolutionExtListener<RiderDocumentModel> {
        public void extensionCreated(@NotNull Lifetime lifetime2, @NotNull ClientProjectSession session2, @NotNull RiderDocumentModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            model.getInitialize().set(null, SchedulerUtilKt.getAsRdScheduler((CoroutineDispatcher)Dispatchers.getIO()), (Function1)extensionCreated.1.INSTANCE);
            model.getCreateDocumentId().set(null, SchedulerUtilKt.getAsRdScheduler((CoroutineDispatcher)Dispatchers.getIO()), (Function1)new Function1<RdCreateDocumentIdRequest, RdCreateDocumentIdResult>(session2){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                @NotNull
                public final RdCreateDocumentIdResult invoke(@NotNull RdCreateDocumentIdRequest request2) {
                    Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                    Path path = Paths.get(request2.getPath(), new String[0]);
                    VirtualFile file2 = VfsUtil.findFile((Path)path, (boolean)false);
                    RiderDocumentBindingService riderDocumentBindingService = RiderDocumentBindingService.Companion.getInstance(this.$session.getProject());
                    Intrinsics.checkNotNull((Object)path);
                    Pair pair2 = RiderDocumentBindingService.access$create(riderDocumentBindingService, file2, path, request2.getProjectModelId());
                    RdFrontendDocumentId documentId = (RdFrontendDocumentId)((Object)pair2.component1());
                    RdFrontendDocumentInfo documentInfo = (RdFrontendDocumentInfo)pair2.component2();
                    return new RdCreateDocumentIdResult(documentId, documentInfo);
                }
            });
        }
    }
}

