/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagnostics;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.rider.model.RdMemoryUsageState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0003\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/diagnostics/RiderMemoryUsagePresenter;", "", "()V", "getDetailedText", "", "state", "Lcom/jetbrains/rider/model/RdMemoryUsageState;", "lineSeparator", "wrapInPre", "", "getStatusBarText", "memoryToStr", "memory", "", "intellij.rider.rdclient.dotnet"})
public final class RiderMemoryUsagePresenter {
    @NotNull
    public static final RiderMemoryUsagePresenter INSTANCE = new RiderMemoryUsagePresenter();

    private RiderMemoryUsagePresenter() {
    }

    @NlsSafe
    private final String memoryToStr(long memory) {
        return memory / (long)1024 / (long)1024 + "M";
    }

    @NlsSafe
    @NotNull
    public final String getStatusBarText(@NotNull RdMemoryUsageState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String allocatedManagedMemory = this.memoryToStr(state.getAllocatedManagedMemory());
        String workingSet = this.memoryToStr(state.getWorkingSet());
        return allocatedManagedMemory + " in " + workingSet;
    }

    @NlsSafe
    @NotNull
    public final String getDetailedText(@NotNull RdMemoryUsageState state, @NotNull String lineSeparator, boolean wrapInPre) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        StringBuilder $this$getDetailedText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (wrapInPre) {
            $this$getDetailedText_u24lambda_u240.append("<pre>");
        }
        RiderMemoryUsagePresenter.getDetailedText$lambda$0$addLine($this$getDetailedText_u24lambda_u240, lineSeparator, "*** Backend Memory Usage ***");
        RiderMemoryUsagePresenter.getDetailedText$lambda$0$addLine($this$getDetailedText_u24lambda_u240, lineSeparator, "Allocated managed memory : " + INSTANCE.memoryToStr(state.getAllocatedManagedMemory()));
        RiderMemoryUsagePresenter.getDetailedText$lambda$0$addLine($this$getDetailedText_u24lambda_u240, lineSeparator, "Working set              : " + INSTANCE.memoryToStr(state.getWorkingSet()));
        RiderMemoryUsagePresenter.getDetailedText$lambda$0$addLine($this$getDetailedText_u24lambda_u240, lineSeparator, "Private memory size      : " + INSTANCE.memoryToStr(state.getPrivateMemorySize()));
        RiderMemoryUsagePresenter.getDetailedText$lambda$0$addLine($this$getDetailedText_u24lambda_u240, lineSeparator, "Virtual memory size      : " + INSTANCE.memoryToStr(state.getVirtualMemorySize()));
        RiderMemoryUsagePresenter.getDetailedText$lambda$0$addLine($this$getDetailedText_u24lambda_u240, lineSeparator, "GC(0)   : " + state.getCollectionCount0());
        RiderMemoryUsagePresenter.getDetailedText$lambda$0$addLine($this$getDetailedText_u24lambda_u240, lineSeparator, "GC(1)   : " + state.getCollectionCount1());
        RiderMemoryUsagePresenter.getDetailedText$lambda$0$addLine($this$getDetailedText_u24lambda_u240, lineSeparator, "GC(2)   : " + state.getCollectionCount2());
        RiderMemoryUsagePresenter.getDetailedText$lambda$0$addLine($this$getDetailedText_u24lambda_u240, lineSeparator, "GC(LOH) : " + state.getCollectionCountLoh());
        if (wrapInPre) {
            $this$getDetailedText_u24lambda_u240.append("</pre>");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String getDetailedText$default(RiderMemoryUsagePresenter riderMemoryUsagePresenter, RdMemoryUsageState rdMemoryUsageState, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return riderMemoryUsagePresenter.getDetailedText(rdMemoryUsageState, string, bl);
    }

    private static final StringBuilder getDetailedText$lambda$0$addLine(StringBuilder $this_buildString, String $lineSeparator, String s) {
        return $this_buildString.append(s + $lineSeparator);
    }
}

