/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion.summaryInfo;

import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.impl.RdTaskKt;
import com.jetbrains.rd.ide.model.CompletionModel_GeneratedKt;
import com.jetbrains.rd.ide.model.CompletionTuple;
import com.jetbrains.rd.ide.model.LookupSummaryInfo;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.completion.ProtocolLookupItemBase;
import com.jetbrains.rdclient.completion.UtilsKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.completion.summaryInfo.ParameterInfoListView;
import com.jetbrains.rider.completion.summaryInfo.RiderLookupSummaryInfos;
import com.jetbrains.rider.completion.summaryInfo.SummaryInfoPositionAdjuster;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J@\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u0011H\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/completion/summaryInfo/RiderLookupSummaryInfosImpl;", "Lcom/jetbrains/rider/completion/summaryInfo/RiderLookupSummaryInfos;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "beginShowSummaryInfo", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lookupItem", "Lcom/jetbrains/rdclient/completion/ProtocolLookupItemBase;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "getSummaryInfo", "continueWith", "Lkotlin/Function3;", "Lcom/jetbrains/rd/ide/model/LookupSummaryInfo;", "showHint", "summaryInfo", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderLookupSummaryInfosImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderLookupSummaryInfosImpl.kt\ncom/jetbrains/rider/completion/summaryInfo/RiderLookupSummaryInfosImpl\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n13#2:128\n13#3:129\n*S KotlinDebug\n*F\n+ 1 RiderLookupSummaryInfosImpl.kt\ncom/jetbrains/rider/completion/summaryInfo/RiderLookupSummaryInfosImpl\n*L\n26#1:128\n26#1:129\n*E\n"})
public final class RiderLookupSummaryInfosImpl
implements RiderLookupSummaryInfos {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger LOG;
    private static final int MinTooltipWidth = 50;
    private static final int MinTooltipHeight = 20;

    public RiderLookupSummaryInfosImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderLookupSummaryInfos.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    @Override
    public void beginShowSummaryInfo(@NotNull Lifetime lifetime2, @NotNull ProtocolLookupItemBase lookupItem, @NotNull LookupImpl lookup) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)lookupItem), (String)"lookupItem");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        if (ApplicationKt.getApplication().isHeadlessEnvironment() || ApplicationKt.getApplication().isUnitTestMode()) {
            return;
        }
        LookupEx activeLookup = LookupManager.getInstance((Project)this.project).getActiveLookup();
        if (!Intrinsics.areEqual((Object)activeLookup, (Object)lookup)) {
            return;
        }
        this.getSummaryInfo(lifetime2, lookup, lookupItem, (Function3<? super Lifetime, ? super LookupSummaryInfo, ? super LookupImpl, Unit>)((Function3)new Function3<Lifetime, LookupSummaryInfo, LookupImpl, Unit>(this){
            final /* synthetic */ RiderLookupSummaryInfosImpl this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@NotNull Lifetime lt, @NotNull LookupSummaryInfo summaryInfo, @NotNull LookupImpl l) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                Intrinsics.checkNotNullParameter((Object)summaryInfo, (String)"summaryInfo");
                Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                RiderLookupSummaryInfosImpl.access$showHint(this.this$0, lt, summaryInfo, l);
            }
        }));
    }

    private final void getSummaryInfo(Lifetime lifetime2, LookupImpl lookup, ProtocolLookupItemBase lookupItem, Function3<? super Lifetime, ? super LookupSummaryInfo, ? super LookupImpl, Unit> continueWith) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        Editor editor2 = lookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        TextControlModel textControlModel = DocumentExKt.getTextControlModel(editor2);
        if (textControlModel == null || (textControlModel = CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel)) == null || (textControlModel = textControlModel.getCompletionSession()) == null || (textControlModel = (CompletionTuple)textControlModel.getValue()) == null || (textControlModel = textControlModel.getSession()) == null) {
            return;
        }
        TextControlModel completionSessionModel = textControlModel;
        LookupSummaryInfo summaryInfo = lookupItem.getSummaryInfo();
        if (summaryInfo == null) {
            int id = lookupItem.getCompletionItem().getId();
            RdTaskKt.startAndAdviseSuccess((IRdCall)((IRdCall)completionSessionModel.getGetSummaryInfoById()), (Lifetime)lifetime2, (Object)id, (Function1)((Function1)new Function1<LookupSummaryInfo, Unit>(lookupItem, this, lookup, continueWith, lifetime2){
                final /* synthetic */ ProtocolLookupItemBase $lookupItem;
                final /* synthetic */ RiderLookupSummaryInfosImpl this$0;
                final /* synthetic */ LookupImpl $lookup;
                final /* synthetic */ Function3<Lifetime, LookupSummaryInfo, LookupImpl, Unit> $continueWith;
                final /* synthetic */ Lifetime $lifetime;
                {
                    this.$lookupItem = $lookupItem;
                    this.this$0 = $receiver;
                    this.$lookup = $lookup;
                    this.$continueWith = $continueWith;
                    this.$lifetime = $lifetime;
                    super(1);
                }

                public final void invoke(@Nullable LookupSummaryInfo lookupSummaryInfo) {
                    LookupSummaryInfo lookupSummaryInfo2 = lookupSummaryInfo;
                    if (lookupSummaryInfo2 == null) {
                        return;
                    }
                    this.$lookupItem.setSummaryInfo(lookupSummaryInfo2);
                    LookupEx activeLookup = LookupManager.getInstance((Project)RiderLookupSummaryInfosImpl.access$getProject$p(this.this$0)).getActiveLookup();
                    if (!Intrinsics.areEqual((Object)activeLookup, (Object)this.$lookup)) {
                        RiderLookupSummaryInfosImpl.access$getLOG$p(this.this$0).trace("We got the summary info for inactive lookup. Skip.");
                        return;
                    }
                    ProtocolLookupItemBase activeLookupItem = UtilsKt.tryGetProtocolItem(activeLookup.getCurrentItem());
                    if (!Intrinsics.areEqual((Object)((Object)activeLookupItem), (Object)((Object)this.$lookupItem))) {
                        ProtocolLookupItemBase protocolLookupItemBase;
                        RiderLookupSummaryInfosImpl.access$getLOG$p(this.this$0).error("We got the summary info for unselected item. active: " + ((protocolLookupItemBase = activeLookupItem) != null && (protocolLookupItemBase = protocolLookupItemBase.getCompletionItem()) != null ? protocolLookupItemBase.getShortText() : null) + ", updated: " + this.$lookupItem.getCompletionItem().getShortText());
                        return;
                    }
                    if (!this.$lookupItem.isValid()) {
                        RiderLookupSummaryInfosImpl.access$getLOG$p(this.this$0).error("We got the summary info for invalid item.");
                        return;
                    }
                    this.$continueWith.invoke((Object)this.$lifetime, (Object)lookupSummaryInfo, (Object)this.$lookup);
                }
            }));
        } else {
            continueWith.invoke((Object)lifetime2, (Object)summaryInfo, (Object)lookup);
        }
    }

    private final void showHint(Lifetime lifetime2, LookupSummaryInfo summaryInfo, LookupImpl lookup) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (!lookup.getComponent().isShowing()) {
            return;
        }
        CompletionProcess completionProcess = CompletionService.getCompletionService().getCurrentCompletion();
        boolean isAutomatic = completionProcess != null ? completionProcess.isAutopopupCompletion() : false;
        Rectangle rectangle = lookup.getCurrentItemBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getCurrentItemBounds(...)");
        JComponent jComponent = lookup.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        SummaryInfoPositionAdjuster adjuster = new SummaryInfoPositionAdjuster(rectangle, jComponent, 5);
        Editor editor2 = lookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        ParameterInfoListView listView = new ParameterInfoListView(summaryInfo, editor2, lifetime2);
        JBPopup jBPopup = DocumentationManager.getInstance((Project)this.project).getDocInfoHint();
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        if (RLifetimeKt.isNotAlive((Lifetime)lifetime2)) {
            return;
        }
        JBPopup jBPopup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)listView), lookup.getComponent()).setMinSize((Dimension)JBUI.size((int)50, (int)20)).setCancelKeyEnabled(!isAutomatic).setResizable(false).setRequestFocus(false).setFocusable(false).setModalContext(false).setKeyEventHandler(arg_0 -> RiderLookupSummaryInfosImpl.showHint$lambda$0((Function1)new Function1<KeyEvent, Boolean>(lookup){
            final /* synthetic */ LookupImpl $lookup;
            {
                this.$lookup = $lookup;
                super(1);
            }

            @NotNull
            public final Boolean invoke(KeyEvent keyEvent) {
                boolean bl;
                if (keyEvent.getKeyCode() == 27) {
                    this.$lookup.hide();
                    bl = false;
                } else {
                    bl = false;
                }
                return bl;
            }
        }, arg_0)).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup2, (String)"createPopup(...)");
        JBPopup $this$showHint_u24lambda_u241 = jBPopup2;
        boolean bl = false;
        listView.setParent($this$showHint_u24lambda_u241);
        lifetime2.onTermination((Function0)new Function0<Unit>($this$showHint_u24lambda_u241){
            final /* synthetic */ JBPopup $this_apply;
            {
                this.$this_apply = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$this_apply.cancel();
            }
        });
        JBPopup popup2 = jBPopup2;
        PopupPositionManager.Position[] positionArray = new PopupPositionManager.Position[]{PopupPositionManager.Position.RIGHT, PopupPositionManager.Position.LEFT};
        Rectangle popupRectangle = adjuster.calculatePopupRectangle(popup2, positionArray);
        listView.setPreferredListSize(popupRectangle.getSize());
        listView.invalidate();
        listView.repaint();
        adjuster.adjust(popup2);
        SwingUtilities.invokeLater(() -> RiderLookupSummaryInfosImpl.showHint$lambda$2(popup2));
    }

    private static final boolean showHint$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void showHint$lambda$2(JBPopup $popup) {
        Intrinsics.checkNotNullParameter((Object)$popup, (String)"$popup");
        $popup.pack(false, true);
    }

    public static final /* synthetic */ void access$showHint(RiderLookupSummaryInfosImpl $this, Lifetime lifetime2, LookupSummaryInfo summaryInfo, LookupImpl lookup) {
        $this.showHint(lifetime2, summaryInfo, lookup);
    }

    public static final /* synthetic */ Project access$getProject$p(RiderLookupSummaryInfosImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ Logger access$getLOG$p(RiderLookupSummaryInfosImpl $this) {
        return $this.LOG;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/completion/summaryInfo/RiderLookupSummaryInfosImpl$Companion;", "", "()V", "MinTooltipHeight", "", "MinTooltipWidth", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

