/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.ide.completion.CompletionSessionMarkerKt;
import com.jetbrains.rd.ide.model.CompletionModel_GeneratedKt;
import com.jetbrains.rd.ide.model.CompletionSessionModel;
import com.jetbrains.rd.ide.model.CompletionTuple;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rdclient.util.idea.LifetimedProjectComponent;
import com.jetbrains.rider.completion.ClientCompletionSupport;
import com.jetbrains.rider.completion.CompletionSessionHeuristics;
import com.jetbrains.rider.completion.CompletionSessionState;
import com.jetbrains.rider.completion.CompletionSessionStrategy;
import com.jetbrains.rider.completion.CompletionStateData;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.FrontendCompletionHostKt;
import com.jetbrains.rider.completion.ModelUtilKt;
import com.jetbrains.rider.completion.MyEditorTypingListener;
import com.jetbrains.rider.completion.PreemptiveCompletionHost;
import com.jetbrains.rider.completion.UtilsKt;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u000fJ(\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J/\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0012\u0010#\u001a\u00020\u00152\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0012\u0010&\u001a\u00020\u00152\b\u0010'\u001a\u0004\u0018\u00010(H\u0014J,\u0010)\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(J\u0018\u0010+\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/completion/CompletionSessionHeuristics;", "Lcom/jetbrains/rdclient/util/idea/LifetimedProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "adviceTerminateIfNoResults", "", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getHideLookupOffset", "", "(Lcom/intellij/openapi/editor/Editor;)Ljava/lang/Integer;", "handleCaretChange", "offset", "newPosition", "oldPosition", "isCaretInLookupRange", "", "isCompletingSameIdentifier", "completionHost", "Lcom/jetbrains/rider/completion/FrontendCompletionHost;", "shouldRescheduleCompletion", "psiFile", "Lcom/intellij/psi/PsiFile;", "char", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Ljava/lang/Character;I)Z", "shouldRescheduleDefaultStrategy", "(Ljava/lang/Character;)Z", "shouldSaveWhenActiveSession", "shouldSaveWhenActiveSessionFor", "shouldTerminateOnEmptyPrefix", "language", "Lcom/intellij/lang/Language;", "shouldTerminateOnRemove", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "terminateCompletionSessionIfNeeded", "currentOffset", "tryScheduleCompletion", "reason", "", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nCompletionSessionHeuristics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/CompletionSessionHeuristics\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,406:1\n13#2:407\n13#3:408\n65#3,4:412\n65#3,4:416\n1747#4,3:409\n1726#4,3:420\n*S KotlinDebug\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/CompletionSessionHeuristics\n*L\n85#1:407\n85#1:408\n356#1:412,4\n359#1:416,4\n325#1:409,3\n386#1:420,3\n*E\n"})
public class CompletionSessionHeuristics
extends LifetimedProjectComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;

    public CompletionSessionHeuristics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CompletionSessionHeuristics.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        ApplicationKt.getApplication().invokeLater(() -> CompletionSessionHeuristics._init_$lambda$0(this, project2));
    }

    protected void adviceTerminateIfNoResults(@NotNull Lifetime textControlLifetime, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        TextControlModel textControlModel = DocumentExKt.getTextControlModel(editor2);
        if (textControlModel == null) {
            return;
        }
        TextControlModel textControlModel2 = textControlModel;
        CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2).getCompletionSession().view(textControlLifetime, (Function2)new Function2<Lifetime, CompletionTuple, Unit>(this, editor2, textControlModel2){
            final /* synthetic */ CompletionSessionHeuristics this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ TextControlModel $textControlModel;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$textControlModel = $textControlModel;
                super(2);
            }

            public final void invoke(@NotNull Lifetime completionSessionLifetime, @Nullable CompletionTuple completionTuple) {
                Intrinsics.checkNotNullParameter((Object)completionSessionLifetime, (String)"completionSessionLifetime");
                CompletionTuple completionTuple2 = completionTuple;
                if (completionTuple2 == null || (completionTuple2 = completionTuple2.getSession()) == null) {
                    return;
                }
                CompletionTuple session2 = completionTuple2;
                Logger $this$trace$iv = CompletionSessionHeuristics.access$getLogger$p(this.this$0);
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("ReleaseChangesIfNotUsedStrategy: viewing new completion session: " + completionTuple.getSession().hashCode());
                }
                SequentialLifetimes typingSeqLifetime = new SequentialLifetimes(completionSessionLifetime);
                DocumentListener typingWithinSessionListener2 = new DocumentListener(completionSessionLifetime, this.$editor, typingSeqLifetime, this.this$0, this.$textControlModel, (CompletionSessionModel)session2){
                    final /* synthetic */ Lifetime $completionSessionLifetime;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ SequentialLifetimes $typingSeqLifetime;
                    final /* synthetic */ CompletionSessionHeuristics this$0;
                    final /* synthetic */ TextControlModel $textControlModel;
                    final /* synthetic */ CompletionSessionModel $session;
                    {
                        this.$completionSessionLifetime = $completionSessionLifetime;
                        this.$editor = $editor;
                        this.$typingSeqLifetime = $typingSeqLifetime;
                        this.this$0 = $receiver;
                        this.$textControlModel = $textControlModel;
                        this.$session = $session;
                    }

                    public void documentChanged(@NotNull DocumentEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (!RLifetimeKt.isAlive((Lifetime)this.$completionSessionLifetime)) {
                            return;
                        }
                        TextControlId textControlId = DocumentExKt.getTextControlId(this.$editor);
                        if (!Intrinsics.areEqual((Object)(textControlId != null ? textControlId.getClientId() : null), (Object)ClientId.Companion.getCurrent().getValue())) {
                            return;
                        }
                        LifetimeDefinition currentTypingLifetime = this.$typingSeqLifetime.next();
                        CompletionStateData completionStateData2 = FrontendCompletionHostKt.getCompletionStateData(this.$editor);
                        completionStateData2.getState().advise((Lifetime)currentTypingLifetime, (Function1)new Function1<CompletionSessionState, Unit>(currentTypingLifetime, this.this$0, completionStateData2, this.$textControlModel, this.$session, this.$editor){
                            final /* synthetic */ LifetimeDefinition $currentTypingLifetime;
                            final /* synthetic */ CompletionSessionHeuristics this$0;
                            final /* synthetic */ CompletionStateData $completionStateData;
                            final /* synthetic */ TextControlModel $textControlModel;
                            final /* synthetic */ CompletionSessionModel $session;
                            final /* synthetic */ Editor $editor;
                            {
                                this.$currentTypingLifetime = $currentTypingLifetime;
                                this.this$0 = $receiver;
                                this.$completionStateData = $completionStateData;
                                this.$textControlModel = $textControlModel;
                                this.$session = $session;
                                this.$editor = $editor;
                                super(1);
                            }

                            public final void invoke(@NotNull CompletionSessionState completionSessionState) {
                                Intrinsics.checkNotNullParameter((Object)((Object)completionSessionState), (String)"completionSessionState");
                                if (completionSessionState.getOrder() < CompletionSessionState.Completed.getOrder()) {
                                    return;
                                }
                                ApplicationKt.getApplication().invokeLater(() -> adviceTerminateIfNoResults.typingWithinSessionListener.documentChanged.1.invoke$lambda$1(this.$currentTypingLifetime, this.this$0, this.$completionStateData, this.$textControlModel, this.$session, this.$editor));
                            }

                            private static final void invoke$lambda$1$lambda$0(LifetimeDefinition $currentTypingLifetime, CompletionSessionHeuristics this$0, CompletionStateData $completionStateData, TextControlModel $textControlModel, CompletionSessionModel $session, Editor $editor) {
                                Intrinsics.checkNotNullParameter((Object)$currentTypingLifetime, (String)"$currentTypingLifetime");
                                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                Intrinsics.checkNotNullParameter((Object)$completionStateData, (String)"$completionStateData");
                                Intrinsics.checkNotNullParameter((Object)$textControlModel, (String)"$textControlModel");
                                Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
                                Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
                                $currentTypingLifetime.executeIfAlive((Function0)new Function0<Unit>(this$0, $currentTypingLifetime, $completionStateData, $textControlModel, $session, $editor){
                                    final /* synthetic */ CompletionSessionHeuristics this$0;
                                    final /* synthetic */ LifetimeDefinition $currentTypingLifetime;
                                    final /* synthetic */ CompletionStateData $completionStateData;
                                    final /* synthetic */ TextControlModel $textControlModel;
                                    final /* synthetic */ CompletionSessionModel $session;
                                    final /* synthetic */ Editor $editor;
                                    {
                                        this.this$0 = $receiver;
                                        this.$currentTypingLifetime = $currentTypingLifetime;
                                        this.$completionStateData = $completionStateData;
                                        this.$textControlModel = $textControlModel;
                                        this.$session = $session;
                                        this.$editor = $editor;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        Logger $this$trace$iv = CompletionSessionHeuristics.access$getLogger$p(this.this$0);
                                        boolean $i$f$trace = false;
                                        if ($this$trace$iv.isTraceEnabled()) {
                                            Logger logger = $this$trace$iv;
                                            boolean bl = false;
                                            logger.trace("ReleaseChangesIfNotUsedStrategy: document has changed and is committed, completion is calculated, waiting for 1 sec...");
                                        }
                                        new Alarm(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)this.$currentTypingLifetime), null, (int)1, null)).addRequest(() -> adviceTerminateIfNoResults.typingWithinSessionListener.documentChanged.1.1.1.invoke$lambda$1(this.$completionStateData, this.$textControlModel, this.$session, this.this$0, this.$editor), 1000);
                                    }

                                    private static final void invoke$lambda$1(CompletionStateData $completionStateData, TextControlModel $textControlModel, CompletionSessionModel $session, CompletionSessionHeuristics this$0, Editor $editor) {
                                        Intrinsics.checkNotNullParameter((Object)$completionStateData, (String)"$completionStateData");
                                        Intrinsics.checkNotNullParameter((Object)$textControlModel, (String)"$textControlModel");
                                        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
                                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
                                        if ($completionStateData.getHasSession()) {
                                            CompletionTuple completionTuple = (CompletionTuple)CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)$textControlModel).getCompletionSession().getValue();
                                            if (Intrinsics.areEqual((Object)(completionTuple != null ? completionTuple.getSession() : null), (Object)$session) && LookupManagerImpl.getInstance((Project)this$0.getProject()).getActiveLookup() == null && CompletionServiceImpl.Companion.getCompletionService().getCurrentCompletion() == null && !CompletionSessionMarkerKt.isCompletionSessionExecuting((Editor)$editor)) {
                                                PreemptiveCompletionHost.Companion.getInstance(this$0.getProject()).terminateCurrentCompletion($editor, "All items are calculated and still no lookup is shown after 1 second");
                                            }
                                        }
                                    }
                                });
                            }

                            private static final void invoke$lambda$1(LifetimeDefinition $currentTypingLifetime, CompletionSessionHeuristics this$0, CompletionStateData $completionStateData, TextControlModel $textControlModel, CompletionSessionModel $session, Editor $editor) {
                                Intrinsics.checkNotNullParameter((Object)$currentTypingLifetime, (String)"$currentTypingLifetime");
                                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                Intrinsics.checkNotNullParameter((Object)$completionStateData, (String)"$completionStateData");
                                Intrinsics.checkNotNullParameter((Object)$textControlModel, (String)"$textControlModel");
                                Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
                                Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
                                if (!RLifetimeKt.isAlive((Lifetime)((Lifetime)$currentTypingLifetime))) {
                                    return;
                                }
                                PsiDocumentManager.getInstance((Project)this$0.getProject()).performWhenAllCommitted(() -> adviceTerminateIfNoResults.typingWithinSessionListener.documentChanged.1.invoke$lambda$1$lambda$0($currentTypingLifetime, this$0, $completionStateData, $textControlModel, $session, $editor));
                            }
                        });
                    }
                };
                this.$editor.getDocument().addDocumentListener(typingWithinSessionListener2, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)completionSessionLifetime, null, (int)1, null));
            }
        });
    }

    private final boolean shouldRescheduleCompletion(Editor editor2, PsiFile psiFile, Character c, int offset) {
        if (this.shouldSaveWhenActiveSession(editor2, offset)) {
            return false;
        }
        Document document = psiFile.getViewProvider().getDocument();
        if (document == null) {
            return false;
        }
        Document document2 = document;
        TextControlModel textControlModel = DocumentExKt.getTextControlModel(editor2);
        if (textControlModel != null) {
            String prefix = FrontendCompletionHost.getCompletionPrefix$default(PreemptiveCompletionHost.Companion.getInstance(this.getProject()), offset, document2, psiFile, ModelUtilKt.getCurrentOffsetSafe(textControlModel), null, false, 48, null);
            List list = CompletionSessionStrategy.Companion.getExtensions().allForLanguage(psiFile.getLanguage());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allForLanguage(...)");
            List strategies = list;
            for (CompletionSessionStrategy strategy2 : strategies) {
                try {
                    Boolean shouldRescheduleCompletion = strategy2.shouldRescheduleCompletion(prefix, psiFile, c, offset);
                    if (shouldRescheduleCompletion == null) continue;
                    return shouldRescheduleCompletion;
                }
                catch (Throwable throwable) {
                    this.logger.error("Error while calling shouldRescheduleCompletion API for '" + strategy2.getClass().getName() + "' for char '" + c + "' for offset '" + offset + "'");
                }
            }
        }
        return this.shouldRescheduleDefaultStrategy(c);
    }

    public boolean shouldRescheduleDefaultStrategy(@Nullable Character c) {
        return c == null || !Character.isLetterOrDigit(c.charValue());
    }

    public final void terminateCompletionSessionIfNeeded(@NotNull Editor editor2, int currentOffset, @Nullable Language language, @Nullable DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        boolean terminateOnEmptyPrefix = this.shouldTerminateOnEmptyPrefix(language);
        boolean terminateOnRemove = this.shouldTerminateOnRemove(event);
        FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.getInstanceOrNull(this.getProject());
        if (frontendCompletionHost == null) {
            return;
        }
        FrontendCompletionHost completionHost = frontendCompletionHost;
        Integer hideLookupOffset = this.getHideLookupOffset(editor2);
        if (hideLookupOffset != null) {
            if (currentOffset < hideLookupOffset || terminateOnRemove || terminateOnEmptyPrefix && currentOffset == hideLookupOffset) {
                completionHost.terminateCurrentCompletion(editor2, "Modification offset [" + currentOffset + "] < hideOffset [" + hideLookupOffset + "]");
            } else if (!this.isCompletingSameIdentifier(editor2, completionHost)) {
                completionHost.terminateCurrentCompletion(editor2, "Caret is moved outside identifier");
            }
        }
    }

    public static /* synthetic */ void terminateCompletionSessionIfNeeded$default(CompletionSessionHeuristics completionSessionHeuristics, Editor editor2, int n, Language language, DocumentEvent documentEvent, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: terminateCompletionSessionIfNeeded");
        }
        if ((n2 & 8) != 0) {
            documentEvent = null;
        }
        completionSessionHeuristics.terminateCompletionSessionIfNeeded(editor2, n, language, documentEvent);
    }

    private final boolean isCompletingSameIdentifier(Editor editor2, FrontendCompletionHost completionHost) {
        TextControlModel textControlModel = DocumentExKt.getTextControlModel(editor2);
        if (textControlModel == null) {
            return true;
        }
        TextControlModel textControlModel2 = textControlModel;
        CompletionTuple completionTuple = (CompletionTuple)CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2).getCompletionSession().getValue();
        if (completionTuple == null || (completionTuple = completionTuple.getParameters()) == null) {
            return true;
        }
        CompletionTuple parameters = completionTuple;
        PsiFile psiFile = PlatformTextControlUtilsKt.getPsiFile(editor2);
        if (psiFile == null) {
            return true;
        }
        PsiFile psiFile2 = psiFile;
        int prefixOffset = PlatformTextControlUtilsKt.getStartOffset(editor2);
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        String prefix = FrontendCompletionHost.getCompletionPrefix$default(completionHost, prefixOffset, document, psiFile2, ModelUtilKt.getCurrentOffsetSafe(textControlModel2), editor2, false, 32, null);
        String string = parameters.getPrefix();
        int completionStart = parameters.getOffset() - (string != null ? string.length() : 0);
        int identifierStart = prefixOffset - prefix.length();
        return identifierStart == completionStart;
    }

    protected boolean shouldTerminateOnRemove(@Nullable DocumentEvent event) {
        if (event == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)event.getNewFragment()).toString(), (Object)"") && Intrinsics.areEqual((Object)((Object)event.getOldFragment()).toString(), (Object)"\n");
    }

    private final boolean shouldTerminateOnEmptyPrefix(Language language) {
        boolean bl;
        block6: {
            if (language == null) {
                return false;
            }
            List list = CompletionSessionStrategy.Companion.getExtensions().allForLanguage(language);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allForLanguage(...)");
            List strategies = list;
            Iterable $this$any$iv = strategies;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    CompletionSessionStrategy it = (CompletionSessionStrategy)element$iv;
                    boolean bl3 = false;
                    try {
                        bl2 = it.shouldTerminateOnEmptyPrefix();
                    }
                    catch (Throwable throwable) {
                        this.logger.error("Error while calling shouldTerminateOnEmptyPrefix API for '" + it.getClass().getName() + "'");
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Integer getHideLookupOffset(Editor editor2) {
        TextControlModel textControlModel = DocumentExKt.getTextControlModel(editor2);
        if (textControlModel == null) {
            return null;
        }
        TextControlModel textControlModel2 = textControlModel;
        int hideLookupOffset = ModelUtilKt.getCurrentOffsetSafe(textControlModel2);
        if (hideLookupOffset < 0) {
            return null;
        }
        String string = ModelUtilKt.getCurrentSessionPrefix(textControlModel2);
        if (string == null) {
            string = "";
        }
        return hideLookupOffset - string.length();
    }

    private final void handleCaretChange(Editor editor2, int offset, int newPosition, int oldPosition) {
        Logger logger;
        Character c;
        if (!Intrinsics.areEqual((Object)editor2.getProject(), (Object)this.getProject())) {
            return;
        }
        TextControlId textControlId = DocumentExKt.getTextControlId(editor2);
        if (!Intrinsics.areEqual((Object)(textControlId != null ? textControlId.getClientId() : null), (Object)ClientId.Companion.getCurrent().getValue())) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(editor2.getDocument());
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        if (!ClientCompletionSupport.Companion.getInstance().preemptiveCompletionEnabled(psiFile2, offset)) {
            CompletionSessionHeuristics.terminateCompletionSessionIfNeeded$default(this, editor2, editor2.getCaretModel().getOffset(), DocumentUtilKt.getLanguage(editor2), null, 8, null);
            return;
        }
        if (newPosition - oldPosition == 1) {
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            c = DocumentExKt.getCharAt(document, oldPosition);
        } else {
            c = null;
        }
        Character typedChar = c;
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Viewing new caret change. Typed Char is '" + typedChar + "'");
        }
        if (this.shouldSaveWhenActiveSession(editor2, offset)) {
            $this$trace$iv = this.logger;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Caret " + offset + " was moved within the active frontend completion. Don't interrupt the session...");
            }
            return;
        }
        if (typedChar != null && !this.shouldRescheduleCompletion(editor2, psiFile2, typedChar, offset)) {
            this.logger.trace("Caret was moved due to the simple letter typing. Don't interrupt the session...");
            return;
        }
        this.tryScheduleCompletion(editor2, "New completion session is coming for offset " + offset + " and char " + typedChar + ".");
    }

    private final void tryScheduleCompletion(Editor editor2, String reason) {
        if (PowerSaveMode.isEnabled()) {
            this.logger.debug("skipping preemptive completion session, cause PowerSave mode is on");
            return;
        }
        PreemptiveCompletionHost.Companion.getInstance(this.getProject()).tryScheduleCompletion(editor2, reason);
    }

    private final boolean shouldSaveWhenActiveSessionFor(Editor editor2, int offset) {
        boolean bl;
        block4: {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(editor2.getDocument());
            if (psiFile == null) {
                return false;
            }
            PsiFile psiFile2 = psiFile;
            List list = CompletionSessionStrategy.Companion.getExtensions().allForLanguage(psiFile2.getLanguage());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allForLanguage(...)");
            List strategies = list;
            Iterable $this$all$iv = strategies;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CompletionSessionStrategy it = (CompletionSessionStrategy)element$iv;
                    boolean bl2 = false;
                    if (it.shouldSaveWhenActiveSession(editor2, psiFile2, offset)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean shouldSaveWhenActiveSession(Editor editor2, int offset) {
        return this.shouldSaveWhenActiveSessionFor(editor2, offset) && (CompletionSessionMarkerKt.isCompletionSessionExecuting((Editor)editor2) || CompletionServiceImpl.Companion.getCompletionService().getCurrentCompletion() != null && this.isCaretInLookupRange(offset));
    }

    private final boolean isCaretInLookupRange(int offset) {
        CompletionProgressIndicator completionProgressIndicator = CompletionServiceImpl.Companion.getCurrentCompletionProgressIndicator();
        if (completionProgressIndicator == null) {
            return false;
        }
        CompletionProgressIndicator currentCompletion = completionProgressIndicator;
        LookupImpl lookupImpl = currentCompletion.getLookup();
        Intrinsics.checkNotNullExpressionValue((Object)lookupImpl, (String)"getLookup(...)");
        LookupImpl lookup = lookupImpl;
        if (lookup.getLookupOriginalStart() < 0) {
            return false;
        }
        Editor editor2 = lookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Integer n = this.getHideLookupOffset(editor2);
        int lookupStart = n != null ? n.intValue() : lookup.getLookupStart();
        return lookupStart <= offset;
    }

    private static final void _init_$lambda$0(CompletionSessionHeuristics this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        if (!UtilsKt.isTypingSessionCompletionPreemptivenessEnabled()) {
            return;
        }
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
        EditorEventMulticaster eventMulticaster = editorEventMulticaster;
        CaretListener adapter2 = new CaretListener(this$0, $project){
            final /* synthetic */ CompletionSessionHeuristics this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void caretPositionChanged(@NotNull CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ApplicationKt.getApplication().assertIsDispatchThread();
                Editor editor2 = e.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                Editor editor3 = editor2;
                LogicalPosition logicalPosition = e.getNewPosition();
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getNewPosition(...)");
                LogicalPosition newPosition = logicalPosition;
                LogicalPosition logicalPosition2 = e.getOldPosition();
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition2, (String)"getOldPosition(...)");
                LogicalPosition oldPosition = logicalPosition2;
                Caret caret = e.getCaret();
                Intrinsics.checkNotNull((Object)caret);
                int eventOffset = caret.getOffset();
                CompletionSessionHeuristics.access$handleCaretChange(this.this$0, editor3, eventOffset, editor3.logicalPositionToOffset(newPosition), editor3.logicalPositionToOffset(oldPosition));
            }

            public void caretAdded(@NotNull CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.onAddRemove(e);
            }

            public void caretRemoved(@NotNull CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.onAddRemove(e);
            }

            private final void onAddRemove(CaretEvent e) {
                PreemptiveCompletionHost preemptiveCompletionHost = PreemptiveCompletionHost.Companion.getInstance(this.$project);
                Editor editor2 = e.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                preemptiveCompletionHost.tryScheduleCompletion(editor2, "onAddRemove caret event");
            }
        };
        SelectionListener selectionListener2 = new SelectionListener(this$0){
            final /* synthetic */ CompletionSessionHeuristics this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(@NotNull SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.selectionChanged(e);
                ApplicationKt.getApplication().assertIsDispatchThread();
                if (e.getOldRange().isEmpty()) {
                    return;
                }
                Editor editor2 = e.getEditor();
                int newPosition = e.getNewRange().getStartOffset();
                int oldPosition = e.getOldRange().getStartOffset();
                int eventOffset = newPosition;
                Intrinsics.checkNotNull((Object)editor2);
                CompletionSessionHeuristics.access$handleCaretChange(this.this$0, editor2, eventOffset, newPosition, oldPosition);
            }
        };
        DocumentListener documentListener2 = new DocumentListener($project, this$0){
            final /* synthetic */ Project $project;
            final /* synthetic */ CompletionSessionHeuristics this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Document document = event.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                if (DocumentExKt.getDocumentSynchronizer(document, this.$project) == null) {
                    return;
                }
                FileEditor fileEditor = FileEditorManager.getInstance((Project)this.$project).getSelectedEditor();
                TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                if (textEditor == null) {
                    return;
                }
                TextEditor selectedEditor = textEditor;
                Editor editor2 = selectedEditor.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                Editor editor3 = editor2;
                if (!Intrinsics.areEqual((Object)editor3.getDocument(), (Object)event.getDocument())) {
                    return;
                }
                TextControlId textControlId = DocumentExKt.getTextControlId(editor3);
                if (!Intrinsics.areEqual((Object)(textControlId != null ? textControlId.getClientId() : null), (Object)ClientId.Companion.getCurrent().getValue())) {
                    return;
                }
                if (CompletionSessionHeuristics.access$shouldSaveWhenActiveSession(this.this$0, editor3, event.getOffset())) {
                    return;
                }
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.$project).getPsiFile(event.getDocument());
                if (psiFile == null) {
                    return;
                }
                PsiFile psiFile2 = psiFile;
                if (event.getOldLength() == 1 && event.getNewLength() == 0) {
                    this.this$0.terminateCompletionSessionIfNeeded(editor3, event.getOffset(), psiFile2.getLanguage(), event);
                } else if (event.getOldLength() == 0 && event.getNewLength() == 1) {
                    CharSequence charSequence = event.getNewFragment();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                    if (CompletionSessionHeuristics.access$shouldRescheduleCompletion(this.this$0, editor3, psiFile2, Character.valueOf(StringsKt.single((CharSequence)charSequence)), event.getOffset())) {
                        CompletionSessionHeuristics.access$tryScheduleCompletion(this.this$0, editor3, "documentModel changed with param: " + event);
                    }
                } else {
                    CompletionSessionHeuristics.access$tryScheduleCompletion(this.this$0, editor3, "documentModel changed with param: " + event);
                }
            }

            public void beforeDocumentChange(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }
        };
        eventMulticaster.addSelectionListener(selectionListener2, (Disposable)this$0);
        eventMulticaster.addCaretListener(adapter2, (Disposable)this$0);
        eventMulticaster.addDocumentListener(documentListener2, (Disposable)this$0);
        MessageBusConnection messageBusConnection = $project.getMessageBus().connect();
        Topic topic = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new MyEditorTypingListener());
        Project myProject = this$0.getProject();
        ApplicationKt.getApplication().getMessageBus().connect((Disposable)myProject).subscribe(FrontendTextControlHostListener.Companion.getTOPIC(), (Object)new FrontendTextControlHostListener(myProject, this$0){
            final /* synthetic */ Project $myProject;
            final /* synthetic */ CompletionSessionHeuristics this$0;
            {
                this.$myProject = $myProject;
                this.this$0 = $receiver;
            }

            public void editorBound(@NotNull Lifetime lifetime2, @NotNull ClientAppSession appSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
                Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
                Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                if (!Intrinsics.areEqual((Object)editor2.getProject(), (Object)this.$myProject)) {
                    return;
                }
                this.this$0.adviceTerminateIfNoResults(lifetime2, editor2);
            }
        });
    }

    public static final /* synthetic */ Logger access$getLogger$p(CompletionSessionHeuristics $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$handleCaretChange(CompletionSessionHeuristics $this, Editor editor2, int offset, int newPosition, int oldPosition) {
        $this.handleCaretChange(editor2, offset, newPosition, oldPosition);
    }

    public static final /* synthetic */ boolean access$shouldSaveWhenActiveSession(CompletionSessionHeuristics $this, Editor editor2, int offset) {
        return $this.shouldSaveWhenActiveSession(editor2, offset);
    }

    public static final /* synthetic */ boolean access$shouldRescheduleCompletion(CompletionSessionHeuristics $this, Editor editor2, PsiFile psiFile, Character c, int offset) {
        return $this.shouldRescheduleCompletion(editor2, psiFile, c, offset);
    }

    public static final /* synthetic */ void access$tryScheduleCompletion(CompletionSessionHeuristics $this, Editor editor2, String reason) {
        $this.tryScheduleCompletion(editor2, reason);
    }

    static {
        CompletionProgressIndicator.setAutopopupTriggerTime((int)10);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/completion/CompletionSessionHeuristics$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/completion/CompletionSessionHeuristics;", "project", "Lcom/intellij/openapi/project/Project;", "tryGetInstance", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nCompletionSessionHeuristics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/CompletionSessionHeuristics$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n+ 3 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,406:1\n19#2,2:407\n13#3:409\n*S KotlinDebug\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/CompletionSessionHeuristics$Companion\n*L\n72#1:407,2\n76#1:409\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompletionSessionHeuristics getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$getComponent$iv = (ComponentManager)project2;
            boolean $i$f$getComponent = false;
            Object object = $this$getComponent$iv.getComponent(CompletionSessionHeuristics.class);
            if (object == null) {
                throw new IllegalStateException("Component " + CompletionSessionHeuristics.class + " not found in container " + $this$getComponent$iv);
            }
            return (CompletionSessionHeuristics)object;
        }

        @Nullable
        public final CompletionSessionHeuristics tryGetInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$tryGetComponent$iv = (ComponentManager)project2;
            boolean $i$f$tryGetComponent = false;
            return (CompletionSessionHeuristics)$this$tryGetComponent$iv.getComponent(CompletionSessionHeuristics.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

