/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.colorSchemes;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.jetbrains.rdclient.highlighting.FrontendHighlighterAttributeCustomizer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\"\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/colorSchemes/FrontendRainbowHighlighterCustomizer;", "Lcom/jetbrains/rdclient/highlighting/FrontendHighlighterAttributeCustomizer;", "()V", "RAINBOW_HIGHLIGHTER_NAME_PREFIX", "", "getRainbowAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "externalName", "getScheme", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getTextAttributesKey", "scheme", "attributeId", "intellij.rider.rdclient.dotnet"})
public final class FrontendRainbowHighlighterCustomizer
implements FrontendHighlighterAttributeCustomizer {
    @NotNull
    private final String RAINBOW_HIGHLIGHTER_NAME_PREFIX;

    public FrontendRainbowHighlighterCustomizer() {
        this.RAINBOW_HIGHLIGHTER_NAME_PREFIX = "ReSharper.RAINBOW_SHARP";
    }

    @Override
    @Nullable
    public TextAttributes getTextAttributes(@NotNull String externalName) {
        TextAttributes textAttributes;
        Intrinsics.checkNotNullParameter((Object)externalName, (String)"externalName");
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        TextAttributesKey textAttributesKey = this.getRainbowAttributesKey(externalName, () -> FrontendRainbowHighlighterCustomizer.getTextAttributes$lambda$0(scheme));
        if (textAttributesKey != null) {
            TextAttributesKey it = textAttributesKey;
            boolean bl = false;
            textAttributes = scheme.getAttributes(it);
        } else {
            textAttributes = null;
        }
        return textAttributes;
    }

    @Override
    @Nullable
    public TextAttributesKey getTextAttributesKey(@NotNull EditorColorsScheme scheme, @NotNull String externalName, @NotNull String attributeId) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)externalName, (String)"externalName");
        Intrinsics.checkNotNullParameter((Object)attributeId, (String)"attributeId");
        return this.getRainbowAttributesKey(externalName, () -> FrontendRainbowHighlighterCustomizer.getTextAttributesKey$lambda$2(scheme));
    }

    private final TextAttributesKey getRainbowAttributesKey(String externalName, Supplier<EditorColorsScheme> getScheme) {
        if (StringsKt.startsWith$default((String)externalName, (String)this.RAINBOW_HIGHLIGHTER_NAME_PREFIX, (boolean)false, (int)2, null)) {
            String string = externalName.substring(this.RAINBOW_HIGHLIGHTER_NAME_PREFIX.length(), externalName.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            int colorIndex = Integer.parseInt(string);
            return RainbowHighlighter.getRainbowAttrWithLazyCreation((TextAttributesScheme)((TextAttributesScheme)getScheme.get()), (int)colorIndex);
        }
        return null;
    }

    private static final EditorColorsScheme getTextAttributes$lambda$0(EditorColorsScheme $scheme) {
        Intrinsics.checkNotNullParameter((Object)$scheme, (String)"$scheme");
        return $scheme;
    }

    private static final EditorColorsScheme getTextAttributesKey$lambda$2(EditorColorsScheme $scheme) {
        Intrinsics.checkNotNullParameter((Object)$scheme, (String)"$scheme");
        return $scheme;
    }
}

