/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ApplicationKt;
import com.intellij.util.TimeoutUtil;
import com.intellij.xml.breadcrumbs.BreadcrumbsUtilEx;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.CrumbAction;
import com.jetbrains.rd.ide.model.CrumbModel;
import com.jetbrains.rd.ide.model.CrumbSession;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.ide.model.RiderProjectDocumentOperationModel_PregeneratedKt;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.threading.SpinWait;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.breadcrumbs.BreadCrumbAction;
import com.jetbrains.rider.breadcrumbs.CustomFileBreadcrumbExtensions;
import com.jetbrains.rider.breadcrumbs.RiderBreadcrumbsSupport;
import com.jetbrains.rider.projectView.SolutionLifecycleHost;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Action;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J5\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J.\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/breadcrumbs/RiderFileBreadcrumbsCollector;", "Lcom/intellij/codeInsight/breadcrumbs/FileBreadcrumbsCollector;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "timestamp", "Ljava/util/concurrent/atomic/AtomicInteger;", "checkCancelled", "", "computeCrumbs", "", "Lcom/intellij/ui/components/breadcrumbs/Crumb;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "forcedShown", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Document;ILjava/lang/Boolean;)Ljava/lang/Iterable;", "getCrumbsSynchronously", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "currentSessionTimestamp", "handlesFile", "watchForChanges", "file", "editor", "Lcom/intellij/openapi/editor/Editor;", "disposable", "Lcom/intellij/openapi/Disposable;", "changesHandler", "Ljava/lang/Runnable;", "RdCrumb", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderFileBreadcrumbsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFileBreadcrumbsCollector.kt\ncom/jetbrains/rider/breadcrumbs/RiderFileBreadcrumbsCollector\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 SpinWait.kt\ncom/jetbrains/rd/util/threading/SpinWait$Companion\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n13#2:216\n13#3:217\n58#3,5:225\n23#4,7:218\n30#4,9:230\n1549#5:239\n1620#5,3:240\n1549#5:243\n1620#5,3:244\n*S KotlinDebug\n*F\n+ 1 RiderFileBreadcrumbsCollector.kt\ncom/jetbrains/rider/breadcrumbs/RiderFileBreadcrumbsCollector\n*L\n59#1:216\n59#1:217\n124#1:225,5\n114#1:218,7\n114#1:230,9\n137#1:239\n137#1:240,3\n165#1:243\n165#1:244,3\n*E\n"})
public final class RiderFileBreadcrumbsCollector
extends FileBreadcrumbsCollector {
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicInteger timestamp;
    @NotNull
    private final Logger logger;

    public RiderFileBreadcrumbsCollector(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.timestamp = new AtomicInteger(0);
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderFileBreadcrumbsCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void watchForChanges(@NotNull VirtualFile file2, @NotNull Editor editor2, @NotNull Disposable disposable, @NotNull Runnable changesHandler) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)changesHandler, (String)"changesHandler");
        if (editor2.getProject() == null) {
            return;
        }
        Lifetime listenerLifetime = LifetimeDisposableExKt.createLifetime((Disposable)disposable);
        ApplicationKt.getApplication().invokeLater(() -> RiderFileBreadcrumbsCollector.watchForChanges$lambda$0(editor2, listenerLifetime, changesHandler));
    }

    public boolean handlesFile(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        if (!EditorSettingsExternalizable.getInstance().isBreadcrumbsShown()) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(virtualFile2);
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        boolean handlesFile = BreadcrumbsUtilEx.isBreadcrumbsShownFor((Language)psiFile2.getLanguage()) && RiderBreadcrumbsSupport.INSTANCE.isAvailable(psiFile2);
        this.logger.debug("backend breadcrumbs support handles file = " + handlesFile);
        return handlesFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<Crumb> computeCrumbs(@NotNull VirtualFile virtualFile2, @NotNull Document document, int offset, @Nullable Boolean forcedShown) {
        void $this$mapTo$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.logger.debug("start computing crumbs for the file " + virtualFile2 + " and offset " + offset + " (thread: " + Thread.currentThread().getId() + ":" + Thread.currentThread().getName() + ")");
        if (!((Boolean)SolutionLifecycleHost.Companion.getInstance(this.project).isBackendLoaded().getValue()).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        int currentSessionTimestamp = this.timestamp.incrementAndGet();
        DocumentSynchronizer documentSynchronizer2 = DocumentExKt.getDocumentSynchronizer(document, this.project);
        if (documentSynchronizer2 == null || (documentSynchronizer2 = documentSynchronizer2.getModelDocument()) == null) {
            return CollectionsKt.emptyList();
        }
        DocumentSynchronizer rdDocument = documentSynchronizer2;
        if (ApplicationKt.getApplication().isDispatchThread()) {
            long startNanoTime = System.nanoTime();
            Iterable<Crumb> crumbs = this.getCrumbsSynchronously(this.project, (RdDocumentModel)rdDocument, currentSessionTimestamp, offset);
            long durationMs = TimeoutUtil.getDurationMillis((long)startNanoTime);
            this.logger.debug("getCrumbsSynchronously took " + durationMs + "ms");
            return crumbs;
        }
        List backendResult = new ArrayList();
        ApplicationManager.getApplication().invokeLater(() -> RiderFileBreadcrumbsCollector.computeCrumbs$lambda$1(this, (RdDocumentModel)rdDocument, offset, currentSessionTimestamp));
        long fullTimeout = 5000L;
        long startNanoTime = System.nanoTime();
        SpinWait.Companion companion = SpinWait.Companion;
        Lifetime lifetime$iv = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project));
        boolean $i$f$spinUntil = false;
        void var15_18 = this_$iv;
        Duration duration = Duration.ofMillis(fullTimeout);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(timeoutMs)");
        Duration duration$iv$iv = duration;
        int $i$f$spinUntil232 = 0;
        long start$iv$iv = System.nanoTime();
        long spins$iv$iv = 0L;
        while (true) {
            CrumbSession session2;
            boolean bl;
            boolean bl2 = false;
            if (this.timestamp.get() > currentSessionTimestamp) {
                throw new ProcessCanceledException();
            }
            this.checkCancelled();
            if ((CrumbSession)com.jetbrains.rd.ide.document.DocumentExKt.getCrumbsSession((RdDocumentModel)rdDocument).getValue() == null) {
                bl = false;
            } else if (InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)session2.getCrumbs())) && session2.getTimestamp() == currentSessionTimestamp) {
                backendResult.addAll((Collection)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)session2.getCrumbs())));
                Logger $this$debug_u24default$iv = this.logger;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl3 = false;
                    logger.debug("Have gotten crumbs from the backend: " + backendResult, e$iv);
                }
                bl = true;
            } else {
                bl = false;
            }
            if (bl || !RLifetimeKt.isAlive((Lifetime)lifetime$iv) || System.nanoTime() - start$iv$iv > duration$iv$iv.toNanos()) break;
            long l = spins$iv$iv;
            spins$iv$iv = l + 1L;
            if (l < 100L) {
                Thread.yield();
                continue;
            }
            Thread.sleep(spins$iv$iv / (long)100);
        }
        long durationMs = TimeoutUtil.getDurationMillis((long)startNanoTime);
        this.logger.debug("SpinWait.spinUntil took " + durationMs + "ms");
        List result2 = new ArrayList();
        for (CustomFileBreadcrumbExtensions ext : (CustomFileBreadcrumbExtensions[])CustomFileBreadcrumbExtensions.Companion.getEP_NAME().getExtensions()) {
            result2.addAll((Collection)ext.createCustomCrumbs(this.project, document));
        }
        Iterable iterable = backendResult;
        List list = result2;
        boolean $i$f$map = false;
        Iterable $i$f$spinUntil232 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CrumbModel bl2 = (CrumbModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IconModel iconModel = it.getIcon();
            collection.add(new RdCrumb((CrumbModel)it, iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null, this.project));
        }
        list.addAll((List)destination$iv$iv);
        return result2;
    }

    private final void checkCancelled() {
        ProgressManager.checkCanceled();
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<Crumb> getCrumbsSynchronously(Project project2, RdDocumentModel documentModel, int currentSessionTimestamp, int offset) {
        void $this$mapTo$iv$iv;
        com.jetbrains.rd.ide.document.DocumentExKt.getCrumbsSession((RdDocumentModel)documentModel).set((Object)new CrumbSession(offset, currentSessionTimestamp));
        IRdDispatcher dispatcher = IRdDispatcherKt.getAsRdDispatcher((IScheduler)ApplicationProtocolKt.getProtocol(project2).getScheduler());
        Ref.ObjectRef backendResult = new Ref.ObjectRef();
        backendResult.element = CollectionsKt.emptyList();
        IRdDispatcherKt.pumpProtocolQueue((IRdDispatcher)dispatcher, (long)3000L, (Function0)((Function0)new Function0<Boolean>(documentModel, currentSessionTimestamp, (Ref.ObjectRef<List<CrumbModel>>)backendResult){
            final /* synthetic */ RdDocumentModel $documentModel;
            final /* synthetic */ int $currentSessionTimestamp;
            final /* synthetic */ Ref.ObjectRef<List<CrumbModel>> $backendResult;
            {
                this.$documentModel = $documentModel;
                this.$currentSessionTimestamp = $currentSessionTimestamp;
                this.$backendResult = $backendResult;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                CrumbSession crumbSession = (CrumbSession)com.jetbrains.rd.ide.document.DocumentExKt.getCrumbsSession((RdDocumentModel)this.$documentModel).getValue();
                if (crumbSession == null) {
                    return true;
                }
                CrumbSession session2 = crumbSession;
                if (InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)session2.getCrumbs())) && session2.getTimestamp() == this.$currentSessionTimestamp) {
                    this.$backendResult.element = InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)session2.getCrumbs()));
                    return false;
                }
                return true;
            }
        }));
        Iterable $this$map$iv = (Iterable)backendResult.element;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CrumbModel crumbModel = (CrumbModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IconModel iconModel = it.getIcon();
            collection.add(new RdCrumb((CrumbModel)it, iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null, project2));
        }
        return (List)destination$iv$iv;
    }

    private static final void watchForChanges$lambda$0(Editor $editor, Lifetime $listenerLifetime, Runnable $changesHandler) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$listenerLifetime, (String)"$listenerLifetime");
        Intrinsics.checkNotNullParameter((Object)$changesHandler, (String)"$changesHandler");
        Project project2 = $editor.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        SolutionLifecycleHost.Companion.getInstance(project3).isBackendLoaded().getChange().advise($listenerLifetime, (Function1)new Function1<Boolean, Unit>($changesHandler){
            final /* synthetic */ Runnable $changesHandler;
            {
                this.$changesHandler = $changesHandler;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$changesHandler.run();
            }
        });
        IProperty<String> transaction = RiderProjectDocumentOperationModel_PregeneratedKt.getRiderProjectDocumentOperationModel(FrontendSessionsUtilKt.getProtocolModel(FrontendSessionsUtilKt.getFrontendProjectSession(project3))).getCommittingTransaction();
        transaction.getChange().advise($listenerLifetime, (Function1)new Function1<String, Unit>($changesHandler){
            final /* synthetic */ Runnable $changesHandler;
            {
                this.$changesHandler = $changesHandler;
                super(1);
            }

            public final void invoke(@Nullable String it) {
                this.$changesHandler.run();
            }
        });
    }

    private static final void computeCrumbs$lambda$1(RiderFileBreadcrumbsCollector this$0, RdDocumentModel $rdDocument, int $offset, int $currentSessionTimestamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$rdDocument, (String)"$rdDocument");
        if (this$0.project.isDisposed() || !$rdDocument.isBound()) {
            return;
        }
        com.jetbrains.rd.ide.document.DocumentExKt.getCrumbsSession((RdDocumentModel)$rdDocument).set((Object)new CrumbSession($offset, $currentSessionTimestamp));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/breadcrumbs/RiderFileBreadcrumbsCollector$RdCrumb;", "Lcom/intellij/xml/breadcrumbs/NavigatableCrumb;", "crumbModel", "Lcom/jetbrains/rd/ide/model/CrumbModel;", "icon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/rd/ide/model/CrumbModel;Ljavax/swing/Icon;Lcom/intellij/openapi/project/Project;)V", "getContextActions", "", "Ljavax/swing/Action;", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "getIcon", "getText", "", "getTooltip", "navigate", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "withSelection", "", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderFileBreadcrumbsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFileBreadcrumbsCollector.kt\ncom/jetbrains/rider/breadcrumbs/RiderFileBreadcrumbsCollector$RdCrumb\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1#2:216\n1549#3:217\n1620#3,3:218\n*S KotlinDebug\n*F\n+ 1 RiderFileBreadcrumbsCollector.kt\ncom/jetbrains/rider/breadcrumbs/RiderFileBreadcrumbsCollector$RdCrumb\n*L\n182#1:217\n182#1:218,3\n*E\n"})
    public static final class RdCrumb
    implements NavigatableCrumb {
        @NotNull
        private final CrumbModel crumbModel;
        @Nullable
        private final Icon icon;
        @NotNull
        private final Project project;

        public RdCrumb(@NotNull CrumbModel crumbModel, @Nullable Icon icon, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)crumbModel, (String)"crumbModel");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.crumbModel = crumbModel;
            this.icon = icon;
            this.project = project2;
        }

        public void navigate(@NotNull Editor editor2, boolean withSelection) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.crumbModel.getNavigate().start(ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), (Object)withSelection);
        }

        @Nullable
        public TextRange getHighlightRange() {
            TextRange textRange;
            RdTextRange rdTextRange = this.crumbModel.getTextRange();
            if (rdTextRange != null) {
                RdTextRange $this$getHighlightRange_u24lambda_u240 = rdTextRange;
                boolean bl = false;
                textRange = new TextRange($this$getHighlightRange_u24lambda_u240.getStartOffset(), $this$getHighlightRange_u24lambda_u240.getEndOffset());
            } else {
                textRange = null;
            }
            return textRange;
        }

        @NotNull
        public String getText() {
            return this.crumbModel.getText();
        }

        @Nullable
        public String getTooltip() {
            return this.crumbModel.getTooltip();
        }

        @Nullable
        public Icon getIcon() {
            return this.icon;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<? extends Action> getContextActions() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.crumbModel.getActions();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void action2;
                CrumbAction crumbAction = (CrumbAction)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new BreadCrumbAction((CrumbAction)action2, this.project));
            }
            return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }
    }
}

