/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.actions.impl.cleanup;

import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.actions.impl.cleanup.RiderCodeCleanupCallStrategy;
import com.jetbrains.rider.actions.impl.cleanup.RiderCodeCleanupSupportKt;
import com.jetbrains.rider.actions.impl.cleanup.RiderCodeCleanupSupportPolicy;
import com.jetbrains.rider.platform.ProtocolLanguageFeatureProvider;
import com.jetbrains.rider.platform.SinglePerLanguageExtension;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/actions/impl/cleanup/RiderCodeCleanupSupport;", "Lcom/jetbrains/rider/platform/ProtocolLanguageFeatureProvider;", "()V", "extensions", "Lcom/jetbrains/rider/platform/SinglePerLanguageExtension;", "Lcom/jetbrains/rider/actions/impl/cleanup/RiderCodeCleanupSupportPolicy;", "forLanguage", "kotlin.jvm.PlatformType", "language", "Lcom/intellij/lang/Language;", "getSupportPolicy", "Lcom/jetbrains/rider/actions/impl/cleanup/RiderCodeCleanupCallStrategy;", "element", "Lcom/intellij/psi/PsiElement;", "hasBackendParts", "", "file", "Lcom/intellij/psi/PsiFile;", "hasFrontendParts", "isAvailable", "intellij.rider.rdclient.dotnet"})
public final class RiderCodeCleanupSupport
implements ProtocolLanguageFeatureProvider {
    @NotNull
    public static final RiderCodeCleanupSupport INSTANCE = new RiderCodeCleanupSupport();
    @NotNull
    private static final SinglePerLanguageExtension<RiderCodeCleanupSupportPolicy> extensions = new SinglePerLanguageExtension("com.intellij.code.cleanup.support");

    private RiderCodeCleanupSupport() {
    }

    @JvmStatic
    public static final RiderCodeCleanupSupportPolicy forLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return (RiderCodeCleanupSupportPolicy)extensions.findSingle(language);
    }

    @NotNull
    public final RiderCodeCleanupCallStrategy getSupportPolicy(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Object object = RiderCodeCleanupSupport.forLanguage(language);
        if (object == null || (object = object.getPolicy()) == null) {
            object = RiderCodeCleanupCallStrategy.FRONTEND_ONLY;
        }
        return object;
    }

    @NotNull
    public final RiderCodeCleanupCallStrategy getSupportPolicy(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return RiderCodeCleanupCallStrategy.FRONTEND_ONLY;
        }
        PsiFile psiFile2 = psiFile;
        boolean bl = psiFile2.isValid();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Language language = psiFile2.getViewProvider().getBaseLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getBaseLanguage(...)");
        Language baseLanguage = language;
        return this.getSupportPolicy(baseLanguage);
    }

    public final boolean hasBackendParts(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return RiderCodeCleanupSupportKt.isBackendInvolved(this.getSupportPolicy(language));
    }

    public final boolean hasFrontendParts(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return RiderCodeCleanupSupportKt.isFrontendInvolved(this.getSupportPolicy(language));
    }

    @Override
    public boolean isAvailable(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.hasBackendParts(file2);
    }
}

