/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.AssemblyExecutionContext;
import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.NetCoreUtil;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.clrmd.ClrProcessThreadDumpUtilKt;
import com.jetbrains.rider.clrmd.CollectThreadDumpRequest;
import com.jetbrains.rider.clrmd.ThreadDumpResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020<2\u0006\u0010=\u001a\u00020>J\u0016\u0010@\u001a\u00020<2\u0006\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dJ'\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u00142\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140I\"\u00020\u0014\u00a2\u0006\u0002\u0010JJ'\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140I\"\u00020\u0014\u00a2\u0006\u0002\u0010OJ\u0018\u0010P\u001a\u00020!2\u0006\u0010Q\u001a\u00020\u00102\u0006\u0010R\u001a\u00020!H\u0002J/\u0010S\u001a\u00020L2\u0006\u0010T\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140I\"\u00020\u0014\u00a2\u0006\u0002\u0010UJ\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dJ\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dJ\u0006\u0010X\u001a\u00020\u0010J2\u0010Y\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020\u00142\b\b\u0002\u0010R\u001a\u00020!2\u000e\b\u0002\u0010[\u001a\b\u0012\u0002\b\u0003\u0018\u00010\\2\b\b\u0002\u0010]\u001a\u00020!J*\u0010^\u001a\u0004\u0018\u00010\u00102\u0006\u0010Z\u001a\u00020\u00142\b\b\u0002\u0010R\u001a\u00020!2\u000e\b\u0002\u0010[\u001a\b\u0012\u0002\b\u0003\u0018\u00010\\J(\u0010_\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020\u00142\b\b\u0002\u0010R\u001a\u00020!2\u000e\b\u0002\u0010[\u001a\b\u0012\u0002\b\u0003\u0018\u00010\\J\u0016\u0010`\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020\u00142\u0006\u0010a\u001a\u00020\u0014J\u0011\u0010b\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\u001dJ\u000e\u0010c\u001a\u00020!2\u0006\u0010A\u001a\u00020\u0005J\u000e\u0010d\u001a\u00020!2\u0006\u0010A\u001a\u00020\u0005J0\u0010e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010g0f2\u0006\u0010h\u001a\u00020i2\n\b\u0002\u0010j\u001a\u0004\u0018\u00010\u0010H\u0086@\u00a2\u0006\u0002\u0010kJ(\u0010l\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010g0f2\u0006\u0010h\u001a\u00020i2\n\b\u0002\u0010j\u001a\u0004\u0018\u00010\u0010J\u0006\u0010m\u001a\u00020<J\"\u0010n\u001a\u0004\u0018\u00010\u00102\u0006\u0010o\u001a\u00020\u00142\u0006\u0010Z\u001a\u00020\u00142\u0006\u0010R\u001a\u00020!H\u0002R4\u0010\u0003\u001a(\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006 \b*\u0012\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\"R\u0011\u0010#\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R\u0011\u0010$\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0019R\u0011\u0010'\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0012R\u000e\u0010)\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010*\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u000e\u001a\u0004\b+\u0010\u0012R\u001b\u0010-\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u000e\u001a\u0004\b.\u0010\u0012R\u001b\u00100\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u000e\u001a\u0004\b1\u0010\u0012R\u001b\u00103\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u000e\u001a\u0004\b4\u0010\u0012R\u0011\u00106\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0019R\u000e\u00108\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R4\u00109\u001a(\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006 \b*\u0012\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006p"}, d2={"Lcom/jetbrains/rider/RiderEnvironment;", "", "()V", "backendHostProcesses", "", "", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "backendLogXmlPath", "Ljava/nio/file/Path;", "getBackendLogXmlPath", "()Ljava/nio/file/Path;", "backendLogXmlPath$delegate", "Lkotlin/Lazy;", "backendThreadDumpDir", "Ljava/io/File;", "getBackendThreadDumpDir", "()Ljava/io/File;", "clrHostExecutableName", "", "clrLauncherExecutableName", "clrLauncherNiExecutableName", "customHostBinDirectory", "getCustomHostBinDirectory", "()Ljava/lang/String;", "setCustomHostBinDirectory", "(Ljava/lang/String;)V", "customizedLoggers", "", "Lcom/intellij/openapi/diagnostic/Logger;", "hostBinEnvironmentVariable", "isNotUnderTeamCity", "", "()Z", "isRiderForDebug", "isUnderTeamCity", "logBackendConf", "getLogBackendConf", "logDirectory", "getLogDirectory", "logger", "originalRiderBackendBinDir", "getOriginalRiderBackendBinDir", "originalRiderBackendBinDir$delegate", "originalRiderBackendNetFrameworkExecutable", "getOriginalRiderBackendNetFrameworkExecutable", "originalRiderBackendNetFrameworkExecutable$delegate", "riderBackendDirectory", "getRiderBackendDirectory", "riderBackendDirectory$delegate", "riderBackendExecutable", "getRiderBackendExecutable", "riderBackendExecutable$delegate", "riderBackendExecutableName", "getRiderBackendExecutableName", "riderBackendName", "riderProcesses", "traceEnvVar", "addRiderAuxiliaryProcess", "", "processHandler", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "addRiderBackendProcess", "addRiderProcess", "pid", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "applyEnvTraceCategories", "createProcessBuilderForAssembly", "Ljava/lang/ProcessBuilder;", "assemblyFullPath", "params", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/ProcessBuilder;", "createRunCmdForLauncherInfo", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "launcherInfo", "Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "(Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "fileExists", "file", "allowDir", "fillRunCmdWithLauncherInfo", "emptyCmd", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "getAllHostPids", "getBackendProcessIdList", "getBundledBinDir", "getBundledFile", "fileName", "pluginClass", "Ljava/lang/Class;", "forceProcessExitOnFailure", "getBundledFileOrNull", "getBundledFileSafe", "getBundledPluginFile", "pluginId", "getProcesses", "isRiderBackendProcess", "isRiderProcess", "requestThreadDumpForRunningRiderBackends", "", "Lcom/jetbrains/rider/clrmd/ThreadDumpResult;", "request", "Lcom/jetbrains/rider/clrmd/CollectThreadDumpRequest;", "dumpDir", "(Lcom/jetbrains/rider/clrmd/CollectThreadDumpRequest;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "requestThreadDumpForRunningRiderBackendsBlocking", "throwRiderBackendNotCompiled", "tryFallbackIfLauncherNotFound", "folder", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderEnvironment.kt\ncom/jetbrains/rider/RiderEnvironment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,796:1\n1549#2:797\n1620#2,3:798\n13#3:801\n13#4:802\n*S KotlinDebug\n*F\n+ 1 RiderEnvironment.kt\ncom/jetbrains/rider/RiderEnvironment\n*L\n86#1:797\n86#1:798,3\n48#1:801\n48#1:802\n*E\n"})
public final class RiderEnvironment {
    @NotNull
    public static final RiderEnvironment INSTANCE = new RiderEnvironment();
    @NotNull
    private static final String traceEnvVar = "RESHARPER_TRACE";
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Set<Integer> riderProcesses;
    @NotNull
    private static final Set<Integer> backendHostProcesses;
    @NotNull
    public static final String riderBackendName = "Rider.Backend";
    @NotNull
    private static final String clrHostExecutableName = "Rider.Backend.exe";
    @NotNull
    private static final String clrLauncherExecutableName;
    @NotNull
    private static final String clrLauncherNiExecutableName;
    @NotNull
    private static final String riderBackendExecutableName;
    @NotNull
    public static final String hostBinEnvironmentVariable = "RESHARPER_HOST_BIN";
    private static final boolean isUnderTeamCity;
    private static final boolean isNotUnderTeamCity;
    private static final boolean isRiderForDebug;
    @Nullable
    private static final List<Logger> customizedLoggers;
    @Nullable
    private static String customHostBinDirectory;
    @NotNull
    private static final Lazy originalRiderBackendNetFrameworkExecutable$delegate;
    @NotNull
    private static final Lazy riderBackendExecutable$delegate;
    @NotNull
    private static final Lazy riderBackendDirectory$delegate;
    @NotNull
    private static final Lazy originalRiderBackendBinDir$delegate;
    @NotNull
    private static final File logDirectory;
    @NotNull
    private static final File backendThreadDumpDir;
    @NotNull
    private static final Lazy backendLogXmlPath$delegate;

    private RiderEnvironment() {
    }

    @NotNull
    public final List<Integer> getProcesses() {
        return CollectionsKt.toList((Iterable)riderProcesses);
    }

    @NotNull
    public final String getRiderBackendExecutableName() {
        return riderBackendExecutableName;
    }

    public final boolean isUnderTeamCity() {
        return isUnderTeamCity;
    }

    public final boolean isNotUnderTeamCity() {
        return isNotUnderTeamCity;
    }

    public final boolean isRiderForDebug() {
        return isRiderForDebug;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<Logger> applyEnvTraceCategories() {
        List list;
        char[] cArray;
        Object object = System.getenv(traceEnvVar);
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{',', ' ', ':', ';'}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            Object it = object;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)it;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void category;
                Logger logger;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Logger $this$applyEnvTraceCategories_u24lambda_u242_u24lambda_u241_u24lambda_u240 = logger = Logger.getInstance((String)category);
                boolean bl3 = false;
                $this$applyEnvTraceCategories_u24lambda_u242_u24lambda_u241_u24lambda_u240.setLevel(LogLevel.TRACE);
                Logger logger2 = logger;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"apply(...)");
                collection.add(logger2);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final String getCustomHostBinDirectory() {
        return customHostBinDirectory;
    }

    public final void setCustomHostBinDirectory(@Nullable String string) {
        customHostBinDirectory = string;
    }

    private final boolean fileExists(File file2, boolean allowDir) {
        if (allowDir) {
            return file2.exists();
        }
        return file2.isFile();
    }

    private final File tryFallbackIfLauncherNotFound(String folder, String fileName, boolean allowDir) {
        if (SystemInfo.isWindows && ApplicationInfoImpl.getShadowInstance().getBuild().isSnapshot()) {
            CharSequence charSequence = fileName;
            Regex regex = new Regex("64.exe$");
            String string = ".exe";
            regex = new Regex("32.exe$");
            String platformIndependentFileName = regex.replace(charSequence = (CharSequence)regex.replace(charSequence, string), string = ".exe");
            File platformIndependentExe = new File(folder, platformIndependentFileName);
            if (this.fileExists(platformIndependentExe, allowDir)) {
                logger.info("fallback file " + platformIndependentFileName + " found at " + folder);
                return platformIndependentExe;
            }
        }
        return null;
    }

    @NotNull
    public final File getBundledFileSafe(@NotNull String fileName, boolean allowDir, @Nullable Class<?> pluginClass) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file2 = this.getBundledFileOrNull(fileName, allowDir, pluginClass);
        if (file2 == null) {
            file2 = new File("");
        }
        return file2;
    }

    public static /* synthetic */ File getBundledFileSafe$default(RiderEnvironment riderEnvironment, String string, boolean bl, Class clazz, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            clazz = null;
        }
        return riderEnvironment.getBundledFileSafe(string, bl, clazz);
    }

    @Nullable
    public final File getBundledFileOrNull(@NotNull String fileName, boolean allowDir, @Nullable Class<?> pluginClass) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            file2 = this.getBundledFile(fileName, allowDir, pluginClass, false);
        }
        catch (FileNotFoundException e) {
            file2 = null;
        }
        return file2;
    }

    public static /* synthetic */ File getBundledFileOrNull$default(RiderEnvironment riderEnvironment, String string, boolean bl, Class clazz, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            clazz = null;
        }
        return riderEnvironment.getBundledFileOrNull(string, bl, clazz);
    }

    @NotNull
    public final File getBundledBinDir() {
        if (customHostBinDirectory != null) {
            return new File(customHostBinDirectory);
        }
        String bin = System.getenv(hostBinEnvironmentVariable);
        if (bin != null) {
            return new File(bin);
        }
        return new File(PathManager.getLibPath(), "ReSharperHost");
    }

    @NotNull
    public final File getBundledPluginFile(@NotNull String fileName, @NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)pluginId));
        if (ideaPluginDescriptor == null) {
            throw new IllegalStateException("Unknown plugin");
        }
        IdeaPluginDescriptor pluginDescriptor = ideaPluginDescriptor;
        File file2 = pluginDescriptor.getPluginPath().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        File file3 = FilesKt.resolve((File)file2, (String)fileName);
        if (!file3.exists()) {
            throw new IllegalStateException("Unknown plugin file " + file3);
        }
        return file3;
    }

    @NotNull
    public final File getBundledFile(@NotNull String fileName, boolean allowDir, @Nullable Class<?> pluginClass, boolean forceProcessExitOnFailure) {
        String customDir;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (pluginClass != null) {
            File file2;
            File file3;
            Path path;
            File fileInPlugin;
            String string = pluginClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            IdeaPluginDescriptor pluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginManagerCore.getPluginByClassName((String)string));
            File file4 = fileInPlugin = pluginDescriptor != null && (path = pluginDescriptor.getPluginPath()) != null && (file3 = path.toFile()) != null && (file2 = FilesKt.resolve((File)file3, (String)"DotFiles")) != null ? FilesKt.resolve((File)file2, (String)fileName) : null;
            boolean bl = file4 != null ? file4.exists() : false;
            if (bl && fileInPlugin.isFile()) {
                return fileInPlugin;
            }
        }
        if ((customDir = customHostBinDirectory) != null) {
            File exe = new File(customDir, fileName);
            if (!this.fileExists(exe, allowDir)) {
                logger.info(fileName + " found at " + customDir + " by custom bin directory");
                File file5 = this.tryFallbackIfLauncherNotFound(customDir, fileName, allowDir);
                if (file5 == null) {
                    throw new FileNotFoundException(fileName + " is not found at " + customHostBinDirectory + " (explicitly specified host directory via customHostBinDirectory)");
                }
                return file5;
            }
            return exe;
        }
        String bin = System.getenv(hostBinEnvironmentVariable);
        if (bin != null) {
            logger.info("%RESHARPER_HOST_BIN% = " + bin);
            File envExe = new File(bin, fileName);
            if (this.fileExists(envExe, allowDir)) {
                logger.info(fileName + " found at " + bin + " (from %RESHARPER_HOST_BIN%)");
                return envExe;
            }
            File file6 = this.tryFallbackIfLauncherNotFound(bin, fileName, allowDir);
            if (file6 == null) {
                RiderEnvironment $this$getBundledFile_u24lambda_u243 = this;
                boolean bl = false;
                if (forceProcessExitOnFailure && (PluginManagerCore.isRunningFromSources() || AppMode.isDevServer())) {
                    $this$getBundledFile_u24lambda_u243.throwRiderBackendNotCompiled();
                }
                throw new FileNotFoundException(fileName + " is not found at " + bin + " (explicitly specified host directory via RESHARPER_HOST_BIN environment variable)");
            }
            return file6;
        }
        logger.info("%RESHARPER_HOST_BIN% is not set");
        File distDir = new File(PathManager.getLibPath(), "ReSharperHost");
        File distExe = new File(distDir, fileName);
        if (this.fileExists(distExe, allowDir)) {
            logger.info(fileName + " found at " + distExe + " (bundled to IDEA)");
            return distExe;
        }
        throw new FileNotFoundException("No '" + fileName + "' found in locations: '%RESHARPER_HOST_BIN%'(" + bin + "), '" + distDir + "'");
    }

    public static /* synthetic */ File getBundledFile$default(RiderEnvironment riderEnvironment, String string, boolean bl, Class clazz, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            clazz = null;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return riderEnvironment.getBundledFile(string, bl, clazz, bl2);
    }

    public final void throwRiderBackendNotCompiled() {
        System.err.println();
        System.err.println("*********************************************************************");
        System.err.println("*****   Start 'Compile Rider Backend' run configuration first   *****");
        System.err.println("*********************************************************************");
        Runtime.getRuntime().halt(1);
    }

    @NotNull
    public final ProcessBuilder createProcessBuilderForAssembly(@NotNull String assemblyFullPath, String ... params2) {
        Intrinsics.checkNotNullParameter((Object)assemblyFullPath, (String)"assemblyFullPath");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        File assemblyFile = new File(assemblyFullPath);
        return AssemblyExecutionContext.Companion.create(assemblyFile, Arrays.copyOf(params2, params2.length)).toProcessBuilder();
    }

    @NotNull
    public final GeneralCommandLine createRunCmdForLauncherInfo(@NotNull BundledAssemblyLauncherInfo launcherInfo, String ... params2) {
        Intrinsics.checkNotNullParameter((Object)launcherInfo, (String)"launcherInfo");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        return this.fillRunCmdWithLauncherInfo(new GeneralCommandLine(), launcherInfo, Arrays.copyOf(params2, params2.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final GeneralCommandLine fillRunCmdWithLauncherInfo(@NotNull GeneralCommandLine emptyCmd, @NotNull BundledAssemblyLauncherInfo launcherInfo, String ... params2) {
        Intrinsics.checkNotNullParameter((Object)emptyCmd, (String)"emptyCmd");
        Intrinsics.checkNotNullParameter((Object)launcherInfo, (String)"launcherInfo");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        String previousBinDirValue = customHostBinDirectory;
        customHostBinDirectory = null;
        try {
            GeneralCommandLine generalCommandLine = AssemblyExecutionContext.Companion.create(launcherInfo, Arrays.copyOf(params2, params2.length)).fillCommandLine(emptyCmd);
            return generalCommandLine;
        }
        finally {
            customHostBinDirectory = previousBinDirValue;
        }
    }

    private final File getOriginalRiderBackendNetFrameworkExecutable() {
        Lazy lazy = originalRiderBackendNetFrameworkExecutable$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File getRiderBackendExecutable() {
        Lazy lazy = riderBackendExecutable$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File getRiderBackendDirectory() {
        Lazy lazy = riderBackendDirectory$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (File)object;
    }

    @NotNull
    public final File getOriginalRiderBackendBinDir() {
        Lazy lazy = originalRiderBackendBinDir$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (File)object;
    }

    @NotNull
    public final File getLogDirectory() {
        return logDirectory;
    }

    @NotNull
    public final File getBackendThreadDumpDir() {
        return backendThreadDumpDir;
    }

    @NotNull
    public final Path getBackendLogXmlPath() {
        Lazy lazy = backendLogXmlPath$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    public final String getLogBackendConf() {
        return ((Object)this.getBackendLogXmlPath().toAbsolutePath()).toString();
    }

    public final void addRiderBackendProcess(@NotNull BaseOSProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        int pid = (int)processHandler.getProcess().pid();
        backendHostProcesses.add(pid);
        this.addRiderAuxiliaryProcess(processHandler);
    }

    public final void addRiderAuxiliaryProcess(@NotNull BaseOSProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        int pid = (int)processHandler.getProcess().pid();
        riderProcesses.add(pid);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(pid){
            final /* synthetic */ int $pid;
            {
                this.$pid = $pid;
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                RiderEnvironment.access$getRiderProcesses$p().remove(this.$pid);
                if (RiderEnvironment.access$getBackendHostProcesses$p().contains(this.$pid)) {
                    RiderEnvironment.access$getBackendHostProcesses$p().remove(this.$pid);
                }
            }
        });
    }

    public final void addRiderProcess(int pid, @NotNull Lifetime lifetime2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        lifetime2.bracketOrThrow((Function0)new Function0<Boolean>(pid){
            final /* synthetic */ int $pid;
            {
                this.$pid = $pid;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return RiderEnvironment.access$getRiderProcesses$p().add(this.$pid);
            }
        }, (Function0)new Function0<Unit>(pid){
            final /* synthetic */ int $pid;
            {
                this.$pid = $pid;
                super(0);
            }

            public final void invoke() {
                RiderEnvironment.access$getRiderProcesses$p().remove(this.$pid);
            }
        });
    }

    public final boolean isRiderProcess(int pid) {
        return riderProcesses.contains(pid);
    }

    public final boolean isRiderBackendProcess(int pid) {
        return backendHostProcesses.contains(pid);
    }

    @NotNull
    public final List<Integer> getBackendProcessIdList() {
        return CollectionsKt.toList((Iterable)backendHostProcesses);
    }

    @NotNull
    public final Map<Integer, ThreadDumpResult> requestThreadDumpForRunningRiderBackendsBlocking(@NotNull CollectThreadDumpRequest request2, @Nullable File dumpDir) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        int[] nArray = CollectionsKt.toIntArray((Collection)backendHostProcesses);
        return ClrProcessThreadDumpUtilKt.requestThreadDumpForClrProcessesBlocking(request2, Arrays.copyOf(nArray, nArray.length), dumpDir);
    }

    public static /* synthetic */ Map requestThreadDumpForRunningRiderBackendsBlocking$default(RiderEnvironment riderEnvironment, CollectThreadDumpRequest collectThreadDumpRequest, File file2, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        return riderEnvironment.requestThreadDumpForRunningRiderBackendsBlocking(collectThreadDumpRequest, file2);
    }

    @Nullable
    public final Object requestThreadDumpForRunningRiderBackends(@NotNull CollectThreadDumpRequest request2, @Nullable File dumpDir, @NotNull Continuation<? super Map<Integer, ThreadDumpResult>> $completion) {
        int[] nArray = CollectionsKt.toIntArray((Collection)backendHostProcesses);
        return ClrProcessThreadDumpUtilKt.requestThreadDumpForClrProcesses(request2, Arrays.copyOf(nArray, nArray.length), dumpDir, $completion);
    }

    public static /* synthetic */ Object requestThreadDumpForRunningRiderBackends$default(RiderEnvironment riderEnvironment, CollectThreadDumpRequest collectThreadDumpRequest, File file2, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        return riderEnvironment.requestThreadDumpForRunningRiderBackends(collectThreadDumpRequest, file2, (Continuation<? super Map<Integer, ThreadDumpResult>>)continuation);
    }

    @NotNull
    public final List<Integer> getAllHostPids() {
        return CollectionsKt.toList((Iterable)backendHostProcesses);
    }

    public static final /* synthetic */ Set access$getRiderProcesses$p() {
        return riderProcesses;
    }

    public static final /* synthetic */ Set access$getBackendHostProcesses$p() {
        return backendHostProcesses;
    }

    public static final /* synthetic */ String access$getClrLauncherNiExecutableName$p() {
        return clrLauncherNiExecutableName;
    }

    public static final /* synthetic */ String access$getClrLauncherExecutableName$p() {
        return clrLauncherExecutableName;
    }

    public static final /* synthetic */ File access$getOriginalRiderBackendNetFrameworkExecutable(RiderEnvironment $this) {
        return $this.getOriginalRiderBackendNetFrameworkExecutable();
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderEnvironment.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderEnvironment.logger = logger;
        Set set = ContainerUtil.newConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newConcurrentSet(...)");
        riderProcesses = set;
        Set set2 = ContainerUtil.newConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"newConcurrentSet(...)");
        backendHostProcesses = set2;
        clrLauncherExecutableName = riderBackendName + (SystemInfo.isWindows ? ".exe" : "");
        clrLauncherNiExecutableName = "Rider.Backend.ni" + (SystemInfo.isWindows ? ".exe" : "");
        riderBackendExecutableName = NetCoreUtil.INSTANCE.runOnNetCore() ? (NetCoreUtil.INSTANCE.useNativeLauncher() ? clrLauncherExecutableName : clrHostExecutableName) : "Rider.Backend64.exe";
        isUnderTeamCity = System.getenv("TEAMCITY_VERSION") != null;
        isNotUnderTeamCity = !isUnderTeamCity;
        CharSequence charSequence = System.getenv(hostBinEnvironmentVariable);
        isRiderForDebug = !(charSequence == null || charSequence.length() == 0);
        customizedLoggers = INSTANCE.applyEnvTraceCategories();
        originalRiderBackendNetFrameworkExecutable$delegate = LazyKt.lazy((Function0)originalRiderBackendNetFrameworkExecutable.2.INSTANCE);
        riderBackendExecutable$delegate = LazyKt.lazy((Function0)riderBackendExecutable.2.INSTANCE);
        riderBackendDirectory$delegate = LazyKt.lazy((Function0)riderBackendDirectory.2.INSTANCE);
        originalRiderBackendBinDir$delegate = LazyKt.lazy((Function0)originalRiderBackendBinDir.2.INSTANCE);
        logDirectory = new File(PathManager.getLogPath());
        backendThreadDumpDir = FilesKt.resolve((File)logDirectory, (String)"BackendThreadDump");
        backendLogXmlPath$delegate = LazyKt.lazy((Function0)backendLogXmlPath.2.INSTANCE);
    }
}

