/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.intellij.remote.RemoteFile;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.util.OSKind;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\r\u001a\u00020\u00002\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000f\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0006\u0010\u0019\u001a\u00020\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/PathInfo;", "", "path", "", "cpuKind", "Lcom/jetbrains/rider/CPUKind;", "(Ljava/lang/String;Lcom/jetbrains/rider/CPUKind;)V", "getCpuKind", "()Lcom/jetbrains/rider/CPUKind;", "getPath", "()Ljava/lang/String;", "sftpPath", "getSftpPath", "appendPath", "folders", "", "([Ljava/lang/String;)Lcom/jetbrains/rider/PathInfo;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "shellQuote", "toString", "transformPathToSftp", "intellij.rider.rdclient.dotnet"})
public final class PathInfo {
    @NotNull
    private final String path;
    @NotNull
    private final CPUKind cpuKind;
    @NotNull
    private final String sftpPath;

    public PathInfo(@NotNull String path, @NotNull CPUKind cpuKind) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)cpuKind), (String)"cpuKind");
        this.path = path;
        this.cpuKind = cpuKind;
        this.sftpPath = this.transformPathToSftp(this.path);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final CPUKind getCpuKind() {
        return this.cpuKind;
    }

    @NotNull
    public final String getSftpPath() {
        return this.sftpPath;
    }

    @NotNull
    public final PathInfo appendPath(String ... folders) {
        Intrinsics.checkNotNullParameter((Object)folders, (String)"folders");
        RemoteFile remoteFile = RemoteFile.createRemoteFile((String)this.path, (this.cpuKind.getOsKind() == OSKind.Windows ? 1 : 0) != 0);
        Intrinsics.checkNotNullExpressionValue((Object)remoteFile, (String)"createRemoteFile(...)");
        RemoteFile remoteFile2 = remoteFile;
        for (String folder : folders) {
            Intrinsics.checkNotNullExpressionValue((Object)RemoteFile.createRemoteFile((String)remoteFile2.getPath(), (String)folder, (this.cpuKind.getOsKind() == OSKind.Windows ? 1 : 0) != 0), (String)"createRemoteFile(...)");
        }
        String string = remoteFile2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return new PathInfo(string, this.cpuKind);
    }

    @NotNull
    public final String shellQuote() {
        String string = ParametersListUtil.escape((CharSequence)this.path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escape(...)");
        return string;
    }

    private final String transformPathToSftp(String path) {
        return StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) ? path : StringsKt.replace$default((String)StringsKt.replace$default((String)path, (String)"C:\\", (String)"/", (boolean)false, (int)4, null), (String)"\\", (String)"/", (boolean)false, (int)4, null);
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    @NotNull
    public final CPUKind component2() {
        return this.cpuKind;
    }

    @NotNull
    public final PathInfo copy(@NotNull String path, @NotNull CPUKind cpuKind) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)cpuKind), (String)"cpuKind");
        return new PathInfo(path, cpuKind);
    }

    public static /* synthetic */ PathInfo copy$default(PathInfo pathInfo, String string, CPUKind cPUKind, int n, Object object) {
        if ((n & 1) != 0) {
            string = pathInfo.path;
        }
        if ((n & 2) != 0) {
            cPUKind = pathInfo.cpuKind;
        }
        return pathInfo.copy(string, cPUKind);
    }

    @NotNull
    public String toString() {
        return "PathInfo(path=" + this.path + ", cpuKind=" + this.cpuKind + ")";
    }

    public int hashCode() {
        int result2 = this.path.hashCode();
        result2 = result2 * 31 + this.cpuKind.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PathInfo)) {
            return false;
        }
        PathInfo pathInfo = (PathInfo)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)pathInfo.path)) {
            return false;
        }
        return this.cpuKind == pathInfo.cpuKind;
    }
}

