/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.ui.diff;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.ui.diff.FrontendDiffMarkModelSupportKt;
import com.jetbrains.rdclient.ui.diff.UnifiedChangeModel;
import com.jetbrains.rdclient.ui.diff.UnifiedChangedBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001\u001fB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001b\u001a\u00020\bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u001d\u001a\u00020\bH\u0002J\b\u0010\u001e\u001a\u00020\bH\u0002R*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdclient/ui/diff/UnifiedBlocksModel;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "onBlocksChanges", "Lkotlin/Function0;", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/ex/EditorEx;Lkotlin/jvm/functions/Function0;)V", "<set-?>", "", "Lcom/jetbrains/rdclient/ui/diff/UnifiedChangedBlock;", "changedBlocks", "getChangedBlocks", "()Ljava/util/List;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "isUpdateScheduled", "", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getOnBlocksChanges", "()Lkotlin/jvm/functions/Function0;", "clearBlocks", "collectBlockHighlighters", "rebuildBlocks", "scheduleBlockUpdate", "BlocksMarkupModelListener", "intellij.rd.client"})
public final class UnifiedBlocksModel {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final Function0<Unit> onBlocksChanges;
    private boolean isUpdateScheduled;
    @NotNull
    private final List<RangeHighlighter> highlighters;
    @NotNull
    private List<UnifiedChangedBlock> changedBlocks;

    public UnifiedBlocksModel(@NotNull Lifetime lifetime2, @NotNull EditorEx editor2, @NotNull Function0<Unit> onBlocksChanges) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(onBlocksChanges, (String)"onBlocksChanges");
        this.lifetime = lifetime2;
        this.editor = editor2;
        this.onBlocksChanges = onBlocksChanges;
        this.highlighters = new ArrayList();
        this.changedBlocks = CollectionsKt.emptyList();
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null);
        BlocksMarkupModelListener markupListener = new BlocksMarkupModelListener();
        this.editor.getMarkupModel().addMarkupModelListener(disposable, (MarkupModelListener)markupListener);
        this.scheduleBlockUpdate();
        this.lifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.clearBlocks();
            }
        });
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    @NotNull
    public final Function0<Unit> getOnBlocksChanges() {
        return this.onBlocksChanges;
    }

    @NotNull
    public final List<UnifiedChangedBlock> getChangedBlocks() {
        return this.changedBlocks;
    }

    private final void scheduleBlockUpdate() {
        if (this.isUpdateScheduled) {
            return;
        }
        this.isUpdateScheduled = true;
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ UnifiedBlocksModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                UnifiedBlocksModel.access$setUpdateScheduled$p(this.this$0, false);
                UnifiedBlocksModel.access$rebuildBlocks(this.this$0);
            }
        }), (int)1, null);
    }

    private final void clearBlocks() {
        for (RangeHighlighter highlighter2 : this.highlighters) {
            highlighter2.dispose();
        }
        this.highlighters.clear();
        this.changedBlocks = CollectionsKt.emptyList();
    }

    private final void rebuildBlocks() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime) || this.editor.isDisposed()) {
            return;
        }
        this.clearBlocks();
        List<UnifiedChangedBlock> newBlocks = this.collectBlockHighlighters(this.editor);
        this.changedBlocks = newBlocks;
        this.onBlocksChanges.invoke();
    }

    private final List<UnifiedChangedBlock> collectBlockHighlighters(EditorEx editor2) {
        DocumentEx documentEx = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        List result2 = new ArrayList();
        editor2.getMarkupModel().processRangeHighlightersOverlappingWith(0, document.getTextLength(), arg_0 -> UnifiedBlocksModel.collectBlockHighlighters$lambda$0((Function1)new Function1<RangeHighlighterEx, Boolean>((List<UnifiedChangedBlock>)result2){
            final /* synthetic */ List<UnifiedChangedBlock> $result;
            {
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final Boolean invoke(RangeHighlighterEx it) {
                Intrinsics.checkNotNull((Object)it);
                UnifiedChangeModel blockModel = FrontendDiffMarkModelSupportKt.getUnifiedChangeModel((RangeHighlighter)it);
                if (blockModel != null) {
                    ((Collection)this.$result).add(new UnifiedChangedBlock(it, blockModel));
                }
                return true;
            }
        }, arg_0));
        return result2;
    }

    private static final boolean collectBlockHighlighters$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$setUpdateScheduled$p(UnifiedBlocksModel $this, boolean bl) {
        $this.isUpdateScheduled = bl;
    }

    public static final /* synthetic */ void access$rebuildBlocks(UnifiedBlocksModel $this) {
        $this.rebuildBlocks();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/ui/diff/UnifiedBlocksModel$BlocksMarkupModelListener;", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "(Lcom/jetbrains/rdclient/ui/diff/UnifiedBlocksModel;)V", "afterAdded", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterRemoved", "attributesChanged", "renderersChanged", "", "fontStyleChanged", "foregroundColorChanged", "onHighlighterModified", "intellij.rd.client"})
    private final class BlocksMarkupModelListener
    implements MarkupModelListener {
        public void afterAdded(@NotNull RangeHighlighterEx highlighter2) {
            Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
            this.onHighlighterModified(highlighter2);
        }

        public void afterRemoved(@NotNull RangeHighlighterEx highlighter2) {
            Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
            this.onHighlighterModified(highlighter2);
        }

        public void attributesChanged(@NotNull RangeHighlighterEx highlighter2, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
            Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
            this.onHighlighterModified(highlighter2);
        }

        private final void onHighlighterModified(RangeHighlighterEx highlighter2) {
            if (FrontendDiffMarkModelSupportKt.getUnifiedChangeModel((RangeHighlighter)highlighter2) != null) {
                UnifiedBlocksModel.this.scheduleBlockUpdate();
            }
        }
    }
}

