/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.ui.diff;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IntPair;
import com.intellij.util.Processor;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.ui.diff.DiffInnerModel;
import com.jetbrains.rdclient.ui.diff.DiffLineModel;
import com.jetbrains.rdclient.ui.diff.FrontendDiffMarkModelSupportKt;
import com.jetbrains.rdclient.ui.diff.UtilKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/ui/diff/DiffEditorHighlightingSynchronizer;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "highlighters", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "clearHighlighters", "", "initHighlighters", "updateHighlighterFor", "highlighter", "HighlightingMarkupModelListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nDiffEditorHighlightingSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffEditorHighlightingSynchronizer.kt\ncom/jetbrains/rdclient/ui/diff/DiffEditorHighlightingSynchronizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1855#2,2:77\n1855#2,2:79\n1855#2,2:81\n1855#2,2:83\n*S KotlinDebug\n*F\n+ 1 DiffEditorHighlightingSynchronizer.kt\ncom/jetbrains/rdclient/ui/diff/DiffEditorHighlightingSynchronizer\n*L\n30#1:77,2\n35#1:79,2\n43#1:81,2\n53#1:83,2\n*E\n"})
public final class DiffEditorHighlightingSynchronizer {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final Map<RangeHighlighterEx, List<RangeHighlighter>> highlighters;

    public DiffEditorHighlightingSynchronizer(@NotNull Lifetime lifetime2, @NotNull EditorEx editor2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.lifetime = lifetime2;
        this.editor = editor2;
        this.highlighters = new LinkedHashMap();
        HighlightingMarkupModelListener markupListener = new HighlightingMarkupModelListener();
        this.editor.getMarkupModel().addMarkupModelListener(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null), (MarkupModelListener)markupListener);
        this.initHighlighters();
        this.lifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.clearHighlighters();
            }
        });
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    private final void initHighlighters() {
        CommonProcessors.CollectProcessor<RangeHighlighterEx> processor2 = new CommonProcessors.CollectProcessor<RangeHighlighterEx>(){

            protected boolean accept(@NotNull RangeHighlighterEx highlighter2) {
                Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
                return FrontendDiffMarkModelSupportKt.getDiffLineModel((RangeHighlighter)highlighter2) != null || FrontendDiffMarkModelSupportKt.getDiffInnerModel((RangeHighlighter)highlighter2) != null;
            }
        };
        this.editor.getMarkupModel().processRangeHighlightersOverlappingWith(0, this.editor.getDocument().getTextLength(), (Processor)processor2);
        Collection collection = processor2.getResults();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResults(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighterEx p0 = (RangeHighlighterEx)element$iv;
            boolean bl = false;
            this.updateHighlighterFor(p0);
        }
    }

    private final void clearHighlighters() {
        for (List<RangeHighlighter> highlighter2 : this.highlighters.values()) {
            Iterable $this$forEach$iv = highlighter2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RangeHighlighter it = (RangeHighlighter)element$iv;
                boolean bl = false;
                it.dispose();
            }
        }
        this.highlighters.clear();
    }

    private final void updateHighlighterFor(RangeHighlighterEx highlighter2) {
        DiffInnerModel innerModel;
        Map<RangeHighlighterEx, List<RangeHighlighter>> map;
        DiffLineModel lineModel = FrontendDiffMarkModelSupportKt.getDiffLineModel((RangeHighlighter)highlighter2);
        if (lineModel != null) {
            List<RangeHighlighter> list = this.highlighters.remove(highlighter2);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RangeHighlighter it = (RangeHighlighter)element$iv;
                    boolean bl = false;
                    it.dispose();
                }
            }
            IntPair lines = UtilKt.getHighlighterLineRange(highlighter2, lineModel.isEmptyRange(), lineModel.isEOF());
            map = this.highlighters;
            List list2 = DiffDrawUtil.createHighlighter((Editor)((Editor)this.editor), (int)lines.first, (int)lines.second, (TextDiffType)UtilKt.toTextDiffType(lineModel.getType()), (DiffDrawUtil.PaintMode)UtilKt.fromModel(lineModel.getEditorMode()), (DiffDrawUtil.PaintMode)UtilKt.fromModel(lineModel.getGutterMode()));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createHighlighter(...)");
            List $i$f$forEach = list2;
            map.put(highlighter2, $i$f$forEach);
        }
        if ((innerModel = FrontendDiffMarkModelSupportKt.getDiffInnerModel((RangeHighlighter)highlighter2)) != null) {
            List<RangeHighlighter> list = this.highlighters.remove(highlighter2);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RangeHighlighter it = (RangeHighlighter)element$iv;
                    boolean bl = false;
                    it.dispose();
                }
            }
            map = this.highlighters;
            List list3 = DiffDrawUtil.createInlineHighlighter((Editor)((Editor)this.editor), (int)highlighter2.getStartOffset(), (int)highlighter2.getEndOffset(), (TextDiffType)UtilKt.toTextDiffType(innerModel.getType()));
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"createInlineHighlighter(...)");
            List list4 = list3;
            map.put(highlighter2, list4);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdclient/ui/diff/DiffEditorHighlightingSynchronizer$HighlightingMarkupModelListener;", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "(Lcom/jetbrains/rdclient/ui/diff/DiffEditorHighlightingSynchronizer;)V", "afterAdded", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterRemoved", "attributesChanged", "renderersChanged", "", "fontStyleChanged", "foregroundColorChanged", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nDiffEditorHighlightingSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffEditorHighlightingSynchronizer.kt\ncom/jetbrains/rdclient/ui/diff/DiffEditorHighlightingSynchronizer$HighlightingMarkupModelListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1855#2,2:77\n*S KotlinDebug\n*F\n+ 1 DiffEditorHighlightingSynchronizer.kt\ncom/jetbrains/rdclient/ui/diff/DiffEditorHighlightingSynchronizer$HighlightingMarkupModelListener\n*L\n66#1:77,2\n*E\n"})
    private final class HighlightingMarkupModelListener
    implements MarkupModelListener {
        public void afterAdded(@NotNull RangeHighlighterEx highlighter2) {
            Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
            DiffEditorHighlightingSynchronizer.this.updateHighlighterFor(highlighter2);
        }

        public void afterRemoved(@NotNull RangeHighlighterEx highlighter2) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
                List list = (List)DiffEditorHighlightingSynchronizer.this.highlighters.remove(highlighter2);
                if (list == null) break block1;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RangeHighlighter it = (RangeHighlighter)element$iv;
                    boolean bl = false;
                    it.dispose();
                }
            }
        }

        public void attributesChanged(@NotNull RangeHighlighterEx highlighter2, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
            Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
            DiffEditorHighlightingSynchronizer.this.updateHighlighterFor(highlighter2);
        }
    }
}

