/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.internal.markup;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.platform.internal.DumpAction;
import com.jetbrains.rd.platform.internal.RdInternalShowTextDiffManager;
import com.jetbrains.rd.platform.internal.TextDiffPresentationData;
import com.jetbrains.rdclient.daemon.util.HighlighterTestUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/internal/markup/CompareBackendAndFrontendHighlighterTrees;", "Lcom/jetbrains/rd/platform/internal/DumpAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.rd.client"})
public final class CompareBackendAndFrontendHighlighterTrees
extends DumpAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        String frontendTree = HighlighterTestUtilKt.getFrontendDump(editor3, true);
        String backendTree = HighlighterTestUtilKt.getBackendDumpSync$default(editor3, true, null, 4, null);
        TextDiffPresentationData highlighters = new TextDiffPresentationData("Backend Tree", backendTree);
        TextDiffPresentationData foldings = new TextDiffPresentationData("Frontend Tree", frontendTree);
        RdInternalShowTextDiffManager.INSTANCE.showDiff(project3, "Compare Backend vs Frontend Trees", highlighters, foldings);
    }
}

