/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.tooltips;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.impl.RdTaskKt;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.ide.model.TooltipModel;
import com.jetbrains.rd.ide.model.TooltipProviderModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendInTestTooltipProvider;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.TooltipInvalidationContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00190\u001dH\u0016R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "debugName", "", "providerModel", "Lcom/jetbrains/rd/ide/model/TooltipProviderModel;", "markupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "invalidationContext", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/TooltipInvalidationContext;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Lcom/jetbrains/rd/ide/model/TooltipProviderModel;Lcom/jetbrains/rd/ide/model/RdMarkupModel;Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/TooltipInvalidationContext;)V", "<set-?>", "", "currentTimestamp", "getCurrentTimestamp", "()I", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getMarkupModel", "()Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "getProviderModel", "()Lcom/jetbrains/rd/ide/model/TooltipProviderModel;", "requestTooltip", "", "id", "", "action", "Lkotlin/Function1;", "Lcom/jetbrains/rd/ide/model/TooltipModel;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendTooltipProviders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendTooltipProviders.kt\ncom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n13#2:109\n*S KotlinDebug\n*F\n+ 1 FrontendTooltipProviders.kt\ncom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider\n*L\n34#1:109\n*E\n"})
public class FrontendTooltipProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final String debugName;
    @NotNull
    private final TooltipProviderModel providerModel;
    @NotNull
    private final RdMarkupModel markupModel;
    private int currentTimestamp;
    @NotNull
    private static final Logger logger;

    public FrontendTooltipProvider(@NotNull Lifetime lifetime2, @NotNull String debugName, @NotNull TooltipProviderModel providerModel, @NotNull RdMarkupModel markupModel, @NotNull TooltipInvalidationContext invalidationContext) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        Intrinsics.checkNotNullParameter((Object)providerModel, (String)"providerModel");
        Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
        Intrinsics.checkNotNullParameter((Object)invalidationContext, (String)"invalidationContext");
        this.lifetime = lifetime2;
        this.debugName = debugName;
        this.providerModel = providerModel;
        this.markupModel = markupModel;
        invalidationContext.invalidated(this.lifetime, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                FrontendTooltipProvider frontendTooltipProvider = this;
                int n = frontendTooltipProvider.getCurrentTimestamp();
                frontendTooltipProvider.currentTimestamp = n + 1;
            }
        }));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    protected final TooltipProviderModel getProviderModel() {
        return this.providerModel;
    }

    @NotNull
    protected final RdMarkupModel getMarkupModel() {
        return this.markupModel;
    }

    public final int getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public void requestTooltip(long id, @NotNull Function1<? super TooltipModel, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
            logger.error("Requesting tooltip for highlighter in already disposed markup. document: " + this.debugName);
            return;
        }
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.markupModel.isReady()))) {
            return;
        }
        RdTaskKt.startAndAdviseSuccess((IRdCall)((IRdCall)this.providerModel.getGetTooltip()), (Object)id, action2);
    }

    @NotNull
    protected static final Logger getLogger() {
        return Companion.getLogger();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendTooltipProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendTooltipProvider.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "markupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "debugName", "", "providerModel", "Lcom/jetbrains/rd/ide/model/TooltipProviderModel;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendTooltipProvider create(@NotNull Lifetime lifetime2, @NotNull RdMarkupModel markupModel, @NotNull String debugName, @NotNull TooltipProviderModel providerModel) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
            Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
            Intrinsics.checkNotNullParameter((Object)providerModel, (String)"providerModel");
            TooltipInvalidationContext invalidationContext = new TooltipInvalidationContext(markupModel);
            return ApplicationManager.getApplication().isUnitTestMode() ? (FrontendTooltipProvider)new FrontendInTestTooltipProvider(lifetime2, debugName, providerModel, markupModel, invalidationContext) : new FrontendTooltipProvider(lifetime2, debugName, providerModel, markupModel, invalidationContext);
        }

        @NotNull
        protected final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        protected static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

