/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.indentGuides;

import com.intellij.codeInsight.daemon.impl.IndentGuideRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideRenderResultCollector;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideRendererKt;
import java.awt.Graphics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J(\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRenderer;", "Lcom/intellij/codeInsight/daemon/impl/IndentGuideRenderer;", "()V", "doPaint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "resultCollector", "Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRenderResultCollector;", "doPaintInTest", "isSelected", "", "endOffset", "", "off", "indentColumn", "paint", "g", "Ljava/awt/Graphics;", "intellij.rd.client"})
public final class FrontendIndentGuideRenderer
extends IndentGuideRenderer {
    protected boolean isSelected(@NotNull Editor editor2, int endOffset, int off, int indentColumn) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return IndentGuideRenderer.isCaretOnGuide((Editor)editor2, (int)endOffset, (int)off, (int)indentColumn);
    }

    public void paint(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter2, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!editor2.getSettings().isIndentGuidesShown()) {
            return;
        }
        if (FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel(highlighter2) == null) {
            super.paint(editor2, highlighter2, g);
            return;
        }
        FrontendIndentGuideRenderResultCollector collector = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> FrontendIndentGuideRenderer.paint$lambda$0(this, g, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
        this.doPaint(editor2, highlighter2, collector);
    }

    private final void doPaint(Editor editor2, RangeHighlighter highlighter2, FrontendIndentGuideRenderResultCollector resultCollector) {
        Integer n = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel(highlighter2);
        Intrinsics.checkNotNull((Object)n);
        int indentLevel2 = n;
        int startOffset = highlighter2.getStartOffset();
        Document document = highlighter2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        if (startOffset >= doc.getTextLength()) {
            return;
        }
        int endOffset = highlighter2.getEndOffset();
        int startLine = doc.getLineNumber(startOffset);
        int endLine = doc.getLineNumber(endOffset);
        int off = editor2.logicalPositionToOffset(new LogicalPosition(startLine, 0)) + indentLevel2;
        int visualIndentLevel = editor2.offsetToVisualPosition((int)off).column;
        int logicalIndentLevel = editor2.offsetToLogicalPosition((int)off).column;
        Integer currentPartStartLine = startLine;
        for (int currentLine = startLine; currentLine < endLine; ++currentLine) {
            if (FrontendIndentGuideRendererKt.access$shouldRenderIndentGuideOnLine(editor2, currentLine, logicalIndentLevel)) {
                Integer n2 = currentPartStartLine;
                if (n2 == null) {
                    n2 = currentLine - 1;
                }
                currentPartStartLine = n2;
                continue;
            }
            if (currentPartStartLine == null) continue;
            FrontendIndentGuideRenderer.doPaint$paint(editor2, indentLevel2, visualIndentLevel, resultCollector, off, endOffset, doc, currentPartStartLine, currentLine);
            currentPartStartLine = null;
        }
        if (currentPartStartLine == null) {
            return;
        }
        FrontendIndentGuideRenderer.doPaint$paint(editor2, indentLevel2, visualIndentLevel, resultCollector, off, endOffset, doc, currentPartStartLine, endLine);
    }

    @TestOnly
    public final void doPaintInTest(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter2, @NotNull FrontendIndentGuideRenderResultCollector resultCollector) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)resultCollector, (String)"resultCollector");
        this.doPaint(editor2, highlighter2, resultCollector);
    }

    private static final void paint$lambda$0(FrontendIndentGuideRenderer this$0, Graphics $g, Editor editorParam, VisualPosition currentPartStartVisualPosition, VisualPosition currentPartEndVisualPosition, int off, int endOffset, Document doc) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$g, (String)"$g");
        Intrinsics.checkNotNullParameter((Object)editorParam, (String)"editorParam");
        Intrinsics.checkNotNullParameter((Object)currentPartStartVisualPosition, (String)"currentPartStartVisualPosition");
        Intrinsics.checkNotNullParameter((Object)currentPartEndVisualPosition, (String)"currentPartEndVisualPosition");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this$0.paint(editorParam, currentPartStartVisualPosition, currentPartEndVisualPosition, off, endOffset, doc, $g);
    }

    private static final void doPaint$paint(Editor $editor, int indentLevel2, int visualIndentLevel, FrontendIndentGuideRenderResultCollector $resultCollector, int off, int endOffset, Document doc, int startLine, int endLine) {
        int currentPartStartOffset = $editor.logicalPositionToOffset(new LogicalPosition(startLine, 0)) + indentLevel2;
        VisualPosition currentPartStartVisualPosition = new VisualPosition($editor.offsetToVisualPosition((int)currentPartStartOffset).line, visualIndentLevel);
        int currentPartEndOffset = $editor.logicalPositionToOffset(new LogicalPosition(endLine, 0)) + indentLevel2;
        VisualPosition currentPartEndVisualPosition = new VisualPosition($editor.offsetToVisualPosition((int)currentPartEndOffset).line, visualIndentLevel);
        $resultCollector.collect($editor, currentPartStartVisualPosition, currentPartEndVisualPosition, off, endOffset, doc);
    }
}

