/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.gutterMarks;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.ExperimentalUI;
import com.jetbrains.rd.ide.model.GutterMarkActionModel;
import com.jetbrains.rd.ide.model.GutterMarkDnDModel;
import com.jetbrains.rd.ide.model.GutterMarkHoverModel;
import com.jetbrains.rd.ide.model.HoverEventType;
import com.jetbrains.rd.ide.model.RdGutterExecutionRequest;
import com.jetbrains.rd.ide.model.RdGutterHoverRequest;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.FrontendGutterIconRenderer;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.GutterMarkInfo;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.GutterMarkWeight;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.IGutterIconRendererWithHover;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.MergableGutterIconRenderer;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendStringTooltipCalculator;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B5\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\"\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\"\u0010%\u001a\u00020!2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0011\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u0002H\u0096\u0002J\u0013\u0010(\u001a\u00020)2\b\u0010'\u001a\u0004\u0018\u00010*H\u0096\u0002J\b\u0010+\u001a\u00020,H\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u000200H\u0016J\n\u00101\u001a\u0004\u0018\u000102H\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0016J\b\u00105\u001a\u00020!H\u0016J\b\u00106\u001a\u00020!H\u0016J\b\u00107\u001a\u00020)H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/FrontendGutterIconRenderer;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/MergableGutterIconRenderer;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/IGutterIconRendererWithHover;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "info", "Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/GutterMarkInfo;", "gutterMarkActionModel", "Lcom/jetbrains/rd/ide/model/GutterMarkActionModel;", "gutterMarkHoverModel", "Lcom/jetbrains/rd/ide/model/GutterMarkHoverModel;", "tooltipProvider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "dndModel", "Lcom/jetbrains/rd/ide/model/GutterMarkDnDModel;", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/GutterMarkInfo;Lcom/jetbrains/rd/ide/model/GutterMarkActionModel;Lcom/jetbrains/rd/ide/model/GutterMarkHoverModel;Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;Lcom/jetbrains/rd/ide/model/GutterMarkDnDModel;)V", "getDndModel", "()Lcom/jetbrains/rd/ide/model/GutterMarkDnDModel;", "getGutterMarkActionModel", "()Lcom/jetbrains/rd/ide/model/GutterMarkActionModel;", "getHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getInfo", "()Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/GutterMarkInfo;", "tooltipCalculator", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendStringTooltipCalculator;", "calcSurroundRange", "Lcom/intellij/openapi/util/TextRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "calculateLeftOffset", "foldingModelImpl", "Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "calculateRightOffset", "compareTo", "other", "equals", "", "", "getAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "getClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getIcon", "Ljavax/swing/Icon;", "getPopupMenuActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getTooltipText", "", "getWeight", "hashCode", "isNavigateAction", "onHover", "", "hoverEvent", "Lcom/jetbrains/rd/ide/model/HoverEventType;", "intellij.rd.client"})
public class FrontendGutterIconRenderer
extends GutterIconRenderer
implements MergableGutterIconRenderer,
DumbAware,
IGutterIconRendererWithHover {
    @NotNull
    private final RangeHighlighter highlighter;
    @NotNull
    private final GutterMarkInfo info;
    @NotNull
    private final GutterMarkActionModel gutterMarkActionModel;
    @NotNull
    private final GutterMarkHoverModel gutterMarkHoverModel;
    @NotNull
    private final GutterMarkDnDModel dndModel;
    @NotNull
    private final FrontendStringTooltipCalculator tooltipCalculator;

    public FrontendGutterIconRenderer(@NotNull RangeHighlighter highlighter2, @NotNull GutterMarkInfo info2, @NotNull GutterMarkActionModel gutterMarkActionModel, @NotNull GutterMarkHoverModel gutterMarkHoverModel, @NotNull FrontendTooltipProvider tooltipProvider, @NotNull GutterMarkDnDModel dndModel) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Intrinsics.checkNotNullParameter((Object)gutterMarkActionModel, (String)"gutterMarkActionModel");
        Intrinsics.checkNotNullParameter((Object)gutterMarkHoverModel, (String)"gutterMarkHoverModel");
        Intrinsics.checkNotNullParameter((Object)tooltipProvider, (String)"tooltipProvider");
        Intrinsics.checkNotNullParameter((Object)dndModel, (String)"dndModel");
        this.highlighter = highlighter2;
        this.info = info2;
        this.gutterMarkActionModel = gutterMarkActionModel;
        this.gutterMarkHoverModel = gutterMarkHoverModel;
        this.dndModel = dndModel;
        this.tooltipCalculator = new FrontendStringTooltipCalculator(this.info.getId(), tooltipProvider);
    }

    @NotNull
    public final RangeHighlighter getHighlighter() {
        return this.highlighter;
    }

    @NotNull
    public final GutterMarkInfo getInfo() {
        return this.info;
    }

    @NotNull
    protected final GutterMarkActionModel getGutterMarkActionModel() {
        return this.gutterMarkActionModel;
    }

    @NotNull
    public final GutterMarkDnDModel getDndModel() {
        return this.dndModel;
    }

    @NotNull
    public Icon getIcon() {
        return this.info.getIcon();
    }

    @Nullable
    public String getTooltipText() {
        return this.tooltipCalculator.getTooltip();
    }

    @Override
    public void onHover(@NotNull HoverEventType hoverEvent) {
        Intrinsics.checkNotNullParameter((Object)hoverEvent, (String)"hoverEvent");
        RdGutterHoverRequest request2 = new RdGutterHoverRequest(this.info.getId(), hoverEvent);
        this.gutterMarkHoverModel.getHover().fire((Object)request2);
    }

    @Nullable
    public AnAction getClickAction() {
        if (this.info.getLeftAction() == null) {
            return null;
        }
        Icon icon = this.getIcon();
        return (AnAction)new DumbAware(this, icon){
            final /* synthetic */ FrontendGutterIconRenderer this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
                if (editor2 == null) {
                    return;
                }
                Editor editor3 = editor2;
                if (!this.this$0.getHighlighter().isValid()) {
                    return;
                }
                TextRange rangeToCollectBulbs = this.this$0.calcSurroundRange(editor3, this.this$0.getHighlighter().getStartOffset());
                RdGutterExecutionRequest request2 = new RdGutterExecutionRequest(this.this$0.getInfo().getId(), rangeToCollectBulbs.getStartOffset(), rangeToCollectBulbs.getEndOffset());
                this.this$0.getGutterMarkActionModel().getLeftClick().fire((Object)request2);
            }
        };
    }

    @Nullable
    public ActionGroup getPopupMenuActions() {
        return null;
    }

    @NotNull
    public final TextRange calcSurroundRange(@NotNull Editor editor2, int offset) {
        FoldingModel foldingModel;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        SoftWrap wrap = editor2.getSoftWrapModel().getSoftWrap(offset);
        if (wrap != null) {
            new TextRange(wrap.getStart(), wrap.getEnd());
        }
        FoldingModelImpl foldingModel2 = (foldingModel = editor2.getFoldingModel()) instanceof FoldingModelImpl ? (FoldingModelImpl)foldingModel : null;
        return new TextRange(this.calculateLeftOffset(offset, editor2, foldingModel2), this.calculateRightOffset(offset, editor2, foldingModel2));
    }

    private final int calculateRightOffset(int offset, Editor editor2, FoldingModelImpl foldingModelImpl) {
        int lineEndOffset = EditorUtil.getNotFoldedLineEndOffset((Editor)editor2, (int)offset);
        if (foldingModelImpl == null) {
            return lineEndOffset;
        }
        List list = foldingModelImpl.getRegionsOverlappingWith(offset, lineEndOffset);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRegionsOverlappingWith(...)");
        List regionsOverlappingWithRange = list;
        Iterator iterator2 = regionsOverlappingWithRange.iterator();
        while (iterator2.hasNext()) {
            int n = offset + 1;
            FoldRegion foldRegion = (FoldRegion)iterator2.next();
            int n2 = foldRegion.getStartOffset();
            boolean bl = n <= n2 ? n2 < lineEndOffset : false;
            if (!bl || foldRegion.isExpanded()) continue;
            return foldRegion.getStartOffset();
        }
        return lineEndOffset;
    }

    private final int calculateLeftOffset(int offset, Editor editor2, FoldingModelImpl foldingModelImpl) {
        int lineStartOffset = EditorUtil.getNotFoldedLineStartOffset((Editor)editor2, (int)offset);
        if (foldingModelImpl == null) {
            return lineStartOffset;
        }
        List list = foldingModelImpl.getRegionsOverlappingWith(lineStartOffset, offset);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRegionsOverlappingWith(...)");
        List regionsOverlappingWithRange = list;
        CollectionsKt.sortWith((List)regionsOverlappingWithRange, (arg_0, arg_1) -> FrontendGutterIconRenderer.calculateLeftOffset$lambda$0(calculateLeftOffset.1.INSTANCE, arg_0, arg_1));
        Iterator iterator2 = regionsOverlappingWithRange.iterator();
        while (iterator2.hasNext()) {
            int n = lineStartOffset + 1;
            FoldRegion foldRegion = (FoldRegion)iterator2.next();
            int n2 = foldRegion.getEndOffset();
            boolean bl = n <= n2 ? n2 < offset : false;
            if (!bl || foldRegion.isExpanded()) continue;
            return foldRegion.getEndOffset();
        }
        return lineStartOffset;
    }

    public boolean isNavigateAction() {
        return this.info.isNavigatable();
    }

    @NotNull
    public GutterIconRenderer.Alignment getAlignment() {
        return this.info.getAlignment() == GutterIconRenderer.Alignment.LINE_NUMBERS && (!ExperimentalUI.Companion.isNewUI() || !EditorUtil.isBreakPointsOnLineNumbers()) ? GutterIconRenderer.Alignment.RIGHT : this.info.getAlignment();
    }

    @Override
    public int getWeight() {
        return this.info.getWeight().getFrontendWeight();
    }

    @Override
    public int compareTo(@NotNull MergableGutterIconRenderer other) {
        int cmp;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof FrontendGutterIconRenderer && (cmp = GutterMarkWeight.Companion.compareByBackend(this.info.getWeight(), ((FrontendGutterIconRenderer)other).info.getWeight())) != 0) {
            return cmp;
        }
        return MergableGutterIconRenderer.super.compareTo(other);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FrontendGutterIconRenderer)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.info, (Object)((FrontendGutterIconRenderer)other).info);
    }

    public int hashCode() {
        return this.info.hashCode();
    }

    private static final int calculateLeftOffset$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

