/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.diagnostics;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.MarkupDiagnostics;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.daemon.diagnostics.MarkupDiagnosticsExtension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdclient/daemon/diagnostics/ToggleMarkupDebugModeAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.rd.client"})
public final class ToggleMarkupDebugModeAction
extends AnAction
implements DumbAware {
    public ToggleMarkupDebugModeAction() {
        super("Toggle Markup Debug Mode");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Document document = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        MarkupDiagnostics markupDiagnostics = MarkupDiagnosticsExtension.Companion.getDiagnostics(project3, document);
        if (markupDiagnostics == null) {
            return;
        }
        MarkupDiagnostics diagnostics = markupDiagnostics;
        if (!InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)diagnostics.isDebugMode()))) {
            presentation2.setEnabled(false);
            return;
        }
        presentation2.setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Document document = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        MarkupDiagnostics markupDiagnostics = MarkupDiagnosticsExtension.Companion.getDiagnostics(project3, document);
        Intrinsics.checkNotNull((Object)markupDiagnostics);
        MarkupDiagnostics diagnostics = markupDiagnostics;
        boolean value2 = BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)diagnostics.isDebugMode()));
        this.getTemplatePresentation().setText((value2 ? "Disable" : "Enable") + " Debug Mode");
        diagnostics.isDebugMode().set((Object)(!value2 ? 1 : 0));
    }
}

