/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.ide.model.highlighterRegistration.IdeaTextAttributesKey;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.daemon.FrontendHighlighterSuppressionHandler;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupSuppressor;
import com.jetbrains.rdclient.daemon.HighlighterRangeRepairer;
import com.jetbrains.rdclient.daemon.MarkupSuppressionKind;
import com.jetbrains.rdclient.daemon.RecyclingHighlighterStorage;
import com.jetbrains.rdclient.daemon.suppressors.ProtocolSuppressableMarkupModel;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 :2\u00020\u0001:\u0002:;B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u0016\u0010\u001f\u001a\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0016\u0010#\u001a\u00020\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0!H\u0002J\u0016\u0010&\u001a\u00020\u001a2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020,H\u0007J\b\u0010-\u001a\u00020\u001aH\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\"H\u0002J\b\u00101\u001a\u00020\u001aH\u0002J\u001a\u00102\u001a\u0004\u0018\u00010*2\u0006\u00103\u001a\u00020*2\u0006\u00104\u001a\u00020\u000eH\u0002J\u0016\u00105\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00106\u001a\u00020,J\u0016\u00107\u001a\u00020\u001a2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001a09H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "markupAdapter", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "highlighterRepairer", "Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;", "storage", "Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "suppressor", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;)V", "<set-?>", "", "isUpdating", "()Z", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getMarkupAdapter", "()Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getStorage", "()Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "bind", "", "protocolMarkup", "Lcom/jetbrains/rdclient/daemon/suppressors/ProtocolSuppressableMarkupModel;", "bind$intellij_rd_client", "flushHighlighters", "highlightersAdded", "added", "", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "highlightersRemoved", "removed", "", "highlightersUpdated", "updated", "isReplaced", "highlighterModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "isSuppressed", "Lcom/jetbrains/rdclient/daemon/MarkupSuppressionKind;", "queueUpdateIfNeed", "recycle", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "element", "removeAllHighlighters", "repair", "model", "trackInvalid", "suppress", "suppressionKind", "update", "block", "Lkotlin/Function0;", "Companion", "MergingUpdateTask", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendMarkupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,311:1\n1747#2,3:312\n1#3:315\n13#4:316\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor\n*L\n147#1:312,3\n284#1:316\n*E\n"})
public final class FrontendMarkupContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final FrontendMarkupAdapter markupAdapter;
    @NotNull
    private final HighlighterRangeRepairer highlighterRepairer;
    @NotNull
    private final RecyclingHighlighterStorage storage;
    @NotNull
    private final FrontendMarkupSuppressor suppressor;
    private boolean isUpdating;
    @NotNull
    private final MergingUpdateQueue mergingUpdateQueue;
    @NotNull
    private static final Logger logger;

    public FrontendMarkupContributor(@NotNull Lifetime lifetime2, @NotNull FrontendMarkupAdapter markupAdapter, @NotNull HighlighterRangeRepairer highlighterRepairer, @NotNull RecyclingHighlighterStorage storage, @NotNull FrontendMarkupSuppressor suppressor2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)markupAdapter, (String)"markupAdapter");
        Intrinsics.checkNotNullParameter((Object)highlighterRepairer, (String)"highlighterRepairer");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)suppressor2, (String)"suppressor");
        this.lifetime = lifetime2;
        this.markupAdapter = markupAdapter;
        this.highlighterRepairer = highlighterRepairer;
        this.storage = storage;
        this.suppressor = suppressor2;
        this.mergingUpdateQueue = new MergingUpdateQueue("FrontendMarkupContributor.mergingUpdateQueue", 50, true, null, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final FrontendMarkupAdapter getMarkupAdapter() {
        return this.markupAdapter;
    }

    @NotNull
    public final RecyclingHighlighterStorage getStorage() {
        return this.storage;
    }

    public final boolean isUpdating() {
        return this.isUpdating;
    }

    private final void queueUpdateIfNeed() {
        if (this.suppressor.isSuppressed$intellij_rd_client() == MarkupSuppressionKind.NONE) {
            ModalityState modalityState = ModalityState.current();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
            this.mergingUpdateQueue.queue((Update)new MergingUpdateTask(modalityState));
        }
    }

    private final void flushHighlighters() {
        this.update((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                List<RangeHighlighterEx> notDeleted;
                Logger $this$trace$iv;
                HighlighterModel repairedModel;
                List extensions;
                Logger logger;
                void $this$trace$iv2;
                FrontendMarkupContributor.access$getLogger$cp().debug("highlighter flush triggered!");
                Logger logger2 = FrontendMarkupContributor.access$getLogger$cp();
                FrontendMarkupContributor frontendMarkupContributor = this.this$0;
                boolean bl = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    logger = $this$trace$iv2;
                    boolean bl2 = false;
                    logger.trace("highlighters in document:" + frontendMarkupContributor.getMarkupAdapter().getAllHighlighters().length);
                }
                List<Map.Entry<RangeHighlighterEx, HighlighterElement>> notUpdated = this.this$0.getStorage().flushNotUpdated();
                if (!((Collection)notUpdated).isEmpty()) {
                    for (Map.Entry entry2 : notUpdated) {
                        RangeHighlighterEx highlighter2 = (RangeHighlighterEx)entry2.getKey();
                        HighlighterElement element = (HighlighterElement)entry2.getValue();
                        HighlighterModel model = element.component1();
                        extensions = element.component2();
                        repairedModel = FrontendMarkupContributor.access$repair(this.this$0, model, false);
                        if (repairedModel == null) {
                            FrontendMarkupContributor.access$getLogger$cp().warn("Received unrepairable update for highlighter during flush. Model: " + HighlightersUtilKt.prettyPrint(model));
                            continue;
                        }
                        this.this$0.getMarkupAdapter().updateHighlighter(highlighter2, new HighlighterElement(repairedModel, extensions));
                    }
                }
                ArrayList<HighlighterElement> notReused = new ArrayList<HighlighterElement>();
                List<HighlighterElement> list = this.this$0.getStorage().flushNotRegistered();
                if (!((Collection)list).isEmpty()) {
                    Logger $this$trace$iv3 = FrontendMarkupContributor.access$getLogger$cp();
                    boolean $i$f$trace322 = false;
                    if ($this$trace$iv3.isTraceEnabled()) {
                        logger = $this$trace$iv3;
                        boolean bl3 = false;
                        logger.trace("Flushing to markup " + list.size() + " not registered highlighters");
                    }
                    for (HighlighterElement $i$f$trace322 : list) {
                        HighlighterModel highlighterModel = $i$f$trace322.component1();
                        extensions = $i$f$trace322.component2();
                        repairedModel = FrontendMarkupContributor.access$repair(this.this$0, highlighterModel, true);
                        if (repairedModel == null) {
                            FrontendMarkupContributor.access$getLogger$cp().warn("Invalid highlighters are presented in notRegistered highlighters during flush");
                            continue;
                        }
                        HighlighterElement repairedElement = new HighlighterElement(repairedModel, extensions);
                        RangeHighlighterEx recycled = FrontendMarkupContributor.access$recycle(this.this$0, repairedElement);
                        if (recycled != null) continue;
                        notReused.add(repairedElement);
                    }
                    int reused = list.size() - notReused.size();
                    $this$trace$iv = FrontendMarkupContributor.access$getLogger$cp();
                    boolean $i$f$trace4 = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        logger = $this$trace$iv;
                        boolean bl4 = false;
                        logger.trace("Reused " + reused + " highlighters during flush");
                    }
                }
                if (!((Collection)(notDeleted = this.this$0.getStorage().flushNotDeleted())).isEmpty()) {
                    $this$trace$iv = FrontendMarkupContributor.access$getLogger$cp();
                    boolean $i$f$trace5 = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        logger = $this$trace$iv;
                        boolean bl5 = false;
                        logger.trace("Deleting " + notDeleted.size() + " highlighters from markup");
                    }
                    this.this$0.getMarkupAdapter().bulkRemoveHighlighters(notDeleted);
                }
                if (notReused.size() != 0) {
                    $this$trace$iv = FrontendMarkupContributor.access$getLogger$cp();
                    boolean $i$f$trace6 = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        logger = $this$trace$iv;
                        boolean bl6 = false;
                        logger.trace("Registering last portion of " + notReused.size() + " highlighters which have failed at reusing");
                    }
                    List<RangeHighlighterEx> added2 = this.this$0.getMarkupAdapter().bulkAddHighlighters((List<HighlighterElement>)notReused);
                    int n = added2.size();
                    for (int i = 0; i < n; ++i) {
                        this.this$0.getStorage().addHighlighter(((HighlighterElement)notReused.get(i)).getHighlighter().getId(), added2.get(i));
                    }
                }
                FrontendMarkupContributor.access$getHighlighterRepairer$p(this.this$0).shrinkHistory();
            }
        }));
    }

    private final void highlightersAdded(List<HighlighterElement> added2) {
        this.update((Function0<Unit>)((Function0)new Function0<Unit>(added2, this){
            final /* synthetic */ List<HighlighterElement> $added;
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.$added = $added;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                List repairedModels = new ArrayList<E>();
                for (HighlighterElement element : this.$added) {
                    HighlighterModel repairedModel;
                    boolean bl;
                    HighlighterModel highlighterModel = element.getHighlighter();
                    List extensions = element.getExtensions();
                    boolean bl2 = bl = this.this$0.getStorage().get(highlighterModel.getId()) == null;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-FrontendMarkupContributor$highlightersAdded$1$22 = false;
                        String $i$a$-assert-FrontendMarkupContributor$highlightersAdded$1$22 = "Multiple highlighter registration on IDEA-side! id: " + highlighterModel.getId() + " model: " + HighlightersUtilKt.prettyPrint(highlighterModel);
                        throw new AssertionError((Object)$i$a$-assert-FrontendMarkupContributor$highlightersAdded$1$22);
                    }
                    if (FrontendMarkupContributor.access$repair(this.this$0, highlighterModel, true) == null || FrontendMarkupContributor.access$isReplaced(this.this$0, highlighterModel)) continue;
                    HighlighterElement repairedElement = new HighlighterElement(repairedModel, extensions);
                    if (FrontendMarkupContributor.access$getSuppressor$p(this.this$0).shouldSuppressAddition(highlighterModel.getProperties())) {
                        RangeHighlighterEx rangeHighlighterEx = FrontendMarkupContributor.access$recycle(this.this$0, repairedElement);
                        if (rangeHighlighterEx == null) {
                            FrontendMarkupContributor $this$invoke_u24lambda_u241 = this.this$0;
                            boolean bl3 = false;
                            $this$invoke_u24lambda_u241.getStorage().queueRegistration(element);
                            FrontendMarkupContributor.access$queueUpdateIfNeed($this$invoke_u24lambda_u241);
                            rangeHighlighterEx = Unit.INSTANCE;
                        }
                        continue;
                    }
                    repairedModels.add(repairedElement);
                }
                if (repairedModels.isEmpty()) {
                    return;
                }
                List<RangeHighlighterEx> bulkAdded = this.this$0.getMarkupAdapter().bulkAddHighlighters(repairedModels);
                int n = bulkAdded.size();
                for (int i = 0; i < n; ++i) {
                    this.this$0.getStorage().addHighlighter(((HighlighterElement)repairedModels.get(i)).getHighlighter().getId(), bulkAdded.get(i));
                }
            }
        }));
    }

    private final boolean isReplaced(HighlighterModel highlighterModel) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = FrontendHighlighterSuppressionHandler.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FrontendHighlighterSuppressionHandler it = (FrontendHighlighterSuppressionHandler)element$iv;
                    boolean bl2 = false;
                    if (!it.shouldSuppress(highlighterModel, this.markupAdapter.getDocument())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void highlightersUpdated(List<HighlighterElement> updated) {
        this.update((Function0<Unit>)((Function0)new Function0<Unit>(updated, this){
            final /* synthetic */ List<HighlighterElement> $updated;
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.$updated = $updated;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                for (HighlighterElement element : this.$updated) {
                    if (this.this$0.getStorage().updateRegistration(element)) continue;
                    RangeHighlighterEx highlighter2 = this.this$0.getStorage().get(element.getHighlighter().getId());
                    if (highlighter2 == null) {
                        FrontendMarkupContributor.access$getLogger$cp().warn("Received update for not registered highlighter " + HighlightersUtilKt.prettyPrint(element.getHighlighter()));
                        continue;
                    }
                    if (FrontendMarkupContributor.access$getSuppressor$p(this.this$0).shouldSuppressUpdate()) {
                        this.this$0.getStorage().queueUpdate(highlighter2, element);
                        FrontendMarkupContributor.access$queueUpdateIfNeed(this.this$0);
                        continue;
                    }
                    HighlighterModel repairedModel = FrontendMarkupContributor.access$repair(this.this$0, element.getHighlighter(), false);
                    if (repairedModel == null) {
                        FrontendMarkupContributor.access$getLogger$cp().warn("Received unrepairable update for highlighter. Model: " + HighlightersUtilKt.prettyPrint(element.getHighlighter()));
                        continue;
                    }
                    this.this$0.getMarkupAdapter().updateHighlighter(highlighter2, new HighlighterElement(repairedModel, element.getExtensions()));
                }
            }
        }));
    }

    private final HighlighterModel repair(HighlighterModel model, boolean trackInvalid) {
        HighlighterModel highlighterModel = this.highlighterRepairer.repair(model);
        if (highlighterModel != null) {
            HighlighterModel it = highlighterModel;
            boolean bl = false;
            return it;
        }
        if (trackInvalid) {
            this.storage.addInvalidHighlighter(model);
        }
        return null;
    }

    private final RangeHighlighterEx recycle(HighlighterElement element) {
        RangeHighlighterEx recycledHighlighter = this.storage.recycle(element.getHighlighter());
        if (recycledHighlighter != null) {
            this.markupAdapter.updateHighlighter(recycledHighlighter, element);
        }
        return recycledHighlighter;
    }

    private final void highlightersRemoved(List<Long> removed) {
        this.update((Function0<Unit>)((Function0)new Function0<Unit>(removed, this){
            final /* synthetic */ List<Long> $removed;
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.$removed = $removed;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                List toRemove = new ArrayList<E>();
                Iterator<Long> iterator2 = this.$removed.iterator();
                while (iterator2.hasNext()) {
                    RangeHighlighterEx highlighter2;
                    long id = ((Number)iterator2.next()).longValue();
                    if (this.this$0.getStorage().remove(id) == null) continue;
                    if (FrontendMarkupContributor.access$getSuppressor$p(this.this$0).shouldSuppressDeletion(UtilKt.getBackendProperties((RangeHighlighter)((RangeHighlighter)highlighter2)))) {
                        this.this$0.getStorage().queueDeletion(highlighter2);
                        FrontendMarkupContributor.access$queueUpdateIfNeed(this.this$0);
                        continue;
                    }
                    toRemove.add(highlighter2);
                }
                if (toRemove.isEmpty()) {
                    return;
                }
                this.this$0.getMarkupAdapter().bulkRemoveHighlighters(toRemove);
            }
        }));
    }

    private final void removeAllHighlighters() {
        this.update((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                boolean any;
                block3: {
                    boolean bl;
                    void $this$trace$iv;
                    List allHighlighters = CollectionsKt.plus(this.this$0.getStorage().getRegisteredHighlighters(), (Iterable)this.this$0.getStorage().flushNotDeleted());
                    FrontendMarkupContributor.access$getLogger$cp().debug("Cleaning highlighter storage. Total amount " + allHighlighters.size());
                    this.this$0.getMarkupAdapter().bulkRemoveHighlighters(allHighlighters);
                    this.this$0.getStorage().clear();
                    Logger logger = FrontendMarkupContributor.access$getLogger$cp();
                    FrontendMarkupContributor frontendMarkupContributor = this.this$0;
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        void var10_6 = $this$trace$iv;
                        boolean bl2 = false;
                        var10_6.trace("storage: " + frontendMarkupContributor.getStorage());
                    }
                    RangeHighlighterEx[] $this$any$iv = this.this$0.getMarkupAdapter().getAllHighlighters();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        RangeHighlighterEx element$iv;
                        RangeHighlighterEx it = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        if (!HighlightersUtilKt.isBackendHighlighter((RangeHighlighter)it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = any = false;
                }
                if (any) {
                    FrontendMarkupContributor.access$getLogger$cp().error("backend highlighters present in Markup model after cleaning");
                }
            }
        }));
    }

    public final void suppress(@NotNull Lifetime lifetime2, @NotNull MarkupSuppressionKind suppressionKind) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)suppressionKind), (String)"suppressionKind");
        this.suppressor.suppress(lifetime2, suppressionKind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void update(Function0<Unit> block) {
        try {
            this.isUpdating = true;
            block.invoke();
        }
        finally {
            this.isUpdating = false;
        }
    }

    public final void bind$intellij_rd_client(@NotNull Lifetime lifetime2, @NotNull ProtocolSuppressableMarkupModel protocolMarkup) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)protocolMarkup, (String)"protocolMarkup");
        protocolMarkup.getHighlightersRemoved().advise(lifetime2, (Function1)new Function1<List<? extends Long>, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<Long> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Logger $this$trace$iv = FrontendMarkupContributor.access$getLogger$cp();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("RdMarkupModel.highlightersRemoved fired: count=" + it.size());
                }
                FrontendMarkupContributor.access$highlightersRemoved(this.this$0, it);
            }
        });
        protocolMarkup.getHighlightersAdded().advise(lifetime2, (Function1)new Function1<List<? extends HighlighterElement>, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<HighlighterElement> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Logger $this$trace$iv = FrontendMarkupContributor.access$getLogger$cp();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    void $this$mapTo$iv$iv;
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    StringBuilder stringBuilder = new StringBuilder().append("RdMarkupModel.highlightersAdded fired: count=" + it.size());
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                    StringBuilder stringBuilder2 = stringBuilder.append('\n');
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                    StringBuilder stringBuilder3 = stringBuilder2.append("Received highlighters from backend.  Highlighter breakdown:");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                    StringBuilder stringBuilder4 = stringBuilder3.append('\n');
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                    StringBuilder result2 = stringBuilder4;
                    Iterable $this$map$iv = it;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void element;
                        HighlighterElement highlighterElement = (HighlighterElement)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        HighlighterModel highlighter2 = element.getHighlighter();
                        result2.append(highlighter2.getProperties().getAttributeId()).append(":");
                        com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.prettyPrint$default(FrontendMarkupContributor.Companion, highlighter2.getTextAttributesKey(), result2, 0, 2, null);
                        collection.add(Unit.INSTANCE);
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                    String string = result2.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    logger.trace(string);
                }
                FrontendMarkupContributor.access$highlightersAdded(this.this$0, it);
            }
        });
        protocolMarkup.getHighlightersUpdated().advise(lifetime2, (Function1)new Function1<List<? extends HighlighterElement>, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<HighlighterElement> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Logger $this$trace$iv = FrontendMarkupContributor.access$getLogger$cp();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("RdMarkupModel.highlightersUpdated fired: count=" + it.size());
                }
                FrontendMarkupContributor.access$highlightersUpdated(this.this$0, it);
            }
        });
        protocolMarkup.getHighlightersCleared().advise(lifetime2, (Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger $this$trace$iv = FrontendMarkupContributor.access$getLogger$cp();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("RdMarkupModel.highlightersCleared fired. call removeAllHighlighters()");
                }
                FrontendMarkupContributor.access$removeAllHighlighters(this.this$0);
            }
        });
        this.suppressor.released(lifetime2, (Function1<? super Lifetime, Unit>)((Function1)new Function1<Lifetime, Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Lifetime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Logger $this$trace$iv = FrontendMarkupContributor.access$getLogger$cp();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("suppressor is released. call flushHighlighters()");
                }
                FrontendMarkupContributor.access$flushHighlighters(this.this$0);
            }
        }));
        lifetime2.onTermination((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrontendMarkupContributor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Logger $this$trace$iv = FrontendMarkupContributor.access$getLogger$cp();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("RdMarkupModel.highlightersCleared fired. call removeAllHighlighters()");
                }
                FrontendMarkupContributor.access$removeAllHighlighters(this.this$0);
            }
        });
        protocolMarkup.bind(lifetime2);
    }

    @TestOnly
    @NotNull
    public final MarkupSuppressionKind isSuppressed() {
        return this.suppressor.isSuppressed$intellij_rd_client();
    }

    public static final /* synthetic */ HighlighterModel access$repair(FrontendMarkupContributor $this, HighlighterModel model, boolean trackInvalid) {
        return $this.repair(model, trackInvalid);
    }

    public static final /* synthetic */ RangeHighlighterEx access$recycle(FrontendMarkupContributor $this, HighlighterElement element) {
        return $this.recycle(element);
    }

    public static final /* synthetic */ HighlighterRangeRepairer access$getHighlighterRepairer$p(FrontendMarkupContributor $this) {
        return $this.highlighterRepairer;
    }

    public static final /* synthetic */ boolean access$isReplaced(FrontendMarkupContributor $this, HighlighterModel highlighterModel) {
        return $this.isReplaced(highlighterModel);
    }

    public static final /* synthetic */ void access$queueUpdateIfNeed(FrontendMarkupContributor $this) {
        $this.queueUpdateIfNeed();
    }

    public static final /* synthetic */ void access$highlightersRemoved(FrontendMarkupContributor $this, List removed) {
        $this.highlightersRemoved(removed);
    }

    public static final /* synthetic */ void access$highlightersAdded(FrontendMarkupContributor $this, List added2) {
        $this.highlightersAdded(added2);
    }

    public static final /* synthetic */ void access$highlightersUpdated(FrontendMarkupContributor $this, List updated) {
        $this.highlightersUpdated(updated);
    }

    public static final /* synthetic */ void access$removeAllHighlighters(FrontendMarkupContributor $this) {
        $this.removeAllHighlighters();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendMarkupContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendMarkupContributor.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\b\b\u0002\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "prettyPrint", "", "Lcom/jetbrains/ide/model/highlighterRegistration/TextAttributesKeyModel;", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "depth", "", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public final void prettyPrint(@Nullable TextAttributesKeyModel $this$prettyPrint, @NotNull StringBuilder result2, int depth) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            if ($this$prettyPrint == null) {
                StringBuilder stringBuilder = result2.append("[NULL KEY]");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                return;
            }
            if (!($this$prettyPrint instanceof IdeaTextAttributesKey)) {
                StringBuilder stringBuilder = result2.append("[NON-IDEA KEY]");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                return;
            }
            String indent = "  ";
            StringBuilder stringBuilder = result2.append($this$prettyPrint.getExternalName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            StringBuilder stringBuilder2 = stringBuilder;
            StringBuilder stringBuilder3 = stringBuilder2.append(" (");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.prettyPrint$indent(depth, result2, indent).append(indent).append("fallback: ");
            TextAttributesKeyModel fallback = ((IdeaTextAttributesKey)$this$prettyPrint).getFallback();
            if (fallback == null) {
                StringBuilder stringBuilder4 = result2.append("NULL");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
            } else {
                this.prettyPrint(fallback, result2, depth + 1);
            }
            StringBuilder stringBuilder5 = com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.prettyPrint$indent(depth, result2, indent).append(")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        }

        public static /* synthetic */ void prettyPrint$default(Companion companion, TextAttributesKeyModel textAttributesKeyModel, StringBuilder stringBuilder, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            companion.prettyPrint(textAttributesKeyModel, stringBuilder, n);
        }

        private static final StringBuilder prettyPrint$indent(int $depth, StringBuilder $result, String indent) {
            for (int i = 0; i < $depth; ++i) {
                $result.append(indent);
            }
            return $result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask;", "Lcom/intellij/util/ui/update/Update;", "modality", "Lcom/intellij/openapi/application/ModalityState;", "(Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;Lcom/intellij/openapi/application/ModalityState;)V", "canEat", "", "update", "run", "", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendMarkupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,311:1\n65#2,4:312\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask\n*L\n41#1:312,4\n*E\n"})
    private final class MergingUpdateTask
    extends Update {
        @NotNull
        private final ModalityState modality;

        public MergingUpdateTask(ModalityState modality) {
            Intrinsics.checkNotNullParameter((Object)modality, (String)"modality");
            super((Object)modality);
            this.modality = modality;
        }

        public void run() {
            ApplicationKt.getApplication().invokeLater(() -> MergingUpdateTask.run$lambda$1(FrontendMarkupContributor.this, this), this.modality);
        }

        public boolean canEat(@NotNull Update update2) {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            if (!(update2 instanceof MergingUpdateTask)) {
                return false;
            }
            ModalityState otherModality = ((MergingUpdateTask)update2).modality;
            return Intrinsics.areEqual((Object)this.modality, (Object)otherModality) || this.modality.dominates(otherModality);
        }

        private static final void run$lambda$1(FrontendMarkupContributor this$0, MergingUpdateTask this$1) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
            if (this$0.suppressor.isSuppressed$intellij_rd_client() == MarkupSuppressionKind.NONE && RLifetimeKt.isAlive((Lifetime)this$0.getLifetime())) {
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("MergingUpdateTask.run&invokeLater: call flushHighlighters(). modality: " + this$1.modality);
                }
                this$0.flushHighlighters();
            }
        }
    }
}

