/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.gcov;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageModel;
import com.jetbrains.cidr.execution.coverage.gcov.GCovUtils;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J5\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageParser;", "", "()V", "doLoadCoverageModels", "", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel;", "gcovFiles", "Ljava/nio/file/Path;", "workingDirectory", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "parse", "", "rootDirectory", "(Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lcom/intellij/openapi/project/Project;)[Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel;", "intellij.cidr.coverage"})
@SourceDebugExtension(value={"SMAP\nGCovCoverageParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCovCoverageParser.kt\ncom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageParser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,43:1\n37#2,2:44\n*S KotlinDebug\n*F\n+ 1 GCovCoverageParser.kt\ncom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageParser\n*L\n23#1:44,2\n*E\n"})
public final class GCovCoverageParser {
    @NotNull
    public final GCovCoverageModel[] parse(@NotNull File rootDirectory, @Nullable File workingDirectory, @NotNull CidrToolEnvironment environment, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref modelsRef = ref;
        HostMachine host = environment.getHostMachine();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GCovCoverageParser.parse$lambda$0(rootDirectory, host, modelsRef, this, workingDirectory, project, environment), CidrCoverageBundle.message("coverage.reading.output.data", new Object[0]), true, project);
        Object object = modelsRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Collection $this$toTypedArray$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new GCovCoverageModel[0]);
    }

    private final List<GCovCoverageModel> doLoadCoverageModels(List<? extends Path> gcovFiles, File workingDirectory, Project project, CidrToolEnvironment environment) {
        CidrCoverageLogKt.getCidrCoverageLog().info("Total number of gcov files: " + gcovFiles.size());
        List<GCovCoverageModel> list = gcovFiles.parallelStream().map(arg_0 -> GCovCoverageParser.doLoadCoverageModels$lambda$1((Function1)new Function1<Path, GCovCoverageModel>(workingDirectory, project, environment){
            final /* synthetic */ File $workingDirectory;
            final /* synthetic */ Project $project;
            final /* synthetic */ CidrToolEnvironment $environment;
            {
                this.$workingDirectory = $workingDirectory;
                this.$project = $project;
                this.$environment = $environment;
                super(1);
            }

            @Nullable
            public final GCovCoverageModel invoke(Path it) {
                try {
                    Intrinsics.checkNotNull((Object)it);
                    return GCovCoverageModel.Companion.loadFrom(it, this.$workingDirectory, this.$project, this.$environment);
                }
                catch (Exception e) {
                    CidrCoverageLogKt.getCidrCoverageLog().warn("Failed to parse gcov file: " + e.getMessage());
                    return null;
                }
            }
        }, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return CollectionsKt.filterNotNull((Iterable)list);
    }

    private static final void parse$lambda$0(File $rootDirectory, HostMachine $host, Ref $modelsRef, GCovCoverageParser this$0, File $workingDirectory, Project $project, CidrToolEnvironment $environment) {
        Intrinsics.checkNotNullParameter((Object)$rootDirectory, (String)"$rootDirectory");
        Intrinsics.checkNotNullParameter((Object)$modelsRef, (String)"$modelsRef");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$environment, (String)"$environment");
        String[] stringArray = new String[]{$rootDirectory.getPath(), "coverage"};
        String string = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String coverageDirectory = string;
        Intrinsics.checkNotNull((Object)$host);
        Path path = $host.getPath(coverageDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        List<Path> gcovFiles = GCovUtils.Companion.getGCovFiles($host, path, false);
        $modelsRef.set(this$0.doLoadCoverageModels(gcovFiles, $workingDirectory, $project, $environment));
    }

    private static final GCovCoverageModel doLoadCoverageModels$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GCovCoverageModel)$tmp0.invoke(p0);
    }
}

