/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.gcov;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel;", "", "filePath", "", "lines", "", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovLineModel;", "(Ljava/lang/String;Ljava/util/List;)V", "getFilePath", "()Ljava/lang/String;", "getLines", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "GCovBlockModel", "GCovBranchModel", "GCovLineModel", "intellij.cidr.coverage"})
public final class GCovCoverageModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String filePath;
    @NotNull
    private final List<GCovLineModel> lines;
    @NotNull
    private static final String HITS_PATTERN = "#####|=====|\\$\\$\\$\\$\\$|%%%%%|-|[0-9]+";
    @NotNull
    private static final Regex PREAMBLE_REGEX = new Regex("-:\\s*0:(.+?):(.+)");
    @NotNull
    private static final Regex LINE_EXECUTION_REGEX = new Regex("(#####|=====|\\$\\$\\$\\$\\$|%%%%%|-|[0-9]+)\\*?:\\s*([0-9]+):(.*)");
    @NotNull
    private static final Regex BLOCK_REGEX = new Regex("(#####|=====|\\$\\$\\$\\$\\$|%%%%%|-|[0-9]+):\\s*([0-9]+)-block\\s+([0-9]+)");
    @NotNull
    private static final Regex BRANCH_TAKEN_REGEX = new Regex("branch\\s+([0-9]+)\\s+taken\\s+([0-9]+)(.*)");
    @NotNull
    private static final Regex BRANCH_NEVER_EXECUTED_REGEX = new Regex("branch\\s+([0-9]+)\\s+never executed");
    @NotNull
    private static final Regex TEMPLATE_SPECIALIZATION_REGEX = new Regex("------------------|.*:");

    public GCovCoverageModel(@NotNull String filePath, @NotNull List<GCovLineModel> lines) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        this.filePath = filePath;
        this.lines = lines;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    @NotNull
    public final List<GCovLineModel> getLines() {
        return this.lines;
    }

    @NotNull
    public final String component1() {
        return this.filePath;
    }

    @NotNull
    public final List<GCovLineModel> component2() {
        return this.lines;
    }

    @NotNull
    public final GCovCoverageModel copy(@NotNull String filePath, @NotNull List<GCovLineModel> lines) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        return new GCovCoverageModel(filePath, lines);
    }

    public static /* synthetic */ GCovCoverageModel copy$default(GCovCoverageModel gCovCoverageModel, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = gCovCoverageModel.filePath;
        }
        if ((n & 2) != 0) {
            list = gCovCoverageModel.lines;
        }
        return gCovCoverageModel.copy(string, list);
    }

    @NotNull
    public String toString() {
        return "GCovCoverageModel(filePath=" + this.filePath + ", lines=" + this.lines + ")";
    }

    public int hashCode() {
        int result = this.filePath.hashCode();
        result = result * 31 + ((Object)this.lines).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GCovCoverageModel)) {
            return false;
        }
        GCovCoverageModel gCovCoverageModel = (GCovCoverageModel)other;
        if (!Intrinsics.areEqual((Object)this.filePath, (Object)gCovCoverageModel.filePath)) {
            return false;
        }
        return Intrinsics.areEqual(this.lines, gCovCoverageModel.lines);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\"\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002J*\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019J \u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$Companion;", "", "()V", "BLOCK_REGEX", "Lkotlin/text/Regex;", "BRANCH_NEVER_EXECUTED_REGEX", "BRANCH_TAKEN_REGEX", "HITS_PATTERN", "", "LINE_EXECUTION_REGEX", "PREAMBLE_REGEX", "TEMPLATE_SPECIALIZATION_REGEX", "extractFileName", "path", "Ljava/nio/file/Path;", "getEncodings", "", "Ljava/nio/charset/Charset;", "project", "Lcom/intellij/openapi/project/Project;", "getFilePath", "tagValue", "workingDirectory", "Ljava/io/File;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "getHits", "", "hitsText", "getOrCreateNearestBlock", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovBlockModel;", "lineModels", "Ljava/util/ArrayList;", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovLineModel;", "Lkotlin/collections/ArrayList;", "loadFrom", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel;", "readLines", "intellij.cidr.coverage"})
    @SourceDebugExtension(value={"SMAP\nGCovCoverageModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCovCoverageModel.kt\ncom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n288#2,2:176\n1549#2:178\n1620#2,3:179\n*S KotlinDebug\n*F\n+ 1 GCovCoverageModel.kt\ncom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$Companion\n*L\n77#1:176,2\n103#1:178\n103#1:179,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GCovCoverageModel loadFrom(@NotNull Path path, @Nullable File workingDirectory, @Nullable Project project, @NotNull CidrToolEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            String filePath = "";
            ArrayList<GCovLineModel> lineModels = new ArrayList<GCovLineModel>();
            List<String> textLines = this.readLines(path, project);
            int unrecognizedLines = 0;
            for (String textLine : textLines) {
                if (TEMPLATE_SPECIALIZATION_REGEX.matches((CharSequence)textLine)) continue;
                MatchResult preambleMatcher = PREAMBLE_REGEX.matchEntire((CharSequence)textLine);
                if (preambleMatcher != null) {
                    String tagName = ((Object)StringsKt.trim((CharSequence)((String)preambleMatcher.getGroupValues().get(1)))).toString();
                    String tagValue = ((Object)StringsKt.trim((CharSequence)((String)preambleMatcher.getGroupValues().get(2)))).toString();
                    if (!StringUtil.equalsIgnoreCase((CharSequence)tagName, (CharSequence)"source")) continue;
                    filePath = this.getFilePath(tagValue, workingDirectory, environment);
                    continue;
                }
                MatchResult lineExecutionMatcher = LINE_EXECUTION_REGEX.matchEntire((CharSequence)textLine);
                if (lineExecutionMatcher != null) {
                    String hits = (String)lineExecutionMatcher.getGroupValues().get(1);
                    int lineIndex = Integer.parseInt((String)lineExecutionMatcher.getGroupValues().get(2));
                    if (!lineModels.isEmpty() && ((GCovLineModel)CollectionsKt.last((List)lineModels)).getLineIndex() >= lineIndex) continue;
                    lineModels.add(new GCovLineModel(lineIndex, this.getHits(hits)));
                    continue;
                }
                MatchResult blockMatcher = BLOCK_REGEX.matchEntire((CharSequence)textLine);
                if (blockMatcher != null) {
                    Object object;
                    Object v0;
                    int blockIndex;
                    int hits;
                    block9: {
                        hits = this.getHits((String)blockMatcher.getGroupValues().get(1));
                        int lineIndex = Integer.parseInt((String)blockMatcher.getGroupValues().get(2));
                        blockIndex = Integer.parseInt((String)blockMatcher.getGroupValues().get(3));
                        Iterable $this$firstOrNull$iv = CollectionsKt.asReversedMutable((List)lineModels);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            GCovLineModel it = (GCovLineModel)element$iv;
                            boolean bl = false;
                            if (!(it.getLineIndex() == lineIndex)) continue;
                            v0 = element$iv;
                            break block9;
                        }
                        v0 = null;
                    }
                    if ((object = (GCovLineModel)v0) == null || (object = ((GCovLineModel)object).getBlocks()) == null) continue;
                    object.add(new GCovBlockModel(blockIndex, hits));
                    continue;
                }
                MatchResult branchTakenMatcher = BRANCH_TAKEN_REGEX.matchEntire((CharSequence)textLine);
                if (branchTakenMatcher != null) {
                    int branchNumber = Integer.parseInt((String)branchTakenMatcher.getGroupValues().get(1));
                    int taken = Integer.parseInt((String)branchTakenMatcher.getGroupValues().get(2));
                    Object object = this.getOrCreateNearestBlock(lineModels);
                    if (object != null && (object = ((GCovBlockModel)object).getBranches()) != null) {
                        object.add(new GCovBranchModel(branchNumber, taken));
                    }
                    continue;
                }
                MatchResult branchNeverExecutedMatcher = BRANCH_NEVER_EXECUTED_REGEX.matchEntire((CharSequence)textLine);
                if (branchNeverExecutedMatcher != null) {
                    int branchNumber = Integer.parseInt((String)branchNeverExecutedMatcher.getGroupValues().get(1));
                    Object object = this.getOrCreateNearestBlock(lineModels);
                    if (object != null && (object = ((GCovBlockModel)object).getBranches()) != null) {
                        object.add(new GCovBranchModel(branchNumber, 0));
                    }
                    continue;
                }
                ++unrecognizedLines;
            }
            CidrCoverageLogKt.getCidrCoverageLog().debug("Completed parse of .gcov file with local path: " + filePath + ", lineModels: " + lineModels.size() + ", unrecognized lines: " + unrecognizedLines);
            return new GCovCoverageModel(filePath, (List<GCovLineModel>)lineModels);
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> readLines(Path path, Project project) {
            for (Charset encoding : this.getEncodings(path, project)) {
                try {
                    void $this$mapTo$iv$iv;
                    List<String> list = Files.readAllLines(path, encoding);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                    Iterable $this$map$iv = list;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                    }
                    return (List)destination$iv$iv;
                }
                catch (MalformedInputException $this$map$iv) {
                }
                catch (Exception exception) {
                    throw exception;
                }
            }
            CidrCoverageLogKt.getCidrCoverageLog().warn("Failed to read text from " + ((Object)path).toString() + ": No appropriate encoding");
            return CollectionsKt.emptyList();
        }

        private final List<Charset> getEncodings(Path path, Project project) {
            String fileName = this.extractFileName(path);
            List encodings = new ArrayList();
            if (project != null) {
                Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<Collection<VirtualFile>>(fileName, project){
                    final /* synthetic */ String $fileName;
                    final /* synthetic */ Project $project;
                    {
                        this.$fileName = $fileName;
                        this.$project = $project;
                        super(0);
                    }

                    @NotNull
                    public final Collection<VirtualFile> invoke() {
                        return FilenameIndex.getVirtualFilesByName((String)this.$fileName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.$project));
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
                Collection virtualFiles2 = (Collection)object;
                for (VirtualFile file : virtualFiles2) {
                    Charset encoding = EncodingRegistry.getInstance().getEncoding(file, true);
                    if (encoding == null) continue;
                    encodings.add(encoding);
                }
            }
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            encodings.add(charset);
            encodings.add(Charsets.UTF_8);
            return CollectionsKt.distinct((Iterable)encodings);
        }

        @NotNull
        public final String extractFileName(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String fileName = ((Object)path.getFileName()).toString();
            String[] stringArray = new String[]{"##"};
            List fileNameParts = StringsKt.split$default((CharSequence)fileName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            for (String fileNamePart : fileNameParts) {
                if (StringsKt.endsWith$default((String)fileNamePart, (String)".gcov", (boolean)false, (int)2, null)) {
                    String string = fileNamePart.substring(0, StringsKt.lastIndexOf$default((CharSequence)fileNamePart, (String)".gcov", (int)0, (boolean)false, (int)6, null));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    return string;
                }
                if (!StringsKt.endsWith$default((String)fileNamePart, (String)".gcda", (boolean)false, (int)2, null)) continue;
                String string = fileNamePart.substring(0, StringsKt.lastIndexOf$default((CharSequence)fileNamePart, (String)".gcda", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            return fileName;
        }

        private final String getFilePath(String tagValue, File workingDirectory, CidrToolEnvironment environment) {
            if (FileUtil.isAbsolute((String)tagValue)) {
                String string = FileUtil.toCanonicalPath((String)environment.toLocalPath(tagValue));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toCanonicalPath(...)");
                return string;
            }
            String string = FileUtil.toCanonicalPath((String)environment.toLocalPath(workingDirectory, tagValue));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toCanonicalPath(...)");
            return string;
        }

        private final GCovBlockModel getOrCreateNearestBlock(ArrayList<GCovLineModel> lineModels) {
            GCovLineModel gCovLineModel = (GCovLineModel)CollectionsKt.lastOrNull((List)lineModels);
            if (gCovLineModel == null) {
                return null;
            }
            GCovLineModel lastLine = gCovLineModel;
            if (lastLine.getBlocks().isEmpty()) {
                lastLine.getBlocks().add(new GCovBlockModel(0, lastLine.getTotalHits()));
            }
            return (GCovBlockModel)CollectionsKt.last(lastLine.getBlocks());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final int getHits(String hitsText) {
            String string = hitsText;
            switch (string.hashCode()) {
                case 58212605: {
                    if (string.equals("=====")) return 0;
                    return Integer.parseInt(hitsText);
                }
                case 34354980: {
                    if (string.equals("$$$$$")) return 0;
                    return Integer.parseInt(hitsText);
                }
                case 45: {
                    if (string.equals("-")) return -1;
                    return Integer.parseInt(hitsText);
                }
                case 33400675: {
                    if (string.equals("#####")) return 0;
                    return Integer.parseInt(hitsText);
                }
                case 35309285: {
                    if (!string.equals("%%%%%")) return Integer.parseInt(hitsText);
                    return 0;
                }
            }
            return Integer.parseInt(hitsText);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovBlockModel;", "", "blockIndex", "", "hits", "(II)V", "getBlockIndex", "()I", "branches", "", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovBranchModel;", "getBranches", "()Ljava/util/List;", "getHits", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.cidr.coverage"})
    public static final class GCovBlockModel {
        private final int blockIndex;
        private final int hits;
        @NotNull
        private final List<GCovBranchModel> branches;

        public GCovBlockModel(int blockIndex, int hits) {
            this.blockIndex = blockIndex;
            this.hits = hits;
            this.branches = new ArrayList();
        }

        public final int getBlockIndex() {
            return this.blockIndex;
        }

        public final int getHits() {
            return this.hits;
        }

        @NotNull
        public final List<GCovBranchModel> getBranches() {
            return this.branches;
        }

        public final int component1() {
            return this.blockIndex;
        }

        public final int component2() {
            return this.hits;
        }

        @NotNull
        public final GCovBlockModel copy(int blockIndex, int hits) {
            return new GCovBlockModel(blockIndex, hits);
        }

        public static /* synthetic */ GCovBlockModel copy$default(GCovBlockModel gCovBlockModel, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = gCovBlockModel.blockIndex;
            }
            if ((n3 & 2) != 0) {
                n2 = gCovBlockModel.hits;
            }
            return gCovBlockModel.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "GCovBlockModel(blockIndex=" + this.blockIndex + ", hits=" + this.hits + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.blockIndex);
            result = result * 31 + Integer.hashCode(this.hits);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GCovBlockModel)) {
                return false;
            }
            GCovBlockModel gCovBlockModel = (GCovBlockModel)other;
            if (this.blockIndex != gCovBlockModel.blockIndex) {
                return false;
            }
            return this.hits == gCovBlockModel.hits;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovBranchModel;", "", "branchNumber", "", "taken", "(II)V", "getBranchNumber", "()I", "getTaken", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.cidr.coverage"})
    public static final class GCovBranchModel {
        private final int branchNumber;
        private final int taken;

        public GCovBranchModel(int branchNumber, int taken) {
            this.branchNumber = branchNumber;
            this.taken = taken;
        }

        public final int getBranchNumber() {
            return this.branchNumber;
        }

        public final int getTaken() {
            return this.taken;
        }

        public final int component1() {
            return this.branchNumber;
        }

        public final int component2() {
            return this.taken;
        }

        @NotNull
        public final GCovBranchModel copy(int branchNumber, int taken) {
            return new GCovBranchModel(branchNumber, taken);
        }

        public static /* synthetic */ GCovBranchModel copy$default(GCovBranchModel gCovBranchModel, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = gCovBranchModel.branchNumber;
            }
            if ((n3 & 2) != 0) {
                n2 = gCovBranchModel.taken;
            }
            return gCovBranchModel.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "GCovBranchModel(branchNumber=" + this.branchNumber + ", taken=" + this.taken + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.branchNumber);
            result = result * 31 + Integer.hashCode(this.taken);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GCovBranchModel)) {
                return false;
            }
            GCovBranchModel gCovBranchModel = (GCovBranchModel)other;
            if (this.branchNumber != gCovBranchModel.branchNumber) {
                return false;
            }
            return this.taken == gCovBranchModel.taken;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovLineModel;", "", "lineIndex", "", "totalHits", "(II)V", "blocks", "", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovBlockModel;", "getBlocks", "()Ljava/util/List;", "getLineIndex", "()I", "getTotalHits", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.cidr.coverage"})
    public static final class GCovLineModel {
        private final int lineIndex;
        private final int totalHits;
        @NotNull
        private final List<GCovBlockModel> blocks;

        public GCovLineModel(int lineIndex, int totalHits) {
            this.lineIndex = lineIndex;
            this.totalHits = totalHits;
            this.blocks = new ArrayList();
        }

        public final int getLineIndex() {
            return this.lineIndex;
        }

        public final int getTotalHits() {
            return this.totalHits;
        }

        @NotNull
        public final List<GCovBlockModel> getBlocks() {
            return this.blocks;
        }

        public final int component1() {
            return this.lineIndex;
        }

        public final int component2() {
            return this.totalHits;
        }

        @NotNull
        public final GCovLineModel copy(int lineIndex, int totalHits) {
            return new GCovLineModel(lineIndex, totalHits);
        }

        public static /* synthetic */ GCovLineModel copy$default(GCovLineModel gCovLineModel, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = gCovLineModel.lineIndex;
            }
            if ((n3 & 2) != 0) {
                n2 = gCovLineModel.totalHits;
            }
            return gCovLineModel.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "GCovLineModel(lineIndex=" + this.lineIndex + ", totalHits=" + this.totalHits + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.lineIndex);
            result = result * 31 + Integer.hashCode(this.totalHits);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GCovLineModel)) {
                return false;
            }
            GCovLineModel gCovLineModel = (GCovLineModel)other;
            if (this.lineIndex != gCovLineModel.lineIndex) {
                return false;
            }
            return this.totalHits == gCovLineModel.totalHits;
        }
    }
}

