/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import java.util.Arrays;

public class IntArrayList {
    private int[] data;
    private int size = 0;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    public int size() {
        return this.size;
    }

    public void ensureCapacity(int capacity) {
        if (capacity <= this.data.length) {
            return;
        }
        int newLength = Math.max(capacity, this.data.length * 2);
        this.data = Arrays.copyOf(this.data, newLength);
    }

    public void add(int value2) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size] = value2;
        ++this.size;
    }

    public void addAll(int[] values2) {
        if (values2 == null) {
            return;
        }
        if (values2.length == 0) {
            return;
        }
        this.ensureCapacity(this.size + values2.length);
        System.arraycopy(values2, 0, this.data, this.size, values2.length);
        this.size += values2.length;
    }

    public int[] toArray() {
        int[] array = new int[this.size];
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }
}

