/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

class RobustClipEnvelopeComputer {
    private Envelope targetEnv;
    private Envelope clipEnv;

    public static Envelope getEnvelope(Geometry a, Geometry b2, Envelope targetEnv) {
        RobustClipEnvelopeComputer cec = new RobustClipEnvelopeComputer(targetEnv);
        cec.add(a);
        cec.add(b2);
        return cec.getEnvelope();
    }

    public RobustClipEnvelopeComputer(Envelope targetEnv) {
        this.targetEnv = targetEnv;
        this.clipEnv = targetEnv.copy();
    }

    public Envelope getEnvelope() {
        return this.clipEnv;
    }

    public void add(Geometry g2) {
        if (g2 == null || g2.isEmpty()) {
            return;
        }
        if (g2 instanceof Polygon) {
            this.addPolygon((Polygon)g2);
        } else if (g2 instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)g2);
        }
    }

    private void addCollection(GeometryCollection gc) {
        for (int i2 = 0; i2 < gc.getNumGeometries(); ++i2) {
            Geometry g2 = gc.getGeometryN(i2);
            this.add(g2);
        }
    }

    private void addPolygon(Polygon poly) {
        LinearRing shell = poly.getExteriorRing();
        this.addPolygonRing(shell);
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            LinearRing hole = poly.getInteriorRingN(i2);
            this.addPolygonRing(hole);
        }
    }

    private void addPolygonRing(LinearRing ring) {
        if (ring.isEmpty()) {
            return;
        }
        CoordinateSequence seq = ring.getCoordinateSequence();
        for (int i2 = 1; i2 < seq.size(); ++i2) {
            this.addSegment(seq.getCoordinate(i2 - 1), seq.getCoordinate(i2));
        }
    }

    private void addSegment(Coordinate p1, Coordinate p2) {
        if (RobustClipEnvelopeComputer.intersectsSegment(this.targetEnv, p1, p2)) {
            this.clipEnv.expandToInclude(p1);
            this.clipEnv.expandToInclude(p2);
        }
    }

    private static boolean intersectsSegment(Envelope env, Coordinate p1, Coordinate p2) {
        return env.intersects(p1, p2);
    }
}

