/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;

public class RingClipper {
    private static final int BOX_LEFT = 3;
    private static final int BOX_TOP = 2;
    private static final int BOX_RIGHT = 1;
    private static final int BOX_BOTTOM = 0;
    private Envelope clipEnv;
    private double clipEnvMinY;
    private double clipEnvMaxY;
    private double clipEnvMinX;
    private double clipEnvMaxX;

    public RingClipper(Envelope clipEnv) {
        this.clipEnv = clipEnv;
        this.clipEnvMinY = clipEnv.getMinY();
        this.clipEnvMaxY = clipEnv.getMaxY();
        this.clipEnvMinX = clipEnv.getMinX();
        this.clipEnvMaxX = clipEnv.getMaxX();
    }

    public Coordinate[] clip(Coordinate[] pts) {
        for (int edgeIndex = 0; edgeIndex < 4; ++edgeIndex) {
            boolean closeRing = edgeIndex == 3;
            if ((pts = this.clipToBoxEdge(pts, edgeIndex, closeRing)).length != 0) continue;
            return pts;
        }
        return pts;
    }

    private Coordinate[] clipToBoxEdge(Coordinate[] pts, int edgeIndex, boolean closeRing) {
        Coordinate start2;
        CoordinateList ptsClip = new CoordinateList();
        Coordinate p0 = pts[pts.length - 1];
        for (int i2 = 0; i2 < pts.length; ++i2) {
            Coordinate intPt;
            Coordinate p1 = pts[i2];
            if (this.isInsideEdge(p1, edgeIndex)) {
                if (!this.isInsideEdge(p0, edgeIndex)) {
                    intPt = this.intersection(p0, p1, edgeIndex);
                    ptsClip.add(intPt, false);
                }
                ptsClip.add(p1.copy(), false);
            } else if (this.isInsideEdge(p0, edgeIndex)) {
                intPt = this.intersection(p0, p1, edgeIndex);
                ptsClip.add(intPt, false);
            }
            p0 = p1;
        }
        if (closeRing && ptsClip.size() > 0 && !(start2 = (Coordinate)ptsClip.get(0)).equals2D((Coordinate)ptsClip.get(ptsClip.size() - 1))) {
            ptsClip.add(start2.copy());
        }
        return ptsClip.toCoordinateArray();
    }

    private Coordinate intersection(Coordinate a, Coordinate b2, int edgeIndex) {
        Coordinate intPt;
        switch (edgeIndex) {
            case 0: {
                intPt = new Coordinate(this.intersectionLineY(a, b2, this.clipEnvMinY), this.clipEnvMinY);
                break;
            }
            case 1: {
                intPt = new Coordinate(this.clipEnvMaxX, this.intersectionLineX(a, b2, this.clipEnvMaxX));
                break;
            }
            case 2: {
                intPt = new Coordinate(this.intersectionLineY(a, b2, this.clipEnvMaxY), this.clipEnvMaxY);
                break;
            }
            default: {
                intPt = new Coordinate(this.clipEnvMinX, this.intersectionLineX(a, b2, this.clipEnvMinX));
            }
        }
        return intPt;
    }

    private double intersectionLineY(Coordinate a, Coordinate b2, double y) {
        double m = (b2.x - a.x) / (b2.y - a.y);
        double intercept = (y - a.y) * m;
        return a.x + intercept;
    }

    private double intersectionLineX(Coordinate a, Coordinate b2, double x) {
        double m = (b2.y - a.y) / (b2.x - a.x);
        double intercept = (x - a.x) * m;
        return a.y + intercept;
    }

    private boolean isInsideEdge(Coordinate p2, int edgeIndex) {
        boolean isInside = false;
        switch (edgeIndex) {
            case 0: {
                isInside = p2.y > this.clipEnvMinY;
                break;
            }
            case 1: {
                isInside = p2.x < this.clipEnvMaxX;
                break;
            }
            case 2: {
                isInside = p2.y < this.clipEnvMaxY;
                break;
            }
            default: {
                isInside = p2.x > this.clipEnvMinX;
            }
        }
        return isInside;
    }
}

