/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.overlayng.InputGeometry;
import org.locationtech.jts.operation.overlayng.OverlayEdge;
import org.locationtech.jts.operation.overlayng.OverlayGraph;
import org.locationtech.jts.operation.overlayng.OverlayLabel;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import org.locationtech.jts.util.Assert;

class OverlayLabeller {
    private OverlayGraph graph;
    private InputGeometry inputGeometry;
    private Collection<OverlayEdge> edges;

    public OverlayLabeller(OverlayGraph graph2, InputGeometry inputGeometry) {
        this.graph = graph2;
        this.inputGeometry = inputGeometry;
        this.edges = graph2.getEdges();
    }

    public void computeLabelling() {
        Collection<OverlayEdge> nodes = this.graph.getNodeEdges();
        this.labelAreaNodeEdges(nodes);
        this.labelConnectedLinearEdges();
        this.labelCollapsedEdges();
        this.labelConnectedLinearEdges();
        this.labelDisconnectedEdges();
    }

    private void labelAreaNodeEdges(Collection<OverlayEdge> nodes) {
        for (OverlayEdge nodeEdge : nodes) {
            this.propagateAreaLocations(nodeEdge, 0);
            if (!this.inputGeometry.hasEdges(1)) continue;
            this.propagateAreaLocations(nodeEdge, 1);
        }
    }

    public void propagateAreaLocations(OverlayEdge nodeEdge, int geomIndex) {
        if (!this.inputGeometry.isArea(geomIndex)) {
            return;
        }
        if (nodeEdge.degree() == 1) {
            return;
        }
        OverlayEdge eStart = OverlayLabeller.findPropagationStartEdge(nodeEdge, geomIndex);
        if (eStart == null) {
            return;
        }
        int currLoc = eStart.getLocation(geomIndex, 1);
        OverlayEdge e2 = eStart.oNextOE();
        do {
            OverlayLabel label2;
            if (!(label2 = e2.getLabel()).isBoundary(geomIndex)) {
                label2.setLocationLine(geomIndex, currLoc);
                continue;
            }
            Assert.isTrue(label2.hasSides(geomIndex));
            int locRight = e2.getLocation(geomIndex, 2);
            if (locRight != currLoc) {
                throw new TopologyException("side location conflict: arg " + geomIndex, e2.getCoordinate());
            }
            int locLeft = e2.getLocation(geomIndex, 1);
            if (locLeft == -1) {
                Assert.shouldNeverReachHere("found single null side at " + e2);
            }
            currLoc = locLeft;
        } while ((e2 = e2.oNextOE()) != eStart);
    }

    private static OverlayEdge findPropagationStartEdge(OverlayEdge nodeEdge, int geomIndex) {
        OverlayEdge eStart = nodeEdge;
        do {
            OverlayLabel label2;
            if (!(label2 = eStart.getLabel()).isBoundary(geomIndex)) continue;
            Assert.isTrue(label2.hasSides(geomIndex));
            return eStart;
        } while ((eStart = (OverlayEdge)eStart.oNext()) != nodeEdge);
        return null;
    }

    private void labelCollapsedEdges() {
        for (OverlayEdge edge : this.edges) {
            if (edge.getLabel().isLineLocationUnknown(0)) {
                this.labelCollapsedEdge(edge, 0);
            }
            if (!edge.getLabel().isLineLocationUnknown(1)) continue;
            this.labelCollapsedEdge(edge, 1);
        }
    }

    private void labelCollapsedEdge(OverlayEdge edge, int geomIndex) {
        OverlayLabel label2 = edge.getLabel();
        if (!label2.isCollapse(geomIndex)) {
            return;
        }
        label2.setLocationCollapse(geomIndex);
    }

    private void labelConnectedLinearEdges() {
        this.propagateLinearLocations(0);
        if (this.inputGeometry.hasEdges(1)) {
            this.propagateLinearLocations(1);
        }
    }

    private void propagateLinearLocations(int geomIndex) {
        List<OverlayEdge> linearEdges = OverlayLabeller.findLinearEdgesWithLocation(this.edges, geomIndex);
        if (linearEdges.size() <= 0) {
            return;
        }
        ArrayDeque<OverlayEdge> edgeStack = new ArrayDeque<OverlayEdge>(linearEdges);
        boolean isInputLine = this.inputGeometry.isLine(geomIndex);
        while (!edgeStack.isEmpty()) {
            OverlayEdge lineEdge = (OverlayEdge)edgeStack.removeFirst();
            OverlayLabeller.propagateLinearLocationAtNode(lineEdge, geomIndex, isInputLine, edgeStack);
        }
    }

    private static void propagateLinearLocationAtNode(OverlayEdge eNode, int geomIndex, boolean isInputLine, Deque<OverlayEdge> edgeStack) {
        int lineLoc = eNode.getLabel().getLineLocation(geomIndex);
        if (isInputLine && lineLoc != 2) {
            return;
        }
        OverlayEdge e2 = eNode.oNextOE();
        do {
            OverlayLabel label2;
            if (!(label2 = e2.getLabel()).isLineLocationUnknown(geomIndex)) continue;
            label2.setLocationLine(geomIndex, lineLoc);
            edgeStack.addFirst(e2.symOE());
        } while ((e2 = e2.oNextOE()) != eNode);
    }

    private static List<OverlayEdge> findLinearEdgesWithLocation(Collection<OverlayEdge> edges, int geomIndex) {
        ArrayList<OverlayEdge> linearEdges = new ArrayList<OverlayEdge>();
        for (OverlayEdge edge : edges) {
            OverlayLabel lbl = edge.getLabel();
            if (!lbl.isLinear(geomIndex) || lbl.isLineLocationUnknown(geomIndex)) continue;
            linearEdges.add(edge);
        }
        return linearEdges;
    }

    private void labelDisconnectedEdges() {
        for (OverlayEdge edge : this.edges) {
            if (edge.getLabel().isLineLocationUnknown(0)) {
                this.labelDisconnectedEdge(edge, 0);
            }
            if (!edge.getLabel().isLineLocationUnknown(1)) continue;
            this.labelDisconnectedEdge(edge, 1);
        }
    }

    private void labelDisconnectedEdge(OverlayEdge edge, int geomIndex) {
        OverlayLabel label2 = edge.getLabel();
        if (!this.inputGeometry.isArea(geomIndex)) {
            label2.setLocationAll(geomIndex, 2);
            return;
        }
        int edgeLoc = this.locateEdgeBothEnds(geomIndex, edge);
        label2.setLocationAll(geomIndex, edgeLoc);
    }

    private int locateEdge(int geomIndex, OverlayEdge edge) {
        int loc = this.inputGeometry.locatePointInArea(geomIndex, edge.orig());
        int edgeLoc = loc != 2 ? 0 : 2;
        return edgeLoc;
    }

    private int locateEdgeBothEnds(int geomIndex, OverlayEdge edge) {
        int locOrig = this.inputGeometry.locatePointInArea(geomIndex, edge.orig());
        int locDest = this.inputGeometry.locatePointInArea(geomIndex, edge.dest());
        boolean isInt = locOrig != 2 && locDest != 2;
        int edgeLoc = isInt ? 0 : 2;
        return edgeLoc;
    }

    public void markResultAreaEdges(int overlayOpCode) {
        for (OverlayEdge edge : this.edges) {
            this.markInResultArea(edge, overlayOpCode);
        }
    }

    public void markInResultArea(OverlayEdge e2, int overlayOpCode) {
        OverlayLabel label2 = e2.getLabel();
        if (label2.isBoundaryEither() && OverlayNG.isResultOfOp(overlayOpCode, label2.getLocationBoundaryOrLine(0, 2, e2.isForward()), label2.getLocationBoundaryOrLine(1, 2, e2.isForward()))) {
            e2.markInResultArea();
        }
    }

    public void unmarkDuplicateEdgesFromResultArea() {
        for (OverlayEdge edge : this.edges) {
            if (!edge.isInResultAreaBoth()) continue;
            edge.unmarkFromResultAreaBoth();
        }
    }

    public static String toString(OverlayEdge nodeEdge) {
        Coordinate orig = nodeEdge.orig();
        StringBuilder sb = new StringBuilder();
        sb.append("Node( " + WKTWriter.format(orig) + " )\n");
        OverlayEdge e2 = nodeEdge;
        do {
            sb.append("  -> " + e2);
            if (e2.isResultLinked()) {
                sb.append(" Link: ");
                sb.append(e2.nextResult());
            }
            sb.append("\n");
        } while ((e2 = e2.oNextOE()) != nodeEdge);
        return sb.toString();
    }
}

