/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.validate;

import java.util.List;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.operation.overlay.validate.PolygonalLineworkExtracter;

public class FuzzyPointLocator {
    private Geometry g;
    private double boundaryDistanceTolerance;
    private MultiLineString linework;
    private PointLocator ptLocator = new PointLocator();
    private LineSegment seg = new LineSegment();

    public FuzzyPointLocator(Geometry g2, double boundaryDistanceTolerance) {
        this.g = g2;
        this.boundaryDistanceTolerance = boundaryDistanceTolerance;
        this.linework = this.extractLinework(g2);
    }

    public int getLocation(Coordinate pt) {
        if (this.isWithinToleranceOfBoundary(pt)) {
            return 1;
        }
        return this.ptLocator.locate(pt, this.g);
    }

    private MultiLineString extractLinework(Geometry g2) {
        PolygonalLineworkExtracter extracter = new PolygonalLineworkExtracter();
        g2.apply(extracter);
        List linework = extracter.getLinework();
        LineString[] lines = GeometryFactory.toLineStringArray(linework);
        return g2.getFactory().createMultiLineString(lines);
    }

    private boolean isWithinToleranceOfBoundary(Coordinate pt) {
        for (int i2 = 0; i2 < this.linework.getNumGeometries(); ++i2) {
            LineString line = (LineString)this.linework.getGeometryN(i2);
            CoordinateSequence seq = line.getCoordinateSequence();
            for (int j = 0; j < seq.size() - 1; ++j) {
                seq.getCoordinate(j, this.seg.p0);
                seq.getCoordinate(j + 1, this.seg.p1);
                double dist = this.seg.distance(pt);
                if (!(dist <= this.boundaryDistanceTolerance)) continue;
                return true;
            }
        }
        return false;
    }
}

