/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryMapper;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainSelectAction;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder;
import org.locationtech.jts.operation.buffer.SegmentMCIndex;

public class OffsetCurve {
    private static final int NEARNESS_FACTOR = 10000;
    private Geometry inputGeom;
    private double distance;
    private BufferParameters bufferParams;
    private double matchDistance;
    private GeometryFactory geomFactory;

    public static Geometry getCurve(Geometry geom, double distance) {
        OffsetCurve oc = new OffsetCurve(geom, distance);
        return oc.getCurve();
    }

    public static Geometry getCurve(Geometry geom, double distance, int quadSegs, int joinStyle, double mitreLimit) {
        BufferParameters bufferParams = new BufferParameters();
        if (quadSegs >= 0) {
            bufferParams.setQuadrantSegments(quadSegs);
        }
        if (joinStyle >= 0) {
            bufferParams.setJoinStyle(joinStyle);
        }
        if (mitreLimit >= 0.0) {
            bufferParams.setMitreLimit(mitreLimit);
        }
        OffsetCurve oc = new OffsetCurve(geom, distance, bufferParams);
        return oc.getCurve();
    }

    public OffsetCurve(Geometry geom, double distance) {
        this(geom, distance, null);
    }

    public OffsetCurve(Geometry geom, double distance, BufferParameters bufParams) {
        this.inputGeom = geom;
        this.distance = distance;
        this.matchDistance = Math.abs(distance) / 10000.0;
        this.geomFactory = this.inputGeom.getFactory();
        this.bufferParams = new BufferParameters();
        if (bufParams != null) {
            this.bufferParams.setQuadrantSegments(bufParams.getQuadrantSegments());
            this.bufferParams.setJoinStyle(bufParams.getJoinStyle());
            this.bufferParams.setMitreLimit(bufParams.getMitreLimit());
        }
    }

    public Geometry getCurve() {
        return GeometryMapper.flatMap(this.inputGeom, 1, new GeometryMapper.MapOp(){

            @Override
            public Geometry map(Geometry geom) {
                if (geom instanceof Point) {
                    return null;
                }
                if (geom instanceof Polygon) {
                    return this.toLineString(geom.buffer(OffsetCurve.this.distance).getBoundary());
                }
                return OffsetCurve.this.computeCurve((LineString)geom, OffsetCurve.this.distance);
            }

            private Geometry toLineString(Geometry geom) {
                if (geom instanceof LinearRing) {
                    LinearRing ring = (LinearRing)geom;
                    return geom.getFactory().createLineString(ring.getCoordinateSequence());
                }
                return geom;
            }
        });
    }

    public static Coordinate[] rawOffset(LineString geom, double distance, BufferParameters bufParams) {
        OffsetCurveBuilder ocb = new OffsetCurveBuilder(geom.getFactory().getPrecisionModel(), bufParams);
        Coordinate[] pts = ocb.getOffsetCurve(geom.getCoordinates(), distance);
        return pts;
    }

    public static Coordinate[] rawOffset(LineString geom, double distance) {
        return OffsetCurve.rawOffset(geom, distance, new BufferParameters());
    }

    private LineString computeCurve(LineString lineGeom, double distance) {
        if (lineGeom.getNumPoints() < 2 || lineGeom.getLength() == 0.0) {
            return this.geomFactory.createLineString();
        }
        if (lineGeom.getNumPoints() == 2) {
            return this.offsetSegment(lineGeom.getCoordinates(), distance);
        }
        Coordinate[] rawOffset = OffsetCurve.rawOffset(lineGeom, distance, this.bufferParams);
        if (rawOffset.length == 0) {
            return this.geomFactory.createLineString();
        }
        Polygon bufferPoly = OffsetCurve.getBufferOriented(lineGeom, distance, this.bufferParams);
        Coordinate[] shell = bufferPoly.getExteriorRing().getCoordinates();
        LineString offsetCurve = this.computeCurve(shell, rawOffset);
        if (!offsetCurve.isEmpty() || bufferPoly.getNumInteriorRing() == 0) {
            return offsetCurve;
        }
        Coordinate[] holePts = OffsetCurve.extractLongestHole(bufferPoly).getCoordinates();
        offsetCurve = this.computeCurve(holePts, rawOffset);
        return offsetCurve;
    }

    private LineString offsetSegment(Coordinate[] pts, double distance) {
        LineSegment offsetSeg = new LineSegment(pts[0], pts[1]).offset(distance);
        return this.geomFactory.createLineString(new Coordinate[]{offsetSeg.p0, offsetSeg.p1});
    }

    private static Polygon getBufferOriented(LineString geom, double distance, BufferParameters bufParams) {
        Geometry buffer = BufferOp.bufferOp((Geometry)geom, Math.abs(distance), bufParams);
        Polygon bufferPoly = OffsetCurve.extractMaxAreaPolygon(buffer);
        if (distance < 0.0) {
            bufferPoly = bufferPoly.reverse();
        }
        return bufferPoly;
    }

    private static Polygon extractMaxAreaPolygon(Geometry geom) {
        if (geom.getNumGeometries() == 1) {
            return (Polygon)geom;
        }
        double maxArea = 0.0;
        Polygon maxPoly = null;
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            Polygon poly = (Polygon)geom.getGeometryN(i2);
            double area = poly.getArea();
            if (maxPoly != null && !(area > maxArea)) continue;
            maxPoly = poly;
            maxArea = area;
        }
        return maxPoly;
    }

    private static LinearRing extractLongestHole(Polygon poly) {
        LinearRing largestHole = null;
        double maxLen = -1.0;
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            LinearRing hole = poly.getInteriorRingN(i2);
            double len = hole.getLength();
            if (!(len > maxLen)) continue;
            largestHole = hole;
            maxLen = len;
        }
        return largestHole;
    }

    private LineString computeCurve(Coordinate[] bufferPts, Coordinate[] rawOffset) {
        boolean[] isInCurve = new boolean[bufferPts.length - 1];
        SegmentMCIndex segIndex = new SegmentMCIndex(bufferPts);
        int curveStart = -1;
        for (int i2 = 0; i2 < rawOffset.length - 1; ++i2) {
            int index2 = this.markMatchingSegments(rawOffset[i2], rawOffset[i2 + 1], segIndex, bufferPts, isInCurve);
            if (curveStart >= 0) continue;
            curveStart = index2;
        }
        Coordinate[] curvePts = OffsetCurve.extractSection(bufferPts, curveStart, isInCurve);
        return this.geomFactory.createLineString(curvePts);
    }

    private int markMatchingSegments(Coordinate p0, Coordinate p1, SegmentMCIndex segIndex, Coordinate[] bufferPts, boolean[] isInCurve) {
        Envelope matchEnv = new Envelope(p0, p1);
        matchEnv.expandBy(this.matchDistance);
        MatchCurveSegmentAction action = new MatchCurveSegmentAction(p0, p1, bufferPts, this.matchDistance, isInCurve);
        segIndex.query(matchEnv, action);
        return action.getMinCurveIndex();
    }

    private static double subsegmentMatchFrac(Coordinate p0, Coordinate p1, Coordinate seg0, Coordinate seg1, double matchDistance) {
        if (matchDistance < Distance.pointToSegment(p0, seg0, seg1)) {
            return -1.0;
        }
        if (matchDistance < Distance.pointToSegment(p1, seg0, seg1)) {
            return -1.0;
        }
        LineSegment seg = new LineSegment(seg0, seg1);
        return seg.segmentFraction(p0);
    }

    private static Coordinate[] extractSection(Coordinate[] ring, int startIndex, boolean[] isExtracted) {
        if (startIndex < 0) {
            return new Coordinate[0];
        }
        CoordinateList coordList = new CoordinateList();
        int i2 = startIndex;
        do {
            coordList.add(ring[i2], false);
        } while (isExtracted[i2] && (i2 = OffsetCurve.next(i2, ring.length - 1)) != startIndex);
        if (isExtracted[i2]) {
            coordList.add(ring[i2], false);
        }
        if (coordList.size() == 1) {
            return new Coordinate[0];
        }
        return coordList.toCoordinateArray();
    }

    private static int next(int i2, int size) {
        return ++i2 < size ? i2 : 0;
    }

    private static class MatchCurveSegmentAction
    extends MonotoneChainSelectAction {
        private Coordinate p0;
        private Coordinate p1;
        private Coordinate[] bufferPts;
        private double matchDistance;
        private boolean[] isInCurve;
        private double minFrac = -1.0;
        private int minCurveIndex = -1;

        public MatchCurveSegmentAction(Coordinate p0, Coordinate p1, Coordinate[] bufferPts, double matchDistance, boolean[] isInCurve) {
            this.p0 = p0;
            this.p1 = p1;
            this.bufferPts = bufferPts;
            this.matchDistance = matchDistance;
            this.isInCurve = isInCurve;
        }

        @Override
        public void select(MonotoneChain mc, int segIndex) {
            double frac = OffsetCurve.subsegmentMatchFrac(this.bufferPts[segIndex], this.bufferPts[segIndex + 1], this.p0, this.p1, this.matchDistance);
            if (frac < 0.0) {
                return;
            }
            this.isInCurve[segIndex] = true;
            if (this.minFrac < 0.0 || frac < this.minFrac) {
                this.minFrac = frac;
                this.minCurveIndex = segIndex;
            }
        }

        public int getMinCurveIndex() {
            return this.minCurveIndex;
        }
    }
}

