/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;

public class BufferInputLineSimplifier {
    private static final int INIT = 0;
    private static final int DELETE = 1;
    private static final int KEEP = 1;
    private Coordinate[] inputLine;
    private double distanceTol;
    private byte[] isDeleted;
    private int angleOrientation = 1;
    private static final int NUM_PTS_TO_CHECK = 10;

    public static Coordinate[] simplify(Coordinate[] inputLine, double distanceTol) {
        BufferInputLineSimplifier simp = new BufferInputLineSimplifier(inputLine);
        return simp.simplify(distanceTol);
    }

    public BufferInputLineSimplifier(Coordinate[] inputLine) {
        this.inputLine = inputLine;
    }

    public Coordinate[] simplify(double distanceTol) {
        this.distanceTol = Math.abs(distanceTol);
        if (distanceTol < 0.0) {
            this.angleOrientation = -1;
        }
        this.isDeleted = new byte[this.inputLine.length];
        boolean isChanged = false;
        while (isChanged = this.deleteShallowConcavities()) {
        }
        return this.collapseLine();
    }

    private boolean deleteShallowConcavities() {
        int index2 = 1;
        int midIndex = this.findNextNonDeletedIndex(index2);
        int lastIndex = this.findNextNonDeletedIndex(midIndex);
        boolean isChanged = false;
        while (lastIndex < this.inputLine.length) {
            boolean isMiddleVertexDeleted = false;
            if (this.isDeletable(index2, midIndex, lastIndex, this.distanceTol)) {
                this.isDeleted[midIndex] = 1;
                isMiddleVertexDeleted = true;
                isChanged = true;
            }
            index2 = isMiddleVertexDeleted ? lastIndex : midIndex;
            midIndex = this.findNextNonDeletedIndex(index2);
            lastIndex = this.findNextNonDeletedIndex(midIndex);
        }
        return isChanged;
    }

    private int findNextNonDeletedIndex(int index2) {
        int next;
        for (next = index2 + 1; next < this.inputLine.length && this.isDeleted[next] == 1; ++next) {
        }
        return next;
    }

    private Coordinate[] collapseLine() {
        CoordinateList coordList = new CoordinateList();
        for (int i2 = 0; i2 < this.inputLine.length; ++i2) {
            if (this.isDeleted[i2] == 1) continue;
            coordList.add(this.inputLine[i2]);
        }
        return coordList.toCoordinateArray();
    }

    private boolean isDeletable(int i0, int i1, int i2, double distanceTol) {
        Coordinate p0 = this.inputLine[i0];
        Coordinate p1 = this.inputLine[i1];
        Coordinate p2 = this.inputLine[i2];
        if (!this.isConcave(p0, p1, p2)) {
            return false;
        }
        if (!this.isShallow(p0, p1, p2, distanceTol)) {
            return false;
        }
        return this.isShallowSampled(p0, p1, i0, i2, distanceTol);
    }

    private boolean isShallowConcavity(Coordinate p0, Coordinate p1, Coordinate p2, double distanceTol) {
        boolean isAngleToSimplify;
        int orientation = Orientation.index(p0, p1, p2);
        boolean bl = isAngleToSimplify = orientation == this.angleOrientation;
        if (!isAngleToSimplify) {
            return false;
        }
        double dist = Distance.pointToSegment(p1, p0, p2);
        return dist < distanceTol;
    }

    private boolean isShallowSampled(Coordinate p0, Coordinate p2, int i0, int i2, double distanceTol) {
        int inc = (i2 - i0) / 10;
        if (inc <= 0) {
            inc = 1;
        }
        for (int i3 = i0; i3 < i2; i3 += inc) {
            if (this.isShallow(p0, p2, this.inputLine[i3], distanceTol)) continue;
            return false;
        }
        return true;
    }

    private boolean isShallow(Coordinate p0, Coordinate p1, Coordinate p2, double distanceTol) {
        double dist = Distance.pointToSegment(p1, p0, p2);
        return dist < distanceTol;
    }

    private boolean isConcave(Coordinate p0, Coordinate p1, Coordinate p2) {
        int orientation = Orientation.index(p0, p1, p2);
        boolean isConcave = orientation == this.angleOrientation;
        return isConcave;
    }
}

