/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentString;

public class SegmentStringUtil {
    public static List extractSegmentStrings(Geometry geom) {
        return SegmentStringUtil.extractNodedSegmentStrings(geom);
    }

    public static List extractNodedSegmentStrings(Geometry geom) {
        ArrayList<NodedSegmentString> segStr = new ArrayList<NodedSegmentString>();
        List lines = LinearComponentExtracter.getLines(geom);
        for (LineString line : lines) {
            Coordinate[] pts = line.getCoordinates();
            segStr.add(new NodedSegmentString(pts, geom));
        }
        return segStr;
    }

    public static List extractBasicSegmentStrings(Geometry geom) {
        ArrayList<BasicSegmentString> segStr = new ArrayList<BasicSegmentString>();
        List lines = LinearComponentExtracter.getLines(geom);
        for (LineString line : lines) {
            Coordinate[] pts = line.getCoordinates();
            segStr.add(new BasicSegmentString(pts, geom));
        }
        return segStr;
    }

    public static Geometry toGeometry(Collection segStrings, GeometryFactory geomFact) {
        LineString[] lines = new LineString[segStrings.size()];
        int index2 = 0;
        for (SegmentString ss2 : segStrings) {
            LineString line = geomFact.createLineString(ss2.getCoordinates());
            lines[index2++] = line;
        }
        if (lines.length == 1) {
            return lines[0];
        }
        return geomFact.createMultiLineString(lines);
    }

    public static String toString(List segStrings) {
        StringBuffer buf = new StringBuffer();
        for (SegmentString segStr : segStrings) {
            buf.append(segStr.toString());
            buf.append("\n");
        }
        return buf.toString();
    }
}

