/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.intervalrtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.intervalrtree.IntervalRTreeBranchNode;
import org.locationtech.jts.index.intervalrtree.IntervalRTreeLeafNode;
import org.locationtech.jts.index.intervalrtree.IntervalRTreeNode;

public class SortedPackedIntervalRTree {
    private final List leaves = new ArrayList();
    private volatile IntervalRTreeNode root = null;

    public void insert(double min, double max, Object item) {
        if (this.root != null) {
            throw new IllegalStateException("Index cannot be added to once it has been queried");
        }
        this.leaves.add(new IntervalRTreeLeafNode(min, max, item));
    }

    private synchronized void init() {
        if (this.root != null) {
            return;
        }
        if (this.leaves.size() == 0) {
            return;
        }
        this.buildRoot();
    }

    private void buildRoot() {
        if (this.root != null) {
            return;
        }
        this.root = this.buildTree();
    }

    private IntervalRTreeNode buildTree() {
        Collections.sort(this.leaves, new IntervalRTreeNode.NodeComparator());
        ArrayList src2 = this.leaves;
        ArrayList temp = null;
        ArrayList dest = new ArrayList();
        while (true) {
            this.buildLevel(src2, dest);
            if (dest.size() == 1) {
                return (IntervalRTreeNode)dest.get(0);
            }
            temp = src2;
            src2 = dest;
            dest = temp;
        }
    }

    private void buildLevel(List src2, List dest) {
        dest.clear();
        for (int i2 = 0; i2 < src2.size(); i2 += 2) {
            IntervalRTreeNode n22;
            IntervalRTreeNode n12 = (IntervalRTreeNode)src2.get(i2);
            IntervalRTreeNode intervalRTreeNode = n22 = i2 + 1 < src2.size() ? (IntervalRTreeNode)src2.get(i2) : null;
            if (n22 == null) {
                dest.add(n12);
                continue;
            }
            IntervalRTreeBranchNode node2 = new IntervalRTreeBranchNode((IntervalRTreeNode)src2.get(i2), (IntervalRTreeNode)src2.get(i2 + 1));
            dest.add(node2);
        }
    }

    public void query(double min, double max, ItemVisitor visitor2) {
        this.init();
        if (this.root == null) {
            return;
        }
        this.root.query(min, max, visitor2);
    }
}

