/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.intervalrtree;

import java.util.Comparator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.io.WKTWriter;

public abstract class IntervalRTreeNode {
    protected double min = Double.POSITIVE_INFINITY;
    protected double max = Double.NEGATIVE_INFINITY;

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public abstract void query(double var1, double var3, ItemVisitor var5);

    protected boolean intersects(double queryMin, double queryMax) {
        return !(this.min > queryMax) && !(this.max < queryMin);
    }

    public String toString() {
        return WKTWriter.toLineString(new Coordinate(this.min, 0.0), new Coordinate(this.max, 0.0));
    }

    public static class NodeComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            IntervalRTreeNode n12 = (IntervalRTreeNode)o1;
            IntervalRTreeNode n22 = (IntervalRTreeNode)o2;
            double mid1 = (n12.min + n12.max) / 2.0;
            double mid2 = (n22.min + n22.max) / 2.0;
            if (mid1 < mid2) {
                return -1;
            }
            if (mid1 > mid2) {
                return 1;
            }
            return 0;
        }
    }
}

